/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PassEncrypt;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.pes.jaxws.PESBrowser;
import com.spss.pes.jaxws.ResultObjectInfo;
import com.spss.pes.jaxws.UICommandFactory;
import com.spss.repository.client.application.jaxws.Repository;
import com.spss.repository.client.application.jaxws.RepositoryConnectionDescriptor;
import com.spss.security.schema.jaxb.ProviderInfo;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

public class PerConnectAction
extends SpssAction {
    private static boolean mBackendPESConnected = false;

    public PerConnectAction() {
        this("file_per_connect");
    }

    public PerConnectAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = CommandLine.isExternalCaller();
        if (actionEvent.getSource() instanceof JMenuItem) {
            bl |= true;
        }
        SpssFrame spssFrame = this.getFrame(((Container)actionEvent.getSource()).getParent());
        this.doConnect(spssFrame, bl, !CommandLine.isExternalCaller());
    }

    public boolean doConnect(SpssFrame spssFrame) {
        return this.doConnect(spssFrame, false, true);
    }

    public boolean doConnect(SpssFrame spssFrame, boolean bl, boolean bl2) {
        boolean bl3;
        ResultObjectInfo resultObjectInfo;
        boolean bl4 = false;
        PESBrowser.setParentFrame((JFrame)spssFrame);
        if (bl) {
            resultObjectInfo = new ResultObjectInfo();
            Repository repository = UICommandFactory.getInstance().getRepository(PESBrowser.getInstance(), true, bl2, resultObjectInfo);
            if (repository != null) {
                PES_Repository.setRepository((Repository)repository);
                PESBrowser.incrementLoginCount();
                resultObjectInfo.setDescriptor(repository.getRepositoryConnectionDescriptor());
            } else {
                bl4 = false;
            }
        } else {
            resultObjectInfo = PESBrowser.connectSPSSToRepository((boolean)bl2);
            if (VersionInfo.isSmartReader() && resultObjectInfo.getRepository() != null) {
                PES_Repository.setRepository((Repository)resultObjectInfo.getRepository());
            }
        }
        boolean bl5 = resultObjectInfo.getWhichOK() != -1 || resultObjectInfo.getRepository() != null && resultObjectInfo.getDescriptor().getSsoToken() != null;
        boolean bl6 = bl3 = resultObjectInfo.getWhichPaste() != -1;
        if (bl5 || bl3) {
            StringBuffer stringBuffer = new StringBuffer(200);
            RepositoryConnectionDescriptor repositoryConnectionDescriptor = resultObjectInfo.getDescriptor();
            stringBuffer.append("REPOSITORY CONNECT\n  /SERVER HOST='");
            stringBuffer.append(repositoryConnectionDescriptor.getHostName());
            stringBuffer.append(":");
            stringBuffer.append(repositoryConnectionDescriptor.getPortNumber());
            String string = repositoryConnectionDescriptor.getContextRoot();
            if (string.length() > 0) {
                if (string.charAt(0) != '/') {
                    stringBuffer.append("/");
                }
                stringBuffer.append(string);
            }
            stringBuffer.append("' SSL=");
            stringBuffer.append(repositoryConnectionDescriptor.getUseSSL() ? "YES" : "NO");
            if (repositoryConnectionDescriptor.getSsoToken() == null) {
                stringBuffer.append("\n  /LOGIN USER='");
                stringBuffer.append(repositoryConnectionDescriptor.getUserName());
                stringBuffer.append("' PASSWORD='");
                PassEncrypt passEncrypt = new PassEncrypt();
                String string2 = "'";
                stringBuffer.append(passEncrypt.encryptString(repositoryConnectionDescriptor.getPassword(), string2));
                if (repositoryConnectionDescriptor.getDomainName().length() > 0) {
                    stringBuffer.append("' DOMAIN='");
                    stringBuffer.append(repositoryConnectionDescriptor.getDomainName());
                }
                stringBuffer.append("' PROVIDER='");
                ProviderInfo providerInfo = repositoryConnectionDescriptor.getProviderInfo();
                if (providerInfo == null && repositoryConnectionDescriptor.getProviderKey() != null) {
                    providerInfo = repositoryConnectionDescriptor.getProviderInfo(repositoryConnectionDescriptor.getProviderKey());
                }
                stringBuffer.append(PerConnectAction.getProviderName(providerInfo.getProviderID()));
                stringBuffer.append("' ENCRYPTEDPWD=YES");
            }
            stringBuffer.append(".");
            if (bl3) {
                SyntaxMgr.getSyntaxMgr().pasteSyntax(stringBuffer.toString());
            } else {
                SyntaxMgr.getSyntaxMgr().executeSyntax(stringBuffer.toString());
                bl4 = true;
                mBackendPESConnected = true;
            }
        }
        return bl4;
    }

    private static String getProviderName(String string) {
        String string2 = string;
        if (string.equals("AD")) {
            string2 = "Active Directory";
        } else if (string.equals("ADL")) {
            string2 = "Active Directory with Local Override";
        } else if (string.equals("devldapOpenLDAP")) {
            string2 = "OpenLDAP";
        } else if (string.equals("iSeries")) {
            string2 = "iSeries";
        } else if (string.equals("Native")) {
            string2 = "Local User Repository";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "Local User Repository";
        }
        return string2;
    }

    public static boolean doBackendPESConnect() {
        boolean bl = false;
        Repository repository = null;
        if (PESBrowser.hasRepository()) {
            repository = PESBrowser.getRepository();
        }
        if (repository == null) {
            return bl;
        }
        RepositoryConnectionDescriptor repositoryConnectionDescriptor = repository.getRepositoryConnectionDescriptor();
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("REPOSITORY CONNECT\n  /SERVER HOST='");
        stringBuffer.append(repositoryConnectionDescriptor.getHostName());
        stringBuffer.append(":");
        stringBuffer.append(repositoryConnectionDescriptor.getPortNumber());
        String string = repositoryConnectionDescriptor.getContextRoot();
        if (string.length() > 0) {
            if (string.charAt(0) != '/') {
                stringBuffer.append("/");
            }
            stringBuffer.append(string);
        }
        stringBuffer.append("' SSL=");
        stringBuffer.append(repositoryConnectionDescriptor.getUseSSL() ? "YES" : "NO");
        if (repositoryConnectionDescriptor.getSsoToken() == null) {
            stringBuffer.append("\n  /LOGIN USER='");
            stringBuffer.append(repositoryConnectionDescriptor.getUserName());
            stringBuffer.append("' PASSWORD='");
            PassEncrypt passEncrypt = new PassEncrypt();
            String string2 = "'";
            stringBuffer.append(passEncrypt.encryptString(repositoryConnectionDescriptor.getPassword(), string2));
            if (repositoryConnectionDescriptor.getDomainName().length() > 0) {
                stringBuffer.append("' DOMAIN='");
                stringBuffer.append(repositoryConnectionDescriptor.getDomainName());
            }
            stringBuffer.append("' PROVIDER='");
            ProviderInfo providerInfo = repositoryConnectionDescriptor.getProviderInfo();
            if (providerInfo == null && repositoryConnectionDescriptor.getProviderKey() != null) {
                providerInfo = repositoryConnectionDescriptor.getProviderInfo(repositoryConnectionDescriptor.getProviderKey());
            }
            if (providerInfo == null) {
                stringBuffer.append(PerConnectAction.getProviderName(repositoryConnectionDescriptor.getProviderKey()));
            } else {
                stringBuffer.append(PerConnectAction.getProviderName(providerInfo.getProviderID()));
            }
            stringBuffer.append("' ENCRYPTEDPWD=YES");
        }
        stringBuffer.append(".");
        SyntaxMgr.getSyntaxMgr().executeSyntax(stringBuffer.toString());
        bl = true;
        mBackendPESConnected = true;
        return bl;
    }

    public static boolean isBackendPESConnected() {
        return mBackendPESConnected;
    }
}

