/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.serialize.DataSerializer;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.clipboard.AppClipboard;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JTable;

public class PasteAction
extends SpssAction {
    public PasteAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        if (iTopWindow instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)iTopWindow;
            DataView dataView = dataFrame.getDataView();
            if (dataView != null) {
                int n = dataView.getActiveView();
                if (dataView.getActiveView() == 0 && DataMgr.getDataMgr().isDataFreeClient()) {
                    return false;
                }
                if (dataView.getActiveView() == 1 && this.getActionId().equals("edit_paste_variable_names")) {
                    return false;
                }
                JTable jTable = dataView.getDataTable(n);
                return DataSerializer.canPaste(jTable);
            }
        } else if (iTopWindow instanceof SyntaxFrame) {
            return appClipboard.isFlavorAvailable(AppClipboard.STRING_FLAVOR);
        }
        return appClipboard.isFlavorAvailable(AppClipboard.STRING_FLAVOR);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame(((Container)actionEvent.getSource()).getParent());
        if (this.getMenuItemEnableStatus(spssFrame)) {
            if (actionEvent.getActionCommand().equals(ResUtil.getString("context_data_paste_spec")) || actionEvent.getActionCommand().equals(ResUtil.getString("edit_paste_variable_names"))) {
                spssFrame.doPasteSpecial();
            } else {
                spssFrame.doPaste();
            }
        }
    }
}

