/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.SyntaxCrypt;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.MRUMgr;
import com.spss.java_client.core.documents.syntax.SyntaxEncodingMarkerUtils;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.actions.ChangeOSDirectory;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class OpenSyntaxAction
extends SpssAction {
    public OpenSyntaxAction() {
        this("file_open_syntax");
    }

    public OpenSyntaxAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        RemoteFileChooser remoteFileChooser = DocUtil.getDocTypeFileChooser(RemoteFileChooser.ChooserType.OpenFile, DocType.SYNTAX_DOC);
        int n = remoteFileChooser.showOpenDialog(this.getFrame(((Container)actionEvent.getSource()).getParent()));
        if (n == 0) {
            ChangeOSDirectory.changeWorkingDirectory(remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            FileLocationsUtil.setFilesDirectoryPath((DocType)DocType.SYNTAX_DOC, (String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            try {
                Object object;
                boolean bl;
                String string;
                File file = remoteFileChooser.getSelectedFile();
                PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
                if (pesFile != null) {
                    string = PES_Repository.RetrieveFromPES((PesFile)pesFile, (boolean)remoteFileChooser.isLockSelected());
                    file = pesFile.getCacheFile();
                    if (file == null) {
                        SpssAlertOptionPane.showWarningMessageDialog(this.getFrame(((Container)actionEvent.getSource()).getParent()), string, VersionInfo.getAppVersionString());
                        return;
                    }
                }
                if (SpssFrameMgr.getSpssFrameMgr().checkForOpenDocument(file.getCanonicalPath())) {
                    return;
                }
                string = null;
                String string2 = remoteFileChooser.getEncodingSelection();
                if (string2 == null) {
                    string2 = ComponentState.getCurrentCharsetName();
                }
                if (bl = SyntaxCrypt.isEncrypted((String)file.getAbsolutePath())) {
                    string = SyntaxUtil.openEncryptedSyntaxDocument(file);
                } else {
                    block22: {
                        object = null;
                        if (string2.equals(CoreResUtil.getString((String)"IDS_AS_DECLARED_ENCODING"))) {
                            SyntaxEncodingMarkerUtils syntaxEncodingMarkerUtils = new SyntaxEncodingMarkerUtils();
                            String string3 = syntaxEncodingMarkerUtils.getDocumentEncodingMarkerValue(file);
                            string2 = string3 == null ? ComponentState.getCurrentCharsetName() : string3;
                        } else if (string2.equals(CoreResUtil.getString((String)"IDS_UNICODE_UTF8"))) {
                            string2 = "UTF-8";
                        } else if (string2.equals(CoreResUtil.getString((String)"IDS_UNICODE_UTF16"))) {
                            string2 = "UTF-16";
                        } else if (string2.equals(CoreResUtil.getString((String)"IDS_UNICODE_UTF16BE"))) {
                            string2 = "UTF-16BE";
                        } else if (string2.equals(CoreResUtil.getString((String)"IDS_UNICODE_UTF16LE"))) {
                            string2 = "UTF-16LE";
                        }
                        try {
                            object = Charset.forName(string2);
                        }
                        catch (UnsupportedCharsetException unsupportedCharsetException) {
                            int n2 = string2.indexOf(":");
                            if (n2 <= 0) break block22;
                            object = Charset.forName(string2.substring(0, n2));
                        }
                    }
                    if (object == null) {
                        object = Charset.forName("ISO_8859-1");
                    }
                    string = SyntaxMgr.getSyntaxMgr().openSyntaxDocument(file, (Charset)object);
                }
                if (string != null) {
                    object = pesFile != null ? pesFile.getUri() : file.getCanonicalPath();
                    MRUMgr.getMRUMgr().addOtherDocumentPath((String)object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

