/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.MRUMgr;
import com.spss.java_client.core.script.engine.IScriptLanguage;
import com.spss.java_client.core.script.engine.IScriptLanguageMgr;
import com.spss.java_client.core.script.engine.ScriptEngine;
import com.spss.java_client.core.script.engine.ScriptLanguageMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.ChangeOSDirectory;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class OpenScriptAction
extends SpssAction {
    public OpenScriptAction() {
        this("file_open_script");
    }

    public OpenScriptAction(String string) {
        super(string);
        this.configureAction(true);
    }

    public boolean getMenuItemEnableStatus(SpssFrame spssFrame) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame((Container)actionEvent.getSource());
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Script, FileLocationsUtil.getFilesDirectoryPath((DocType)DocType.SCRIPT_DOC), false);
            String string = iScriptLanguageMgr.getDefaultLanguage().getLanguageName();
            this.setFileFilters(remoteFileChooser, string);
            this.setPythonVersion(remoteFileChooser, string);
            remoteFileChooser.setPythonVersionControlsVisible(iScriptLanguageMgr.isPythonScriptInstalled());
            ChangeOSDirectory.changeWorkingDirectory(remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            int n = remoteFileChooser.showOpenDialog(this.getFrame(((Container)actionEvent.getSource()).getParent()));
            if (n == 0) {
                FileLocationsUtil.setFilesDirectoryPath((DocType)DocType.SCRIPT_DOC, (String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                ScriptEngine.getScriptEngine().setSelectedPythonVersion(remoteFileChooser.getPythonVersionSelection());
                try {
                    ScriptEngine.getScriptEngine().openScript(remoteFileChooser.getSelectedFilePath());
                    MRUMgr.getMRUMgr().addOtherDocumentPath(remoteFileChooser.getSelectedFile().getCanonicalPath());
                }
                catch (Exception exception) {
                    if (exception.getMessage() != null) {
                        SpssAlertOptionPane.showErrorMessageDialog(spssFrame, exception.getMessage(), VersionInfo.getAppVersionString());
                    }
                }
            }
        } else {
            SpssAlertOptionPane.showErrorMessageDialog(spssFrame, ResUtil.getString("ERR_NO_SCRIPTING_LANGUAGE_AVAILABLE_TO_EDIT"), VersionInfo.getAppVersionString());
        }
    }

    private void setFileFilters(RemoteFileChooser remoteFileChooser, String string) {
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            RefFileFilter refFileFilter = null;
            String string2 = string.toLowerCase().contains("python") ? "Python" : string;
            for (IScriptLanguage iScriptLanguage : vector) {
                RefFileFilter refFileFilter2;
                String string3;
                if (iScriptLanguage.getLanguageName().equalsIgnoreCase("Python2")) {
                    string3 = "Python";
                } else {
                    if (iScriptLanguage.getLanguageName().equalsIgnoreCase("Python3")) continue;
                    string3 = iScriptLanguage.getLanguageName();
                }
                Vector vector2 = iScriptLanguage.getFileExtensions();
                StringBuffer stringBuffer = new StringBuffer();
                if (vector2.size() != 0) {
                    refFileFilter2 = iScriptLanguage.getFileExtensions().iterator();
                    stringBuffer.append((String)refFileFilter2.next());
                    while (refFileFilter2.hasNext()) {
                        String string4 = (String)refFileFilter2.next();
                        stringBuffer.append(";");
                        stringBuffer.append(string4);
                    }
                }
                if (stringBuffer.length() <= 0) continue;
                refFileFilter2 = new RefFileFilter(string3 + " (" + stringBuffer.toString() + ")", stringBuffer.toString(), ";");
                remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter2);
                if (!iScriptLanguage.getLanguageName().toLowerCase().contains(string2.toLowerCase())) continue;
                refFileFilter = refFileFilter2;
            }
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
            if (refFileFilter != null) {
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
            }
        }
    }

    private void setPythonVersion(RemoteFileChooser remoteFileChooser, String string) {
        if (string.toLowerCase().contains("python")) {
            remoteFileChooser.setPythonVersionSelection(string.substring(6));
        }
    }
}

