/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.dialogs.base.file.open_dimensions_data.OpenDimensionsDataDlg;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.winutils.DimensionsDataModelInterface;
import com.spss.uitools.winutils.WindowsRegistryReader;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class OpenDimensionsDataAction
extends SpssAction {
    private static String DIMENSIONS_VERSION_HEADER = "SPSSMR.DMOM.";
    private static String sDimensionsVersion = null;
    private String mConnectionString;
    private Object[][] mFullDimensionsVarList;
    private Boolean mHasSystemVars;
    private Boolean mHasCodeVars;
    private Boolean mHasSourceFileVars;
    private PseudoDialog mPseudoDialog = null;
    private JFrame mFrame;

    public OpenDimensionsDataAction() {
        super("file_open_dimensions_data");
        this.configureAction(true);
    }

    public OpenDimensionsDataAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public boolean showMenu() {
        if (OSInfo.getOSType() == OSInfo.OSType.WIN && !VersionInfo.isStudentVersion()) {
            try {
                if (sDimensionsVersion == null) {
                    String[] stringArray = WindowsRegistryReader.getWindowsRegistryReader().readSubKeysWinRegistry("HKLM", "SOFTWARE\\Microsoft\\.NETFramework\\AssemblyFolders");
                    if (stringArray == null) {
                        sDimensionsVersion = "";
                    } else {
                        for (String string : stringArray) {
                            if (!string.toUpperCase().startsWith(DIMENSIONS_VERSION_HEADER)) continue;
                            String string2 = string.substring(DIMENSIONS_VERSION_HEADER.length());
                            if (sDimensionsVersion != null && string2.compareToIgnoreCase(sDimensionsVersion) <= 0) continue;
                            sDimensionsVersion = string2;
                        }
                    }
                }
                if (sDimensionsVersion != null && sDimensionsVersion.length() > 0) {
                    try {
                        int n = Integer.parseInt(sDimensionsVersion.replace(".", ""));
                        return !DataServerProxy.getDataProxy().isRemoteConnection() && n >= 3501;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        return ComponentState.getProcessorAvailable() && !ComponentState.getProcessorBusy();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.mFrame = this.getFrame(((Container)actionEvent.getSource()).getParent());
        ConnectionHandler connectionHandler = new ConnectionHandler(this, "Provider=mrOleDB.Provider.2", false);
        connectionHandler.start();
        this.mPseudoDialog = new PseudoDialog(this.mFrame);
        this.mPseudoDialog.setVisible(true);
    }

    private void connectionInitiated(String string) {
        this.disposePseudoDlg();
        this.mConnectionString = string;
        if (this.mConnectionString == null || this.mConnectionString.length() == 0) {
            return;
        }
        ConnectionHandler connectionHandler = new ConnectionHandler(this, this.mConnectionString, true);
        connectionHandler.start();
        this.mPseudoDialog = new PseudoDialog(this.mFrame);
        this.mPseudoDialog.setVisible(true);
    }

    private void connectionComplete(Object[] objectArray) {
        this.disposePseudoDlg();
        if (objectArray == null || objectArray[4] instanceof String) {
            ResourceBundle resourceBundle = FileResBundle.getBundle((String)FileResBundle.getDefaultResourceBundleName());
            String string = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"ERR_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_NO_DATA_FOUND_MESSAGE");
            String string2 = String.format(string, "");
            if (objectArray != null && objectArray.length > 4 && objectArray[4] instanceof String) {
                string2 = String.format(string, (String)objectArray[4]);
            }
            Object[] objectArray2 = new String[]{ResUtil.getCommonDlgString("IDS_YES"), ResUtil.getCommonDlgString("IDS_NO")};
            int n = SpssAlertOptionPane.showOptionDialog(this.mFrame, string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray2, (Object)objectArray2[0]);
            if (0 != n) {
                return;
            }
            ConnectionHandler connectionHandler = new ConnectionHandler(this, this.mConnectionString, false);
            connectionHandler.start();
            this.mPseudoDialog = new PseudoDialog(this.mFrame);
            this.mPseudoDialog.setVisible(true);
        } else {
            this.handleConnection(objectArray);
            new OpenDimensionsDataDlg(this.mFrame, this.mConnectionString, this.mFullDimensionsVarList, this.mHasSystemVars, this.mHasCodeVars, this.mHasSourceFileVars);
        }
    }

    private void handleConnection(Object[] objectArray) {
        int n;
        this.mHasSystemVars = (Boolean)objectArray[4];
        this.mFullDimensionsVarList = new Object[5][((String[])objectArray[0]).length];
        int n2 = 0;
        for (String string : (String[])objectArray[0]) {
            this.mFullDimensionsVarList[0][n2] = string;
            ++n2;
        }
        for (n = 0; n < ((Integer[])objectArray[1]).length; ++n) {
            this.mFullDimensionsVarList[1][n] = DimensionsDataModelInterface.DataTypeConstants.lookup((int)((Integer[])objectArray[1])[n]);
        }
        this.mHasCodeVars = false;
        this.mHasSourceFileVars = false;
        for (n = 0; n < ((Integer[])objectArray[2]).length; ++n) {
            this.mFullDimensionsVarList[2][n] = DimensionsDataModelInterface.UsageTypeConstants.lookup((int)((Integer[])objectArray[2])[n]);
            if (!this.mHasCodeVars.booleanValue() && this.mFullDimensionsVarList[2][n] == DimensionsDataModelInterface.UsageTypeConstants.vtCoding) {
                this.mHasCodeVars = true;
            }
            if (this.mHasSourceFileVars.booleanValue() || this.mFullDimensionsVarList[2][n] != DimensionsDataModelInterface.UsageTypeConstants.vtSourceFile) continue;
            this.mHasSourceFileVars = true;
        }
        System.arraycopy((Boolean[])objectArray[3], 0, this.mFullDimensionsVarList[3], 0, ((Boolean[])objectArray[3]).length);
    }

    private void disposePseudoDlg() {
        if (this.mPseudoDialog != null) {
            this.mPseudoDialog.setVisible(false);
            this.mPseudoDialog.dispose();
            this.mPseudoDialog = null;
        }
    }

    class ConnectionHandler
    extends Thread {
        private OpenDimensionsDataAction mAction;
        private String mConnectString;
        private Object[] mConnectData;
        private boolean mGetVariables;

        ConnectionHandler(OpenDimensionsDataAction openDimensionsDataAction2, String string, boolean bl) {
            this.mAction = openDimensionsDataAction2;
            this.mConnectString = string;
            this.mGetVariables = bl;
        }

        @Override
        public void run() {
            if (!this.mGetVariables) {
                this.mConnectString = DimensionsDataModelInterface.getDimensionsDataModelInterface().promptForConnectionString(this.mConnectString);
            } else {
                this.mConnectData = DimensionsDataModelInterface.getDimensionsDataModelInterface().getVariableList(OpenDimensionsDataAction.this.mConnectionString);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ConnectionHandler.this.mGetVariables) {
                        ConnectionHandler.this.mAction.connectionInitiated(ConnectionHandler.this.mConnectString);
                    } else {
                        ConnectionHandler.this.mAction.connectionComplete(ConnectionHandler.this.mConnectData);
                    }
                }
            });
        }
    }

    class PseudoDialog
    extends JDialog {
        PseudoDialog(JFrame jFrame) {
            super((Frame)jFrame, true);
            this.setUndecorated(true);
        }

        @Override
        public void setVisible(boolean bl) {
            if (bl) {
                this.setLocation(-10000, -10000);
            }
            super.setVisible(bl);
        }
    }
}

