/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.data_access.ODBC.ODBCDacProxy;
import com.spss.java_client.core.error_handler.ErrorDispatcher;
import com.spss.java_client.core.error_handler.ErrorEventMsg;
import com.spss.java_client.core.error_handler.ICoreErrorHandler;
import com.spss.java_client.core.error_handler.IErrorHandler;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardDlgType;
import com.spss.java_client.ui.dialogs.base.file.openquery.NewQueryDlg;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardSyntaxUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class NewQueryAction
extends SpssAction
implements ICoreErrorHandler {
    public NewQueryAction() {
        this("file_new_query");
    }

    public NewQueryAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        return ComponentState.getProcessorAvailable() && !ComponentState.getProcessorBusy();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Serializable serializable;
        ErrorDispatcher.getErrorDispatcher().addListener(0, (IErrorHandler)this);
        DBWizardDlgType.setDBWizardDlgType(DBWizardDlgType.DBWizardDialogTypeEnum.eNewQueryDlg);
        JFrame jFrame = this.getFrame(((Container)actionEvent.getSource()).getParent());
        if (jFrame == null) {
            for (serializable = (Component)actionEvent.getSource(); serializable != null && !(serializable instanceof JFrame); serializable = ((Component)serializable).getParent()) {
            }
            if (serializable instanceof JFrame) {
                jFrame = (JFrame)serializable;
                object = new ImageIcon(ResUtil.getImageURL("IDI_DE_WINDOW_ACTIVE"));
                jFrame.setIconImage(((ImageIcon)object).getImage());
            }
        }
        DBData.getDBData().clear();
        DBWizardSyntaxUtil.reset();
        serializable = new Vector();
        object = ODBCDacProxy.getODBCDacProxy();
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode((ODBCDacProxy)object);
        ODBCDacProxy.getODBCDacProxy().getDataSources((Vector)serializable, sqlReturnCode);
        ErrorDispatcher.getErrorDispatcher().removeListener((IErrorHandler)this);
        if (OSInfo.getOSType() == OSInfo.OSType.LINUX && ((Vector)serializable).size() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog(jFrame, ResUtil.getString("ERR_NO_ODBC_DATA_SOURCE_DEFINED"), VersionInfo.getAppVersionString());
        } else {
            NewQueryDlg newQueryDlg = new NewQueryDlg(jFrame);
            newQueryDlg.setVisible(true);
        }
    }

    public void handleError(ErrorEventMsg errorEventMsg) {
        if (errorEventMsg.getErrorCode() == -14 || errorEventMsg.getErrorCode() == -12) {
            errorEventMsg.setErrorHandled(true);
            errorEventMsg.setUserNotified(true);
        }
    }
}

