/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.CommandAction;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.base.utilities.manage_extensions.StatsAppInfo;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.utilities.StatsCDBAppInfo;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.CDBAppInfo;
import com.spss.shared.custom_gui.ui_builder.app.ExtensionHubAppInfo;
import com.spss.shared.extensionmanager.res.EmResBundle;
import com.spss.shared.extensionmanager.res.EmResUtil;
import com.spss.shared.extensionmanager.ui.ExtensionsManageDialog;
import com.spss.shared.extensionmanager.utilities.ExtensionManageUtil;
import com.spss.shared.extensionmanager.utilities.ExtensionMgr;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;

public class ManageExtensionBundleAction
extends CommandAction {
    private static final String CONNECT_SPSS_COMMUNITY = "IDS_PROGRESS_CONTENT";

    public ManageExtensionBundleAction() {
        this("utilities_manage_extension_bundle");
    }

    public ManageExtensionBundleAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        ResourceBundle resourceBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        SpssProgressDlg spssProgressDlg = new SpssProgressDlg((Window)spssFrame, VersionInfo.getAppVersionString());
        spssProgressDlg.setSize(new Dimension(600, 200));
        spssProgressDlg.setMessage(resourceBundle.getString(CONNECT_SPSS_COMMUNITY));
        spssProgressDlg.setLocationRelativeTo(spssFrame);
        ConnectToSpssCommunity connectToSpssCommunity = new ConnectToSpssCommunity(spssProgressDlg);
        Thread thread = new Thread(connectToSpssCommunity);
        thread.start();
        spssProgressDlg.setVisible(true);
        if (!spssProgressDlg.isWorkDone()) {
            thread.interrupt();
            return;
        }
        if (!connectToSpssCommunity.isConnectSuccess()) {
            object = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()).getString("IDS_INSTALL_EXTENSION_BUNDLE_CANNOT_CONNECT_TO_SPSS_COMMUNITY");
            ManageExtensionBundleAction.showCanNotConnectError(spssFrame, (String)object);
            ExtensionMgr.getExtensionMgr().setInternetStatus(false);
        } else {
            ExtensionMgr.getExtensionMgr().setInternetStatus(true);
        }
        spssFrame = OSInfo.getOSType() == OSInfo.OSType.MAC ? null : this.getFrame(((Container)actionEvent.getSource()).getParent());
        object = new StatsAppInfo();
        ExtensionManageUtil.getInstance().setApplicationInfo((ExtensionHubAppInfo)object);
        ResourceBundle resourceBundle2 = EmResUtil.getBundle((String)EmResBundle.getDefaultResourceBundleName(), (Locale)Locale.getDefault());
        EmResUtil.setLocale((Locale)Locale.getDefault());
        final ExtensionsManageDialog extensionsManageDialog = new ExtensionsManageDialog((JFrame)spssFrame, (ExtensionHubAppInfo)object, resourceBundle2, EmResBundle.getImageFolder());
        extensionsManageDialog.setLocationRelativeTo((Component)spssFrame);
        extensionsManageDialog.setModal(true);
        extensionsManageDialog.setVisible(true);
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                    Point point = extensionsManageDialog.getLocationOnScreen();
                    ++point.x;
                    ++point.y;
                    extensionsManageDialog.setLocation(point);
                    --point.x;
                    --point.y;
                    extensionsManageDialog.setLocation(point);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            thread2.start();
        }
    }

    private static void showCanNotConnectError(SpssFrame spssFrame, String string) {
        Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_OK")};
        SpssAlertOptionPane.showOptionDialog(spssFrame, string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, objectArray[0]);
    }

    class ConnectToSpssCommunity
    implements Runnable {
        private boolean mConnectSuccess = false;
        private SpssProgressDlg mSpssProgressDlg;

        public ConnectToSpssCommunity(SpssProgressDlg spssProgressDlg) {
            this.mSpssProgressDlg = spssProgressDlg;
        }

        @Override
        public void run() {
            try {
                StatsAppInfo statsAppInfo = new StatsAppInfo();
                ExtensionManageUtil.getInstance().setApplicationInfo((ExtensionHubAppInfo)statsAppInfo);
                StatsCDBAppInfo statsCDBAppInfo = new StatsCDBAppInfo(false);
                BuilderUtil.getInstance().setAppInfo((CDBAppInfo)statsCDBAppInfo);
                if (ExtensionMgr.downloadIndexZipToTempFolderAndExtract()) {
                    this.mConnectSuccess = true;
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.mSpssProgressDlg.setWorkDone(true);
            }
            catch (Exception exception) {
                this.mConnectSuccess = false;
                this.mSpssProgressDlg.setWorkDone(true);
            }
            this.mSpssProgressDlg.dispose();
        }

        public boolean isConnectSuccess() {
            return this.mConnectSuccess;
        }
    }
}

