/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFile;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OutputCrypt;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.comp_util.SyntaxCrypt;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.MRUMgr;
import com.spss.java_client.core.documents.data.data_access.DacMgr;
import com.spss.java_client.core.documents.data.data_access.IDataAccessCallback;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.syntax.SyntaxEncodingMarkerUtils;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.script.ScriptingFrameworkException;
import com.spss.java_client.core.script.engine.IScriptLanguage;
import com.spss.java_client.core.script.engine.IScriptLanguageMgr;
import com.spss.java_client.core.script.engine.ScriptEngine;
import com.spss.java_client.core.script.engine.ScriptLanguageMgr;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.DAC.DacMgrUICallback;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.file.EncryptionEnterPasswordDlg;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.PerConnectAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.pes.jaxws.PESBrowser;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.PASWFileUtil;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class MRUAction
extends SpssAction {
    private boolean mIsData = false;
    private String mFullPath = null;

    public MRUAction(int n, String string, String string2, boolean bl) {
        super("file_MRUF");
        this.mIsData = bl;
        this.mFullPath = string2;
        this.putValue("Name", String.format("%d %s", n, string));
        this.putValue("ShortDescription", string2);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && n < 10) {
            this.putValue("MnemonicKey", 48 + n);
        }
    }

    public MRUAction(String string, boolean bl) {
        super("file_MRUF");
        this.mIsData = bl;
        this.mFullPath = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        File file = this.mIsData && DataServerProxy.getDataProxy().isRemoteConnection() ? new RefFile(this.mFullPath) : new File(this.mFullPath);
        if (PES_Repository.isPesUri((String)this.mFullPath)) {
            if (PESBrowser.getLoginCount() == 0) {
                object2 = new PerConnectAction();
                ((PerConnectAction)object2).actionPerformed(actionEvent);
            }
            if (PESBrowser.getLoginCount() == 0) {
                return;
            }
            if (PESBrowser.getLoginCount() > 0 && !PerConnectAction.isBackendPESConnected()) {
                PerConnectAction.doBackendPESConnect();
            }
            object2 = new PesFile(this.mFullPath);
            object = PES_Repository.RetrieveFromPES((PesFile)object2);
            file = object2.getCacheFile();
            if (file == null) {
                SpssAlertOptionPane.showWarningMessageDialog(this.getFrame(((Container)actionEvent.getSource()).getParent()), (String)object, VersionInfo.getAppVersionString());
                return;
            }
        }
        if (file.canRead()) {
            if (this.mIsData) {
                Object object3;
                object2 = "";
                object = null;
                SpssFrameMgr.OpenInfo openInfo = SpssFrameMgr.getSpssFrameMgr().checkForSaveFileAlreadyOpen(this.mFullPath);
                if (openInfo.getResponse() == SpssFrameMgr.OpenInfo.UserResponse.revert) {
                    object = openInfo.getDataSetName();
                } else if (openInfo.getResponse() == SpssFrameMgr.OpenInfo.UserResponse.cancel) {
                    return;
                }
                if (object != null && ((String)object).length() > 0) {
                    object2 = (String)object2 + "DATASET CLOSE " + (String)object + ".\n";
                    SyntaxMgr.getSyntaxMgr().executeSyntax((String)object2);
                }
                SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
                if (openInfo.getDataSetName() == null && !(object3 = RemoteFileSysUtil.getRemoteFileSysUtil().validateFile(this.mFullPath)).errorOccurred() && object3.getFileStatus() == RemoteFileStatus.FileNodeStatus.RFS_WRITEABLE_BUT_LOCKED && !RemoteFileChooser.displayConfirmFileInUseAlert(this.mFullPath, spssFrame)) {
                    return;
                }
                object3 = new DacMgrUICallback(spssFrame);
                DacMgr.getDacMgr().openRecentData(this.mFullPath, (IDataAccessCallback)object3);
            } else {
                if (SpssFrameMgr.getSpssFrameMgr().checkForOpenDocument(this.mFullPath)) {
                    return;
                }
                if (this.mFullPath.endsWith(ResUtil.getCommonDlgString("IDS_WELCOME_OUTPUT_FILE_FILTER_EXTENSION"))) {
                    Object object4;
                    object2 = null;
                    object = file;
                    if (OutputCrypt.isEncrypted((String)file.getAbsolutePath())) {
                        object4 = new EncryptionEnterPasswordDlg(this.getFrame(((Container)actionEvent.getSource()).getParent()), file.getName());
                        object4.setVisible(true);
                        if (!((EncryptionEnterPasswordDlg)((Object)object4)).isOkSelected()) {
                            return;
                        }
                        object2 = ((EncryptionEnterPasswordDlg)((Object)object4)).getEncryptFilePassword();
                        String string = PrefsMgr.getPrefsMgr().getTempPath();
                        try {
                            object = PASWFileUtil.createTempFile((String)"decrypt", (String)".spv", (File)new File(string));
                            string = ((File)object).getAbsolutePath();
                            ((File)object).deleteOnExit();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            return;
                        }
                        if (!OutputCrypt.decrypt((String)object2, (String)this.mFullPath, (String)string)) {
                            String string2 = String.format(ComponentState.getSPSSLocale(), CoreResUtil.getString((String)"ERR_FILE_OPEN_PASSWORD_FAILED"), new Object[0]);
                            SpssAlertOptionPane.showErrorMessageDialog(this.getFrame(((Container)actionEvent.getSource()).getParent()), string2, VersionInfo.getAppVersionString());
                            return;
                        }
                    }
                    if ((object4 = OutputManager.getOutputManager().openDocument(file, (File)object, null, true)) != null && object2 != null) {
                        object4.setPassword((String)object2, false);
                    }
                } else if (this.isScriptFile(this.mFullPath)) {
                    try {
                        ScriptEngine.getScriptEngine().openScript(this.mFullPath);
                    }
                    catch (ScriptingFrameworkException scriptingFrameworkException) {
                        object = this.getFrame((Container)actionEvent.getSource());
                        SpssAlertOptionPane.showWarningMessageDialog((Window)object, scriptingFrameworkException.getMessage(), VersionInfo.getAppVersionString());
                    }
                } else {
                    boolean bl = SyntaxCrypt.isEncrypted((String)file.getAbsolutePath());
                    if (bl) {
                        SyntaxUtil.openEncryptedSyntaxDocument(file);
                    } else {
                        object = new SyntaxEncodingMarkerUtils();
                        String string = object.getDocumentEncodingMarkerValue(file);
                        if (string != null) {
                            Charset charset;
                            block36: {
                                charset = null;
                                try {
                                    charset = Charset.forName(string);
                                }
                                catch (UnsupportedCharsetException unsupportedCharsetException) {
                                    int n = string.indexOf(":");
                                    if (n <= 0) break block36;
                                    charset = Charset.forName(string.substring(0, n));
                                }
                            }
                            if (charset == null) {
                                charset = Charset.forName("ISO_8859-1");
                            }
                            SyntaxMgr.getSyntaxMgr().openSyntaxDocument(file, charset);
                        } else {
                            SyntaxMgr.getSyntaxMgr().openSyntaxDocument(file);
                        }
                    }
                    MRUMgr.getMRUMgr().addOtherDocumentPath(this.mFullPath);
                }
            }
        } else {
            object2 = this.getFrame((Container)actionEvent.getSource());
            object = ResUtil.getCommonDlgString("ERR_FILE_NOT_FOUND").replace("%s", this.mFullPath);
            SpssAlertOptionPane.showWarningMessageDialog((Window)object2, (String)object, VersionInfo.getAppVersionString());
            if (this.mIsData) {
                MRUMgr.getMRUMgr().removeDataDocumentPath(this.mFullPath);
            } else {
                MRUMgr.getMRUMgr().removeOtherDocumentPath(this.mFullPath);
            }
        }
    }

    private boolean isScriptFile(String string) {
        String string2 = string.substring(string.lastIndexOf(46)).trim();
        IScriptLanguage iScriptLanguage = null;
        if (string2 != null && !string2.equals("") && string2.length() > 1) {
            IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
            IScriptLanguage iScriptLanguage2 = iScriptLanguageMgr.getDefaultLanguage();
            if (iScriptLanguage2.isPython().booleanValue()) {
                iScriptLanguageMgr.setSelectedPythonVersion(iScriptLanguage2.getLanguageName());
                ScriptEngine.getScriptEngine().setSelectedPythonVersion(iScriptLanguage2.getLanguageName());
            } else {
                iScriptLanguageMgr.setSelectedPythonVersion("");
                ScriptEngine.getScriptEngine().setSelectedPythonVersion("");
            }
            iScriptLanguage = iScriptLanguageMgr.getLanguageByExtention(string2.substring(1));
        }
        return iScriptLanguage != null;
    }
}

