/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet.ExtensionsManager;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet.InstallExtensionsFromInternetDlg;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;

public class InstallExtensionBundleFromInternetAction
extends SpssAction {
    private static final String CONNECT_SPSS_COMMUNITY = "IDS_EXTENSION_BUNDLE_CONNECTING_SPSS_COMMUNITY";

    public InstallExtensionBundleFromInternetAction() {
        this("utilities_install_extension_bundle_from_internet");
    }

    public InstallExtensionBundleFromInternetAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ResourceBundle resourceBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        SpssProgressDlg spssProgressDlg = new SpssProgressDlg((Window)spssFrame, VersionInfo.getAppVersionString());
        spssProgressDlg.setMessage(resourceBundle.getString(CONNECT_SPSS_COMMUNITY));
        spssProgressDlg.setLocationRelativeTo(spssFrame);
        ConnectToSpssCommunity connectToSpssCommunity = new ConnectToSpssCommunity(spssProgressDlg);
        Thread thread = new Thread(connectToSpssCommunity);
        thread.start();
        spssProgressDlg.setVisible(true);
        if (!spssProgressDlg.isWorkDone()) {
            thread.interrupt();
            return;
        }
        if (!connectToSpssCommunity.isConnectSuccess()) {
            String string = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()).getString("IDS_INSTALL_EXTENSION_BUNDLE_CANNOT_CONNECT_TO_SPSS_COMMUNITY");
            InstallExtensionBundleFromInternetAction.showCanNotConnectError(spssFrame, string);
            return;
        }
        spssFrame = OSInfo.getOSType() == OSInfo.OSType.MAC ? null : this.getFrame(((Container)actionEvent.getSource()).getParent());
        InstallExtensionsFromInternetDlg installExtensionsFromInternetDlg = new InstallExtensionsFromInternetDlg(spssFrame);
        installExtensionsFromInternetDlg.setVisible(true);
    }

    private static void showCanNotConnectError(SpssFrame spssFrame, String string) {
        Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_OK")};
        SpssAlertOptionPane.showOptionDialog(spssFrame, string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, objectArray[0]);
    }

    class ConnectToSpssCommunity
    implements Runnable {
        private boolean mConnectSuccess = false;
        private SpssProgressDlg mSpssProgressDlg;

        public ConnectToSpssCommunity(SpssProgressDlg spssProgressDlg) {
            this.mSpssProgressDlg = spssProgressDlg;
        }

        @Override
        public void run() {
            try {
                this.mConnectSuccess = ExtensionsManager.isAnyDownloadServerConnectable();
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (this.mConnectSuccess) {
                    ExtensionsManager.getExtensionsManager().getExtensions();
                }
                this.mSpssProgressDlg.setWorkDone(true);
            }
            catch (Exception exception) {
                this.mConnectSuccess = false;
                this.mSpssProgressDlg.setWorkDone(true);
            }
            this.mSpssProgressDlg.dispose();
        }

        public boolean isConnectSuccess() {
            return this.mConnectSuccess;
        }
    }
}

