/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.pasw.framework.common.PaswException;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.dialogs.base.utilities.MissingAddOnsDlg;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.ExtensionBundleMessageDlg;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.utilities.StatsCDBAppInfo;
import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.CDBAppInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.SpecificationBuilder;
import com.spss.uitools.ui_builder.SpecificationWriter;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.ScriptType;
import com.spss.uitools.ui_builder.definition.SubDlgButtonDefinition;
import com.spss.uitools.util.PASWFileUtil;
import com.spss.uitools.util.TraceSettings;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class InstallDlgAction
extends SpssAction
implements CommandLocation.ResLoader {
    private boolean mShowWarnings;
    private File mTempFolder = null;
    private File mExtensionFile = null;
    private File mAppExtFile = null;
    private static final String XML_FILE_EXT = ".xml";
    private static final String EXT_FILE_NAME = "extension.xml";
    private static final String APP_EXT_FILE_NAME = "app-extension.xml";

    public InstallDlgAction() {
        this(true);
    }

    public InstallDlgAction(boolean bl) {
        super("utilities_install_dialog");
        this.mShowWarnings = bl;
        this.configureAction(false);
        this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource((String)"spdfile16.png")));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame((Component)actionEvent.getSource());
        try {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
            UiPkgFilter uiPkgFilter = new UiPkgFilter();
            remoteFileChooser.setDialogTitle(BuilderResUtil.getString((String)"IDS_OPEN_CLEF_DLG_TITLE"));
            remoteFileChooser.addChoosableFileFilter(uiPkgFilter);
            SPDXFilter sPDXFilter = new SPDXFilter();
            remoteFileChooser.addChoosableFileFilter(sPDXFilter);
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
            remoteFileChooser.setFileFilter(uiPkgFilter);
            int n = remoteFileChooser.showOpenDialog(spssFrame);
            if (n == 0) {
                Object object;
                StatsCDBAppInfo statsCDBAppInfo;
                boolean bl;
                Object object2;
                FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                File file = remoteFileChooser.getSelectedFile();
                PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
                if (pesFile != null) {
                    object2 = PES_Repository.RetrieveFromPES((PesFile)pesFile);
                    file = pesFile.getCacheFile();
                    if (file == null) {
                        SpssAlertOptionPane.showWarningMessageDialog(spssFrame, (String)object2, VersionInfo.getAppVersionString());
                        return;
                    }
                }
                object2 = new Vector();
                FileFilter fileFilter = remoteFileChooser.getFileFilter();
                if (fileFilter instanceof SPDXFilter) {
                    bl = false;
                    statsCDBAppInfo = new StatsCDBAppInfo(false);
                    BuilderUtil.getInstance().setAppInfo((CDBAppInfo)statsCDBAppInfo);
                    ((Vector)object2).add(SpecificationBuilder.getAppDataCustomCFEFolderPath());
                } else {
                    bl = true;
                    statsCDBAppInfo = new StatsCDBAppInfo(true);
                    BuilderUtil.getInstance().setAppInfo((CDBAppInfo)statsCDBAppInfo);
                    ((Vector)object2).addAll(Arrays.asList(FileLocationsUtil.getSecondaryExtensionDirectory()));
                    object = FileLocationsUtil.getAppdataCustomDialogDirectoryForAllUsers();
                    if (object != null) {
                        ((Vector)object2).add(object);
                    }
                    if (System.getProperty("os.name", "Windows").toLowerCase().indexOf("win") >= 0) {
                        ((Vector)object2).add(FileLocationsUtil.getAppdataCustomDialogDirectory());
                        ((Vector)object2).add(FileLocationsUtil.getCustomDialogsDirectory());
                    } else {
                        ((Vector)object2).add(FileLocationsUtil.getCustomDialogsDirectory());
                        ((Vector)object2).add(FileLocationsUtil.getAppdataCustomDialogDirectory());
                    }
                }
                if (((Vector)object2).size() > 0) {
                    object = ((Vector)object2).iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        File file2 = new File(string);
                        if (!file2.exists() || !file2.isDirectory() || !PASWFileUtil.isWritable((File)file2)) continue;
                        DialogDefinition dialogDefinition = this.readPackageFile(file, bl);
                        if (dialogDefinition != null) {
                            if (bl) {
                                if (!this.validateSyntaxAndMenuLocation(spssFrame, dialogDefinition, false)) {
                                    return;
                                }
                                this.deploySpecification(spssFrame, dialogDefinition, true);
                                dialogDefinition.setIsCompatMode(true);
                                dialogDefinition.setTabbed(false);
                            }
                            this.cleanupTempFolder();
                            return;
                        }
                        this.cleanupTempFolder();
                    }
                }
                object = new ExtensionBundleMessageDlg(spssFrame, CoreResUtil.getString((String)"IDS_INSTALL_EXTENSION_BUNDLE_TITLE2_TEXT"), CoreResUtil.getString((String)"IDS_INSTALL_EXTENSION_BUNDLE_MSG4_TEXT"), "", (Vector<String>)object2, true, "idh_cust_not_writeable");
                object.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SpssAlertOptionPane.showWarningMessageDialog(spssFrame, exception.getMessage(), VersionInfo.getAppVersionString());
            this.cleanupTempFolder();
        }
    }

    private void cleanupTempFolder() {
        if (this.mTempFolder != null) {
            for (File file : this.mTempFolder.listFiles()) {
                file.delete();
            }
            this.mTempFolder.delete();
            this.mTempFolder = null;
        }
    }

    public DialogDefinition readPackageFile(File file) throws Exception {
        DialogDefinition dialogDefinition = null;
        try {
            String string = PrefsMgr.getPrefsMgr().getTempPath();
            this.mTempFolder = PASWFileUtil.createTempFile((String)"_uibuilder", (String)".tmp", (File)new File(string));
            this.mTempFolder.delete();
            if (!this.mTempFolder.mkdir()) {
                throw new Exception(String.format(BuilderResUtil.getString((String)"IDS_CANT_MAKE_TEMP_FOLDER"), this.mTempFolder.getPath()));
            }
            File file2 = this.readEntries(file, this.mTempFolder);
            if (file2 == null || !file2.exists()) {
                throw new Exception(String.format(BuilderResUtil.getString((String)"IDS_BAD_PACKAGE_FILE"), file.getName()));
            }
            dialogDefinition = CommandExecutor.get().readClefFileSpec(file2);
            if (dialogDefinition == null) {
                throw new Exception(BuilderResUtil.getString((String)"IDS_BAD_PACKAGE_FILE"));
            }
            this.setDefinitionPaths(dialogDefinition, this.mTempFolder);
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)("Error reading package file: " + exception.getMessage()), (int)15);
            throw exception;
        }
        finally {
            if (this.mTempFolder != null && this.mTempFolder.exists()) {
                this.mTempFolder.deleteOnExit();
            }
        }
        return dialogDefinition;
    }

    public DialogDefinition readPackageFile(File file, boolean bl) throws Exception {
        DialogDefinition dialogDefinition = null;
        try {
            String string = PrefsMgr.getPrefsMgr().getTempPath();
            this.mTempFolder = PASWFileUtil.createTempFile((String)"_uibuilder", (String)".tmp", (File)new File(string));
            this.mTempFolder.delete();
            if (!this.mTempFolder.mkdir()) {
                throw new Exception(String.format(BuilderResUtil.getString((String)"IDS_CANT_MAKE_TEMP_FOLDER"), this.mTempFolder.getPath()));
            }
            this.mTempFolder.deleteOnExit();
            this.mExtensionFile = null;
            this.mAppExtFile = null;
            FileInputStream fileInputStream = new FileInputStream(file);
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            this.mExtensionFile = bl ? this.readFromJar(this.mTempFolder, this.mExtensionFile, jarInputStream) : this.readCFFromJar(this.mTempFolder, this.mExtensionFile, jarInputStream);
            jarInputStream.close();
            if (this.mExtensionFile == null || !this.mExtensionFile.exists()) {
                throw new Exception("CLEF file does not exist");
            }
            dialogDefinition = bl ? this.setCurrentDefinition(this.mExtensionFile, null, true) : this.setCurrentCFDefinition(this.mExtensionFile, this.mAppExtFile, true);
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)("Error reading package file: " + exception.getMessage()), (int)15);
            throw exception;
        }
        finally {
            if (this.mTempFolder != null && this.mTempFolder.exists()) {
                this.mTempFolder.deleteOnExit();
            }
        }
        return dialogDefinition;
    }

    private DialogDefinition setCurrentDefinition(File file, File file2, boolean bl) throws Exception {
        DialogDefinition dialogDefinition = BuilderUtil.getInstance().readClefFileSpec(file, file2, true);
        if (dialogDefinition == null) {
            throw new Exception("Cannot read file specification");
        }
        if (bl) {
            String string;
            String string2;
            String string3;
            File file3 = file.getParentFile();
            String string4 = dialogDefinition.getHelpFileName();
            if (string4 != null && string4.length() > 0) {
                string3 = new File(string4).getName();
                string2 = file3.getCanonicalPath() + File.separator + string3;
                dialogDefinition.setHelpFileName(string2);
            }
            if ((string3 = dialogDefinition.getCustomPropertiesFile()) != null && string3.length() > 0) {
                string2 = new File(string3).getName();
                string = file3.getCanonicalPath() + File.separator + string2;
                dialogDefinition.setCustomPropertiesFile(string);
            }
            LinkedList linkedList = dialogDefinition.getPanels();
            for (PanelDefinition panelDefinition : linkedList) {
                for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                    string = panelDefinition.getPanelElement(i);
                    if (!(string instanceof SubDlgButtonDefinition) || (string4 = (string2 = ((SubDlgButtonDefinition)string).getDialogDefinition()).getHelpFileName()) == null || string4.length() <= 0) continue;
                    String string5 = new File(string4).getName();
                    String string6 = file3.getCanonicalPath() + File.separator + string5;
                    string2.setHelpFileName(string6);
                }
            }
        }
        return dialogDefinition;
    }

    private DialogDefinition setCurrentCFDefinition(File file, File file2, boolean bl) throws Exception {
        DialogDefinition dialogDefinition = BuilderUtil.getInstance().readClefFileSpec(file, file2, false);
        if (dialogDefinition == null) {
            throw new Exception("Cannot read file specification");
        }
        if (bl) {
            Object object;
            String string;
            String string2;
            String string3;
            File file3 = file.getParentFile();
            String string4 = dialogDefinition.getHelpFileName();
            if (string4 != null && string4.length() > 0) {
                string3 = new File(string4).getName();
                string2 = file3.getCanonicalPath() + File.separator + "helps" + File.separator + string3;
                dialogDefinition.setHelpFileName(string2);
            }
            if ((string3 = dialogDefinition.getCustomPropertiesFile()) != null && string3.length() > 0) {
                string2 = new File(string3).getName();
                string = file3.getCanonicalPath() + File.separator + string2;
                dialogDefinition.setCustomPropertiesFile(string);
            }
            if ((string2 = dialogDefinition.getNodeIconFile()) != null && string2.length() > 0) {
                string = new File(string2).getName();
                object = file3.getCanonicalPath() + File.separator + "images" + File.separator + string;
                dialogDefinition.setNodeIconFile((String)object);
            }
            LinkedList linkedList = dialogDefinition.getPanels();
            for (PanelDefinition panelDefinition : linkedList) {
                for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                    object = panelDefinition.getPanelElement(i);
                    if (!(object instanceof SubDlgButtonDefinition) || (string4 = (string = ((SubDlgButtonDefinition)object).getDialogDefinition()).getHelpFileName()) == null || string4.length() <= 0) continue;
                    String string5 = new File(string4).getName();
                    String string6 = file3.getCanonicalPath() + File.separator + "helps" + File.separator + string5;
                    string.setHelpFileName(string6);
                }
            }
        }
        return dialogDefinition;
    }

    private File readFromJar(File file, File file2, JarInputStream jarInputStream) throws IOException {
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string = jarEntry.getName();
            ByteBuffer byteBuffer = this.readEntry(jarInputStream);
            File file3 = new File(file.getPath() + File.separator + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            fileOutputStream.write(byteBuffer.array());
            fileOutputStream.close();
            jarInputStream.closeEntry();
            if (XML_FILE_EXT.regionMatches(true, 0, string, string.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length())) {
                file2 = file3;
            }
            file3.deleteOnExit();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    private File readCFFromJar(File file, File file2, JarInputStream jarInputStream) throws IOException {
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string = jarEntry.getName();
            File file3 = new File(file.getPath() + File.separator + string);
            if (!jarEntry.isDirectory()) {
                ByteBuffer byteBuffer = this.readEntry(jarInputStream);
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                fileOutputStream.write(byteBuffer.array());
                fileOutputStream.close();
                jarInputStream.closeEntry();
                if (EXT_FILE_NAME.regionMatches(true, 0, string, 0, EXT_FILE_NAME.length())) {
                    file2 = file3;
                } else if (APP_EXT_FILE_NAME.regionMatches(true, 0, string, 0, APP_EXT_FILE_NAME.length())) {
                    this.mAppExtFile = file3;
                }
            } else {
                file3.mkdir();
            }
            file3.deleteOnExit();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    public boolean validateSyntaxAndMenuLocation(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl) {
        boolean bl2 = this.checkForSyntaxTemplate(jFrame, dialogDefinition, bl);
        if (bl2) {
            bl2 = this.checkForMenuLocation(jFrame, dialogDefinition, bl);
        }
        return bl2;
    }

    public boolean deploySpecification(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl) {
        return this.deploySpecification(jFrame, dialogDefinition, bl, false);
    }

    public boolean deploySpecification(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl, boolean bl2) {
        return this.deploySpecification(true, jFrame, dialogDefinition, bl, bl2);
    }

    public boolean deploySpecification(boolean bl, JFrame jFrame, DialogDefinition dialogDefinition, boolean bl2, boolean bl3) {
        this.mShowWarnings = bl2;
        if (bl2 && !MissingAddOnsDlg.checkForMissingAddOns(jFrame, dialogDefinition)) {
            return false;
        }
        try {
            String string;
            SpecificationWriter specificationWriter;
            int n;
            String string2 = SpecificationWriter.getDeploymentFolder((boolean)bl3);
            if (string2 == null) {
                if (jFrame != null) {
                    Object[] objectArray = new String[]{ResUtil.getCommonDlgString("IDS_OK"), ResUtil.getCommonDlgString("IDS_HELP")};
                    int n2 = SpssAlertOptionPane.showOptionDialog(jFrame, BuilderResUtil.getString((String)"IDS_INSTALL_SPEC_ERROR"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
                    if (n2 == 1) {
                        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_UIBUILDER");
                    }
                }
                return false;
            }
            String string3 = string2 + File.separator + dialogDefinition.getDialogId();
            File file = new File(string3);
            if (!file.exists()) {
                if (!file.mkdirs()) {
                    throw new Exception("Error creating deployment directory");
                }
            } else if (bl2 && (n = SpssAlertOptionPane.showConfirmDialog(jFrame, BuilderResUtil.getString((String)"IDS_OVERWRITE_SPEC_QUERY"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) != 0) {
                return false;
            }
            if (!(specificationWriter = new SpecificationWriter(dialogDefinition)).writeClefStream(string = string3 + File.separator + dialogDefinition.getDialogId() + XML_FILE_EXT)) {
                throw new Exception(this.makeErrorText(specificationWriter));
            }
            StatsCDBAppInfo statsCDBAppInfo = new StatsCDBAppInfo(true);
            BuilderUtil.getInstance().setAppInfo((CDBAppInfo)statsCDBAppInfo);
            BuilderUtil.getInstance().updateFrames(dialogDefinition, string);
            if (bl2 && bl) {
                String string4 = dialogDefinition.getCommandLocation().getCommandPath() + ">" + dialogDefinition.getCommandLocation().getCommandTitle();
                this.showDeployedMsg(jFrame, dialogDefinition, string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (bl2) {
                SpssAlertOptionPane.showErrorMessageDialog(jFrame, BuilderResUtil.getString((String)"IDS_ERROR_SAVING_DLG") + "\n\n" + exception.getMessage(), VersionInfo.getAppVersionString());
            }
            return false;
        }
        return true;
    }

    public boolean deployCFSpecification(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl) {
        return this.deployCFSpecification(true, jFrame, dialogDefinition, bl, false);
    }

    public boolean deployCFSpecification(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl, boolean bl2) {
        return this.deployCFSpecification(true, jFrame, dialogDefinition, bl, bl2);
    }

    public boolean deployCFSpecification(boolean bl, JFrame jFrame, DialogDefinition dialogDefinition, boolean bl2, boolean bl3) {
        if (dialogDefinition.getDialogId().contains(" ")) {
            BuilderAlertPane.showWarningMessageDialog((Window)jFrame, (String)BuilderResUtil.getString((String)"IDS_IDS_CANT_HAVE_SPACES"), (String)BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        StatsCDBAppInfo statsCDBAppInfo = new StatsCDBAppInfo(false);
        statsCDBAppInfo.setExEnvPathsPriority(bl3);
        BuilderUtil.getInstance().setAppInfo((CDBAppInfo)statsCDBAppInfo);
        DialogDefinition dialogDefinition2 = (DialogDefinition)dialogDefinition.clone();
        if (dialogDefinition2 == null) {
            return false;
        }
        if (bl2 && !MissingAddOnsDlg.checkForMissingAddOns(jFrame, dialogDefinition2)) {
            return false;
        }
        String string = BuilderUtil.getInstance().getExtensionPath().getAbsolutePath();
        String string2 = string + File.separator + dialogDefinition2.getDialogId() + ".cfe";
        File file = new File(string2);
        try {
            SpecificationWriter specificationWriter;
            if (!file.exists() && !file.createNewFile()) {
                throw new Exception("Error creating deployment file");
            }
            String string3 = BuilderUtil.getInstance().hasMenuItem(dialogDefinition2);
            if (string3 != null) {
                int n = BuilderAlertPane.showConfirmDialog((Window)jFrame, (String)BuilderResUtil.getString((String)"IDS_SAME_MENU_ITEM_WARNING"), (String)BuilderUtil.getInstance().getAppVersionString(), (BuilderAlertPane.OptionType)BuilderAlertPane.OptionType.YES_NO_OPTION);
                if (n != 1) {
                    return false;
                }
                if (!BuilderUtil.getInstance().removeDeployed(string + File.separator + string3 + ".cfe")) {
                    return false;
                }
            }
            if (!this.writeCfeFile(string2, specificationWriter = new SpecificationWriter(dialogDefinition2), dialogDefinition2)) {
                throw new Exception(this.makeErrorText(specificationWriter));
            }
            String string4 = BuilderUtil.getInstance().loadExtension(file);
            String string5 = BuilderUtil.getInstance().getUIExtensionsFolderPath() == null ? string : (string.startsWith(BuilderUtil.getInstance().getUIExtensionsFolderPath()) ? "" : string);
            BuilderUtil.getInstance().addCfeMenuToFrames(dialogDefinition2.getCommandLocation().getCommandActionId(), dialogDefinition2.getCommandLocation().getCommandPath());
            if (bl) {
                String string6 = String.format(BuilderResUtil.getString((String)"IDS_DIALOG_INSTALLED"), string5);
                BuilderAlertPane.showInformationMessageDialog((Window)jFrame, (String)string6, (String)BuilderUtil.getInstance().getAppVersionString());
            }
        }
        catch (PaswException paswException) {
            if (!file.delete()) {
                file.deleteOnExit();
            }
            BuilderAlertPane.showErrorMessageDialog((Window)jFrame, (String)(BuilderResUtil.getString((String)"IDS_ERROR_SAVING_DLG") + "\n\n" + paswException.getMessage()), (String)BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        catch (IOException iOException) {
            if (!file.delete()) {
                file.deleteOnExit();
            }
            BuilderAlertPane.showErrorMessageDialog((Window)jFrame, (String)(BuilderResUtil.getString((String)"IDS_ERROR_SAVING_DLG") + "\n\n" + iOException.getMessage()), (String)BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BuilderAlertPane.showErrorMessageDialog((Window)jFrame, (String)(BuilderResUtil.getString((String)"IDS_ERROR_SAVING_DLG") + "\n\n" + exception.getMessage()), (String)BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        return true;
    }

    private void showDeployedMsg(JFrame jFrame, DialogDefinition dialogDefinition, String string) {
        String string2 = dialogDefinition.getCommandLocation().getCommandActionId();
        String string3 = dialogDefinition.getCommandLocation().getCommandPath();
        String string4 = Integer.toString(dialogDefinition.getCommandLocation().getMenuItemOffset());
        boolean bl = CommandExecutor.get().hasCommand(string3, string2, string4);
        if (!bl) {
            SpssAlertOptionPane.showInformationMessageDialog(jFrame, BuilderResUtil.getString((String)"IDS_DIALOG_DEPLOYED"), VersionInfo.getAppVersionString());
        } else {
            String string5 = String.format(BuilderResUtil.getString((String)"IDS_DIALOG_INSTALLED"), string);
            SpssAlertOptionPane.showInformationMessageDialog(jFrame, string5, VersionInfo.getAppVersionString());
        }
    }

    private String makeErrorText(SpecificationWriter specificationWriter) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        Vector vector = specificationWriter.getErrors();
        for (String string : vector) {
            stringBuffer.append(n++).append(". ").append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private File readEntries(File file, File file2) throws IOException {
        File file3 = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        JarInputStream jarInputStream = new JarInputStream(fileInputStream);
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string = jarEntry.getName();
            ByteBuffer byteBuffer = this.readEntry(jarInputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(file2.getPath() + File.separator + string);
            fileOutputStream.write(byteBuffer.array());
            fileOutputStream.close();
            jarInputStream.closeEntry();
            String string2 = XML_FILE_EXT;
            if (string2.regionMatches(true, 0, string, string.length() - string2.length(), string2.length())) {
                file3 = new File(file2.getPath() + File.separator + string);
            }
            jarEntry = jarInputStream.getNextJarEntry();
        }
        jarInputStream.close();
        return file3;
    }

    private ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        try {
            int n = jarInputStream.read(byArray, 0, 4096);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 4096);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    private void setDefinitionPaths(DialogDefinition dialogDefinition, File file) throws Exception {
        String string;
        String string2;
        String string3;
        String string4 = dialogDefinition.getHelpFileName();
        if (string4 != null && string4.length() > 0) {
            string3 = new File(string4).getName();
            string2 = file.getCanonicalPath() + File.separator + string3;
            dialogDefinition.setHelpFileName(string2);
        }
        if ((string3 = dialogDefinition.getCustomPropertiesFile()) != null && string3.length() > 0) {
            string2 = new File(string3).getName();
            string = file.getCanonicalPath() + File.separator + string2;
            dialogDefinition.setCustomPropertiesFile(string);
        }
        LinkedList linkedList = dialogDefinition.getPanels();
        for (PanelDefinition panelDefinition : linkedList) {
            for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                string = panelDefinition.getPanelElement(i);
                if (!(string instanceof SubDlgButtonDefinition) || (string4 = (string2 = ((SubDlgButtonDefinition)string).getDialogDefinition()).getHelpFileName()) == null || string4.length() <= 0) continue;
                String string5 = new File(string4).getName();
                String string6 = file.getCanonicalPath() + File.separator + string5;
                string2.setHelpFileName(string6);
            }
        }
    }

    private boolean checkForMenuLocation(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl) {
        if (this.mShowWarnings && dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)this).length() == 0) {
            Object[] objectArray = new String[]{BuilderResUtil.getString((String)"IDS_OK")};
            String string = bl ? BuilderResUtil.getString((String)"IDS_NO_MENU_LOC_WARNING_BUNDLE") : BuilderResUtil.getString((String)"IDS_NO_MENU_LOCATION_MSG");
            int n = SpssAlertOptionPane.showOptionDialog(jFrame, String.format(string, dialogDefinition.getDialogId()), BuilderResUtil.getString((String)"IDS_CANNOT_INSTALL_DIALOG"), SpssAlertOptionPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
            return false;
        }
        return true;
    }

    private boolean checkForSyntaxTemplate(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl) {
        if (dialogDefinition.getDialogSyntax().length() == 0) {
            Object[] objectArray = new String[]{BuilderResUtil.getString((String)"IDS_OK")};
            String string = bl ? BuilderResUtil.getString((String)"IDS_NO_TEMPLATE_WARNING_BUNDLE") : BuilderResUtil.getString((String)"IDS_NO_TEMPLATE_WARNING_STATS");
            int n = SpssAlertOptionPane.showOptionDialog(jFrame, String.format(string, dialogDefinition.getDialogId()), BuilderResUtil.getString((String)"IDS_CANNOT_INSTALL_DIALOG"), SpssAlertOptionPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeCfeFile(String string, SpecificationWriter specificationWriter, DialogDefinition dialogDefinition) throws IOException {
        boolean bl = true;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            String string2;
            if (this.mTempFolder == null) {
                string2 = PrefsMgr.getPrefsMgr().getTempPath();
                this.mTempFolder = PASWFileUtil.createTempFile((String)"_uibuilder", (String)".tmp", (File)new File(string2));
                this.mTempFolder.delete();
                if (!this.mTempFolder.mkdir()) {
                    throw new Exception(String.format(BuilderResUtil.getString((String)"IDS_CANT_MAKE_TEMP_FOLDER"), this.mTempFolder.getPath()));
                }
                this.mTempFolder.deleteOnExit();
            }
            string2 = this.mTempFolder.getPath() + File.separator + "extension" + XML_FILE_EXT;
            new File(string2).deleteOnExit();
            if (!specificationWriter.writeCFStream(string2, true, true)) {
                boolean bl2 = false;
                return bl2;
            }
            string2 = this.mTempFolder.getPath() + File.separator + "app-extension" + XML_FILE_EXT;
            if (!specificationWriter.writeAppExtensionsStream(string2)) {
                boolean bl3 = false;
                return bl3;
            }
            string2 = this.mTempFolder.getPath() + File.separator + "module" + XML_FILE_EXT;
            if (!specificationWriter.writeCFModuleStream(string2)) {
                boolean bl4 = false;
                return bl4;
            }
            BuilderUtil.getInstance().writeIconFiles(this.mTempFolder, ScriptType.SYNTAX);
            BuilderUtil.getInstance().writePeerJar(this.mTempFolder, ScriptType.SYNTAX);
            BuilderUtil.getInstance().writePropertiesFiles(this.mTempFolder, dialogDefinition.getDialogId(), ScriptType.SYNTAX);
            FileOutputStream fileOutputStream = new FileOutputStream(string, false);
            deflaterOutputStream = new JarOutputStream(fileOutputStream);
            ((ZipOutputStream)deflaterOutputStream).setMethod(8);
            this.saveToJar((JarOutputStream)deflaterOutputStream, this.mTempFolder, false);
            String string3 = dialogDefinition.getHelpFileName();
            if (string3 != null && string3.length() > 0) {
                String string4 = this.mTempFolder.getPath() + File.separator + "helps";
                String string5 = SpecificationWriter.getDeploymentFolder((boolean)false) + File.separator + dialogDefinition.getDialogId();
                boolean bl5 = string3.contains(File.separator);
                if (!bl5) {
                    string3 = string4 + File.separator + string3;
                    dialogDefinition.setHelpFileName(string3);
                }
                LinkedList linkedList = dialogDefinition.getPanels();
                for (PanelDefinition panelDefinition : linkedList) {
                    for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                        DialogDefinition dialogDefinition2;
                        PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
                        if (!(panelElementDefinition instanceof SubDlgButtonDefinition) || (string3 = (dialogDefinition2 = ((SubDlgButtonDefinition)panelElementDefinition).getDialogDefinition()).getHelpFileName()) == null || string3.length() <= 0 || (bl5 = string3.contains(File.separator))) continue;
                        string3 = string4 + File.separator + string3;
                        dialogDefinition2.setHelpFileName(string3);
                    }
                }
                if (!specificationWriter.writeHelpFiles(dialogDefinition, string5, true)) {
                    throw new Exception(this.makeErrorText(specificationWriter));
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        finally {
            if (deflaterOutputStream != null) {
                try {
                    deflaterOutputStream.flush();
                    ((ZipOutputStream)deflaterOutputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return bl;
    }

    private void saveToJar(JarOutputStream jarOutputStream, File file, boolean bl) throws Exception {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            Object object;
            if (file2.isFile()) {
                object = new FileInputStream(file2);
                int n = ((FileInputStream)object).available();
                byte[] byArray = new byte[n];
                int n2 = ((FileInputStream)object).read(byArray);
                ((FileInputStream)object).close();
                if (n2 != n) {
                    throw new Exception("Can't read input bytes");
                }
                CRC32 cRC32 = new CRC32();
                cRC32.update(byArray);
                String string = bl ? file.getName() + "/" + file2.getName() : file2.getName();
                JarEntry jarEntry = new JarEntry(string);
                jarEntry.setCompressedSize(n);
                jarEntry.setCrc(cRC32.getValue());
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.write(byArray);
                jarOutputStream.closeEntry();
                continue;
            }
            object = file2.getName();
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + "/";
            }
            JarEntry jarEntry = new JarEntry((String)object);
            jarOutputStream.putNextEntry(jarEntry);
            jarOutputStream.closeEntry();
            this.saveToJar(jarOutputStream, file2, true);
        }
    }

    public String getString(String string) {
        return ResUtil.getString(string);
    }

    class SPDXFilter
    extends FileFilter {
        SPDXFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            String string2 = BuilderFrame.getBuilderSPDXExpension();
            return string2.regionMatches(true, 0, string, string.length() - string2.length(), string2.length());
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString((String)"IDS_SPDX_FILE_DESC");
        }
    }

    class UiPkgFilter
    extends FileFilter {
        UiPkgFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = BuilderFrame.getBuilderSPDExpension();
            String string2 = file.getName();
            return string.regionMatches(true, 0, string2, string2.length() - string.length(), string.length());
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString((String)"IDS_PKG_FILE_DESC");
        }
    }
}

