/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.laf.GradientTabbedPane;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JTable;

public class GotoDataEditorAction
extends SpssAction {
    public GotoDataEditorAction() {
        this("go_to_data");
    }

    public GotoDataEditorAction(String string) {
        super(string);
        this.configureAction(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        if (locallyUniqueId == null) {
            locallyUniqueId = DataMgr.getDataMgr().getActiveBackendDocumentId();
        }
        if (locallyUniqueId == null) {
            return;
        }
        DataFrame dataFrame = SpssFrameMgr.getSpssFrameMgr().getDataFrame(locallyUniqueId);
        if (dataFrame != null) {
            dataFrame.setState(0);
            dataFrame.toFront();
        }
    }

    public static void selectDataCases(int[] nArray, boolean bl, boolean bl2) {
        DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (dataFrame != null && nArray.length > 0) {
            dataFrame.toFront();
            DataView dataView = dataFrame.getDataView();
            GradientTabbedPane gradientTabbedPane = dataView.getTabbedPane();
            gradientTabbedPane.setSelectedIndex(0);
            JTable jTable = dataView.getDataTables()[0];
            JTable jTable2 = dataView.getDataTables()[1];
            Rectangle rectangle = jTable.getVisibleRect();
            double d = rectangle.getHeight();
            double d2 = jTable.getRowHeight();
            int n = (int)(d / d2);
            if (bl) {
                jTable.clearSelection();
            }
            if (jTable.getColumnCount() > 0) {
                jTable.setColumnSelectionInterval(0, jTable.getColumnCount() - 1);
                jTable2.setColumnSelectionInterval(0, 0);
            }
            if (nArray.length > 0) {
                jTable.setRowSelectionInterval(nArray[0] - 1, nArray[0] - 1);
                jTable2.setRowSelectionInterval(nArray[0] - 1, nArray[0] - 1);
                if (nArray.length > 1) {
                    for (int i = 1; i < nArray.length; ++i) {
                        jTable.addRowSelectionInterval(nArray[i] - 1, nArray[i] - 1);
                        jTable2.addRowSelectionInterval(nArray[i] - 1, nArray[i] - 1);
                    }
                }
                if (bl2) {
                    GotoDataEditorAction.scrollRowToVisible(jTable, nArray[0] - 1);
                }
            }
        }
    }

    private static void scrollRowToVisible(JTable jTable, int n) {
        Rectangle rectangle = jTable.getVisibleRect();
        Rectangle rectangle2 = jTable.getCellRect(n, 0, false);
        int n2 = rectangle.height / rectangle2.height;
        int n3 = rectangle2.height * n2;
        int n4 = n3 / 4;
        if (rectangle.y > rectangle2.y - 20) {
            rectangle2.y -= n4;
        } else if (rectangle.getMaxY() < rectangle2.getMaxY() + 20.0) {
            rectangle2.y += n4 * 3;
        }
        jTable.scrollRectToVisible(rectangle2);
    }
}

