/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.winutils.WindowsRegistryReader;

public class ExportToDimensionAction
extends ProcedureAction {
    private static String sDimensionsVersion = null;

    public ExportToDimensionAction(String string, String string2) {
        super(string, string2);
        this.configureAction(true);
    }

    @Override
    public boolean showMenu() {
        if (OSInfo.getOSType() == OSInfo.OSType.WIN && !VersionInfo.isStudentVersion()) {
            try {
                if (sDimensionsVersion == null) {
                    sDimensionsVersion = "";
                    String[] stringArray = WindowsRegistryReader.getWindowsRegistryReader().readSubKeysWinRegistry("HKLM", "SOFTWARE\\Microsoft\\.NETFramework\\AssemblyFolders");
                    if (stringArray != null) {
                        for (String string : stringArray) {
                            String string2 = "SPSSMR.DMOM.";
                            if (!string.toUpperCase().startsWith(string2)) continue;
                            String string3 = string.substring(string2.length());
                            if (sDimensionsVersion != null && string3.compareToIgnoreCase(sDimensionsVersion) <= 0) continue;
                            sDimensionsVersion = string3;
                        }
                    }
                }
                if (sDimensionsVersion.length() > 0) {
                    try {
                        int n = Integer.parseInt(sDimensionsVersion.replace(".", ""));
                        return !DataServerProxy.getDataProxy().isRemoteConnection() && n >= 3501;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        if (!(iTopWindow instanceof DataFrame)) {
            return false;
        }
        DataFrame dataFrame = (DataFrame)iTopWindow;
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(dataFrame.getDatasetId());
        return iSpssDataSrc != null && iSpssDataSrc.columnCount() > 0;
    }
}

