/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.licensing.SPSSLic;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import java.awt.event.ActionEvent;

public class ExitAction
extends SpssAction {
    public ExitAction() {
        this("file_exit");
    }

    public ExitAction(String string) {
        super(string);
        this.configureAction(false);
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        return this.canEnable();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doExit();
    }

    private void doSignOutAndExit() {
        boolean bl;
        if (SPSSLic.confirmSignOutAndExit() && (bl = AppMgr.getAppMgr().closeSessionData(true))) {
            SPSSLic.signOutAndExit();
            AppMgr.getAppMgr().closeSessionData(false);
        }
    }

    public void doExit() {
        if (this.canEnable()) {
            if (this.getActionId() == "file_signout_and_exit" || this.getActionId() == "file_signout_and_quit") {
                this.doSignOutAndExit();
            } else {
                AppMgr.getAppMgr().closeSessionData(false);
            }
        }
    }

    private boolean canEnable() {
        return !ComponentState.getProcessorAvailable() || !ComponentState.getProcessorBusy();
    }
}

