/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.data_access.DacMgr;
import com.spss.java_client.core.documents.data.data_access.DacType;
import com.spss.java_client.core.documents.data.data_access.ODBC.ODBCDacProxy;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardDataReader;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardDlgType;
import com.spss.java_client.ui.dialogs.base.file.openquery.KeyDoesNotExistsException;
import com.spss.java_client.ui.dialogs.base.file.openquery.NewQueryDlg;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class EditQueryAction
extends SpssAction {
    public EditQueryAction() {
        this("file_edit_query");
    }

    public EditQueryAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        ODBCDacProxy oDBCDacProxy;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        boolean bl = false;
        if (DacMgr.getDacMgr().isDacPackageInstalled(DacType.DAC_ODBC) && (oDBCDacProxy = ODBCDacProxy.getODBCDacProxy()).isServerPackageLoaded()) {
            ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
            oDBCDacProxy.getDataSources(vector, sqlReturnCode);
            if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                ODBCDacProxy.getODBCDacProxy().getOleDbDataSources(vector2, sqlReturnCode);
                bl = vector2.size() > 0;
            }
        }
        return ComponentState.getProcessorAvailable() && !ComponentState.getProcessorBusy() && (vector.size() > 0 || bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame((Container)actionEvent.getSource());
        DBWizardDlgType.setDBWizardDlgType(DBWizardDlgType.DBWizardDialogTypeEnum.eEditQueryDlg);
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        RefFileFilter refFileFilter = new RefFileFilter(ResUtil.getString(resourceBundle, "IDS_DB_COMMON_DATABASE_QUERY"), ResUtil.getString(resourceBundle, "IDS_DB_COMMON_SPQ"));
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(true);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setDialogTitle(VersionInfo.getAppVersionString());
        int n = remoteFileChooser.showOpenDialog(spssFrame);
        if (n == 0) {
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string = remoteFileChooser.getSelectedFilePath();
            if (string.length() > 0) {
                try {
                    boolean bl = DBWizardDataReader.readSerializedData(string);
                    if (bl) {
                        NewQueryDlg newQueryDlg = null;
                        newQueryDlg = new NewQueryDlg(spssFrame);
                    }
                }
                catch (KeyDoesNotExistsException keyDoesNotExistsException) {
                    SpssAlertOptionPane.showWarningMessageDialog(spssFrame, MessageFormat.format(ResUtil.getString(resourceBundle, "ERR_DB_COMMON_INCOMPITIBLE_FORMAT"), string), ResUtil.getString(resourceBundle, "IDS_DBWIZARD_WARNING_TITLE"));
                }
                catch (IOException iOException) {
                    SpssAlertOptionPane.showWarningMessageDialog(spssFrame, MessageFormat.format(ResUtil.getString(resourceBundle, "ERR_DB_COMMON_INCOMPITIBLE_FORMAT"), string), ResUtil.getString(resourceBundle, "IDS_DBWIZARD_WARNING_TITLE"));
                }
                finally {
                    ODBC.getODBC().disconnect();
                }
            }
        }
    }
}

