/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.dialogs.base.custom_gui.DialogExecutor;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.utilities.StatsCDBAppInfo;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.custom_gui.ui_builder.BaseDialogExecutor;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.CDBAppInfo;
import com.spss.shared.custom_gui.ui_builder.extension.ExtensionPropertyContainer;
import com.spss.shared.custom_gui.ui_builder.extension.ExtensionPropertyDlg;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class EditInstalledExtensionBundlesAction
extends SpssAction {
    static final String EXTENSION_BUNDLE_DLG_TITLE = "IDS_EDIT_INSTALLED_EXTENSION_BUNDLES_DIALOG_TITLE";
    static final String EXTENSION_BUNDLE_DLG_FILE_FILTER_TEXT = "IDS_FILE_CHOOSER_EXTENSION_BUNDLE_FILE_FILTER_TEXT";
    static final String EXTENSION_BUNDLE_DLG_FILE_EXT_TEXT = ".spe";

    public EditInstalledExtensionBundlesAction() {
        this("utilities_edit_extension_bundles_dialog");
    }

    public EditInstalledExtensionBundlesAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = OSInfo.getOSType() == OSInfo.OSType.MAC ? null : this.getFrame(((Container)actionEvent.getSource()).getParent());
        File file = this.getExtensionBundleFile(spssFrame);
        if (file != null) {
            try {
                StatsCDBAppInfo statsCDBAppInfo = new StatsCDBAppInfo(false);
                BuilderUtil.getInstance().setAppInfo((CDBAppInfo)statsCDBAppInfo);
                BuilderUtil.getInstance().setStandalone(true);
                ExtensionPropertyContainer extensionPropertyContainer = new ExtensionPropertyContainer(file.getAbsolutePath());
                ExtensionPropertyDlg extensionPropertyDlg = new ExtensionPropertyDlg((JFrame)spssFrame, extensionPropertyContainer, (BaseDialogExecutor)new DialogExecutor());
                ResourceBundle resourceBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                extensionPropertyDlg.setTitle(resourceBundle.getString("IDS_EXTENSION_BUNDLE_EDIT_TITLE"));
                extensionPropertyDlg.setModal(true);
                extensionPropertyDlg.setVisible(true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private File getExtensionBundleFile(SpssFrame spssFrame) {
        File file = null;
        RemoteFileChooser remoteFileChooser = this.showFileDialog(EXTENSION_BUNDLE_DLG_FILE_EXT_TEXT, CoreResUtil.getString((String)EXTENSION_BUNDLE_DLG_FILE_FILTER_TEXT), CoreResUtil.getString((String)EXTENSION_BUNDLE_DLG_TITLE), spssFrame);
        if (remoteFileChooser != null) {
            file = remoteFileChooser.getSelectedFile();
        }
        return file;
    }

    private RemoteFileChooser showFileDialog(String string, String string2, String string3, SpssFrame spssFrame) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false, false, false, true, false);
        remoteFileChooser.setDialogTitle(string3);
        remoteFileChooser.setFileSelectionMode(0);
        RefFileFilter refFileFilter = new RefFileFilter(string2, string);
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(OSInfo.getOSType() == OSInfo.OSType.MAC);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = remoteFileChooser.showOpenDialog(spssFrame);
        if (n == 0) {
            return remoteFileChooser;
        }
        return null;
    }
}

