/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.serialize.DataSerializer;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerPanel;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JTable;

public class CutAction
extends SpssAction {
    public CutAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ITopWindow iTopWindow = this.getTopWindow(((Container)actionEvent.getSource()).getParent());
        if (iTopWindow instanceof SpssFrame) {
            ((SpssFrame)iTopWindow).doCut();
        } else {
            ViewerPanel viewerPanel = iTopWindow.getViewerPanel();
            if (viewerPanel != null) {
                viewerPanel.doCut();
            }
        }
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        if (iTopWindow instanceof SyntaxFrame) {
            return ((SyntaxFrame)iTopWindow).getSyntaxView().getSelectedText().length() > 0;
        }
        if (iTopWindow instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)iTopWindow;
            DataView dataView = dataFrame.getDataView();
            if (dataView != null) {
                int n = dataView.getActiveView();
                if (n != 0) {
                    return false;
                }
                JTable jTable = dataView.getDataTable(n);
                return DataSerializer.canCopy(jTable);
            }
        } else {
            if (iTopWindow instanceof ViewerFrame) {
                ViewerFrame viewerFrame = (ViewerFrame)iTopWindow;
                return viewerFrame.getDocument().getSelectedItemCount(true) > 0 && (!viewerFrame.getDocument().getCoreDocument().isLocked() || !VersionInfo.isSmartReader());
            }
            ViewerDocument viewerDocument = iTopWindow.getViewerDocument();
            if (viewerDocument != null) {
                return viewerDocument.getSelectedItemCount(true) > 0;
            }
        }
        return false;
    }
}

