/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.serialize.DataSerializer;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerPanel;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JTable;

public class CopyAction
extends SpssAction {
    public CopyAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ITopWindow iTopWindow = this.getTopWindow(((Container)actionEvent.getSource()).getParent());
        if (iTopWindow instanceof SpssFrame) {
            if (iTopWindow instanceof DataFrame) {
                ((DataFrame)iTopWindow).getDataView().setCopyType(DataView.CopyType.COPY_WITH_NONE);
            }
            ((SpssFrame)iTopWindow).doCopy();
        } else {
            ViewerPanel viewerPanel = iTopWindow.getViewerPanel();
            if (viewerPanel != null) {
                viewerPanel.doCopy();
            }
        }
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        if (iTopWindow instanceof SyntaxFrame) {
            return ((SyntaxFrame)iTopWindow).getSyntaxView().getSelectedText().length() > 0;
        }
        if (iTopWindow instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)iTopWindow;
            DataView dataView = dataFrame.getDataView();
            if (dataView != null) {
                JTable jTable = dataView.getDataTable(dataView.getActiveView());
                return DataSerializer.canCopy(jTable);
            }
        } else {
            ViewerDocument viewerDocument = iTopWindow.getViewerDocument();
            if (viewerDocument != null) {
                return viewerDocument.getSelectedItemCount(true) > 0;
            }
        }
        return false;
    }
}

