/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.util.OutOfMemoryErrorHandler;
import com.spss.uitools.util.TraceSettings;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class CloseAction
extends SpssAction {
    public CloseAction() {
        this("file_close");
    }

    public CloseAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        boolean bl = true;
        if (iTopWindow instanceof DataFrame) {
            bl = DataMgr.getDataMgr().dataSourceCount() > 1;
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        if (actionEvent.getSource() instanceof Component) {
            SpssFrame spssFrame = this.getFrame((Component)actionEvent.getSource());
            if (spssFrame instanceof SpssFrame) {
                SpssFrame[] spssFrameArray;
                SpssFrameMgr spssFrameMgr = SpssFrameMgr.getSpssFrameMgr();
                SpssFrame spssFrame2 = spssFrameMgr.getDesignatedFrame(DocType.DE_DOC);
                SpssFrame spssFrame3 = spssFrame;
                spssFrame3.performClose();
                bl = true;
                spssFrameMgr.setActivatedFrame(spssFrameMgr.getDesignatedFrame(spssFrame3.docType()));
                if (spssFrame2 == null && (spssFrameArray = spssFrameMgr.getOpenDocuments()).length == 0 && !ComponentState.getProcessorBusy()) {
                    AppMgr.getAppMgr().closeSessionData(false);
                    bl = false;
                }
            } else {
                spssFrame.dispose();
            }
        }
        if (bl) {
            if (TraceSettings.getTrace((int)131072)) {
                TraceSettings.trace1((String)("CloseAction: Available memory before suggesting GC: " + Runtime.getRuntime().freeMemory() + " bytes"), (int)131072);
            }
            try {
                OutOfMemoryErrorHandler.runGC();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (TraceSettings.getTrace((int)131072)) {
                TraceSettings.trace1((String)("CloseAction: Available memory after suggesting GC: " + Runtime.getRuntime().freeMemory() + " bytes"), (int)131072);
            }
            TraceSettings.tracePerformance((String)"Doc Close: After GC");
        }
    }
}

