/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.ConsumeStream;
import com.spss.uitools.util.PASWFileUtil;
import com.spss.uitools.winutils.WindowsRegistryReader;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class AmosAction
extends SpssAction
implements Runnable {
    private static boolean sInitialized = false;
    private static boolean sAmosPresent = false;
    private static String sAmosPath = null;

    public AmosAction() {
        super("analyze_amos");
        this.configureAction(false);
    }

    @Override
    public boolean showMenu() {
        if (!sInitialized) {
            this.initialize();
        }
        if (sAmosPresent) {
            String string = ResUtil.getString(this.mActionId);
            if (string == null) {
                string = "IBM SPSS Amos...";
            }
            this.putValue("Name", string);
        }
        return sAmosPresent;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!sAmosPresent) {
            return;
        }
        if (!DocUtil.checkForData(this.getActionId())) {
            return;
        }
        new Thread((Runnable)this, "AmosAction.actionPerformed").start();
    }

    @Override
    public void run() {
        String string = this.saveCurrentDataset();
        if (string == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        vector.add("\"" + sAmosPath + "\"");
        vector.add("-ddat");
        vector.add("-spss");
        vector.add("\"" + string + "\"");
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(vector);
        try {
            Process process = processBuilder.start();
            new ConsumeStream(process.getInputStream(), System.out).start();
            new ConsumeStream(process.getErrorStream(), System.err).start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String saveCurrentDataset() {
        String string;
        String string2 = PrefsMgr.getPrefsMgr().getTempPath();
        try {
            File file = PASWFileUtil.createTempFile((String)"StatisticsData", (String)".sav", (File)new File(string2));
            string = string2 = file.getAbsolutePath();
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        boolean bl = DataServerProxy.getDataProxy().isRemoteConnection();
        if (bl) {
            string2 = UtilityProxy.getUtilProxy().getServerTemporaryFileName();
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String string3 = String.format("SAVE OUTFILE \"%s\"\n  /UNSELECTED DELETE.\nEXECUTE.\n", string2);
        if (!SyntaxMgr.getSyntaxMgr().executeSynchronousSyntax(string3, 100000L)) {
            return null;
        }
        if (bl && !UtilityProxy.getUtilProxy().copyServerFile(string2, string, false)) {
            return null;
        }
        return string;
    }

    private void initialize() {
        sInitialized = true;
        if (OSCheck.getOSType() == OSInfo.OSType.WIN && !CommandLine.isExternalCaller()) {
            int n;
            for (int i = n = VersionInfo.getMajorVersion().shortValue(); i > 10; --i) {
                File file;
                String string = String.format("SOFTWARE\\Amos\\%s.0\\Locale Manager", i);
                String string2 = WindowsRegistryReader.getWindowsRegistryReader().readWinRegistry("HKLM", string, "ClientPath");
                if ((string2 == null || string2.length() == 0) && OSInfo.isX64()) {
                    string = String.format("SOFTWARE\\Wow6432Node\\Amos\\%s.0\\Locale Manager", i);
                    string2 = WindowsRegistryReader.getWindowsRegistryReader().readWinRegistry("HKLM", string, "ClientPath");
                }
                if (string2 == null || string2.length() <= 0) continue;
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
                if (sAmosPresent = (file = new File(sAmosPath = string2 + "AmosGraphicsCLI.exe")).exists()) break;
            }
        }
    }
}

