/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.ReconnectReadThread;
import com.spss.java_client.core.server.ServerObject;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.doc_types.doc_util.ThinBeveledBorder;
import com.spss.java_client.ui.resources.ClientResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class StatusBar
extends JPanel
implements MouseListener {
    public int mNextXpos = 0;
    protected JLabel mHelpPane = null;
    protected JLabel mProcessorPane = null;
    protected JLabel mOMSPane = null;
    protected JLabel mXFormsPane = null;
    protected JLabel mEncodingPane = null;
    protected JLabel mObjectSizePane = null;

    public StatusBar() {
        super(new GridBagLayout(), false);
        this.init();
    }

    protected void init() {
        ResourceBundle resourceBundle = ResUtil.getBundle(ClientResBundle.getDefaultResourceBundleName(), Locale.getDefault());
        this.mHelpPane = new JLabel(" ");
        this.mProcessorPane = new JLabel("  ");
        this.mOMSPane = new JLabel("  ");
        this.mXFormsPane = new JLabel(ResUtil.getString("IDS_EMPTY_CASES"));
        this.mEncodingPane = new JLabel("  ");
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ThinBeveledBorder thinBeveledBorder = new ThinBeveledBorder(uIDefaults.getColor("ToolBar.highlight"), uIDefaults.getColor("ToolBar.shadow"), 1);
        this.mHelpPane.setBorder(thinBeveledBorder);
        this.mProcessorPane.setBorder(thinBeveledBorder);
        this.mOMSPane.setBorder(thinBeveledBorder);
        this.mXFormsPane.setBorder(thinBeveledBorder);
        this.mEncodingPane.setBorder(thinBeveledBorder);
        this.setBorder(new ThinBeveledBorder(uIDefaults.getColor("ToolBar.highlight"), uIDefaults.getColor("ToolBar.shadow"), 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.99;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.mHelpPane.setToolTipText(ResUtil.getString(resourceBundle, "IDS_SBAR_INFO_AREA"));
        this.mHelpPane.addMouseListener(this);
        this.add((Component)this.mHelpPane, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        this.mProcessorPane.setToolTipText(ResUtil.getString(resourceBundle, "IDS_SBAR_PROCESSOR_AREA"));
        this.mProcessorPane.addMouseListener(this);
        this.add((Component)this.mProcessorPane, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        this.mOMSPane.setToolTipText(ResUtil.getString(resourceBundle, "IDS_SBAR_OMS_AREA"));
        this.mOMSPane.addMouseListener(this);
        this.add((Component)this.mOMSPane, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 5;
        this.mXFormsPane.setToolTipText(ResUtil.getString(resourceBundle, "IDS_SBAR_CASE_COUNTER_AREA"));
        this.mXFormsPane.addMouseListener(this);
        this.add((Component)this.mXFormsPane, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 7;
        this.mEncodingPane.setToolTipText(ResUtil.getString(resourceBundle, "IDS_SBAR_ENCODING_PANE_MESSAGE"));
        this.mEncodingPane.addMouseListener(this);
        this.add((Component)this.mEncodingPane, gridBagConstraints);
        this.mNextXpos = 8;
    }

    public void putDefaultStatusMsg() {
        String string;
        DataServerProxy dataServerProxy = DataServerProxy.getDataProxy();
        ServerObject serverObject = dataServerProxy.getServerObject();
        boolean bl = ComponentState.getProcessorAvailable();
        String string2 = VersionInfo.getProductNickName();
        if (bl && serverObject != null && !serverObject.isLocalServer()) {
            String string3 = serverObject.getName() + ":" + serverObject.getPort();
            string = String.format(ResUtil.getString("IDS_SPSS_PROCESSOR_ON_READY"), string2, string3);
        } else {
            string = bl ? String.format(ResUtil.getString("IDS_SPSS_PROCESSOR_READY"), string2) : String.format(ResUtil.getString("IDS_SPSS_PROCESSOR_UNAVAIL"), string2);
        }
        ReconnectReadThread.ReconnectStateEnum reconnectStateEnum = ComponentState.GetReconnectState();
        if (reconnectStateEnum != ReconnectReadThread.ReconnectStateEnum.DISCONNECTED && reconnectStateEnum != ReconnectReadThread.ReconnectStateEnum.RECONNECT_TRANSITION) {
            this.mProcessorPane.setText(string);
        }
    }

    public void updateStatusBarEncodingText() {
        this.mEncodingPane.setText(ComponentState.isUnicodeServer() ? "Unicode:ON" : "Unicode:OFF");
        DocUtil.resetFiltersMap();
    }

    public void updateStatusBarHelpText(String string) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        this.mHelpPane.setText(string);
    }

    public void updateStatusBarHelpText(AbstractButton abstractButton) {
        String string = null;
        if (abstractButton != null) {
            string = abstractButton.getToolTipText() != null ? abstractButton.getToolTipText() : abstractButton.getText();
        }
        this.updateStatusBarHelpText(string);
    }

    public void putPaneMessage(StatusPane statusPane, String string) {
        JLabel jLabel = this.getPane(statusPane);
        jLabel.setText(string);
    }

    public String getPaneMessage(StatusPane statusPane) {
        JLabel jLabel = this.getPane(statusPane);
        return jLabel.getText();
    }

    public JLabel getPane(StatusPane statusPane) {
        JLabel jLabel = null;
        if (statusPane == StatusPane.helpPane) {
            jLabel = this.mHelpPane;
        } else if (statusPane == StatusPane.processorPane) {
            jLabel = this.mProcessorPane;
        } else if (statusPane == StatusPane.omsPane) {
            jLabel = this.mOMSPane;
        } else if (statusPane == StatusPane.xFormsPane) {
            jLabel = this.mXFormsPane;
        } else if (statusPane == StatusPane.encodingPane) {
            jLabel = this.mEncodingPane;
        }
        return jLabel;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.getStatusMessage(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mHelpPane.setText("      ");
    }

    protected void setStatusBarFont() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Font font = uIDefaults.getFont("Menu.font");
        if (font != null) {
            for (Component component : this.getComponents()) {
                component.setFont(font);
            }
        }
    }

    private void getStatusMessage(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof JLabel) {
            String string = ((JLabel)object).getToolTipText();
            this.mHelpPane.setText(string);
        }
    }

    public static enum StatusPane {
        helpPane,
        processorPane,
        omsPane,
        xFormsPane,
        encodingPane,
        filterPane,
        weightPane,
        splitFilePane,
        lineColumnPane,
        overWritePane,
        numLockPane,
        capLockPane,
        objectSizePane;

    }
}

