/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.FileDrop;
import com.spss.java_client.core.common.ILocaleListener;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.SpssWindowStates;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.ICoreDocument;
import com.spss.java_client.core.documents.ICoreDocumentUIAgent;
import com.spss.java_client.core.documents.MRUMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.output.IVersionCheckListener;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.nps_feedless.UserInfoUtil;
import com.spss.java_client.core.script.base.exception.InvalidMenuPathException;
import com.spss.java_client.core.script.base.exception.NonInvokableActionException;
import com.spss.java_client.core.script.engine.IScriptLanguageMgr;
import com.spss.java_client.core.script.engine.ScriptLanguageMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.controlbar.BaseToolbar;
import com.spss.java_client.ui.controlbar.ToolbarFactory;
import com.spss.java_client.ui.controlbar.ToolbarItem;
import com.spss.java_client.ui.controlbar.ToolbarObject;
import com.spss.java_client.ui.controlbar.ToolbarsUtil;
import com.spss.java_client.ui.controlbar.UserTool;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.DocumentVersionCheckAdaptor;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.StatusBar;
import com.spss.java_client.ui.doc_types.actions.ActivateDatasetAction;
import com.spss.java_client.ui.doc_types.actions.DesignateWindowAction;
import com.spss.java_client.ui.doc_types.actions.MRUAction;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.actions.SaveAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.actions.SyntaxGotoBookmarkAction;
import com.spss.java_client.ui.doc_types.actions.UserMenuAction;
import com.spss.java_client.ui.doc_types.actions.output.SelectLastOutputAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.AddOnMenuFileReader;
import com.spss.java_client.ui.doc_types.doc_util.FrameMenuBuildUtil;
import com.spss.java_client.ui.doc_types.doc_util.MenuCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuItemCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuItemPosComparator;
import com.spss.java_client.ui.doc_types.doc_util.ThinMenuBarBorder;
import com.spss.java_client.ui.doc_types.output.TableViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerPanel;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.print.PrintOptions;
import com.spss.java_client.ui.print.PrintUtilities;
import com.spss.java_client.ui.print.SpssPrintable;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.undo.SpssUndoManager;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.syntaxeditor.shared_objects.BookmarkInfo;
import com.spss.uitools.dialogs.DialogInvocationUtil;
import com.spss.uitools.util.OutOfMemoryErrorHandler;
import com.spss.uitools.util.TraceSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public abstract class SpssFrame
extends JFrame
implements MenuListener,
MenuDragMouseListener,
ChangeListener,
ContainerListener,
ICoreDocumentUIAgent,
ILocaleListener,
ITopWindow {
    protected JPanel mMainPanel = null;
    protected JMenuBar mMainMenuBar = null;
    protected JPanel mTBPanelNorth = null;
    protected StatusBar mStatusBarPanel = null;
    protected StringBuffer mDebugInfo = null;
    protected List<ToolbarObject> mToolbarPrefCache = null;
    protected String mRootMenuPrefPath = null;
    protected String mRootPrefPath = null;
    protected SpssUndoManager mUndoManager;
    protected PrintOptions mPrintOptions = new PrintOptions();
    protected HashMap<String, SpssAction> mToolbarActionMap = new HashMap();
    protected boolean mPendingTransforms = false;
    private EventQueue mEvents = null;
    protected boolean mShowTooltipsToolbar = true;
    protected boolean mShowLargeButtonsToolbar = false;
    protected Set<BaseToolbar> mFloatingToolbars = new HashSet<BaseToolbar>();
    private static final String MENU_ELEMENT_DEMLIMITER = ">";
    private static final String MENU_ITEM_POSTFIX = "...";
    private static final int NEGATIVE_THREASHOLD_VALUE = -2;
    private String mFrameID;
    private FileDrop mFileDrop;
    private boolean mIsPrinting;
    private int mTotalWidth;

    public SpssFrame() throws HeadlessException {
        this("", "");
    }

    public SpssFrame(String string, String string2) throws HeadlessException {
        super(string);
        this.mRootPrefPath = "doc_types/" + string2;
        this.mRootMenuPrefPath = this.mRootPrefPath + "/" + "menus";
        this.mFrameID = string2;
        this.mIsPrinting = false;
        this.setDefaultCloseOperation(2);
        this.mTBPanelNorth = new JPanel();
        this.mTBPanelNorth.addContainerListener(this);
        this.setupUndoManager();
        this.setupStatusBar();
        this.buildMenuBar();
        this.buildToolBar();
        this.createMainPanel();
        this.addMenuBarListeners(this.mMainMenuBar);
        this.addToolBarListeners();
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                if (SpssFrame.this instanceof ViewerFrame && !UserInfoUtil.isOnceNpsDialogShowed()) {
                    ViewerFrame.npsDisplayThread npsDisplayThread2 = new ViewerFrame.npsDisplayThread((ViewerFrame)SpssFrame.this);
                    npsDisplayThread2.start();
                }
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (SpssFrame.this.doActivate()) {
                    SpssFrameMgr spssFrameMgr = SpssFrameMgr.getSpssFrameMgr();
                    spssFrameMgr.setActivatedFrame(SpssFrame.this);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                int n = windowEvent.getID();
                if (SpssFrame.this.mEvents == null) {
                    SpssFrame.this.mEvents = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                if (SpssFrame.this.mEvents.peekEvent(n) != null) {
                    SpssFrame.this.closeGroup(n);
                } else if (SpssFrame.this.canClose()) {
                    SpssFrame.this.toFront();
                    SpssFrameMgr spssFrameMgr = SpssFrameMgr.getSpssFrameMgr();
                    if (SpssFrame.this instanceof DataFrame && DataMgr.getDataMgr().getDataDocumentCount() == 1 || spssFrameMgr.getOpenDocuments().length == 1) {
                        if (ComponentState.getProcessorBusy()) {
                            return;
                        }
                        AppMgr.getAppMgr().closeSessionData(false);
                        return;
                    }
                    SpssFrame.this.performClose();
                    SpssFrame spssFrame = spssFrameMgr.getLastActiveFrame();
                    if (spssFrame != null) {
                        spssFrame.repaint();
                    }
                    SpssFrame.this.collectGarbage();
                }
            }
        };
        this.addWindowListener(windowAdapter);
        this.addWindowFocusListener(windowAdapter);
        this.putDefaultStatusMsg();
        if (OutputManager.getOutputManager().getOmsManager().isOmsActive()) {
            this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.omsPane, ResUtil.getString("IDS_OMS"));
        }
        this.mFileDrop = new FileDrop((Component)this, new FileDrop.Listener(){

            public void filesDropped(File[] fileArray) {
                AppMgr.getAppMgr().openFiles(fileArray);
            }
        });
        ComponentState.addLocaleListener((ILocaleListener)this);
        if (OutputManager.getOutputManager().getVersionCheck() == null) {
            OutputManager.getOutputManager().setVersionCheck((IVersionCheckListener)new DocumentVersionCheckAdaptor());
        }
        this.getScreensTotalWidth();
    }

    public void performClose() {
        this.doDocumentClose();
    }

    public void doDocumentClose() {
        try {
            EventListener eventListener;
            ComponentState.removeLocaleListener((ILocaleListener)this);
            SpssFrameMgr.getSpssFrameMgr().removeDocument(this);
            if (this.mFileDrop != null) {
                this.mFileDrop.dispose();
                this.mFileDrop = null;
            }
            if (this.mMainMenuBar != null) {
                this.removeMenuBarListeners(this.mMainMenuBar);
                this.mMainMenuBar.removeAll();
                this.mMainMenuBar = null;
            }
            this.mPrintOptions = null;
            WindowListener[] windowListenerArray = this.getWindowListeners();
            Object object = windowListenerArray;
            int n = ((WindowListener[])object).length;
            for (int i = 0; i < n; ++i) {
                eventListener = object[i];
                this.removeWindowListener((WindowListener)eventListener);
            }
            this.removeToolBarListeners();
            this.mToolbarPrefCache = null;
            if (this.mToolbarActionMap != null) {
                object = this.mToolbarActionMap.keySet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    eventListener = this.mToolbarActionMap.get(string);
                    if (!(eventListener instanceof SelectLastOutputAction)) continue;
                    SelectLastOutputAction selectLastOutputAction = (SelectLastOutputAction)eventListener;
                    selectLastOutputAction.performClose();
                }
                this.mToolbarActionMap = null;
            }
            if (this.mTBPanelNorth != null) {
                int n2 = this.mTBPanelNorth.getComponentCount();
                for (n = 0; n < n2; ++n) {
                    Component component = this.mTBPanelNorth.getComponent(n);
                    if (!(component instanceof BaseToolbar)) continue;
                    eventListener = (BaseToolbar)component;
                    ((BaseToolbar)eventListener).closeToolBar();
                }
                this.mTBPanelNorth.removeContainerListener(this);
                this.mTBPanelNorth = null;
            }
            if (this.mUndoManager != null) {
                this.mUndoManager.discardAllEdits();
            }
            this.mUndoManager = null;
            if (this.mStatusBarPanel != null) {
                this.mStatusBarPanel.removeAll();
                this.mStatusBarPanel = null;
            }
            if (this.mMainPanel != null) {
                this.mMainPanel.removeAll();
                this.mMainPanel = null;
            }
            if (this.rootPane != null) {
                this.rootPane.removeAll();
                this.rootPane.remove(this.rootPane);
                this.rootPane = null;
            }
            this.removeAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean saveModified() {
        return true;
    }

    public void putDefaultStatusMsg() {
        this.mStatusBarPanel.putDefaultStatusMsg();
        this.mStatusBarPanel.updateStatusBarEncodingText();
    }

    public DocType docType() {
        return DocType.NO_DOC;
    }

    @Override
    public abstract ICoreDocument getCoreDocument();

    public abstract void resetSearchDialog();

    public void updateStatusBarHelpText(String string) {
        if (this.mStatusBarPanel != null) {
            this.mStatusBarPanel.updateStatusBarHelpText(string);
        }
    }

    public void updateStatusBarHelpText(AbstractButton abstractButton) {
        if (this.mStatusBarPanel != null) {
            this.mStatusBarPanel.updateStatusBarHelpText(abstractButton);
        }
    }

    public void loadMenuBarPreferences(String string, JMenuBar jMenuBar, MenuItemCache menuItemCache) throws BackingStoreException {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node(string);
        String[] stringArray = preferences2.childrenNames();
        Arrays.sort(stringArray, 0, stringArray.length, MenuItemPosComparator.ASCENDING);
        if (menuItemCache.getItemCount() == 0) {
            for (String string2 : stringArray) {
                boolean bl;
                ArrayList<String> arrayList;
                Preferences preferences3;
                if (string2.endsWith(";Analyze")) {
                    preferences3 = preferences.node(string + "/5;" + "Analyze");
                    if (string.endsWith("output/menus")) {
                        preferences3 = preferences.node(string + "/7;" + "Analyze");
                    }
                    arrayList = new ArrayList<String>();
                    arrayList.addAll(Arrays.asList(preferences3.childrenNames()));
                    bl = true;
                    for (String string3 : arrayList) {
                        if (!string3.endsWith("analyze_bayesian")) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        Preferences preferences4 = preferences3.node("2;analyze_bayesian");
                        preferences4.put("0", "analyze_bayesian_one_sample");
                        preferences4.put("1", "analyze_bayesian_one_sample_bi");
                        preferences4.put("2", "analyze_bayesian_one_sample_po");
                        preferences4.put("3", "analyze_bayesian_related_sample");
                        preferences4.put("4", "analyze_bayesian_indept_sample");
                        preferences4.put("5", "analyze_bayesian_pearson_corre");
                        preferences4.put("6", "analyze_bayesian_univariate_regression");
                        preferences4.put("7", "analyze_bayesian_oneway_anova");
                        preferences4.put("8", "analyze_bayesian_log_linear");
                    }
                }
                if (string2.endsWith(";Help")) {
                    preferences3 = preferences.node(string + "/14;" + "Help");
                    if (string.endsWith("dataeditor/menus")) {
                        preferences3 = preferences.node(string + "/12;" + "Help");
                    }
                    arrayList = new ArrayList();
                    arrayList.addAll(Arrays.asList(preferences3.childrenNames()));
                    bl = true;
                    for (String string3 : arrayList) {
                        if (!string3.endsWith("help_spss_support")) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        preferences3.put("1", "help_spss_support");
                    }
                    bl = true;
                    if (preferences3.get("11", null) != null && preferences3.get("11", null).equals("help_give_feedback")) {
                        bl = false;
                    }
                    if (!VersionInfo.isSmartReader()) {
                        if (UserInfoUtil.isPaid() && bl) {
                            preferences3.put("11", "help_give_feedback");
                        }
                        if (!UserInfoUtil.isPaid() && !bl) {
                            preferences3.remove("11");
                        }
                    } else if (bl) {
                        preferences3.put("11", "help_give_feedback");
                    }
                }
                FrameMenuBuildUtil.loadMenuPreferencesToCache(menuItemCache, preferences2, string2);
            }
        }
        FrameMenuBuildUtil.loadMenusFromCache(jMenuBar, null, menuItemCache, true);
        this.removeEmptyMenuBarMenus(jMenuBar);
    }

    public abstract MenuItemCache getMenuTreeCache();

    public abstract void setMenuTreeCache(MenuCache var1);

    public void setToolbarPrefCache(List<ToolbarObject> list) {
        this.mToolbarPrefCache = list;
    }

    public boolean isPrinting() {
        return this.mIsPrinting;
    }

    public void setIsPrinting(boolean bl) {
        this.mIsPrinting = bl;
    }

    public void notifyCharsetChange(String string) {
    }

    public void notifyILangChange(final Locale locale) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.notifyILangChangeImpl(locale);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssFrame.this.notifyILangChangeImpl(locale);
                }
            });
        }
    }

    private void notifyILangChangeImpl(Locale locale) {
        this.removeMenuBarListeners(this.mMainMenuBar);
        this.buildMenuBar();
        this.addMenuBarListeners(this.mMainMenuBar);
        this.mTBPanelNorth.removeAll();
        this.mToolbarActionMap.clear();
        this.buildToolBar();
        if (this.mStatusBarPanel != null) {
            this.mMainPanel.remove(this.mStatusBarPanel);
        }
        this.setupStatusBar();
        this.mMainPanel.add((Component)this.mStatusBarPanel, "South");
        this.resetSearchDialog();
        this.updateTitleBar();
    }

    public void notifySpssLocaleChange(Locale locale) {
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getComponent() == this.mTBPanelNorth && containerEvent.getChild() instanceof BaseToolbar) {
            this.mFloatingToolbars.remove(containerEvent.getChild());
        }
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getComponent() == this.mTBPanelNorth && containerEvent.getChild() instanceof BaseToolbar) {
            this.mFloatingToolbars.add((BaseToolbar)containerEvent.getChild());
        }
    }

    public List<ToolbarObject> getToolbarPrefCache() {
        return this.mToolbarPrefCache;
    }

    public boolean isShowLargeButtonsToolbar() {
        return this.mShowLargeButtonsToolbar;
    }

    public void setShowLargeButtonsToolbar(boolean bl) {
        this.mShowLargeButtonsToolbar = bl;
    }

    public void setShowTooltipsToolbar(boolean bl) {
        block4: {
            if (this.mToolbarActionMap == null || this.mShowTooltipsToolbar == bl) break block4;
            this.mShowTooltipsToolbar = bl;
            Collection<SpssAction> collection = this.mToolbarActionMap.values();
            if (this.mShowTooltipsToolbar) {
                for (SpssAction spssAction : collection) {
                    spssAction.enableToolTip();
                }
            } else {
                for (SpssAction spssAction : collection) {
                    spssAction.putValue("ShortDescription", null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void refreshToolbar() {
        Iterator<BaseToolbar> iterator = this.mFloatingToolbars.iterator();
        while (iterator.hasNext()) {
            void object;
            BaseToolbar baseToolbar = iterator.next();
            Container container = baseToolbar.getParent();
            while (object != null) {
                if (object instanceof JDialog) {
                    ((JDialog)object).dispose();
                    break;
                }
                Container container2 = object.getParent();
            }
            iterator.remove();
        }
        this.mTBPanelNorth.removeAll();
        this.mFloatingToolbars.clear();
        for (ToolbarObject toolbarObject : this.mToolbarPrefCache) {
            if (!toolbarObject.isVisible() || toolbarObject.getToolbarItems().size() <= 0 || !toolbarObject.getDocTypes().contains(this.docType())) continue;
            BaseToolbar baseToolbar = new BaseToolbar(toolbarObject.getName());
            baseToolbar.setupToolbar(this, toolbarObject);
            this.mTBPanelNorth.add(baseToolbar);
        }
        this.mTBPanelNorth.revalidate();
        this.mTBPanelNorth.repaint();
        this.addToolBarListeners();
    }

    public StatusBar getStatusBar() {
        return this.mStatusBarPanel;
    }

    @Override
    public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        JMenu jMenu = (JMenu)menuEvent.getSource();
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.updateStatusBarHelpText(jMenu);
        }
        if (!(jMenu.getAction() instanceof UserMenuAction) && jMenu.getAction() != null && jMenu.getAction() instanceof SpssAction) {
            String string = ((SpssAction)jMenu.getAction()).getActionId();
            if ("View".equals(string)) {
                this.refreshMenuCheckStatus(jMenu);
                this.refreshMenuText(jMenu);
            } else if ("Window".equals(string)) {
                this.updateWindowMenuDocuments(jMenu);
                this.refreshMenuCheckStatus(jMenu);
                this.refreshMenuText(jMenu);
            } else if ("file_MRUD".equals(string)) {
                this.updateDataMRUMenu(jMenu);
            } else if ("run_active_dataset".equals(string)) {
                this.updateActiveDatasetMenu(jMenu);
            } else if ("file_MRUF".equals(string)) {
                this.updateFileMRUMenu(jMenu);
            } else if ("File".equals(string)) {
                this.refreshMenuText(jMenu);
            } else if ("Tools".equals(string)) {
                this.refreshMenuCheckStatus(jMenu);
                this.refreshMenuText(jMenu);
            } else if ("syntax_goto_bookmark".equals(string)) {
                this.updateSyntaxGotoBookmarkMenu(jMenu);
            }
        }
        this.updateMenuEnableStatus(jMenu);
    }

    @Override
    public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        this.updateStatusBarHelpText((String)null);
    }

    @Override
    public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        this.updateStatusBarHelpText((String)null);
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        if (!CommandLine.isExternalCaller()) {
            this.updateStatusBarHelpText((String)null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Component component = (Component)changeEvent.getSource();
        if (component instanceof JMenuItem) {
            boolean bl = ((JMenuItem)component).isArmed();
            this.updateStatusBarHelpText(bl ? (JMenuItem)component : null);
        } else if (component instanceof AbstractButton) {
            boolean bl = ((AbstractButton)component).getModel().isRollover();
            this.updateStatusBarHelpText(bl ? (AbstractButton)component : null);
        } else {
            this.updateStatusBarHelpText((String)null);
        }
    }

    @Override
    public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        JMenuItem jMenuItem = (JMenuItem)menuDragMouseEvent.getSource();
        this.updateStatusBarHelpText(jMenuItem);
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        this.updateStatusBarHelpText((String)null);
    }

    public void append(String string) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new StringBuffer(string);
        } else {
            this.mDebugInfo.append(string);
        }
    }

    public SpssUndoManager getUndoManager() {
        return this.mUndoManager;
    }

    protected void setupUndoManager() {
        this.mUndoManager = new SpssUndoManager(this);
        this.mUndoManager.setLimit(10);
    }

    public void updateMenuEnableStatus(JMenu jMenu) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            Action action;
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !((action = jMenuItem.getAction()) instanceof SpssAction)) continue;
            SpssAction spssAction = (SpssAction)action;
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this));
            if (SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive()) {
                jMenuItem.setEnabled(false);
                continue;
            }
            jMenuItem.setEnabled(spssAction.isEnabled());
        }
        this.updateToolbarEnableStatus();
    }

    public void updateToolbarEnableStatus() {
        if (this.mToolbarActionMap == null || SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                Set<String> set = this.mToolbarActionMap.keySet();
                for (String string : set) {
                    URL uRL;
                    SpssAction spssAction = this.mToolbarActionMap.get(string);
                    if (spssAction == null) continue;
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this));
                    if (!(spssAction instanceof ProcedureAction) || !((ProcedureAction)spssAction).isPoolingIcon(spssAction.getActionId()) || (uRL = this.isShowLargeButtonsToolbar() ? ResUtil.getLargeImageURL(spssAction.getActionId()) : ResUtil.getImageURL(spssAction.getActionId())) == null) continue;
                    spssAction.putValue("SmallIcon", new ImageIcon(uRL));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SpssFrame.this.mToolbarActionMap != null) {
                        try {
                            Set<String> set = SpssFrame.this.mToolbarActionMap.keySet();
                            for (String string : set) {
                                SpssAction spssAction = SpssFrame.this.mToolbarActionMap.get(string);
                                if (spssAction == null) continue;
                                spssAction.setEnabled(spssAction.getMenuItemEnableStatus(SpssFrame.this));
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    public void updatePendingTransformation(boolean bl) {
        if (bl != this.mPendingTransforms) {
            this.mPendingTransforms = bl;
            String string = this.mPendingTransforms ? ResUtil.getString("IDS_STAT_TRANS_PENDING") : "      ";
            this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.xFormsPane, string);
            Graphics graphics = this.mStatusBarPanel.getGraphics();
            if (graphics != null) {
                this.mStatusBarPanel.update(graphics);
            }
        }
    }

    public boolean hasPendingTransforms() {
        return this.mPendingTransforms;
    }

    public abstract SpssPrintable getPrintable();

    public PrintOptions getPrintOptions() {
        return this.mPrintOptions;
    }

    public SpssAction getToolbarAction(ToolbarItem toolbarItem, boolean bl) {
        String string = toolbarItem.getActionId();
        SpssAction spssAction = null;
        if (toolbarItem.isUserDefinedTool()) {
            UserTool userTool = ToolbarsUtil.getUserDefinedTool(string);
            if (userTool != null) {
                spssAction = new UserMenuAction(userTool.getActionId());
                if (this.mShowTooltipsToolbar) {
                    spssAction.enableToolTip();
                }
            }
        } else {
            if (this.mToolbarActionMap == null) {
                return null;
            }
            spssAction = this.mToolbarActionMap.get(string);
            if (spssAction == null && bl && FrameMenuBuildUtil.isValidLicense(string)) {
                try {
                    spssAction = string.equals("utilities_designate_window") ? new DesignateWindowAction() : (this instanceof ViewerFrame && string.equals("file_save") ? new SaveAction() : (SpssAction)ActionCatalog.getActionCatalog().getSpssAction(string).clone());
                    if (this.mShowTooltipsToolbar) {
                        spssAction.enableToolTip();
                    }
                    this.mToolbarActionMap.put(string, spssAction);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return spssAction;
    }

    public void gotoTableRows(TableViewerItem.TableSection tableSection) {
    }

    public boolean isNavigateEnabled(TableViewerItem.TableSection tableSection) {
        return false;
    }

    public abstract void doCopy();

    public abstract void doPaste();

    public void doPasteSpecial() {
    }

    public abstract void doCut();

    public abstract void doDelete();

    public abstract void doGridFont();

    public abstract void saveFrameSize();

    protected boolean doActivate() {
        SpssFrameMgr.getSpssFrameMgr().designateWindow(this);
        this.updateToolbarEnableStatus();
        return true;
    }

    public void addMenuBarListeners(JMenuBar jMenuBar) {
        if (jMenuBar == null) {
            return;
        }
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            this.addMenuListeners(jMenuBar.getMenu(i));
        }
    }

    public void removeMenuBarListeners(JMenuBar jMenuBar) {
        if (jMenuBar == null) {
            return;
        }
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            this.removeMenuListeners(jMenuBar.getMenu(i));
        }
    }

    public void addMenuListeners(JMenu jMenu) {
        if (jMenu == null) {
            return;
        }
        int n = jMenu.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (component instanceof JMenu) {
                this.addMenuListeners((JMenu)component);
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            ((JMenuItem)component).addMenuDragMouseListener(this);
            ((JMenuItem)component).addChangeListener(this);
        }
        jMenu.addMenuListener(this);
    }

    public void removeMenuListeners(JMenu jMenu) {
        if (jMenu == null) {
            return;
        }
        int n = jMenu.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (component instanceof JMenu) {
                this.removeMenuListeners((JMenu)component);
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            ((JMenuItem)component).removeMenuDragMouseListener(this);
            ((JMenuItem)component).removeChangeListener(this);
        }
        jMenu.removeMenuListener(this);
    }

    public void setToolBarVisible(boolean bl) {
        this.mTBPanelNorth.setVisible(bl);
    }

    public void setToolBarPanel(JPanel jPanel) {
        this.remove(this.mTBPanelNorth);
        this.mTBPanelNorth = jPanel;
        this.add((Component)this.mTBPanelNorth, "North");
    }

    public JPanel getToolBarPanel() {
        return this.mTBPanelNorth;
    }

    @Override
    public ViewerPanel getViewerPanel() {
        return null;
    }

    protected boolean canClose() {
        return true;
    }

    protected void addToolBarListeners() {
        Component[] componentArray;
        for (Component component : componentArray = this.mTBPanelNorth.getComponents()) {
            if (!(component instanceof BaseToolbar)) continue;
            BaseToolbar baseToolbar = (BaseToolbar)component;
            int n = baseToolbar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = baseToolbar.getComponent(i);
                if (!(component2 instanceof AbstractButton)) continue;
                ((AbstractButton)component2).addChangeListener(this);
            }
        }
    }

    public void setToolbarItemsFocusable(boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = this.mTBPanelNorth.getComponents()) {
            if (!(component instanceof BaseToolbar)) continue;
            BaseToolbar baseToolbar = (BaseToolbar)component;
            int n = baseToolbar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = baseToolbar.getComponent(i);
                if (!(component2 instanceof JButton) && !(component2 instanceof JCheckBox) && !(component2 instanceof JComboBox) && !(component2 instanceof JToggleButton)) continue;
                component2.setFocusable(bl);
                component2.setFocusTraversalKeysEnabled(true);
            }
        }
    }

    public void setFocusOnToolbars() {
        Component[] componentArray;
        for (Component component : componentArray = this.mTBPanelNorth.getComponents()) {
            BaseToolbar baseToolbar;
            Component component2;
            if (!(component instanceof BaseToolbar) || (component2 = (baseToolbar = (BaseToolbar)component).getComponent(0)) == null || !component2.isEnabled()) continue;
            component2.requestFocusInWindow();
        }
    }

    public boolean isToolbarControl(Component component) {
        Component[] componentArray;
        boolean bl = false;
        block0: for (Component component2 : componentArray = this.mTBPanelNorth.getComponents()) {
            if (!(component2 instanceof BaseToolbar)) continue;
            BaseToolbar baseToolbar = (BaseToolbar)component2;
            int n = baseToolbar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component3 = baseToolbar.getComponent(i);
                if (component3 == null || component3 != component) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    protected void removeToolBarListeners() {
        if (this.mTBPanelNorth != null) {
            Component[] componentArray;
            for (Component component : componentArray = this.mTBPanelNorth.getComponents()) {
                if (!(component instanceof BaseToolbar)) continue;
                BaseToolbar baseToolbar = (BaseToolbar)component;
                int n = baseToolbar.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component2 = baseToolbar.getComponent(i);
                    if (!(component2 instanceof AbstractButton)) continue;
                    ((AbstractButton)component2).removeChangeListener(this);
                }
            }
        }
    }

    protected void createMainPanel() {
        this.mMainPanel = new JPanel(new BorderLayout(), false);
        this.mMainPanel.setOpaque(true);
        if (this.mTBPanelNorth != null) {
            this.mMainPanel.add((Component)this.mTBPanelNorth, "North");
        }
        if (this.mStatusBarPanel != null) {
            this.mMainPanel.add((Component)this.mStatusBarPanel, "South");
        }
        this.setContentPane(this.mMainPanel);
    }

    public JMenuBar getMainMenuBar() {
        return this.mMainMenuBar;
    }

    protected void refreshMenuBar() {
        SpssFrame[] spssFrameArray;
        for (SpssFrame spssFrame : spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
            if (spssFrame.docType() != this.docType()) continue;
            spssFrame.getMainMenuBar().removeAll();
            FrameMenuBuildUtil.loadMenusFromCache(spssFrame.getMainMenuBar(), null, this.getMenuTreeCache(), true);
            spssFrame.addMenuBarListeners(spssFrame.getMainMenuBar());
            this.setupAddOnMenu(spssFrame.getMainMenuBar());
            CommandExecutor.get().addCustomCommands(this);
            this.removeEmptyMenuBarMenus(spssFrame.getMainMenuBar());
            spssFrame.validate();
            spssFrame.repaint();
        }
    }

    private void removeEmptyMenuBarMenus(JMenuBar jMenuBar) {
        Vector<JMenu> vector = new Vector<JMenu>();
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            if (jMenuBar.getMenu(i).getItemCount() != 0) continue;
            vector.addElement(jMenuBar.getMenu(i));
        }
        for (Component component : vector) {
            jMenuBar.remove(component);
        }
    }

    protected void refreshMenuBarFor(SpssFrame spssFrame) {
        if (spssFrame.docType() == this.docType()) {
            spssFrame.getMainMenuBar().removeAll();
            spssFrame.getMainMenuBar().repaint();
            FrameMenuBuildUtil.loadMenusFromCache(spssFrame.getMainMenuBar(), null, this.getMenuTreeCache(), true);
            spssFrame.addMenuBarListeners(spssFrame.getMainMenuBar());
            this.setupAddOnMenu(spssFrame.getMainMenuBar());
            CommandExecutor.get().addCustomCommands(this);
            this.removeEmptyMenuBarMenus(spssFrame.getMainMenuBar());
            spssFrame.validate();
            spssFrame.repaint();
        }
    }

    protected void buildMenuBar() {
        this.mMainMenuBar = new JMenuBar();
        this.setJMenuBar(this.mMainMenuBar);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ThinMenuBarBorder thinMenuBarBorder = new ThinMenuBarBorder(uIDefaults.getColor("MenuBar.shadow"));
        this.mMainMenuBar.setBorder(thinMenuBarBorder);
        try {
            Preferences preferences;
            Preferences preferences2 = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            if (!preferences2.nodeExists("other_apps")) {
                ToolbarsUtil.loadUserDefinedToolsMapFromSysPrefs();
            }
            if (!((preferences = preferences2.node(this.mRootPrefPath)).nodeExists("menus") && this.hasEnoughMenus(preferences) && this.hasAllCheckedMenuItems(preferences))) {
                this.saveMenuBarDefaultPreferences();
            }
            this.loadMenuBarPreferences(this.mRootMenuPrefPath, this.mMainMenuBar, this.getMenuTreeCache());
            this.setupNewScriptMenu(this.mMainMenuBar);
            this.setupAddOnMenu(this.mMainMenuBar);
            CommandExecutor.get().addCustomCommands(this);
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JMenu getExAnalyzeMenu() {
        JMenu jMenu = null;
        String string = ResUtil.getString("Analyze");
        for (int i = 0; i < this.mMainMenuBar.getMenuCount(); ++i) {
            JMenu jMenu2 = this.mMainMenuBar.getMenu(i);
            if (!jMenu2.getText().equals(string)) continue;
            jMenu = jMenu2;
            break;
        }
        return jMenu;
    }

    protected void setupAddOnMenu(JMenuBar jMenuBar) {
        boolean bl = false;
        if (!bl) {
            return;
        }
        if (!PrefsMgr.getILangTag().equals("en")) {
            return;
        }
        if (VersionInfo.isStudentVersion()) {
            return;
        }
        JMenu jMenu = null;
        int n = -1;
        int n2 = jMenuBar.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            JMenu jMenu2 = (JMenu)jMenuBar.getComponent(i);
            String string = jMenu2.getActionCommand();
            if (!string.equals(ResUtil.getString("Utilities"))) continue;
            n = i + 1;
            jMenu = new JMenu(ResUtil.getString("Add-ons"));
            jMenu.setMnemonic(ResUtil.getAccessKey("Add-ons"));
            jMenuBar.add((Component)jMenu, n);
            AddOnMenuFileReader.addMenuTreeForAddOns(jMenu);
            Vector<String> vector = this.getDeletedAddOnItem();
            for (String string2 : vector) {
                this.deleteMenuItemFromMenu(jMenu, string2);
            }
            break;
        }
        if (jMenu != null && jMenu.getItemCount() == 0) {
            jMenuBar.remove(n);
        }
    }

    protected void buildToolBar() {
        ToolbarFactory.loadToolbar(this, this.mTBPanelNorth);
    }

    protected void setupStatusBar() {
        this.mStatusBarPanel = new StatusBar();
    }

    protected void updateTitleBar() {
    }

    protected void saveMenuBarPreferences() throws BackingStoreException {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node(this.mRootMenuPrefPath);
        preferences2.removeNode();
        preferences2 = preferences.node(this.mRootMenuPrefPath);
        int n = this.getMenuTreeCache().getItemCount();
        for (int i = 0; i < n; ++i) {
            FrameMenuBuildUtil.saveSubMenuPreferences(this.getMenuTreeCache().getItem(i), preferences2, i);
        }
    }

    protected void saveToolBarPreferences() throws BackingStoreException {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node(this.mRootPrefPath + "/" + "toolbars");
        preferences2.clear();
        ToolbarFactory.saveCmdsToPersistentStorage(this.mToolbarPrefCache);
    }

    protected abstract void saveMenuBarDefaultPreferences() throws BackingStoreException;

    protected abstract void addDeletedAddOnItem(String var1);

    protected abstract Vector<String> getDeletedAddOnItem();

    public abstract void clearDeletedAddOnItems();

    protected void copyMenuItemFromInstaller(Preferences preferences, Preferences preferences2, String string) throws BackingStoreException {
        if (preferences != null && preferences.nodeExists(string)) {
            String[] stringArray;
            Preferences preferences3 = preferences.node(string);
            for (String string2 : stringArray = preferences3.keys()) {
                String string3 = preferences3.get(string2, "");
                preferences2.put(string2, string3);
            }
        }
    }

    protected void refreshMenuCheckStatus(JMenu jMenu) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            SpssAction spssAction;
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2 = jMenu.getItem(i);
            if (jMenuItem2 instanceof JCheckBoxMenuItem) {
                jMenuItem = (JCheckBoxMenuItem)jMenuItem2;
                spssAction = (SpssAction)jMenuItem2.getAction();
                ((JCheckBoxMenuItem)jMenuItem).setState(spssAction.getMenuItemCheckStatus(this));
                continue;
            }
            if (!(jMenuItem2 instanceof JRadioButtonMenuItem)) continue;
            jMenuItem = (JRadioButtonMenuItem)jMenuItem2;
            spssAction = (SpssAction)jMenuItem2.getAction();
            jMenuItem.setSelected(spssAction.getMenuItemCheckStatus(this));
        }
    }

    protected void refreshMenuText(JMenu jMenu) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !(jMenuItem.getAction() instanceof SpssAction)) continue;
            SpssAction spssAction = (SpssAction)jMenuItem.getAction();
            spssAction.updateMenuText(jMenuItem);
            String string = (String)spssAction.getValue("ShortDescription");
            if (string == null) continue;
            jMenuItem.setToolTipText(string);
        }
    }

    protected void updateActiveDatasetMenu(JMenu jMenu) {
        jMenu.removeAll();
        DataMgr dataMgr = DataMgr.getDataMgr();
        int n = dataMgr.dataSourceCount();
        LocallyUniqueId locallyUniqueId = dataMgr.getActiveDocumentId();
        for (int i = 0; i < n; ++i) {
            ISpssDataSrc iSpssDataSrc = dataMgr.getDataSource(i);
            String string = iSpssDataSrc.getDatasetName();
            if (string.length() == 0) {
                string = ResUtil.getString("IDS_DATASET_UNNAMED");
            }
            ActivateDatasetAction activateDatasetAction = new ActivateDatasetAction(i + 1, string, iSpssDataSrc.getFileSpec());
            if (locallyUniqueId.equals((Object)iSpssDataSrc.getDataSetId())) {
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(activateDatasetAction);
                jCheckBoxMenuItem.setState(true);
                jMenu.add(jCheckBoxMenuItem);
                continue;
            }
            jMenu.add(activateDatasetAction);
        }
    }

    protected void updateSyntaxGotoBookmarkMenu(JMenu jMenu) {
        jMenu.removeAll();
        if (this instanceof SyntaxFrame) {
            SyntaxFrame syntaxFrame = (SyntaxFrame)this;
            ArrayList<BookmarkInfo> arrayList = syntaxFrame.getSyntaxView().getBookmarkInfos();
            if (arrayList != null && arrayList.size() > 0) {
                for (BookmarkInfo bookmarkInfo : arrayList) {
                    jMenu.add(new SyntaxGotoBookmarkAction(bookmarkInfo));
                }
            } else {
                jMenu.add(new SyntaxGotoBookmarkAction((BookmarkInfo)null));
            }
        }
    }

    protected void updateDataMRUMenu(JMenu jMenu) {
        jMenu.removeAll();
        MRUMgr mRUMgr = MRUMgr.getMRUMgr();
        int n = mRUMgr.getDataDocCount();
        for (int i = 0; i < n; ++i) {
            jMenu.add(new MRUAction(i + 1, mRUMgr.getDataDoc(i, false), mRUMgr.getDataDoc(i, true), true));
        }
        if (n == 0) {
            String string = jMenu.getText();
            JMenuItem jMenuItem = jMenu.add(string);
            jMenuItem.setEnabled(false);
        }
    }

    protected void updateFileMRUMenu(JMenu jMenu) {
        jMenu.removeAll();
        MRUMgr mRUMgr = MRUMgr.getMRUMgr();
        int n = mRUMgr.getOtherDocCount();
        for (int i = 0; i < n; ++i) {
            jMenu.add(new MRUAction(i + 1, mRUMgr.getOtherDoc(i, false), mRUMgr.getOtherDoc(i, true), false));
        }
        if (n == 0) {
            String string = jMenu.getText();
            JMenuItem jMenuItem = jMenu.add(string);
            jMenuItem.setEnabled(false);
        }
    }

    protected void updateWindowMenuDocuments(JMenu jMenu) {
        JMenuItem jMenuItem;
        int n;
        int n2 = jMenu.getItemCount();
        int n3 = 0;
        for (n = n2 - 1; n >= 0; --n) {
            jMenuItem = jMenu.getItem(n);
            if (jMenuItem == null) {
                n3 = n;
                break;
            }
            jMenu.remove(jMenuItem);
        }
        SpssFrameMgr.getSpssFrameMgr().addDocumentMenuItems(jMenu);
        n2 = jMenu.getItemCount();
        for (n = n3 + 1; n < n2; ++n) {
            jMenuItem = jMenu.getItem(n);
            jMenuItem.addChangeListener(this);
            jMenuItem.addMenuDragMouseListener(this);
            Action action = jMenuItem.getAction();
            if (!(action instanceof SpssAction)) continue;
            SpssAction spssAction = (SpssAction)action;
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this));
        }
    }

    private void closeGroup(int n) {
        if (this.mEvents != null && this.mEvents.peekEvent(n) != null) {
            AppMgr.getAppMgr().closeSessionData(false);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (CommandLine.isAutomated() || CommandLine.isProduction()) {
            super.setVisible(false);
        } else {
            super.setVisible(bl);
        }
    }

    public void setUIVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void setHeight(int n) throws IllegalArgumentException {
        if (n < 0 || n > Toolkit.getDefaultToolkit().getScreenSize().height) {
            throw new IllegalArgumentException();
        }
        this.setSize(this.getWidth(), n);
        this.validate();
    }

    public void setWidth(int n) throws IllegalArgumentException {
        if (n < 0 || n > Toolkit.getDefaultToolkit().getScreenSize().width) {
            throw new IllegalArgumentException();
        }
        this.setSize(n, this.getHeight());
        this.validate();
    }

    public void setTop(int n) throws IllegalArgumentException {
        if (n < 0 || n > Toolkit.getDefaultToolkit().getScreenSize().height) {
            throw new IllegalArgumentException();
        }
        this.setLocation(this.getX(), n);
    }

    public void setLeft(int n) throws IllegalArgumentException {
        if (n < 0 || n > this.mTotalWidth) {
            throw new IllegalArgumentException();
        }
        this.setLocation(n, this.getY());
    }

    public void setWindowState(SpssWindowStates spssWindowStates) {
        switch (spssWindowStates) {
            case SpssMinimized: {
                int n = 1;
                this.setExtendedState(n);
                break;
            }
            case SpssMaximized: {
                int n = 6;
                this.setExtendedState(n);
                break;
            }
            case SpssNormal: {
                int n = 0;
                this.setExtendedState(n);
            }
        }
    }

    public void printDoc() {
        PrintUtilities.print(this, this.getPrintable());
    }

    public void printDocNoDialog() {
        SpssPrintable spssPrintable = this.getPrintable();
        spssPrintable.printInit();
        AppMgr.getAppMgr().monitorThread(PrintUtilities.printNoDialog(spssPrintable));
    }

    public boolean getUIVisible() {
        return this.isVisible();
    }

    @Override
    public int getHeight() {
        return (int)this.getSize().getHeight();
    }

    @Override
    public int getWidth() {
        return (int)this.getSize().getWidth();
    }

    public int getTop() {
        return (int)this.getLocation().getY();
    }

    public int getLeft() {
        return (int)this.getLocation().getX();
    }

    public SpssWindowStates getWindowState() {
        int n = this.getExtendedState();
        SpssWindowStates spssWindowStates = SpssWindowStates.SpssNormal;
        if (n == 1) {
            spssWindowStates = SpssWindowStates.SpssMinimized;
        } else if ((n & 6) == 6) {
            spssWindowStates = SpssWindowStates.SpssMaximized;
        }
        return spssWindowStates;
    }

    public String getTitleText() {
        String string = this.getTitle();
        if (string.startsWith("*")) {
            string = string.substring(1);
        }
        return string;
    }

    public String invokeDialog(String string, boolean bl, final boolean bl2, boolean bl3) throws InvalidMenuPathException, NonInvokableActionException {
        Object object;
        final String[] stringArray = new String[1];
        SpssAction spssAction = SpssFrame.getActionFromString(string, this);
        if (spssAction == null && null == (spssAction = ((ActionCatalog)(object = ActionCatalog.getActionCatalog())).getSpssAction(CommandExecutor.get().getCustomActionId(string)))) {
            throw new InvalidMenuPathException();
        }
        if (!this.isInvokableDialogAction(spssAction)) {
            throw new NonInvokableActionException();
        }
        object = bl ? new Container() : this.getToolBarPanel();
        Object object2 = object;
        SpssAction spssAction2 = spssAction;
        if (!bl3) {
            new Thread(new Runnable((Container)object2, spssAction2){
                final /* synthetic */ Container val$pseudoEventSource;
                final /* synthetic */ SpssAction val$finalAction;
                {
                    this.val$pseudoEventSource = container;
                    this.val$finalAction = spssAction;
                }

                @Override
                public void run() {
                    stringArray[0] = SpssFrame.this.invokeDialogEx(bl2, false, this.val$pseudoEventSource, this.val$finalAction);
                }
            }).start();
        } else {
            stringArray[0] = this.invokeDialogEx(bl2, true, (Container)object2, spssAction2);
        }
        return stringArray[0];
    }

    private String invokeDialogEx(boolean bl, boolean bl2, final Container container, final SpssAction spssAction) {
        String string = DialogInvocationUtil.invokeDialog((Runnable)new Runnable(){

            @Override
            public void run() {
                ActionEvent actionEvent = new ActionEvent(container, 1001, spssAction.getActionId());
                spssAction.actionPerformed(actionEvent);
            }
        }, (boolean)bl2, (boolean)bl);
        return string;
    }

    void loadDynamicMenus(Vector<String> vector, String string, String string2) {
        block3: {
            MRUMgr mRUMgr;
            block2: {
                mRUMgr = MRUMgr.getMRUMgr();
                if (!string2.equals("file_MRUD")) break block2;
                int n = mRUMgr.getDataDocCount();
                for (int i = 0; i < n; ++i) {
                    vector.add(string + MENU_ELEMENT_DEMLIMITER + String.format("%d %s", i + 1, mRUMgr.getDataDoc(i, false)));
                }
                break block3;
            }
            if (!string2.equals("file_MRUF")) break block3;
            int n = mRUMgr.getOtherDocCount();
            for (int i = 0; i < n; ++i) {
                vector.add(string + MENU_ELEMENT_DEMLIMITER + String.format("%d %s", i + 1, mRUMgr.getOtherDoc(i, false)));
            }
        }
    }

    void loadMenuTable(Vector<String> vector, String string, MenuItemCache menuItemCache) {
        int n = menuItemCache.getItemCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                SpssAction spssAction;
                MenuItemCache menuItemCache2 = menuItemCache.getItem(i);
                if (menuItemCache2.getItemId().equals("separator")) continue;
                String string2 = menuItemCache2.getItemId();
                String string3 = string2.lastIndexOf(";") > 0 ? string2.substring(0, string2.lastIndexOf(";")) : ((spssAction = ActionCatalog.getActionCatalog().getSpssAction(menuItemCache2.getItemId())) == null ? ResUtil.getString(string2) : (String)spssAction.getValue("Name"));
                String string4 = string + MENU_ELEMENT_DEMLIMITER + string3;
                vector.add(string4);
                if (string2.equals("file_MRUD") || string2.equals("file_MRUF") || string2.equals("run_active_dataset")) {
                    this.loadDynamicMenus(vector, string4, string2);
                    continue;
                }
                this.loadMenuTable(vector, string4, menuItemCache2);
            }
        }
    }

    public Vector<String> getMenuTable() {
        int n = this.getMenuTreeCache().getItemCount();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            MenuItemCache menuItemCache = this.getMenuTreeCache().getItem(i);
            String string = menuItemCache.getItemId();
            vector.add(ResUtil.getString(string));
            if (string.equals("Add-ons")) {
                AddOnMenuFileReader.loadMenuListForAddOns(vector, string);
                continue;
            }
            if (string.equals("Window")) {
                SpssFrameMgr.getSpssFrameMgr().addDocumentMenuItemsToMenuTable(vector, ResUtil.getString(string));
                continue;
            }
            this.loadMenuTable(vector, ResUtil.getString(string), menuItemCache);
        }
        Set<String> set = CommandExecutor.get().getCustomMenuPathes();
        for (String string : set) {
            vector.add(string);
        }
        return vector;
    }

    public void deleteMenuItem(String string, boolean bl) throws InvalidMenuPathException {
        Serializable serializable;
        if (string == null) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (string.startsWith("Add-ons") ? !((Vector)(serializable = this.getMenuTable())).contains(string) : (string4 = SpssFrame.getMenuActionFromString(string, this)) == null || string4.length() == 0) {
            throw new InvalidMenuPathException();
        }
        serializable = this.getMainMenuBar();
        int n = ((Container)serializable).getComponentCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = (JMenu)this.getMainMenuBar().getComponent(i);
            string3 = jMenu.getActionCommand();
            if (string3 != null && string3.equals(string)) {
                ((Container)serializable).remove(jMenu);
                string2 = string3;
                bl3 = true;
                break;
            }
            string2 = string.replace(string3 + MENU_ELEMENT_DEMLIMITER, "");
            bl2 = this.deleteMenuItemFromMenu(jMenu, string2);
            if (bl2) break;
        }
        if (bl2 || bl3) {
            if (bl) {
                if (!bl3 && string3 != null && string3.equals("Add-ons")) {
                    this.addDeletedAddOnItem(string2);
                } else {
                    bl2 = this.getMenuTreeCache().removeMenuItem(string4);
                    if (bl2) {
                        this.refreshMenuBarFor(this);
                    }
                }
            } else if (!bl3 && string3 != null && string3.equals("Add-ons")) {
                this.clearDeletedAddOnItems();
            }
            this.refreshToolbar();
        } else {
            SpssAlertOptionPane.showWarningMessageDialog(this, ResUtil.getString("IDS_MENU_PATH_NOT_EXIST"), VersionInfo.getAppVersionString());
        }
    }

    private boolean deleteMenuItemFromMenu(JMenu jMenu, String string) {
        boolean bl = false;
        if (jMenu == null) {
            return false;
        }
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            String string2;
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            String string3 = jMenuItem.getActionCommand();
            if (string3 != null && (string3.equalsIgnoreCase(string) || string3.equalsIgnoreCase(string + MENU_ITEM_POSTFIX))) {
                jMenu.remove(jMenuItem);
                return true;
            }
            if (jMenuItem instanceof JMenu && (bl = this.deleteMenuItemFromMenu((JMenu)jMenuItem, string2 = string.replace(string3 = string3 + MENU_ELEMENT_DEMLIMITER, "")))) break;
        }
        return bl;
    }

    public void setToolbarVisible(String string, boolean bl) throws BackingStoreException {
        for (ToolbarObject toolbarObject : this.mToolbarPrefCache) {
            if (!toolbarObject.getName().equalsIgnoreCase(string)) continue;
            toolbarObject.setVisible(bl);
        }
        this.saveToolBarPreferences();
        this.refreshToolbar();
    }

    public boolean getToolbarVisible(String string) {
        boolean bl = false;
        for (ToolbarObject toolbarObject : this.mToolbarPrefCache) {
            if (!toolbarObject.getName().equalsIgnoreCase(string)) continue;
            bl = toolbarObject.isVisible();
        }
        return bl;
    }

    private void collectGarbage() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    7 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait(1000L);
                    }
                    OutOfMemoryErrorHandler.runGC();
                }
                catch (InterruptedException interruptedException) {
                    TraceSettings.trace1((String)"System.gc() interrupted", (int)15);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }).start();
    }

    private static SpssAction getActionFromString(String string, SpssFrame spssFrame) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ActionCatalog actionCatalog = ActionCatalog.getActionCatalog();
        SpssAction spssAction = actionCatalog.getSpssAction(string);
        if (spssAction != null) {
            return spssAction;
        }
        String[] stringArray = string.trim().split(MENU_ELEMENT_DEMLIMITER, -2);
        int n = 0;
        MenuItemCache menuItemCache = spssFrame.getMenuTreeCache();
        boolean bl = false;
        while (!bl && n < stringArray.length) {
            String string2 = stringArray[n];
            ++n;
            if (!(menuItemCache instanceof MenuCache)) break;
            boolean bl2 = false;
            for (int i = 0; i < menuItemCache.getItemCount(); ++i) {
                MenuItemCache menuItemCache2 = menuItemCache.getItem(i);
                String string3 = ResUtil.getString(menuItemCache2.getItemId());
                if (string3 == null) {
                    ComponentState.trace1((String)("could not retrieve the text for childMenuItem" + menuItemCache2.getItemId()), (int)32768);
                    continue;
                }
                if (menuItemCache2 instanceof MenuCache) {
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    bl2 = true;
                    menuItemCache = menuItemCache2;
                    break;
                }
                if (!string3.equalsIgnoreCase(string2) && !string3.equalsIgnoreCase(string2 + MENU_ITEM_POSTFIX)) continue;
                bl2 = true;
                menuItemCache = menuItemCache2;
                if (n < stringArray.length) break;
                bl = true;
                break;
            }
            if (bl2) continue;
            return null;
        }
        if (bl) {
            return actionCatalog.getSpssAction(menuItemCache.getItemId());
        }
        return null;
    }

    private static String getMenuActionFromString(String string, SpssFrame spssFrame) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ActionCatalog actionCatalog = ActionCatalog.getActionCatalog();
        SpssAction spssAction = actionCatalog.getSpssAction(string);
        if (spssAction != null) {
            return spssAction.getActionId();
        }
        String[] stringArray = string.trim().split(MENU_ELEMENT_DEMLIMITER, -2);
        int n = 0;
        MenuItemCache menuItemCache = spssFrame.getMenuTreeCache();
        boolean bl = false;
        boolean bl2 = false;
        while (!bl && n < stringArray.length) {
            String string2 = stringArray[n];
            ++n;
            if (!(menuItemCache instanceof MenuCache)) {
                return null;
            }
            bl2 = false;
            for (int i = 0; i < menuItemCache.getItemCount(); ++i) {
                MenuItemCache menuItemCache2 = menuItemCache.getItem(i);
                String string3 = menuItemCache2.getItemId();
                String string4 = ResUtil.getString(string3);
                if (string4 == null && string3 == null) {
                    ComponentState.trace1((String)("could not retrieve the text for childMenuItem" + menuItemCache2.getItemId()), (int)32768);
                    continue;
                }
                String[] stringArray2 = null;
                if (string3.contains("-")) {
                    stringArray2 = string3.split("-");
                } else if (string3.contains(";")) {
                    stringArray2 = string3.split(";");
                }
                if (stringArray2 == null || stringArray2.length <= 0 || !stringArray2[0].equalsIgnoreCase(string2)) continue;
                string4 = string2;
                if (menuItemCache2 instanceof MenuCache) {
                    if (!string4.equalsIgnoreCase(string2)) continue;
                    bl2 = true;
                    menuItemCache = menuItemCache2;
                    break;
                }
                if (!string4.equalsIgnoreCase(string2) && !string4.equalsIgnoreCase(string2 + MENU_ITEM_POSTFIX)) continue;
                bl2 = true;
                menuItemCache = menuItemCache2;
                if (n < stringArray.length) break;
                bl = true;
                break;
            }
            if (bl2) continue;
            return null;
        }
        if (bl || bl2) {
            return menuItemCache.getItemId();
        }
        return null;
    }

    private boolean isInvokableDialogAction(SpssAction spssAction) {
        TraceSettings.trace1((String)("Action is invokable: " + spssAction.getValue("Name")), (int)32768);
        return true;
    }

    public String getFrameId() {
        return this.mFrameID;
    }

    private boolean hasEnoughMenus(Preferences preferences) throws BackingStoreException {
        boolean bl = false;
        Preferences preferences2 = preferences.node("menus");
        String[] stringArray = preferences2.childrenNames();
        if (stringArray != null && stringArray.length > 8) {
            bl = true;
        }
        return bl;
    }

    private boolean hasAllCheckedMenuItems(Preferences preferences) throws BackingStoreException {
        String[] stringArray;
        boolean bl;
        String[] stringArray2;
        String[] stringArray3;
        String[] stringArray4;
        Preferences preferences2 = preferences.node("menus");
        Preferences preferences3 = null;
        Preferences preferences4 = null;
        Preferences preferences5 = null;
        for (String string : stringArray4 = preferences2.childrenNames()) {
            if (string.endsWith(";File")) {
                preferences3 = preferences2.node(string);
            } else if (string.endsWith(";Edit")) {
                preferences4 = preferences2.node(string);
            } else if (string.endsWith(";Analyze")) {
                preferences5 = preferences2.node(string);
            }
            if (preferences3 != null && preferences4 != null && preferences5 != null) break;
        }
        if (preferences3 == null || preferences4 == null || preferences5 == null) {
            return false;
        }
        boolean bl2 = false;
        for (String stringArray5 : stringArray3 = preferences3.childrenNames()) {
            if (!stringArray5.endsWith(";file_open")) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return false;
        }
        boolean bl22 = false;
        for (String stringArray5 : stringArray2 = preferences3.keys()) {
            String string2 = preferences3.get(stringArray5, null);
            if (string2 != null && string2.equals("file_print")) {
                bl22 = true;
            }
            if (bl22) break;
        }
        if (!bl22) {
            return false;
        }
        boolean bl3 = false;
        int n = 0;
        for (String string : stringArray2 = preferences4.keys()) {
            String string3 = preferences4.get(string, null);
            if (string3 != null && string3.equals("edit_undo")) {
                bl = true;
            } else if (string3 != null && string3.equals("edit_options")) {
                n = 1;
            }
            if (bl && n != 0) break;
        }
        if (!bl || n == 0) {
            return false;
        }
        boolean bl4 = false;
        for (String string : stringArray = preferences5.childrenNames()) {
            if (!string.endsWith(";analyze_desc_stat")) continue;
            bl4 = true;
            break;
        }
        return bl4;
    }

    public void disableAllToolbarItems() {
        if (this.mToolbarActionMap != null) {
            Set<String> set = this.mToolbarActionMap.keySet();
            for (String string : set) {
                SpssAction spssAction = this.mToolbarActionMap.get(string);
                if (spssAction == null) continue;
                spssAction.setEnabled(false);
            }
        }
    }

    private int getMenuIndex(JMenu jMenu, String string) {
        int n = -1;
        int n2 = jMenu.getMenuComponentCount();
        for (int i = 0; i < n2; ++i) {
            JMenu jMenu2;
            String string2;
            if (!(jMenu.getMenuComponent(i) instanceof JMenu) || !(string2 = (jMenu2 = (JMenu)jMenu.getMenuComponent(i)).getActionCommand()).equals(ResUtil.getString(string))) continue;
            n = i;
            break;
        }
        return n;
    }

    private int getMenuItemIndex(JMenu jMenu, String string) {
        int n = -1;
        int n2 = jMenu.getMenuComponentCount();
        for (int i = 0; i < n2; ++i) {
            JMenuItem jMenuItem;
            String string2;
            if (!(jMenu.getMenuComponent(i) instanceof JMenuItem) || !(string2 = (jMenuItem = (JMenuItem)jMenu.getMenuComponent(i)).getActionCommand()).equals(ResUtil.getString(string))) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    protected void setupNewScriptMenu(JMenuBar jMenuBar) {
        if (!VersionInfo.allowScripting()) {
            return;
        }
        int n = -1;
        int n2 = jMenuBar.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            JMenuItem jMenuItem;
            JMenu jMenu;
            int n3;
            JMenu jMenu2 = (JMenu)jMenuBar.getComponent(i);
            String string = jMenu2.getActionCommand();
            if (!string.equals(ResUtil.getString("File")) || (n3 = this.getMenuIndex(jMenu2, "file_new")) < 0 || (n = this.getMenuItemIndex(jMenu = (JMenu)jMenu2.getMenuComponent(n3), "file_new_output")) < 0) continue;
            IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
            if (iScriptLanguageMgr.isPythonScriptInstalled()) {
                jMenuItem = new JMenu(ResUtil.getString("file_new_script"));
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    jMenuItem.setMnemonic(ResUtil.getAccessKey("file_new_script"));
                }
                JMenuItem jMenuItem2 = new JMenuItem(ActionCatalog.getActionCatalog().getSpssAction("file_new_script_python2"));
                JMenuItem jMenuItem3 = new JMenuItem(ActionCatalog.getActionCatalog().getSpssAction("file_new_script_python3"));
                jMenuItem.add((Component)jMenuItem2, 0);
                jMenuItem.add((Component)jMenuItem3, 1);
                if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                    JMenuItem jMenuItem4 = new JMenuItem(ActionCatalog.getActionCatalog().getSpssAction("file_new_script_basic"));
                    jMenuItem.add((Component)jMenuItem4, 2);
                }
            } else {
                jMenuItem = new JMenuItem(ActionCatalog.getActionCatalog().getSpssAction("file_new_script"));
            }
            jMenu.add((Component)jMenuItem, n);
        }
    }

    public boolean isFrameMaximized() {
        return (this.getExtendedState() & 6) == 6;
    }

    public void minimized(boolean bl) {
    }

    private void getScreensTotalWidth() {
        GraphicsDevice[] graphicsDeviceArray;
        this.mTotalWidth = 0;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            DisplayMode displayMode = graphicsDevice.getDisplayMode();
            this.mTotalWidth += displayMode.getWidth();
        }
    }
}

