/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.ValidateDataDlg;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VariablesTab
extends BaseProcedureTab
implements ListDataListener {
    private List<String> mModelVarNames = new ArrayList<String>();
    private static final String SRC_VAR_LIST = "ValidateDlgSrcVarList";
    private static final String ANALYSIS_TARGET_VAR_LIST = "ValidateDlgAnalysisTargetVarList";
    private static final String IDENTIFIER_VAR_LIST = "ValidateDlgIdentifierTargetVarList";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mAnalysisTargetVarList;
    private TargetVariableList mCaseIdTargetVarList;
    private ArrowButton mAnalysisArrowButton;
    private ArrowButton mCaseIdArrowButton;
    private Set<String> mVarNames = new HashSet<String>();

    public VariablesTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.doEnableBasicChecksTab(listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        ValidateDataDlg validateDataDlg;
        Map<ISpssVariable, Set<SingleVariableRule>> map;
        if (listDataEvent.getSource() == this.mAnalysisTargetVarList.getModel() && (map = (validateDataDlg = (ValidateDataDlg)this.mParent).getSingleVarRulesTab().getRulesSelectionMap()).size() > 0) {
            ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
            VarListModel varListModel = this.mAnalysisTargetVarList.getModel();
            int n = varListModel.getSize();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    arrayList.add(varListModel.getElementAt(i));
                }
            }
            Set<ISpssVariable> set = map.keySet();
            for (ISpssVariable iSpssVariable : set) {
                if (arrayList.contains(iSpssVariable)) continue;
                map.get(iSpssVariable).clear();
            }
        }
        this.doEnableBasicChecksTab(listDataEvent);
    }

    public void doEnableBasicChecksTab(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mAnalysisTargetVarList.getModel()) {
            ((ValidateDataDlg)this.mParent).getBasicChecksTab().enableControls();
        }
        if (listDataEvent.getSource() == this.mCaseIdTargetVarList.getModel()) {
            boolean bl = this.mCaseIdTargetVarList.getModel().getSize() > 0;
            ((ValidateDataDlg)this.mParent).getBasicChecksTab().enableFlags(bl);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public String generateSyntax() {
        VarListModel varListModel;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n" + SyntaxUtil.getMainCommand("VALIDATEDATA"));
        VarListModel varListModel2 = this.mAnalysisTargetVarList.getModel();
        int n = varListModel2.getSize();
        if (n > 0) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(varListModel2.getElementAt(i).getName());
            }
        }
        if ((n = (varListModel = this.mCaseIdTargetVarList.getModel()).getSize()) > 0) {
            stringBuffer.append(" ID=");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(varListModel.getElementAt(i).getName());
            }
        }
        return stringBuffer.toString();
    }

    public boolean isNameInDataSource(String string) {
        return this.mVarNames.contains(string.toLowerCase());
    }

    public boolean isCatVarsPresent() {
        VarListModel varListModel = this.mAnalysisTargetVarList.getModel();
        int n = varListModel.getSize();
        boolean bl = false;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                MeasurementLevel measurementLevel = iSpssVariable.getMeasurementLevel();
                if (!measurementLevel.equals((Object)MeasurementLevel.ordinal) && !measurementLevel.equals((Object)MeasurementLevel.nominal)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean isScaleVarsPresent() {
        VarListModel varListModel = this.mAnalysisTargetVarList.getModel();
        int n = varListModel.getSize();
        boolean bl = false;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                MeasurementLevel measurementLevel = iSpssVariable.getMeasurementLevel();
                if (!measurementLevel.equals((Object)MeasurementLevel.scale) && !measurementLevel.equals((Object)MeasurementLevel.unknown)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public List<ISpssVariable> getAllVars() {
        int n;
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        VarListModel varListModel = this.mSrcVarList.getModel();
        int n2 = varListModel.getSize();
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                arrayList.add(varListModel.getElementAt(n));
            }
        }
        if ((n2 = (varListModel = this.mAnalysisTargetVarList.getModel()).getSize()) > 0) {
            for (n = 0; n < n2; ++n) {
                arrayList.add(varListModel.getElementAt(n));
            }
        }
        if ((n2 = (varListModel = this.mCaseIdTargetVarList.getModel()).getSize()) > 0) {
            for (n = 0; n < n2; ++n) {
                arrayList.add(varListModel.getElementAt(n));
            }
        }
        return arrayList;
    }

    public Set<String> getVarNames() {
        return this.mVarNames;
    }

    public List<ISpssVariable> getCatVarsList() {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        VarListModel varListModel = this.mAnalysisTargetVarList.getModel();
        int n = varListModel.getSize();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                MeasurementLevel measurementLevel = iSpssVariable.getMeasurementLevel();
                if (!measurementLevel.equals((Object)MeasurementLevel.ordinal) && !measurementLevel.equals((Object)MeasurementLevel.nominal)) continue;
                arrayList.add(iSpssVariable);
            }
        }
        return arrayList;
    }

    public List<ISpssVariable> getScaleVarsList() {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        VarListModel varListModel = this.mAnalysisTargetVarList.getModel();
        int n = varListModel.getSize();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                MeasurementLevel measurementLevel = iSpssVariable.getMeasurementLevel();
                if (!measurementLevel.equals((Object)MeasurementLevel.scale) && !measurementLevel.equals((Object)MeasurementLevel.unknown)) continue;
                arrayList.add(iSpssVariable);
            }
        }
        return arrayList;
    }

    public List<ISpssVariable> getAnalysisVarsList() {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        VarListModel varListModel = this.mAnalysisTargetVarList.getModel();
        int n = varListModel.getSize();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                arrayList.add(varListModel.getElementAt(i));
            }
        }
        return arrayList;
    }

    public List<String> loadModalVarNames() {
        ISpssVariable iSpssVariable;
        int n;
        VarListModel varListModel = this.mAnalysisTargetVarList.getModel();
        int n2 = varListModel.getSize();
        for (n = 0; n < n2; ++n) {
            iSpssVariable = varListModel.getElementAt(n);
            if (this.mModelVarNames.contains(iSpssVariable.getName().toLowerCase())) continue;
            this.mModelVarNames.add(iSpssVariable.getName().toLowerCase());
        }
        varListModel = this.mCaseIdTargetVarList.getModel();
        n2 = varListModel.getSize();
        for (n = 0; n < n2; ++n) {
            iSpssVariable = varListModel.getElementAt(n);
            if (this.mModelVarNames.contains(iSpssVariable.getName().toLowerCase())) continue;
            this.mModelVarNames.add(iSpssVariable.getName().toLowerCase());
        }
        return this.mModelVarNames;
    }

    public void pruneSourceList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(((ValidateDataDlg)this.mParent).getSingleVarRulesTab().getSingleVarLoadedOutComeVars());
        arrayList.addAll(((ValidateDataDlg)this.mParent).getCrossVarRulesTab().getCrossVarLoadedOutComeVars());
        this.mVarNames.clear();
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.columnCount();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            bl = true;
            if (arrayList.contains(iSpssVariable.getName())) {
                this.removeVariableFromLists(iSpssVariable);
                bl = false;
            } else if (this.isSpecialVar(iSpssVariable)) {
                this.removeVariableFromLists(iSpssVariable);
                bl = false;
            } else if (this.isSplitVar(iSpssVariable, iSpssDataSrc)) {
                this.removeVariableFromLists(iSpssVariable);
                bl = false;
            } else if (this.isWeightVar(iSpssVariable, iSpssDataSrc)) {
                this.removeVariableFromLists(iSpssVariable);
                bl = false;
            }
            if (!bl) continue;
            this.mVarNames.add(iSpssVariable.getName().toLowerCase());
        }
        this.mSrcVarList.requestFocus();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.mSrcVarList.ensureIndexIsVisible(0);
    }

    public boolean isAnalysisVarPresent() {
        return this.mAnalysisTargetVarList.getModel().getSize() > 0;
    }

    public boolean isCaseIdentifierVarSelected() {
        return this.mCaseIdTargetVarList.getModel().getSize() > 0;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_vdtab_variables";
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mSrcVarList;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 10;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2 * 3, DialogUtil.getVarListWidth() * 2 / 3, n2 * 2, DialogUtil.getVarListWidth() * 2 / 3);
        DialogUtil.addUsingGBL(this, this.setupListPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VariablesTab.this.mSrcVarList.requestFocus();
                if (VariablesTab.this.mSrcVarList.getSelectedIndex() == -1) {
                    VariablesTab.this.mSrcVarList.setSelectedIndex(0);
                }
            }
        });
    }

    TargetVariableList getAnalysisTargetVarList() {
        return this.mAnalysisTargetVarList;
    }

    TargetVariableList getCaseIdTargetVarList() {
        return this.mCaseIdTargetVarList;
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_VLD_VD_VARIABLES_COLON");
        jLabel.setLabelFor(this.mSrcVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_VLD_VD_ANALYSIS_VARIABLES_COLON");
        jLabel2.setLabelFor(this.mAnalysisTargetVarList);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_VLD_VD_CASE_ID_VAR_COLON");
        jLabel3.setLabelFor(this.mCaseIdTargetVarList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mAnalysisTargetVarList);
        jScrollPane2.setPreferredSize(this.mAnalysisTargetVarList.getMinimumSize());
        JScrollPane jScrollPane3 = new JScrollPane(this.mCaseIdTargetVarList);
        jScrollPane3.setPreferredSize(this.mCaseIdTargetVarList.getMinimumSize());
        int n = (int)jLabel3.getPreferredSize().getHeight();
        n = n * 3 / 2;
        double[] dArray = new double[]{-1.0, 0.5, 7.0, -2.0, 7.0, 0.5, -1.0};
        double[] dArray2 = new double[]{-2.0, -1.0, n, -1.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        jPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.setHGap(3);
        tableLayout.setVGap(3);
        jPanel.add((Component)jLabel, "1, 0");
        jPanel.add((Component)jLabel2, "5, 0");
        jPanel.add((Component)jScrollPane, "1, 1, 1, 3");
        jPanel.add((Component)this.mAnalysisArrowButton, "3, 1, c, c");
        jPanel.add((Component)jScrollPane2, "5, 1");
        jPanel.add((Component)jLabel3, "5, 2, f, b");
        jPanel.add((Component)this.mCaseIdArrowButton, "3, 3, c, c");
        jPanel.add((Component)jScrollPane3, "5, 3");
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        SplitVarFilter splitVarFilter = new SplitVarFilter();
        this.mSrcVarList.addVarFilter(splitVarFilter);
        this.mSrcVarList.setIdentifier(SRC_VAR_LIST);
        this.mSrcVarList.loadFromActiveDataset();
        this.mAnalysisTargetVarList = new TargetVariableList();
        this.mAnalysisTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mAnalysisTargetVarList.setIdentifier(ANALYSIS_TARGET_VAR_LIST);
        this.mAnalysisTargetVarList.addVarFilter(splitVarFilter);
        this.mCaseIdTargetVarList = new TargetVariableList();
        this.mCaseIdTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCaseIdTargetVarList.setIdentifier(IDENTIFIER_VAR_LIST);
        this.mCaseIdTargetVarList.addVarFilter(splitVarFilter);
        this.mAnalysisArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCaseIdArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.setDefaults();
        this.mAnalysisTargetVarList.getModel().addListDataListener(this);
        this.mCaseIdTargetVarList.getModel().addListDataListener(this);
        this.mAnalysisArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mAnalysisArrowButton.registerVariableList(this.mAnalysisTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mCaseIdArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCaseIdArrowButton.registerVariableList(this.mCaseIdTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.addToComponentOrder(this.mSrcVarList);
        this.addToComponentOrder(this.mAnalysisArrowButton);
        this.addToComponentOrder(this.mCaseIdArrowButton);
        this.addToComponentOrder(this.mAnalysisTargetVarList);
        this.addToComponentOrder(this.mCaseIdTargetVarList);
    }

    private void setDefaults() {
        this.mSrcVarList.getModel().removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mAnalysisTargetVarList.getModel().removeAll();
        this.mCaseIdTargetVarList.getModel().removeAll();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private boolean isSpecialVar(ISpssVariable iSpssVariable) {
        String string = iSpssVariable.getName();
        int n = string.lastIndexOf("_");
        return n > -1 && n == string.length() - 1;
    }

    private boolean isSplitVar(ISpssVariable iSpssVariable, ISpssDataSrc iSpssDataSrc) {
        boolean bl = false;
        int n = iSpssDataSrc.getNSplitVars();
        for (int i = 0; i < n; ++i) {
            int n2 = iSpssDataSrc.getSplitVarIndex(i);
            ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(n2);
            if (!iSpssVariable2.equals(iSpssVariable)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isWeightVar(ISpssVariable iSpssVariable, ISpssDataSrc iSpssDataSrc) {
        boolean bl = false;
        int n = iSpssDataSrc.getWeightVarIndex();
        if (n > -1) {
            ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(n);
            bl = iSpssVariable.equals(iSpssVariable2);
        }
        return bl;
    }

    private void removeVariableFromLists(ISpssVariable iSpssVariable) {
        if (this.mSrcVarList.getModel().findElementIndex(iSpssVariable) > 0) {
            this.mSrcVarList.getModel().removeElement(iSpssVariable);
        } else if (this.mAnalysisTargetVarList.getModel().findElementIndex(iSpssVariable) > 0) {
            this.mAnalysisTargetVarList.getModel().removeElement(iSpssVariable);
        } else if (this.mCaseIdTargetVarList.getModel().findElementIndex(iSpssVariable) > 0) {
            this.mCaseIdTargetVarList.getModel().removeElement(iSpssVariable);
        }
    }

    private class SplitVarFilter
    implements IVarFilter {
        private SplitVarFilter() {
        }

        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.getNSplitVars();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(iSpssDataSrc.getSplitVarIndex(i));
                if (iSpssVariable == null || iSpssVariable2 == null || !iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
                return false;
            }
            return true;
        }
    }
}

