/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRulesTab;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.ValidateDataDlg;
import com.spss.shared.core_tools.utils.SerializableObject;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidateDataSingleRules
extends BaseTabbedSubDialog {
    static String SINGLE_RULES_ADDED_UPDATED = "IDS_SINGLE_RULES_ADDED_UPDATED";
    private SingleVariableRulesTab mRulesTab;
    private Map<SingleVariableRule, SingleVariableRule> mRulesMap;

    public ValidateDataSingleRules(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_VLD_SVAR_RULE_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    protected void init() {
        super.init();
        this.mRulesTab = new SingleVariableRulesTab(this);
        this.mRulesMap = new HashMap<SingleVariableRule, SingleVariableRule>();
        this.addTab(this.getResString("IDS_VLD_SVAR_SINGLE_RUES_TAB_CAPTION"), this.mRulesTab);
        this.pack();
        this.mRulesTab.afterPack();
        this.mRulesTab.setCrossRules(((ValidateDataDlg)this.mParentDlg).getCrossVarRulesTab().getCrossVariableRules());
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("SINGLE_VARIABLE_RULES");
        ArrayList<SingleVariableRule> arrayList = new ArrayList<SingleVariableRule>();
        if (serializableObjectArray != null) {
            this.mRulesMap.clear();
            for (SerializableObject serializableObject : serializableObjectArray) {
                SingleVariableRule singleVariableRule = (SingleVariableRule)serializableObject;
                try {
                    SingleVariableRule singleVariableRule2 = singleVariableRule.clone();
                    arrayList.add(singleVariableRule2);
                    this.mRulesMap.put(singleVariableRule2, singleVariableRule);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    ComponentState.trace1((String)cloneNotSupportedException.getMessage(), (int)15);
                }
            }
        }
        this.mRulesTab.setRules(arrayList, (Map)dialogDataModel.getObject("VARIABLE_RULE_MAP"));
    }

    private boolean isRuleComplete(SingleVariableRule singleVariableRule) {
        return singleVariableRule.getMaximumValue() != null && singleVariableRule.getMaximumValue().length() > 0 || singleVariableRule.getMinimumValue() != null && singleVariableRule.getMinimumValue().length() > 0 || singleVariableRule.getValues() != null && !singleVariableRule.getValues().isEmpty();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            List<SingleVariableRule> list = this.mRulesTab.getRules();
            Object object = list.iterator();
            while (object.hasNext()) {
                SingleVariableRule singleVariableRule = object.next();
                if (singleVariableRule.getCurrentValidValues() != SingleVariableRule.ValidValues.eWITHIN_RANGE || !singleVariableRule.getMaximumValue().equals("") || !singleVariableRule.getMinimumValue().equals("") || singleVariableRule.isFlagUserMissingValues() || singleVariableRule.isFlagSystemMissingValues() || singleVariableRule.isFlagBlankValues() || singleVariableRule.isFlagUnlabeledValues() || singleVariableRule.isFlagNonIntegerValues()) continue;
                object.remove();
            }
            object = new ArrayList();
            for (SingleVariableRule singleVariableRule : list) {
                if (this.mRulesMap.containsKey(singleVariableRule)) {
                    SingleVariableRule singleVariableRule2 = this.mRulesMap.get(singleVariableRule);
                    singleVariableRule2.setFlagBlankValues(singleVariableRule.isFlagBlankValues());
                    singleVariableRule2.setFlagNonIntegerValues(singleVariableRule.isFlagNonIntegerValues());
                    singleVariableRule2.setFlagSystemMissingValues(singleVariableRule.isFlagSystemMissingValues());
                    singleVariableRule2.setFlagUnlabeledValues(singleVariableRule.isFlagUnlabeledValues());
                    singleVariableRule2.setFlagUserMissingValues(singleVariableRule.isFlagUserMissingValues());
                    singleVariableRule2.setCurrentValidValues(singleVariableRule.getCurrentValidValues());
                    singleVariableRule2.setDateFormat(singleVariableRule.getDateFormat());
                    singleVariableRule2.setCaseSensitive(singleVariableRule.isCaseSensitive());
                    singleVariableRule2.setMaximumValue(singleVariableRule.getMaximumValue());
                    singleVariableRule2.setMinimumValue(singleVariableRule.getMinimumValue());
                    singleVariableRule2.setName(singleVariableRule.getName());
                    singleVariableRule2.setType(singleVariableRule.getType());
                    singleVariableRule2.setValues(singleVariableRule.getValues());
                    object.add(singleVariableRule2);
                    continue;
                }
                object.add(singleVariableRule);
            }
            dialogDataModel.putSerializableArray("SINGLE_VARIABLE_RULES", object.toArray(new SerializableObject[object.size()]));
        }
        dialogDataModel.putBoolean(SINGLE_RULES_ADDED_UPDATED, true);
        return bl;
    }
}

