/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.RulesUtil;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.res.ValidateDataResBundle;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.BasicChecksTab;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.CrossVarRulesTab;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.OutputTab;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.SaveTab;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.SingleVarRulesTab;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.SummaryVariable;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.VariablesTab;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;

public class ValidateDataDlg
extends BaseTabbedDialog {
    private VariablesTab mVariablesTab;
    private BasicChecksTab mBasicChecksTab;
    private SingleVarRulesTab mSingleVarRulesTab;
    private CrossVarRulesTab mCrossVarRulesTab;
    private SaveTab mSaveTab;
    private StringBuffer mValLabelsFormatSyntax = new StringBuffer();
    private Set<String> mModelVarNames = new HashSet<String>();
    private String mSortCasesSyntax;
    private Set<String> mVarNames = new HashSet<String>();
    private boolean mSyntaxResult = true;
    private boolean mValDataSyntax = true;
    ArrayList<String> mUniqueAddedVariableNames = new ArrayList();

    public ValidateDataDlg(JFrame jFrame) {
        super(jFrame, true, ValidateDataResBundle.getDefaultResourceBundleName(), ValidateDataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_VLD_CAPTION"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getIActionKey() {
        return "data_validation_validate_data";
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = super.okPastePressed();
        if (bl) {
            bl = this.validateMinSpec();
        }
        return bl;
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        this.mVarNames.addAll(this.mVariablesTab.getVarNames());
        String string = this.generateDeleteFromSaveSyntax();
        if (this.mSyntaxResult) {
            String string2 = this.generateSaveSyntax();
            String string3 = this.generateTemporarySyntax();
            boolean bl = string3.length() <= 0;
            this.mSingleVarRulesTab.setTemporary(bl);
            this.mSingleVarRulesTab.generateSyntax();
            this.mCrossVarRulesTab.setTemporary(bl);
            this.mCrossVarRulesTab.generateSyntax();
            stringBuffer.append(string);
            stringBuffer.append(this.mCrossVarRulesTab.getDatafileDeleteSyntax());
            stringBuffer.append(this.mCrossVarRulesTab.getDatafileAttribSyntax());
            stringBuffer.append(this.mSingleVarRulesTab.getDatafileDeleteSyntax());
            stringBuffer.append(this.mSingleVarRulesTab.getDeleteLinksSyntax());
            stringBuffer.append(this.mSingleVarRulesTab.getDatafileAttribSyntax());
            stringBuffer.append(this.mSingleVarRulesTab.getVarAttribLinksSyntax());
            stringBuffer.append(string3);
            stringBuffer.append(this.mSingleVarRulesTab.getComputeSyntax());
            stringBuffer.append(this.mCrossVarRulesTab.getComputeSyntax());
            stringBuffer.append(this.generateVarAttrOutcomeVarValLabelsFormatSyntax(bl));
            stringBuffer.append(this.mSingleVarRulesTab.getVarLabelsSyntax());
            stringBuffer.append(this.mCrossVarRulesTab.getVarLabelsSyntax());
            stringBuffer.append(this.mValLabelsFormatSyntax);
            if (this.mValDataSyntax) {
                stringBuffer.append(this.getValidateDataSyntax(string2));
            }
            stringBuffer.append(this.generateSummariesSyntax());
            if (this.mValDataSyntax && this.mSortCasesSyntax != null) {
                stringBuffer.append(this.mSortCasesSyntax);
            }
            stringBuffer.append("\n");
        }
        if (stringBuffer.indexOf("\n") == 0) {
            stringBuffer.replace(0, 1, "");
        }
        return stringBuffer.toString();
    }

    public CrossVarRulesTab getCrossVarRulesTab() {
        return this.mCrossVarRulesTab;
    }

    public SingleVarRulesTab getSingleVarRulesTab() {
        return this.mSingleVarRulesTab;
    }

    public BasicChecksTab getBasicChecksTab() {
        return this.mBasicChecksTab;
    }

    public VariablesTab getVariablesTab() {
        return this.mVariablesTab;
    }

    @Override
    public void reset() {
        super.reset();
        this.loadRules();
        this.loadCrossRulesSelections();
        this.mVariablesTab.pruneSourceList();
        this.mSaveTab.populateSummaryData();
    }

    @Override
    protected void init() {
        super.init();
        this.mVariablesTab = new VariablesTab(this);
        this.mBasicChecksTab = new BasicChecksTab(this);
        this.mSingleVarRulesTab = new SingleVarRulesTab(this);
        this.mCrossVarRulesTab = new CrossVarRulesTab(this);
        OutputTab outputTab = new OutputTab(this);
        this.mSaveTab = new SaveTab(this);
        this.addTab(this.getResString("IDS_VLD_VARIABLES_CAPTION"), this.mVariablesTab);
        this.addTab(this.getResString("IDS_VLD_BC_CAPTION"), this.mBasicChecksTab);
        this.addTab(this.getResString("IDS_VLD_SVR_CAPTION"), this.mSingleVarRulesTab);
        this.addTab(this.getResString("IDS_VLD_CVR_CAPTION"), this.mCrossVarRulesTab);
        this.addTab(this.getResString("IDS_VLD_OUT_CAPTION"), outputTab);
        this.addTab(this.getResString("IDS_VLD_SAVE_CAPTION"), this.mSaveTab);
        this.enableOkPaste(true);
        this.loadRules();
        this.pack();
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mVariablesTab.pruneSourceList();
    }

    private void loadCrossRulesSelections() {
        List<CrossVariableRule> list = this.mCrossVarRulesTab.getCrossVariableRules();
        if (list != null && !list.isEmpty()) {
            HashSet<CrossVariableRule> hashSet = new HashSet<CrossVariableRule>();
            Object[] objectArray = this.getDialogDataModel().getArray("IDS_SELECTED_CROSS_VARIABLE_RULES");
            if (objectArray != null) {
                block0: for (Object object : objectArray) {
                    if (object == null) continue;
                    String string = (String)object;
                    for (CrossVariableRule crossVariableRule : list) {
                        if (!crossVariableRule.getName().equals(string)) continue;
                        hashSet.add(crossVariableRule);
                        continue block0;
                    }
                }
            } else {
                hashSet.addAll(list);
            }
            this.mCrossVarRulesTab.setSelectedRules(hashSet);
        }
    }

    private boolean validateMinSpec() {
        boolean bl;
        this.mValDataSyntax = this.mVariablesTab.isAnalysisVarPresent() || this.mVariablesTab.isCaseIdentifierVarSelected() || this.mSingleVarRulesTab.isSingleRulesApplied() || this.mCrossVarRulesTab.isCrossRulesApplied();
        boolean bl2 = bl = this.mValDataSyntax || this.mSingleVarRulesTab.isRulesModified() || this.mCrossVarRulesTab.isRulesModified();
        if (!bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_VLD_VD_MIN_SPEC_ALERT"), VersionInfo.getAppVersionString());
        }
        return bl;
    }

    private String generateDeleteFromSaveSyntax() {
        Comparable<StringBuffer> comparable;
        String string = this.getPersistentConflictNames();
        boolean bl = false;
        if (string.length() > 0) {
            comparable = this.getDialogDataModel().getBoolean("IDS_VLD_SAVE_REPLACE");
            if (comparable != null && ((Boolean)comparable).booleanValue()) {
                bl = true;
            } else if (0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_VLD_SAVE_REPLACE_VARS"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                bl = true;
                this.getDialogDataModel().putBoolean("IDS_VLD_SAVE_REPLACE", true);
            } else {
                this.mSyntaxResult = false;
            }
        }
        comparable = new StringBuffer();
        List<String> list = this.mSingleVarRulesTab.getSingleVarLoadedOutComeVars();
        for (String string2 : list) {
            ((StringBuffer)comparable).append(" ").append(string2);
        }
        list = this.mCrossVarRulesTab.getCrossVarLoadedOutComeVars();
        for (String string2 : list) {
            ((StringBuffer)comparable).append(" ").append(string2);
        }
        if (bl) {
            ((StringBuffer)comparable).append(" ").append(string);
        }
        if (((StringBuffer)comparable).length() > 0) {
            String string3 = ((StringBuffer)comparable).toString().trim();
            ((StringBuffer)comparable).delete(0, ((StringBuffer)comparable).length());
            ((StringBuffer)comparable).append(SyntaxUtil.getMainCommand("DELETE VARIABLES"));
            ((StringBuffer)comparable).append(SyntaxUtil.getMainCommandParamters(string3));
            ((StringBuffer)comparable).append(".");
        }
        return ((StringBuffer)comparable).toString();
    }

    private String getPersistentConflictNames() {
        this.mModelVarNames.clear();
        this.mModelVarNames.addAll(this.mVariablesTab.loadModalVarNames());
        SerializableObject[] serializableObjectArray = this.getDialogDataModel().getSerializableArray("IDS_VLD_SAVE_SUMMARY_VARS_TABLE_MODEL");
        ArrayList<SummaryVariable> arrayList = new ArrayList<SummaryVariable>();
        if (serializableObjectArray != null && serializableObjectArray.length > 0) {
            for (SerializableObject serializableObject : serializableObjectArray) {
                arrayList.add((SummaryVariable)serializableObject);
            }
        }
        SerializableObject[] serializableObjectArray2 = new StringBuffer();
        if (this.isCheckedForEmptyCases()) {
            this.addToConflictNamesList(((SummaryVariable)arrayList.get(0)).getName(), (StringBuffer)serializableObjectArray2);
        }
        if (this.isCheckedForDupIDs()) {
            this.addToConflictNamesList(((SummaryVariable)arrayList.get(1)).getName(), (StringBuffer)serializableObjectArray2);
        }
        if (this.isCheckedForIncompleteIDs()) {
            this.addToConflictNamesList(((SummaryVariable)arrayList.get(2)).getName(), (StringBuffer)serializableObjectArray2);
        }
        if ((this.getSingleVarRulesTab().isSingleRulesApplied() || this.getCrossVarRulesTab().isCrossRulesApplied()) && this.isCheckedForRuleViolations()) {
            this.addToConflictNamesList(((SummaryVariable)arrayList.get(3)).getName(), (StringBuffer)serializableObjectArray2);
        }
        return serializableObjectArray2.toString();
    }

    private void addToConflictNamesList(String string, StringBuffer stringBuffer) {
        if (string == null || string.length() < 1) {
            return;
        }
        if (this.mVariablesTab.isNameInDataSource(string) || this.mModelVarNames.contains(string.toLowerCase())) {
            stringBuffer.append(" ").append(string);
        }
    }

    private String generateSaveSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        SerializableObject[] serializableObjectArray = this.getDialogDataModel().getSerializableArray("IDS_VLD_SAVE_SUMMARY_VARS_TABLE_MODEL");
        ArrayList<SummaryVariable> arrayList = new ArrayList<SummaryVariable>();
        if (serializableObjectArray != null && serializableObjectArray.length > 0) {
            for (SerializableObject serializableObject : serializableObjectArray) {
                arrayList.add((SummaryVariable)serializableObject);
            }
        }
        if (this.isCheckedForEmptyCases()) {
            stringBuffer.append(" EMPTYCASE(");
            stringBuffer.append(((SummaryVariable)arrayList.get(0)).getName());
            stringBuffer.append(")");
            this.mVarNames.add(((SummaryVariable)arrayList.get(0)).getName().toLowerCase());
        }
        if (this.isCheckedForDupIDs()) {
            stringBuffer.append(" DUPLICATEID(");
            stringBuffer.append(((SummaryVariable)arrayList.get(1)).getName());
            stringBuffer.append(")");
            this.mVarNames.add(((SummaryVariable)arrayList.get(1)).getName().toLowerCase());
        }
        if (this.isCheckedForIncompleteIDs()) {
            stringBuffer.append(" INCOMPLETEID(");
            stringBuffer.append(((SummaryVariable)arrayList.get(2)).getName());
            stringBuffer.append(")");
            this.mVarNames.add(((SummaryVariable)arrayList.get(2)).getName().toLowerCase());
        }
        if ((this.getSingleVarRulesTab().isSingleRulesApplied() || this.getCrossVarRulesTab().isCrossRulesApplied()) && arrayList.size() > 3) {
            Object object;
            if (((SummaryVariable)arrayList.get(3)).isSelected()) {
                stringBuffer.append(" RULEVIOLATIONS(");
                stringBuffer.append(((SummaryVariable)arrayList.get(3)).getName());
                stringBuffer.append(")");
                object = this.getDialogDataModel().getBoolean("IDS_VLD_OUT_MOVE_CHECK");
                if (object != null && ((Boolean)object).booleanValue()) {
                    this.generateSortCasesSyntax(((SummaryVariable)arrayList.get(3)).getName(), false);
                }
                this.mVarNames.add(((SummaryVariable)arrayList.get(3)).getName());
            } else {
                object = this.getDialogDataModel().getBoolean("IDS_VLD_OUT_MOVE_CHECK");
                if (object != null && ((Boolean)object).booleanValue()) {
                    String string = this.getResString("IDS_VLD_SAVE_VIOLATIONS_NAME");
                    string = VarNameValidator.generateUniqueSpssName((String)string, this.mVarNames, (boolean)true);
                    stringBuffer.append(" RULEVIOLATIONS(");
                    stringBuffer.append(string);
                    stringBuffer.append(")");
                    this.generateSortCasesSyntax(string, true);
                }
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "\n" + SyntaxUtil.getSubCommand("/SAVE"));
        }
        return stringBuffer.toString();
    }

    private String generateSummariesSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_VLD_OUT_DISPLAY_CHECK");
        if (bl != null && bl.booleanValue() && this.mVariablesTab.isAnalysisVarPresent()) {
            List<ISpssVariable> list;
            List<ISpssVariable> list2 = this.mVariablesTab.getCatVarsList();
            int n = list2.size();
            if (n > 0) {
                stringBuffer.append("\n* ").append(this.getResString("IDS_VLD_SUMCAT_COMMENT")).append(".");
                stringBuffer.append("\n").append(SyntaxUtil.getMainCommand("FREQUENCIES"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(list2.get(i).getName());
                }
                stringBuffer.append(".");
            }
            if ((n = (list = this.mVariablesTab.getScaleVarsList()).size()) > 0) {
                stringBuffer.append("\n* ").append(this.getResString("IDS_VLD_SUMSCALE_COMMENT")).append(".");
                stringBuffer.append("\n").append(SyntaxUtil.getMainCommand("DESCRIPTIVES"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(list.get(i).getName());
                }
                stringBuffer.append(".");
            }
        }
        return stringBuffer.toString();
    }

    private String getValidateDataSyntax(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n* ").append(this.getResString("IDS_VLD_VALDATA_SYN_COMMENT")).append(".");
        stringBuffer.append(this.mVariablesTab.generateSyntax());
        stringBuffer.append(this.mCrossVarRulesTab.getCrossRulesSyntax());
        stringBuffer.append(this.generateBasicChecksSyntax());
        stringBuffer.append(this.generateOutputSyntax());
        stringBuffer.append(string);
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    private String generateOutputSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/CASEREPORT DISPLAY="));
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_VLD_OUT_LISTALL_CHECK");
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        if ((this.mSingleVarRulesTab.isSingleRulesApplied() || this.mCrossVarRulesTab.isCrossRulesApplied()) && bl2) {
            stringBuffer.append("YES MINVIOLATIONS=");
            String string = this.getDialogDataModel().getString("IDS_VLD_OUT_MIN_NUM_EDIT");
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(1);
            }
            stringBuffer.append(" CASELIMIT=FIRSTN(");
            string = this.getDialogDataModel().getString("IDS_VLD_OUT_MAX_NUM_EDIT");
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(100);
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append("NO");
        }
        if (this.mSingleVarRulesTab.isSingleRulesApplied()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/RULESUMMARIES"));
            StringBuffer stringBuffer2 = new StringBuffer();
            bl = this.getDialogDataModel().getBoolean("IDS_VLD_OUT_SUM_VIOL_VAR_CHECK");
            boolean bl3 = true;
            if (bl != null) {
                bl3 = bl;
            }
            if (bl3) {
                stringBuffer2.append(" BYVARIABLE");
            }
            if ((bl = this.getDialogDataModel().getBoolean("IDS_VLD_OUT_SUM_VIOL_RULE_CHECK")) != null && bl.booleanValue()) {
                stringBuffer2.append(" BYRULE");
            }
            if (stringBuffer2.length() == 0) {
                stringBuffer2.append(" NONE");
            }
            stringBuffer.append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    private String generateBasicChecksSyntax() {
        Comparable<Boolean> comparable;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mVariablesTab.isAnalysisVarPresent()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/VARCHECKS STATUS="));
            comparable = this.getDialogDataModel().getBoolean("IDS_VLD_BC_FLAG_VAR_CHECK");
            if (comparable != null && ((Boolean)comparable).booleanValue()) {
                String string;
                stringBuffer.append("ON");
                boolean bl = this.checkContainsMeasurementLevel(MeasurementLevel.nominal) || this.checkContainsMeasurementLevel(MeasurementLevel.ordinal);
                boolean bl2 = this.checkContainsMeasurementLevel(MeasurementLevel.scale);
                if (bl || bl2) {
                    stringBuffer.append(" PCTMISSING=");
                    string = this.getDialogDataModel().getString("IDS_VLD_BC_MAX_MIS_VAL_EDIT");
                    if (string != null) {
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append("70");
                    }
                }
                if (bl) {
                    stringBuffer.append(" PCTEQUAL=");
                    string = this.getDialogDataModel().getString("IDS_VLD_BC_MAX_CASES_SINGLE_CAT_EDIT");
                    if (string != null) {
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append("95");
                    }
                }
                if (bl) {
                    stringBuffer.append(" PCTUNEQUAL=");
                    string = this.getDialogDataModel().getString("IDS_VLD_BC_MAX_CAT_COUNTONE_EDIT");
                    if (string != null) {
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append("90");
                    }
                }
                if (bl2) {
                    stringBuffer.append(" CV=");
                    string = this.getDialogDataModel().getString("IDS_VLD_BC_MIN_COEF_VAR_EDIT");
                    if (string != null) {
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append("0.001");
                    }
                    stringBuffer.append(" STDDEV=");
                    string = this.getDialogDataModel().getString("IDS_VLD_BC_MIN_STD_DEV_EDIT");
                    if (string != null) {
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append("0");
                    }
                }
            } else {
                stringBuffer.append("OFF");
            }
        }
        if (this.mVariablesTab.isCaseIdentifierVarSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/IDCHECKS"));
            comparable = new StringBuffer();
            Boolean bl = this.getDialogDataModel().getBoolean("IDS_VLD_BC_FLAG_INCOMLETE_CHECK");
            if (bl != null) {
                if (bl.booleanValue()) {
                    ((StringBuffer)comparable).append(" INCOMPLETE");
                }
            } else {
                ((StringBuffer)comparable).append(" INCOMPLETE");
            }
            if ((bl = this.getDialogDataModel().getBoolean("IDS_VLD_BC_FLAG_DUPLICATE_CHECK")) != null) {
                if (bl.booleanValue()) {
                    ((StringBuffer)comparable).append(" DUPLICATE");
                }
            } else {
                ((StringBuffer)comparable).append(" DUPLICATE");
            }
            if (((StringBuffer)comparable).length() == 0) {
                ((StringBuffer)comparable).append(" NONE");
            }
            stringBuffer.append(((StringBuffer)comparable).toString());
        }
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/CASECHECKS REPORTEMPTY="));
        comparable = this.getDialogDataModel().getBoolean("IDS_VLD_BC_FLAG_EMPTY_CHECK");
        if (comparable != null) {
            if (((Boolean)comparable).booleanValue()) {
                stringBuffer.append("YES");
                if (this.mVariablesTab.isAnalysisVarPresent()) {
                    stringBuffer.append(" SCOPE=");
                    Integer n = this.getDialogDataModel().getInteger("IDS_VLD_BC_DEFINE_CASES_COMBO");
                    if (n != null) {
                        if (n == 0) {
                            stringBuffer.append("ALLVARS");
                        } else {
                            stringBuffer.append("ANALYSISVARS");
                        }
                    } else {
                        stringBuffer.append("ALLVARS");
                    }
                }
            } else {
                stringBuffer.append("NO");
            }
        } else {
            stringBuffer.append("YES SCOPE=ALLVARS");
        }
        return stringBuffer.toString();
    }

    private String generateVarAttrOutcomeVarValLabelsFormatSyntax(boolean bl) {
        String string = this.getListOutVars();
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > 0) {
            stringBuffer.append("\n* ").append(this.getResString("IDS_VLD_MARK_RULE_OUT_COMMENT")).append(".");
            stringBuffer.append("\n").append(SyntaxUtil.getMainCommand("VARIABLE ATTRIBUTE"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES=")).append(string);
            stringBuffer.append(" ATTRIBUTE=$VD.RuleOutcomeVar(\"Yes\").");
            this.mValLabelsFormatSyntax.setLength(0);
            if (bl) {
                this.mValLabelsFormatSyntax.append("\n").append(SyntaxUtil.getMainCommand("VALUE LABELS"));
                this.mValLabelsFormatSyntax.append(SyntaxUtil.getMainCommandParamters(string));
                this.mValLabelsFormatSyntax.append(" 1 ");
                this.mValLabelsFormatSyntax.append(CharacterUtil.smartQuote((String)this.getResString("IDS_VLD_LABEL_INVALID")));
                this.mValLabelsFormatSyntax.append(" 0 ");
                this.mValLabelsFormatSyntax.append(CharacterUtil.smartQuote((String)this.getResString("IDS_VLD_LABEL_VALID")));
                this.mValLabelsFormatSyntax.append(SyntaxUtil.terminateSyntax());
                this.mValLabelsFormatSyntax.append(SyntaxUtil.getMainCommand("FORMAT"));
                this.mValLabelsFormatSyntax.append(SyntaxUtil.getMainCommandParamters(string));
                this.mValLabelsFormatSyntax.append(" (F1.0).");
                this.mValLabelsFormatSyntax.append("\n").append(SyntaxUtil.getMainCommand("VARIABLE WIDTH "));
                this.mValLabelsFormatSyntax.append(SyntaxUtil.getMainCommandParamters(string));
                this.mValLabelsFormatSyntax.append(" (4).");
                this.mValLabelsFormatSyntax.append("\n").append(SyntaxUtil.getMainCommand("VARIABLE LEVEL "));
                this.mValLabelsFormatSyntax.append(SyntaxUtil.getMainCommandParamters(string));
                this.mValLabelsFormatSyntax.append(" (NOMINAL).");
            }
        }
        return stringBuffer.toString();
    }

    private String getListOutVars() {
        int n;
        int n2;
        String string = this.mSingleVarRulesTab.getOutcomeVarsList().trim();
        String string2 = this.mCrossVarRulesTab.getOutcomeVarsList().trim();
        if (string2.length() > 0) {
            if (string.length() > 0) {
                string = string + " ";
                string = string + string2;
            } else {
                string = string2;
            }
        }
        if (string.length() > 0 && (n2 = string.indexOf(32)) > -1 && (n = string.indexOf(32, n2 + 1)) > -1) {
            String string3 = string.substring(0, n2).trim();
            int n3 = string.lastIndexOf(32);
            String string4 = string.substring(n3 + 1).trim();
            if (string3.length() > 0 && string4.length() > 0) {
                string = string3 + " TO " + string4;
            }
        }
        return string;
    }

    private String generateTemporarySyntax() {
        Boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        if (!(!this.getSingleVarRulesTab().isSingleRulesApplied() && !this.getCrossVarRulesTab().isCrossRulesApplied() || (bl = this.getDialogDataModel().getBoolean("IDS_VLD_SAVE_INDICATOR")) != null && bl.booleanValue())) {
            stringBuffer.append("\n").append(SyntaxUtil.getMainCommand("TEMPORARY."));
        }
        return stringBuffer.toString();
    }

    private void generateSortCasesSyntax(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getMainCommand("SORT CASES "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
            stringBuffer.append("(D).");
            if (bl) {
                stringBuffer.append("\n").append(SyntaxUtil.getMainCommand("DELETE VARIABLES "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
                stringBuffer.append(".");
            }
            this.mSortCasesSyntax = stringBuffer.toString();
        }
    }

    private boolean isCheckedForEmptyCases() {
        SerializableObject serializableObject;
        boolean bl = false;
        SerializableObject[] serializableObjectArray = this.getDialogDataModel().getSerializableArray("IDS_VLD_SAVE_SUMMARY_VARS_TABLE_MODEL");
        if (serializableObjectArray != null && serializableObjectArray.length > 0 && (serializableObject = serializableObjectArray[0]) != null) {
            SummaryVariable summaryVariable = (SummaryVariable)serializableObject;
            Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_VLD_BC_FLAG_EMPTY_CHECK");
            bl = bl2 != null && bl2 != false && summaryVariable.isSelected();
        }
        return bl;
    }

    private boolean isCheckedForDupIDs() {
        SerializableObject serializableObject;
        SerializableObject[] serializableObjectArray;
        boolean bl = false;
        if (this.getVariablesTab().isCaseIdentifierVarSelected() && (serializableObjectArray = this.getDialogDataModel().getSerializableArray("IDS_VLD_SAVE_SUMMARY_VARS_TABLE_MODEL")) != null && serializableObjectArray.length > 0 && (serializableObject = serializableObjectArray[1]) != null) {
            SummaryVariable summaryVariable = (SummaryVariable)serializableObject;
            Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_VLD_BC_FLAG_DUPLICATE_CHECK");
            bl = bl2 != null && bl2 != false && summaryVariable.isSelected();
        }
        return bl;
    }

    private boolean isCheckedForIncompleteIDs() {
        SerializableObject serializableObject;
        SerializableObject[] serializableObjectArray;
        boolean bl = false;
        if (this.getVariablesTab().isCaseIdentifierVarSelected() && (serializableObjectArray = this.getDialogDataModel().getSerializableArray("IDS_VLD_SAVE_SUMMARY_VARS_TABLE_MODEL")) != null && serializableObjectArray.length > 0 && (serializableObject = serializableObjectArray[1]) != null) {
            SummaryVariable summaryVariable = (SummaryVariable)serializableObject;
            Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_VLD_BC_FLAG_INCOMLETE_CHECK");
            bl = bl2 != null && bl2 != false && summaryVariable.isSelected();
        }
        return bl;
    }

    private boolean isCheckedForRuleViolations() {
        SerializableObject serializableObject;
        SerializableObject[] serializableObjectArray;
        boolean bl = false;
        if (this.getVariablesTab().isCaseIdentifierVarSelected() && (serializableObjectArray = this.getDialogDataModel().getSerializableArray("IDS_VLD_SAVE_SUMMARY_VARS_TABLE_MODEL")) != null && serializableObjectArray.length > 0 && (serializableObject = serializableObjectArray[1]) != null) {
            SummaryVariable summaryVariable = (SummaryVariable)serializableObject;
            bl = summaryVariable.isSelected();
        }
        return bl;
    }

    private boolean checkContainsMeasurementLevel(MeasurementLevel measurementLevel) {
        boolean bl = false;
        VarListModel varListModel = this.getVariablesTab().getAnalysisTargetVarList().getModel();
        int n = varListModel.getSize();
        for (int i = 0; i < n && !bl; ++i) {
            bl = varListModel.getElementAt(i).getMeasurementLevel().equals((Object)measurementLevel);
        }
        return bl;
    }

    private void loadRules() {
        Object object;
        List<SingleVariableRule> list;
        List<CrossVariableRule> list2 = RulesUtil.loadCrossVarRules();
        if (!list2.isEmpty()) {
            this.mCrossVarRulesTab.setRules(list2);
        }
        if (!(list = RulesUtil.loadSingleVarRules()).isEmpty()) {
            this.mSingleVarRulesTab.setRules(list);
            object = RulesUtil.loadSelectionsMap(this.mVariablesTab.getAllVars(), list);
            this.mSingleVarRulesTab.setRuleSelections((Map<ISpssVariable, Set<SingleVariableRule>>)object);
        }
        object = RulesUtil.loadSingleVarOutcomeVars();
        this.mSingleVarRulesTab.setSingleVarLoadedOutComeVars((List<String>)object);
        List<String> list3 = RulesUtil.loadCrossVarOutcomeVars();
        this.mCrossVarRulesTab.setCrossVarLoadedOutComeVars(list3);
    }

    public String generateSPSSName(String string) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        String string2 = VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)string, (int)0);
        int n = 0;
        while (this.mUniqueAddedVariableNames.contains(string2) || iSpssDataSrc.findVarIndex(string2) != -1) {
            string2 = "V" + n;
            ++n;
        }
        this.mUniqueAddedVariableNames.add(string2);
        return string2;
    }
}

