/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRulesTab;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.ValidateDataDlg;
import com.spss.shared.core_tools.utils.SerializableObject;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidateDataCrossRules
extends BaseTabbedSubDialog {
    String CROSS_RULES_ADDED_UPDATED = "IDS_CROSS_RULES_ADDED_UPDATED";
    private CrossVariableRulesTab mRulesTab;
    private Map<CrossVariableRule, CrossVariableRule> mRulesMap;

    public ValidateDataCrossRules(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_VLD_CVAR_RULE_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    protected void init() {
        super.init();
        this.mRulesMap = new HashMap<CrossVariableRule, CrossVariableRule>();
        this.mRulesTab = new CrossVariableRulesTab(this);
        this.addTab(this.getResString("IDS_VLD_CVAR_SINGLE_RUES_TAB_CAPTION"), this.mRulesTab);
        this.mRulesTab.setSingleRules(((ValidateDataDlg)this.mParentDlg).getSingleVarRulesTab().getRules());
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("IDS_CROSS_VARIABLE_RULES");
        ArrayList<CrossVariableRule> arrayList = new ArrayList<CrossVariableRule>();
        if (serializableObjectArray != null) {
            this.mRulesMap.clear();
            for (SerializableObject serializableObject : serializableObjectArray) {
                CrossVariableRule crossVariableRule = (CrossVariableRule)serializableObject;
                try {
                    CrossVariableRule crossVariableRule2 = crossVariableRule.clone();
                    arrayList.add(crossVariableRule2);
                    this.mRulesMap.put(crossVariableRule2, crossVariableRule);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    ComponentState.trace1((String)cloneNotSupportedException.getMessage(), (int)15);
                }
            }
        }
        this.mRulesTab.setRules(arrayList);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            List<CrossVariableRule> list = this.mRulesTab.getRules();
            ArrayList<CrossVariableRule> arrayList = new ArrayList<CrossVariableRule>();
            for (CrossVariableRule crossVariableRule : list) {
                if (crossVariableRule.getName().length() <= 0 || crossVariableRule.getLogicalExpression().length() <= 0) continue;
                if (this.mRulesMap.containsKey(crossVariableRule)) {
                    CrossVariableRule crossVariableRule2 = this.mRulesMap.get(crossVariableRule);
                    crossVariableRule2.setName(crossVariableRule.getName());
                    crossVariableRule2.setLogicalExpression(crossVariableRule.getLogicalExpression());
                    arrayList.add(crossVariableRule2);
                    continue;
                }
                arrayList.add(crossVariableRule);
            }
            dialogDataModel.putSerializableArray("IDS_CROSS_VARIABLE_RULES", arrayList.toArray(new SerializableObject[arrayList.size()]));
        }
        dialogDataModel.putBoolean(this.CROSS_RULES_ADDED_UPDATED, true);
        return bl;
    }
}

