/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.ui.dialogs.validatedata.validate_data.SummaryVariable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SummaryVarsTableModel
extends AbstractTableModel {
    final int DESC_COL = 0;
    final int SAVE_COL = 1;
    final int NAME_COL = 2;
    final int NUM_COLS = 3;
    private List<SummaryVariable> mSummaryVariables = new ArrayList<SummaryVariable>();
    private List<Boolean> mEnableStates = new ArrayList<Boolean>(4);
    protected String[] mColumnNames;

    public SummaryVarsTableModel() {
        for (int i = 0; i < 4; ++i) {
            this.mEnableStates.add(i, false);
        }
    }

    public void setColumnNames(List<String> list) {
        this.mColumnNames = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.mColumnNames[i] = list.get(i);
        }
    }

    public void clear() {
        this.mSummaryVariables.clear();
        this.fireTableDataChanged();
    }

    public void setEnableRow(int n, boolean bl) {
        this.mEnableStates.set(n, bl);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.mSummaryVariables.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        SummaryVariable summaryVariable = this.mSummaryVariables.get(n);
        if (summaryVariable != null) {
            switch (n2) {
                case 0: {
                    object = summaryVariable.getDescription();
                    break;
                }
                case 1: {
                    object = summaryVariable.isSelected();
                    break;
                }
                case 2: {
                    object = summaryVariable.getName();
                    break;
                }
            }
        }
        return object;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 > 0 ? this.mEnableStates.get(n) : false;
    }

    @Override
    public String getColumnName(int n) {
        return this.mColumnNames[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 > 0) {
            SummaryVariable summaryVariable = this.mSummaryVariables.get(n);
            switch (n2) {
                case 1: {
                    summaryVariable.setSelected((Boolean)object);
                    break;
                }
                case 2: {
                    summaryVariable.setName((String)object);
                    break;
                }
            }
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void addSummaryVariable(SummaryVariable summaryVariable) {
        if (!this.mSummaryVariables.contains(summaryVariable)) {
            this.mSummaryVariables.add(summaryVariable);
            int n = this.mSummaryVariables.size() - 1;
            this.fireTableRowsInserted(n, n);
        }
    }

    public List<SummaryVariable> getSummaryVariables() {
        return this.mSummaryVariables;
    }
}

