/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssMultiLineToggleButtonUtil;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.FrequenciesScanner;
import com.spss.java_client.ui.dialogs.common.IFrequencyScannerListener;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SpssFocusCellRenderer;
import com.spss.java_client.ui.dialogs.common.SpssFocusGenericRenderer;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.AnalysisData;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.AnalysisSPSSVarTableCellRenderer;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.AnalysisVarHistogramTableCellRenderer;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.AnalysisVarValuesTableCellRenderer;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.AnalysisVarsTableModel;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.HistogramData;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.SingleRulesTableModel;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.TableHeaderToolTipDisplay;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.ValidateDataDlg;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.ValidateDataSingleRules;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;

public class SingleVarRulesTab
extends BaseProcedureTab
implements ItemListener,
ActionListener,
TableModelListener,
IFrequencyScannerListener {
    private static final int RULES_TABLE_HEIGHT = 200;
    private static final int RULES_TABLE_WIDTH = 160;
    private static final int ANALYSIS_VARS_TABLE_HEIGHT = 70;
    private static final int ANALYSIS_VARS_TABLE_WIDTH = 320;
    static final long VLD_SVR_CASES_EDIT_DAFAULT = 5000L;
    static final String VLD_SVR_LIMIT_NUMBER_CHECK = "IDS_VLD_SVR_LIMIT_NUMBER";
    static final String VLD_SVR_CASES_EDIT = "IDS_VLD_SVR_CASES_EDIT";
    private static final int DEFAULT_CASES_TO_SCAN = -1;
    static final String SINGLE_VARIABLE_RULES = "SINGLE_VARIABLE_RULES";
    static final String VARIABLE_RULE_MAP = "VARIABLE_RULE_MAP";
    private Map<SingleVariableRule, Map<String, ISpssVariable>> mComputeRulesMap = new TreeMap<SingleVariableRule, Map<String, ISpssVariable>>();
    private Map<SingleVariableRule, Integer> mMapRuleRefs = new HashMap<SingleVariableRule, Integer>();
    private int mRuleNumber;
    private int mVarNumber;
    private StringBuffer mDatafileDeleteSyntax = new StringBuffer();
    private StringBuffer mDatafileAttribSyntax = new StringBuffer();
    private String mComputeSyntax;
    private StringBuffer mDeleteLinksSyntax = new StringBuffer();
    private StringBuffer mVarAttribLinksSyntax = new StringBuffer();
    private StringBuffer mVarLabelsSyntax = new StringBuffer();
    private StringBuffer mListOutVarsSyntax = new StringBuffer();
    private StringBuffer mListDatafileAttribSyntax = new StringBuffer();
    private boolean mNotTemporary;
    private CoreFrequencies mCoreFrequencies = new CoreFrequencies();
    private HistogramData mHistogramData;
    private JCheckBox mLimitCasesCheck;
    private JLabel mNumScannedCasesLabel;
    private JLabel mCasesLabel;
    private ContextEnabledTextField mCasesEdit;
    private JButton mRescanButton;
    private JTable mAnalysisVarsTable;
    private AnalysisVarsTableModel mAnalysisTableModel;
    private JTable mRulesTable;
    private SingleRulesTableModel mRulesTableModel;
    private JComboBox mDisplayCombo;
    private JButton mDefineRulesButton;
    private List<ISpssVariable> mScanVars;
    private boolean mRulesLoaded = false;
    private boolean mLinksLoaded = false;
    private boolean mRulesModified = false;
    private List<String> mSingleVarLoadedOutComeVars;
    private boolean mShowNoRulesMessage = false;
    private JScrollPane mRulesTableScrollPane;

    public SingleVarRulesTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.mAnalysisTableModel.removeAll();
        this.mRulesTableModel.clearAllRules();
        this.mRulesTableModel.fireTableDataChanged();
        this.mAnalysisTableModel.fireTableDataChanged();
        this.mAnalysisTableModel.setRulesTableModel(this.mRulesTableModel);
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_vdtab_standard_rules";
    }

    public void generateSyntax() {
        this.initializeSyntaxData();
        this.generateDatafileAttribSyntax();
        this.mVarNumber = 0;
        List<ISpssVariable> list = this.getParentValidateDataDlg().getVariablesTab().getAnalysisVarsList();
        Map<ISpssVariable, Set<SingleVariableRule>> map = this.mRulesTableModel.getSelectionsMap();
        List<SingleVariableRule> list2 = this.mRulesTableModel.getRules();
        for (ISpssVariable iSpssVariable : list) {
            Set<SingleVariableRule> set = map.get(iSpssVariable);
            if (set == null || set.isEmpty()) continue;
            ++this.mVarNumber;
            this.mRuleNumber = 0;
            for (SingleVariableRule singleVariableRule : list2) {
                if (!set.contains(singleVariableRule)) continue;
                this.addRuleToSyntax(iSpssVariable, singleVariableRule);
            }
        }
        this.generateComputeSyntax();
        if (this.mVarAttribLinksSyntax.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n* ").append(this.getResString("IDS_VLD_SVR_REDEFINE_LINKS_COMMENT")).append(".");
            stringBuffer.append("\nVARIABLE ATTRIBUTE");
            this.mVarAttribLinksSyntax.insert(0, stringBuffer.toString());
            this.mVarAttribLinksSyntax.append(".");
        }
        this.assembleSyntax();
    }

    private ValidateDataDlg getParentValidateDataDlg() {
        return (ValidateDataDlg)this.mParent;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mLimitCasesCheck) {
            this.mCasesLabel.setEnabled(this.mLimitCasesCheck.isSelected());
            this.mCasesEdit.setEnabled(this.mLimitCasesCheck.isSelected());
            this.mCasesEdit.setOpaque(this.mLimitCasesCheck.isSelected());
        } else if (itemEvent.getSource() == this.mDisplayCombo && itemEvent.getStateChange() == 1) {
            AnalysisVarsTableModel.VisibleVars visibleVars = AnalysisVarsTableModel.VisibleVars.eALL;
            switch (this.mDisplayCombo.getSelectedIndex()) {
                case 0: {
                    visibleVars = AnalysisVarsTableModel.VisibleVars.eALL;
                    break;
                }
                case 1: {
                    visibleVars = AnalysisVarsTableModel.VisibleVars.eNUMERIC;
                    break;
                }
                case 2: {
                    visibleVars = AnalysisVarsTableModel.VisibleVars.eSTRING;
                    break;
                }
                case 3: {
                    visibleVars = AnalysisVarsTableModel.VisibleVars.eDATE;
                }
            }
            ListSelectionModel listSelectionModel = this.mAnalysisVarsTable.getSelectionModel();
            listSelectionModel.clearSelection();
            this.mAnalysisTableModel.setVisibleVarType(visibleVars);
            if (this.mAnalysisTableModel.getRowCount() > 0) {
                listSelectionModel.setSelectionInterval(0, 0);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        long l = -1L;
        if (object == this.mRescanButton) {
            if (this.mLimitCasesCheck.isSelected()) {
                if (this.checkScanCasesEditRange()) {
                    l = Long.parseLong(this.mCasesEdit.getText());
                    if (l == Long.MAX_VALUE) {
                        l = -1L;
                    }
                    this.rescan(l);
                }
            } else {
                this.rescan(l);
            }
        }
    }

    public void populateAnalysisVarTableModel() {
        this.mAnalysisTableModel.removeAll();
        VarListModel varListModel = this.getParentValidateDataDlg().getVariablesTab().getAnalysisTargetVarList().getModel();
        int n = varListModel.getSize();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            AnalysisData analysisData = new AnalysisData();
            analysisData.setSpssVariable(iSpssVariable);
            analysisData.setHistogramImage(this.mHistogramData.getHistogramImage(iSpssVariable));
            if (ComponentState.isBtdRtlOrLtr()) {
                analysisData.setMinimum(ComponentState.prepareStringForBidiRendering((String)this.mHistogramData.getMinimum(iSpssVariable)));
                analysisData.setMaximum(ComponentState.prepareStringForBidiRendering((String)this.mHistogramData.getMaximum(iSpssVariable)));
            } else {
                analysisData.setMinimum(this.mHistogramData.getMinimum(iSpssVariable));
                analysisData.setMaximum(this.mHistogramData.getMaximum(iSpssVariable));
            }
            this.mAnalysisTableModel.addAnalysisData(analysisData);
        }
        if (n > 0) {
            this.mAnalysisVarsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void setRules(List<SingleVariableRule> list) {
        this.mRulesLoaded = list.size() > 0;
        for (SingleVariableRule singleVariableRule : list) {
            this.mRulesTableModel.addRule(singleVariableRule);
        }
    }

    public List<SingleVariableRule> getRules() {
        return this.mRulesTableModel.getRules();
    }

    public void setRuleSelections(Map<ISpssVariable, Set<SingleVariableRule>> map) {
        if (map != null) {
            this.mLinksLoaded = map.size() > 0;
        }
        this.mRulesTableModel.setSelectionsMap(map);
    }

    public Map<ISpssVariable, Set<SingleVariableRule>> getRulesSelectionMap() {
        return this.mRulesTableModel.getSelectionsMap();
    }

    public List<String> getSingleVarLoadedOutComeVars() {
        return this.mSingleVarLoadedOutComeVars;
    }

    public void setSingleVarLoadedOutComeVars(List<String> list) {
        this.mSingleVarLoadedOutComeVars = list;
    }

    public boolean isSingleRulesApplied() {
        Map<ISpssVariable, Set<SingleVariableRule>> map = this.mRulesTableModel.getSelectionsMap();
        boolean bl = false;
        List<ISpssVariable> list = this.getParentValidateDataDlg().getVariablesTab().getAnalysisVarsList();
        for (ISpssVariable iSpssVariable : list) {
            Set<SingleVariableRule> set = map.get(iSpssVariable);
            if (set == null || set.size() <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isRulesModified() {
        return this.mRulesModified;
    }

    public void setTemporary(boolean bl) {
        this.mNotTemporary = bl;
    }

    public String getDatafileDeleteSyntax() {
        return this.mDatafileDeleteSyntax.toString();
    }

    public String getDeleteLinksSyntax() {
        return this.mDeleteLinksSyntax.toString();
    }

    public String getDatafileAttribSyntax() {
        return this.mDatafileAttribSyntax.toString();
    }

    public String getVarAttribLinksSyntax() {
        return this.mVarAttribLinksSyntax.toString();
    }

    public String getComputeSyntax() {
        return this.mComputeSyntax;
    }

    public String getOutcomeVarsList() {
        return this.mListOutVarsSyntax.toString();
    }

    public String getVarLabelsSyntax() {
        return this.mVarLabelsSyntax.toString();
    }

    @Override
    public void finishedScanning(CoreFrequencies coreFrequencies) {
        this.mHistogramData.prepareHistoData(this.mScanVars, coreFrequencies);
        this.mRescanButton.setEnabled(true);
        this.populateAnalysisVarTableModel();
        String string = this.mNumScannedCasesLabel.getText();
        int n = string.lastIndexOf(":");
        string = string.substring(0, n + 1) + " " + coreFrequencies.casesPassed();
        this.mNumScannedCasesLabel.setText(string);
        this.mParent.setCursor(null);
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mAnalysisVarsTable;
    }

    @Override
    protected boolean validateTab() {
        boolean bl = super.validateTab();
        if (bl) {
            bl = this.checkScanCasesEditRange();
        }
        return bl;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_VLD_SVR_APPLY_RULES") + "\n\n" + this.getResString("IDS_VLD_SVR_SHOWS"));
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setEditable(false);
        jTextArea.setRows(4);
        int n2 = jTextArea.getPreferredSize().height;
        jTextArea.setMinimumSize(new Dimension(660, n2));
        jTextArea.setPreferredSize(new Dimension(660, n2));
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this, jTextArea, gridBagConstraints, 0, 0, 1, 1, n, insets);
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n3, insets.left, insets.bottom, insets.right);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.setupTablePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.setupDisplayPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets2 = new Insets(n3, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, this.setupDistributionsPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets2);
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        VarListModel varListModel = this.getParentValidateDataDlg().getVariablesTab().getAnalysisTargetVarList().getModel();
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        int n = varListModel.getSize();
        for (int i = 0; i < n; ++i) {
            arrayList.add(varListModel.getElementAt(i));
        }
        List<ISpssVariable> list = this.mAnalysisTableModel.getSPSSVars();
        for (ISpssVariable iSpssVariable : list) {
            if (arrayList.contains(iSpssVariable)) continue;
            this.mAnalysisTableModel.removeAnalysisData(iSpssVariable);
        }
        this.mScanVars.clear();
        for (ISpssVariable iSpssVariable : arrayList) {
            if (!this.mHistogramData.needScan(iSpssVariable)) continue;
            this.mScanVars.add(iSpssVariable);
        }
        if (!this.mScanVars.isEmpty()) {
            this.doScan(5000L);
        } else {
            this.populateAnalysisVarTableModel();
        }
        this.mShowNoRulesMessage = this.checkShowNoRulesMessage();
    }

    private boolean checkShowNoRulesMessage() {
        int[] nArray = this.mAnalysisVarsTable.getSelectedRows();
        TableModel tableModel = this.mAnalysisVarsTable.getModel();
        HashSet<SingleVariableRule.Type> hashSet = new HashSet<SingleVariableRule.Type>();
        for (int n : nArray) {
            ISpssVariable iSpssVariable = (ISpssVariable)tableModel.getValueAt(n, 0);
            if (iSpssVariable.getType() > 0) {
                hashSet.add(SingleVariableRule.Type.eSTRING);
                continue;
            }
            hashSet.add(iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat() ? SingleVariableRule.Type.eDATE : SingleVariableRule.Type.eNUMERIC);
        }
        return hashSet.size() > 1;
    }

    private boolean checkScanCasesEditRange() {
        long l = -1L;
        try {
            String string = this.mCasesEdit.getText();
            if (string != null && string.length() > 0) {
                l = Long.parseLong(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            l = Long.MAX_VALUE;
            this.mCasesEdit.setText(String.valueOf(l));
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_VLD_SVR_ENTER_VALID_CASES_RANGE"), VersionInfo.getAppVersionString());
        }
        boolean bl = true;
        if (l < 1L) {
            bl = false;
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_VLD_SVR_ENTER_POSITIVE"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SingleVarRulesTab.this.mCasesEdit.requestFocus();
                }
            });
        }
        return bl;
    }

    private void initializeSyntaxData() {
        this.mDatafileAttribSyntax.setLength(0);
        this.mDatafileDeleteSyntax.setLength(0);
        this.mVarAttribLinksSyntax.setLength(0);
        this.mVarLabelsSyntax.setLength(0);
        this.mListOutVarsSyntax.setLength(0);
    }

    private void assembleSyntax() {
        if (this.mRulesLoaded) {
            this.mDatafileDeleteSyntax.append("\n* ").append(this.getResString("IDS_VLD_SVR_DELETE_SINGLE_VAR_RULES_COMMENT")).append(".");
            this.mDatafileDeleteSyntax.append("\n").append(SyntaxUtil.getMainCommand("DATAFILE ATTRIBUTE"));
            this.mDatafileDeleteSyntax.append(SyntaxUtil.getMainCommandParamters("DELETE=$VD.SRule."));
        } else {
            this.mDatafileDeleteSyntax.setLength(0);
        }
        if (this.mLinksLoaded) {
            this.mDeleteLinksSyntax.append("\n* ").append(this.getResString("IDS_VLD_SVR_DELETE_EXISTING_LINKS")).append(".");
            this.mDeleteLinksSyntax.append("\n").append(SyntaxUtil.getMainCommand("VARIABLE ATTRIBUTE"));
            this.mDeleteLinksSyntax.append(SyntaxUtil.getMainCommandParamters("VARIABLES=ALL DELETE=$VD.SRuleRef."));
        } else {
            this.mDeleteLinksSyntax.setLength(0);
        }
        if (this.mListDatafileAttribSyntax.length() > 0) {
            this.mDatafileAttribSyntax.append("\n* ").append(this.getResString("IDS_VLD_SVR_REDIFINE_SINGLE_RULES_COMMENT")).append(".");
            this.mDatafileAttribSyntax.append("\n").append(SyntaxUtil.getMainCommand("DATAFILE ATTRIBUTE"));
            this.mDatafileAttribSyntax.append(SyntaxUtil.getMainCommandParamters("ATTRIBUTE="));
            this.mDatafileAttribSyntax.append(this.mListDatafileAttribSyntax);
            this.mDatafileAttribSyntax.append(".");
        }
    }

    private void generateComputeSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        Set<SingleVariableRule> set = this.mComputeRulesMap.keySet();
        for (SingleVariableRule singleVariableRule : set) {
            ISpssVariable iSpssVariable;
            Set<String> set2;
            Map<String, ISpssVariable> map = this.mComputeRulesMap.get(singleVariableRule);
            if (map == null) continue;
            if (map.size() > 3) {
                stringBuffer.append("\n* ").append(singleVariableRule.getName()).append(".");
                stringBuffer2.setLength(0);
                stringBuffer3.setLength(0);
                set2 = map.keySet();
                for (String string : set2) {
                    iSpssVariable = map.get(string);
                    stringBuffer2.append(" ").append(string);
                    stringBuffer3.append(" ").append(iSpssVariable.getName());
                }
                stringBuffer.append("\n").append(SyntaxUtil.getMainCommand("DO REPEAT"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("#OV="));
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append("\n  /#IV=");
                stringBuffer.append(stringBuffer3.toString());
                stringBuffer.append(SyntaxUtil.terminateSyntax());
                stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("#OV="));
                stringBuffer.append(this.getComputeExpression(singleVariableRule, "#IV"));
                stringBuffer.append(SyntaxUtil.terminateSyntax().toString()).append(SyntaxUtil.getMainCommand("END REPEAT."));
                this.addToListOutVars(stringBuffer2.toString());
                continue;
            }
            if (map.size() <= 0) continue;
            stringBuffer.append("\n* ").append(singleVariableRule.getName()).append(".");
            set2 = map.keySet();
            for (String string : set2) {
                iSpssVariable = map.get(string);
                stringBuffer.append("\n").append(SyntaxUtil.getMainCommand("COMPUTE"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
                stringBuffer.append("=");
                stringBuffer.append(this.getComputeExpression(singleVariableRule, iSpssVariable.getName()));
                stringBuffer.append(".");
                this.addToListOutVars(string);
            }
        }
        this.mComputeSyntax = stringBuffer.toString();
    }

    private void addToListOutVars(String string) {
        if (this.mListOutVarsSyntax.length() > 0) {
            this.mListOutVarsSyntax.append(" ");
        }
        this.mListOutVarsSyntax.append(string);
    }

    private void addRuleToSyntax(ISpssVariable iSpssVariable, SingleVariableRule singleVariableRule) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        String string = this.getParentValidateDataDlg().generateSPSSName(singleVariableRule.getName() + "_" + iSpssVariable.getName());
        ++this.mRuleNumber;
        int n = this.mMapRuleRefs.get(singleVariableRule);
        String string2 = "$VD.SRuleRef[" + this.mRuleNumber + "]";
        if (this.mRuleNumber == 1) {
            this.mVarAttribLinksSyntax.append("\n    ");
            if (this.mVarNumber > 1) {
                this.mVarAttribLinksSyntax.append("/");
            }
            this.mVarAttribLinksSyntax.append("VARIABLES=");
            this.mVarAttribLinksSyntax.append(iSpssVariable.getName());
            this.mVarAttribLinksSyntax.append(" ATTRIBUTE=");
        }
        this.mVarAttribLinksSyntax.append("\n      ");
        this.mVarAttribLinksSyntax.append(string2);
        this.mVarAttribLinksSyntax.append("(\"Rule=");
        this.mVarAttribLinksSyntax.append("'$VD.SRule[" + n + "]'");
        this.mVarAttribLinksSyntax.append(",OutcomeVar=");
        this.mVarAttribLinksSyntax.append(CharacterUtil.smartQuote((String)string));
        this.mVarAttribLinksSyntax.append("\")");
        Map<String, ISpssVariable> map = this.mComputeRulesMap.get(singleVariableRule);
        if (map != null) {
            map.put(string, iSpssVariable);
        } else {
            map = new HashMap<String, ISpssVariable>();
            map.put(string, iSpssVariable);
            this.mComputeRulesMap.put(singleVariableRule, map);
        }
        if (this.mNotTemporary) {
            this.mVarLabelsSyntax.append("\n").append(SyntaxUtil.getMainCommand("VARIABLE LABELS"));
            this.mVarLabelsSyntax.append(SyntaxUtil.getMainCommandParamters(string));
            this.mVarLabelsSyntax.append("  ");
            this.mVarLabelsSyntax.append(CharacterUtil.smartQuote((String)(singleVariableRule.getName() + ":" + iSpssVariable.getLabel())));
            this.mVarLabelsSyntax.append(".");
        }
    }

    private void generateDatafileAttribSyntax() {
        boolean bl = true;
        this.mMapRuleRefs.clear();
        List<SingleVariableRule> list = this.mRulesTableModel.getRules();
        this.mListDatafileAttribSyntax.setLength(0);
        int n = 1;
        for (SingleVariableRule singleVariableRule : list) {
            boolean bl2;
            this.mMapRuleRefs.put(singleVariableRule, n);
            this.mListDatafileAttribSyntax.append("\n   $VD.SRule[").append(n).append("](\"Label=").append(CharacterUtil.smartQuote((String)singleVariableRule.getName()));
            this.mListDatafileAttribSyntax.append(", Type='");
            if (singleVariableRule.getType() == SingleVariableRule.Type.eNUMERIC) {
                this.mListDatafileAttribSyntax.append("Numeric'");
            } else if (singleVariableRule.getType() == SingleVariableRule.Type.eSTRING) {
                this.mListDatafileAttribSyntax.append("String'");
            } else {
                this.mListDatafileAttribSyntax.append("Date', Format=").append(CharacterUtil.smartQuote((String)singleVariableRule.getDateFormat().getFormat()));
            }
            this.mListDatafileAttribSyntax.append(", Domain=");
            boolean bl3 = bl2 = singleVariableRule.getCurrentValidValues() == SingleVariableRule.ValidValues.eWITHIN_RANGE;
            if (bl2) {
                this.mListDatafileAttribSyntax.append(CharacterUtil.smartQuote((String)"Range")).append(", Minimum=");
                this.mListDatafileAttribSyntax.append(CharacterUtil.smartQuote((String)singleVariableRule.getMinimumValue())).append(", Maximum='").append(singleVariableRule.getMaximumValue()).append("'");
            } else {
                this.mListDatafileAttribSyntax.append(CharacterUtil.smartQuote((String)"List"));
            }
            this.mListDatafileAttribSyntax.append(", FlagUserMissing='");
            if (singleVariableRule.isFlagUserMissingValues()) {
                this.mListDatafileAttribSyntax.append("Yes");
            } else {
                this.mListDatafileAttribSyntax.append("No");
            }
            this.mListDatafileAttribSyntax.append("', FlagSystemMissing='");
            if (singleVariableRule.isFlagSystemMissingValues() && singleVariableRule.getType() != SingleVariableRule.Type.eSTRING) {
                this.mListDatafileAttribSyntax.append("Yes");
            } else {
                this.mListDatafileAttribSyntax.append("No");
            }
            this.mListDatafileAttribSyntax.append("', FlagBlank='");
            if (singleVariableRule.isFlagBlankValues() && singleVariableRule.getType() == SingleVariableRule.Type.eSTRING) {
                this.mListDatafileAttribSyntax.append("Yes");
            } else {
                this.mListDatafileAttribSyntax.append("No");
            }
            this.mListDatafileAttribSyntax.append("', ");
            if (bl2) {
                this.mListDatafileAttribSyntax.append("FlagNoninteger='");
                if (singleVariableRule.isFlagNonIntegerValues() && singleVariableRule.getType() == SingleVariableRule.Type.eNUMERIC) {
                    this.mListDatafileAttribSyntax.append("Yes");
                } else {
                    this.mListDatafileAttribSyntax.append("No");
                }
                this.mListDatafileAttribSyntax.append("', FlagUnlabeled='");
                if (singleVariableRule.isFlagUnlabeledValues()) {
                    this.mListDatafileAttribSyntax.append("Yes");
                } else {
                    this.mListDatafileAttribSyntax.append("No");
                }
                this.mListDatafileAttribSyntax.append("'");
            } else {
                this.mListDatafileAttribSyntax.append("CaseSensitive='");
                if (singleVariableRule.isCaseSensitive() && singleVariableRule.getType() == SingleVariableRule.Type.eSTRING) {
                    this.mListDatafileAttribSyntax.append("Yes");
                } else {
                    this.mListDatafileAttribSyntax.append("No");
                }
                this.mListDatafileAttribSyntax.append("',List=");
                for (String string : singleVariableRule.getValues()) {
                    this.mListDatafileAttribSyntax.append(CharacterUtil.smartQuote((String)string)).append(" ");
                    bl = false;
                }
                if (bl) {
                    this.mListDatafileAttribSyntax.append("'");
                }
            }
            this.mListDatafileAttribSyntax.append(" \")");
            ++n;
        }
    }

    private String getComputeExpression(SingleVariableRule singleVariableRule, String string) {
        String string2 = singleVariableRule.getType() == SingleVariableRule.Type.eSTRING ? this.getStringExpression(singleVariableRule, string) : (singleVariableRule.getType() == SingleVariableRule.Type.eDATE ? this.getDateExpression(singleVariableRule, string) : (singleVariableRule.getType() == SingleVariableRule.Type.eNUMERIC ? this.getNumericExpression(singleVariableRule, string) : string));
        return string2;
    }

    private String getNumericExpression(SingleVariableRule singleVariableRule, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        StringBuffer stringBuffer = new StringBuffer();
        if (singleVariableRule.getCurrentValidValues() == SingleVariableRule.ValidValues.eWITHIN_RANGE) {
            String string6 = singleVariableRule.getMinimumValue();
            if (string6 != null && string6.length() > 0) {
                string2 = "VALUE(" + string + ")>=" + string6;
            }
            if ((string6 = singleVariableRule.getMaximumValue()) != null && string6.length() > 0) {
                string3 = "VALUE(" + string + ")<=" + string6;
            }
            if (singleVariableRule.isFlagUnlabeledValues()) {
                string4 = "NOT(VALUELABEL(" + string + ")='')";
            }
            if (singleVariableRule.isFlagNonIntegerValues()) {
                string5 = "VALUE(" + string + ")=TRUNC(VALUE(" + string + "))";
            }
            if (string2.length() > 0) {
                stringBuffer.append(string2);
            }
            if (string3.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string3);
            }
            if (string4.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string4);
            }
            if (string5.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string5);
            }
        } else {
            StringBuffer stringBuffer2 = new StringBuffer();
            List<String> list = singleVariableRule.getValues();
            for (String string7 : list) {
                stringBuffer2.append(",").append(string7);
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append("ANY(VALUE(").append(string).append(")").append(stringBuffer2.toString()).append(")");
            }
        }
        return this.getNumMissingClause(singleVariableRule, string, stringBuffer.toString());
    }

    private String getDateExpression(SingleVariableRule singleVariableRule, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        StringBuffer stringBuffer = new StringBuffer();
        if (singleVariableRule.getCurrentValidValues() == SingleVariableRule.ValidValues.eWITHIN_RANGE) {
            String string5 = singleVariableRule.getMinimumValue();
            if (string5 != null && string5.length() > 0) {
                string2 = "VALUE(" + string + ")>=" + this.getNumberExpression(string5, singleVariableRule.getDateFormat().getFormat());
            }
            if ((string5 = singleVariableRule.getMaximumValue()) != null && string5.length() > 0) {
                string3 = "VALUE(" + string + ")<=" + this.getNumberExpression(string5, singleVariableRule.getDateFormat().getFormat());
            }
            if (singleVariableRule.isFlagUnlabeledValues()) {
                string4 = "NOT(VALUELABEL(" + string + ")='')";
            }
            if (string2.length() > 0) {
                stringBuffer.append(string2);
            }
            if (string3.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string3);
            }
            if (string4.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string4);
            }
        } else {
            StringBuffer stringBuffer2 = new StringBuffer();
            List<String> list = singleVariableRule.getValues();
            for (String string6 : list) {
                stringBuffer2.append(",").append(this.getNumberExpression(string6, singleVariableRule.getDateFormat().getFormat()));
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append("ANY(VALUE(").append(string).append(")");
                stringBuffer.append(stringBuffer2.toString()).append(")");
            }
        }
        return this.getNumMissingClause(singleVariableRule, string, stringBuffer.toString());
    }

    private String getNumMissingClause(SingleVariableRule singleVariableRule, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = singleVariableRule.isFlagUserMissingValues();
        boolean bl2 = singleVariableRule.isFlagSystemMissingValues();
        if (!bl && !bl2) {
            if (string2.length() <= 0) {
                stringBuffer.append("");
            } else {
                stringBuffer.append("NOT(").append(string2).append(" OR MISSING(").append(string).append("))");
            }
        } else if (bl && bl2) {
            if (string2.length() <= 0) {
                stringBuffer.append("MISSING(").append(string).append(")");
            } else {
                stringBuffer.append("NOT(").append(string2);
                stringBuffer.append(" AND NOT(MISSING(").append(string).append(")))");
            }
        } else if (bl && !bl2) {
            String string3 = "SYSMIS(" + string + ")";
            String string4 = "MISSING(" + string + ") AND NOT(SYSMIS(" + string + "))";
            if (string2.length() <= 0) {
                stringBuffer.append(string4);
            } else {
                stringBuffer.append("NOT(").append(string2).append(" OR ").append(string3).append(")");
                stringBuffer.append("OR (").append(string4).append(")");
            }
        } else {
            String string5 = "(MISSING(" + string + ") AND NOT(SYSMIS(" + string + ")))";
            if (string2.length() <= 0) {
                stringBuffer.append("SYSMIS(").append(string).append(")");
            } else {
                stringBuffer.append("NOT(").append(string2).append(" OR ").append(string5).append(")");
                stringBuffer.append(" OR SYSMIS(").append(string).append(")");
            }
        }
        return stringBuffer.toString();
    }

    private String getStringExpression(SingleVariableRule singleVariableRule, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        StringBuffer stringBuffer = new StringBuffer();
        if (singleVariableRule.getCurrentValidValues() == SingleVariableRule.ValidValues.eWITHIN_RANGE) {
            String string5 = singleVariableRule.getMinimumValue();
            if (string5 != null && string5.length() > 0) {
                if (singleVariableRule.getType() == SingleVariableRule.Type.eSTRING) {
                    string5 = CharacterUtil.smartQuote((String)string5);
                }
                string3 = string + ">=" + string5;
            }
            if ((string5 = singleVariableRule.getMaximumValue()) != null && string5.length() > 0) {
                if (singleVariableRule.getType() == SingleVariableRule.Type.eSTRING) {
                    string5 = CharacterUtil.smartQuote((String)string5);
                }
                string2 = string + "<=" + string5;
            }
            if (singleVariableRule.isFlagUnlabeledValues()) {
                string4 = "NOT(VALUELABEL(" + string + ")='')";
            }
            if (string3.length() > 0) {
                stringBuffer.append(string3);
            }
            if (string2.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string2);
            }
            if (string4.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string4);
            }
        } else {
            boolean bl = singleVariableRule.isCaseSensitive();
            StringBuffer stringBuffer2 = new StringBuffer();
            List<String> list = singleVariableRule.getValues();
            for (String string6 : list) {
                stringBuffer2.append(",").append(CharacterUtil.smartQuote((String)string6));
            }
            if (stringBuffer2.length() > 0) {
                if (bl) {
                    stringBuffer.append("ANY(").append(string).append(stringBuffer2.toString()).append(")");
                } else {
                    stringBuffer.append("ANY(LOWER(").append(string).append(")").append(stringBuffer2.toString().toLowerCase()).append(")");
                }
            }
        }
        return this.getStringMissingClause(singleVariableRule, string, stringBuffer.toString());
    }

    private String getStringMissingClause(SingleVariableRule singleVariableRule, String string, String string2) {
        String string3 = "MISSING(" + string + ")";
        String string4 = string + "=''";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = singleVariableRule.isFlagUserMissingValues();
        boolean bl2 = singleVariableRule.isFlagBlankValues();
        if (string2.length() > 0) {
            if (bl && bl2) {
                stringBuffer.append("NOT(").append(string2).append(")");
                stringBuffer.append(" OR ").append(string3);
                stringBuffer.append(" OR ").append(string4);
            } else if (!bl && !bl2) {
                stringBuffer.append("NOT(").append(string2).append(" OR ").append(string3).append(" OR ").append(string4).append(")");
            } else if (!bl && bl2) {
                stringBuffer.append("NOT(").append(string2).append(" OR ").append(string3).append(")");
                stringBuffer.append(" OR ").append(string4);
            } else {
                stringBuffer.append("NOT(").append(string2).append(" OR ").append(string4).append(")");
                stringBuffer.append(" OR ").append(string3);
            }
        } else if (bl && bl2) {
            stringBuffer.append(string3).append(" OR ").append(string4);
        } else if (!bl && !bl2) {
            stringBuffer.setLength(0);
        } else if (bl) {
            stringBuffer.append(string4);
        } else {
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private String getNumberExpression(String string, String string2) {
        return "NUMBER('" + string + "'," + string2 + ")";
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.mShowNoRulesMessage = this.mRulesTable.getRowCount() == 0 && this.checkShowNoRulesMessage();
        this.mRulesTableScrollPane.repaint();
    }

    private JPanel setupDisplayPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_VLD_SVR_DISPLAY_COLON");
        jLabel.setLabelFor(this.mDisplayCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 21;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, n2 * 3, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mNumScannedCasesLabel, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        n = 26;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDefineRulesButton, gridBagConstraints, 3, 0, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupDistributionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_VLD_SVR_VAR_DISTRIBUTIONS")));
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_VLD_SVR_LIMIT_SCANNED"));
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setFont(this.mCasesLabel.getFont());
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setEditable(false);
        jTextArea.setRows(2);
        int n = jTextArea.getPreferredSize().height;
        jTextArea.setMinimumSize(new Dimension(320, n));
        jTextArea.setPreferredSize(new Dimension(320, n));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = 10;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mLimitCasesCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, n3, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCasesLabel, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCasesEdit, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRescanButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n2 = 21;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 4, 0, 1, 2, n2, insets2);
        return jPanel;
    }

    private JPanel setupTablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_VLD_SVR_ANALYSIS_VARS_COLON");
        jLabel.setLabelFor(this.mAnalysisVarsTable);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mAnalysisVarsTable);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 2, 1, n, null);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_VLD_SVR_RULES_COLON");
        jLabel2.setLabelFor(this.mRulesTable);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mRulesTableScrollPane = new JScrollPane(this.mRulesTable){

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (SingleVarRulesTab.this.mShowNoRulesMessage) {
                    int n = 1;
                    int n2 = 20;
                    int n3 = 40;
                    Font font = graphics.getFont();
                    graphics.setFont(SingleVarRulesTab.this.mAnalysisVarsTable.getFont());
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    String string = SingleVarRulesTab.this.getResString("IDS_VLD_SVR_NO_RULES_SHOWN");
                    int n4 = fontMetrics.stringWidth(string);
                    int n5 = SingleVarRulesTab.this.mRulesTableScrollPane.getWidth() - 30;
                    if (n4 > n5) {
                        String string2;
                        int n6;
                        while ((n6 = fontMetrics.stringWidth(string2 = SpssMultiLineToggleButtonUtil.clipStringIfNecessary(fontMetrics, string, n5))) < n4) {
                            String string3;
                            int n7 = string2.lastIndexOf(" ");
                            if (n7 == -1) {
                                n7 = string.lastIndexOf(" ");
                            }
                            if (n7 > -1) {
                                string3 = string.substring(0, n7);
                                string = string.substring(n7 + 1);
                            } else {
                                int n8 = string2.length() - 3;
                                string3 = string2.substring(0, n8);
                                string = string.substring(n8);
                            }
                            n4 = fontMetrics.stringWidth(string);
                            graphics.drawString(string3, n2, n3 + n * fontMetrics.getHeight());
                            ++n;
                        }
                        graphics.drawString(string, n2, n3 + n * fontMetrics.getHeight());
                    } else {
                        graphics.drawString(string, n2, n3 + n * fontMetrics.getHeight());
                    }
                    graphics.setFont(font);
                    this.repaint();
                }
            }
        };
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mRulesTableScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this.mParent, VLD_SVR_LIMIT_NUMBER_CHECK);
        this.mLimitCasesCheck = new JCheckBox(controlAction);
        controlAction = new TextFieldAction(this.mParent, VLD_SVR_CASES_EDIT);
        this.mCasesEdit = new ContextEnabledTextField();
        this.mCasesEdit.setDocument((Document)new FixedLengthNumericDocument(25, true, false));
        this.mCasesEdit.setAction((Action)controlAction);
        this.mCasesEdit.setColumns(5);
        this.mNumScannedCasesLabel = DialogUtil.createLabel(this.mParent, "IDS_VLD_SVR_CASES_SCANNED");
        this.mCasesLabel = DialogUtil.createLabel(this.mParent, "IDS_VLD_SVR_CASES_COLON");
        this.mCasesLabel.setLabelFor((Component)this.mCasesEdit);
        controlAction = new ToggleButtonAction(this.mParent, "IDS_VLD_SVR_RESCAN");
        this.mRescanButton = new JButton(controlAction);
        this.mLimitCasesCheck.addItemListener(this);
        String[] stringArray = this.mParent.getResStringArray("IDS_VLD_SVR_DISPLAY_COMBO_VALUES");
        this.mDisplayCombo = new JComboBox<String>(stringArray);
        controlAction = new ToggleButtonAction(this.mParent, "IDS_VLD_SVR_DEFINE_RULES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleVarRulesTab.this.runDefineSingleRulesSubDialog();
            }
        };
        this.mDefineRulesButton = new JButton(controlAction);
        this.mScanVars = new ArrayList<ISpssVariable>();
        this.mHistogramData = new HistogramData();
        this.setupTable();
        this.mLimitCasesCheck.addItemListener(this);
        this.mRescanButton.addActionListener(this);
        this.mDisplayCombo.addItemListener(this);
        this.setDefaults();
        this.addToComponentOrder(this.mAnalysisVarsTable);
        this.addToComponentOrder(this.mDisplayCombo);
        this.addToComponentOrder(this.mRulesTable);
        this.addToComponentOrder(this.mDefineRulesButton);
        this.addToComponentOrder(this.mLimitCasesCheck);
        this.addToComponentOrder(this.mCasesEdit);
        this.addToComponentOrder(this.mRescanButton);
        this.mAnalysisVarsTable.setFocusable(true);
        this.mRulesTable.setFocusable(true);
        this.mAnalysisVarsTable.setFocusTraversalKeys(0, null);
        this.mRulesTable.setFocusTraversalKeys(0, null);
    }

    private void setupTableForFocusRepainting(final JTable jTable) {
        SpssFocusCellRenderer spssFocusCellRenderer = new SpssFocusCellRenderer();
        jTable.setDefaultRenderer(Object.class, spssFocusCellRenderer);
        jTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jTable.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                jTable.repaint();
            }
        });
    }

    private void setupTable() {
        this.mAnalysisTableModel = new AnalysisVarsTableModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getResString("IDS_VLD_SVR_HEADER_VARIABLE"));
        arrayList.add(this.getResString("IDS_VLD_SVR_HEADER_DISTRIBUTION"));
        arrayList.add(this.getResString("IDS_VLD_SVR_HEADER_MINIMUM"));
        arrayList.add(this.getResString("IDS_VLD_SVR_HEADER_MAXIMUM"));
        arrayList.add(this.getResString("IDS_VLD_SVR_HEADER_RULES"));
        this.mAnalysisTableModel.setColumnNames(arrayList);
        this.mAnalysisVarsTable = new JTable(this.mAnalysisTableModel);
        this.setupTableForFocusRepainting(this.mAnalysisVarsTable);
        AnalysisSPSSVarTableCellRenderer analysisSPSSVarTableCellRenderer = new AnalysisSPSSVarTableCellRenderer((ValidateDataDlg)this.mParent);
        this.mAnalysisVarsTable.setDefaultRenderer(SpssVariable.class, analysisSPSSVarTableCellRenderer);
        AnalysisVarHistogramTableCellRenderer analysisVarHistogramTableCellRenderer = new AnalysisVarHistogramTableCellRenderer();
        this.mAnalysisVarsTable.getColumnModel().getColumn(1).setCellRenderer(analysisVarHistogramTableCellRenderer);
        AnalysisVarValuesTableCellRenderer analysisVarValuesTableCellRenderer = new AnalysisVarValuesTableCellRenderer();
        this.mAnalysisVarsTable.getColumnModel().getColumn(2).setCellRenderer(analysisVarValuesTableCellRenderer);
        this.mAnalysisVarsTable.getColumnModel().getColumn(3).setCellRenderer(analysisVarValuesTableCellRenderer);
        this.mAnalysisVarsTable.getColumnModel().getColumn(4).setCellRenderer(analysisVarValuesTableCellRenderer);
        this.mAnalysisVarsTable.getTableHeader().setFont(this.mAnalysisVarsTable.getFont().deriveFont(1));
        this.mAnalysisVarsTable.setShowGrid(false);
        this.mAnalysisVarsTable.setAutoResizeMode(0);
        JTableHeader jTableHeader = this.mAnalysisVarsTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        ((DefaultTableCellRenderer)jTableHeader.getDefaultRenderer()).setHorizontalAlignment(2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = this.getResString("IDS_VLD_SVR_HEADER_APPLY");
        String string2 = this.getResString("IDS_VLD_SVR_HEADER_NAME");
        arrayList2.add("<HTML><B>" + string + "</B></HTML>");
        arrayList2.add("<HTML><B>" + string2 + "</B></HTML>");
        this.mRulesTableModel = new SingleRulesTableModel(this.mAnalysisVarsTable);
        this.mRulesTableModel.setColumnNames(arrayList2);
        this.mRulesTable = new JTable(this.mRulesTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Object object;
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent && (object = this.getValueAt(n, n2)) instanceof String) {
                    ((JComponent)component).setToolTipText((String)object);
                }
                return component;
            }
        };
        this.setupTableForFocusRepainting(this.mRulesTable);
        this.mRulesTable.getColumnModel().getColumn(0).setCellRenderer(new SpssFocusGenericRenderer(this.mRulesTable.getDefaultRenderer(Boolean.class)));
        JTableHeader jTableHeader2 = this.mRulesTable.getTableHeader();
        ((DefaultTableCellRenderer)jTableHeader2.getDefaultRenderer()).setHorizontalAlignment(2);
        TableColumnModel tableColumnModel = jTableHeader2.getColumnModel();
        TableHeaderToolTipDisplay tableHeaderToolTipDisplay = new TableHeaderToolTipDisplay();
        tableHeaderToolTipDisplay.addToolTip(tableColumnModel.getColumn(0), string);
        tableHeaderToolTipDisplay.addToolTip(tableColumnModel.getColumn(1), string2);
        jTableHeader2.addMouseMotionListener(tableHeaderToolTipDisplay);
        this.mAnalysisTableModel.setRulesTableModel(this.mRulesTableModel);
        this.setupColumnWidths();
        this.mAnalysisVarsTable.setPreferredScrollableViewportSize(new Dimension(320, 70));
        this.mRulesTable.setPreferredScrollableViewportSize(new Dimension(160, 200));
        this.mRulesTableModel.addTableModelListener(this);
    }

    private void setupColumnWidths() {
        Serializable serializable;
        TableColumnModel tableColumnModel = this.mRulesTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.mRulesTable.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.mRulesTable, tableColumn.getHeaderValue(), false, false, 0, 0);
        int n = component.getPreferredSize().width;
        tableColumn.setPreferredWidth(n);
        tableColumnModel.getColumn(1).setPreferredWidth(160 - n);
        TableColumnModel tableColumnModel2 = this.mAnalysisVarsTable.getColumnModel();
        int n2 = 0;
        for (int i = 2; i < 5; ++i) {
            serializable = tableColumnModel2.getColumn(i);
            Component component2 = tableCellRenderer.getTableCellRendererComponent(this.mAnalysisVarsTable, ((TableColumn)serializable).getHeaderValue(), false, false, 0, 0);
            int n3 = component2.getPreferredSize().width;
            n2 += n3;
            ((TableColumn)serializable).setPreferredWidth(n3 + 15);
        }
        TableColumn tableColumn2 = tableColumnModel2.getColumn(1);
        serializable = tableCellRenderer.getTableCellRendererComponent(this.mAnalysisVarsTable, tableColumn2.getHeaderValue(), false, false, 0, 0);
        int n4 = Math.max(((Component)serializable).getPreferredSize().width, 70);
        tableColumn2.setPreferredWidth(n4 + 30);
        tableColumnModel2.getColumn(0).setPreferredWidth(320 - (n2 += n4));
    }

    private void setDefaults() {
        this.mLimitCasesCheck.setSelected(true);
        this.mCasesEdit.setText(Long.toString(5000L));
        this.mDisplayCombo.setSelectedIndex(0);
        this.mCasesLabel.setText(this.getResString("IDS_VLD_SVR_CASES_COLON"));
    }

    private void rescan(long l) {
        VarListModel varListModel = this.getParentValidateDataDlg().getVariablesTab().getAnalysisTargetVarList().getModel();
        int n = varListModel.getSize();
        this.mScanVars.clear();
        for (int i = 0; i < n; ++i) {
            this.mScanVars.add(varListModel.getElementAt(i));
        }
        if (!this.mScanVars.isEmpty()) {
            this.doScan(l);
        }
    }

    private void doScan(long l) {
        FrequenciesThread frequenciesThread = new FrequenciesThread(l);
        frequenciesThread.start();
        FrequenciesScanner frequenciesScanner = new FrequenciesScanner(this.mCoreFrequencies, SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), this.getResString("IDS_VLD_CAPTION"));
        frequenciesScanner.registerScannerListener(this);
        frequenciesScanner.startScanning();
    }

    private void runDefineSingleRulesSubDialog() {
        List<SingleVariableRule> list = this.mRulesTableModel.getRules();
        DialogDataModel dialogDataModel = this.getParentValidateDataDlg().getDialogDataModel();
        Object[] objectArray = list.toArray(new SerializableObject[list.size()]);
        dialogDataModel.putSerializableArray(SINGLE_VARIABLE_RULES, (SerializableObject[])objectArray);
        dialogDataModel.putObject(VARIABLE_RULE_MAP, this.mRulesTableModel.getSelectionsMap());
        this.getParentValidateDataDlg().runSubDialog(new ValidateDataSingleRules((BaseProcedureDialog)this.mParent));
        Object[] objectArray2 = dialogDataModel.getSerializableArray(SINGLE_VARIABLE_RULES);
        ArrayList<SingleVariableRule> arrayList = new ArrayList<SingleVariableRule>();
        if (Arrays.equals(objectArray, objectArray2)) {
            this.mShowNoRulesMessage = false;
        }
        for (Object object2 : objectArray2) {
            arrayList.add((SingleVariableRule)object2);
        }
        List<SingleVariableRule> list2 = this.mRulesTableModel.getRules();
        ArrayList<SingleVariableRule> arrayList2 = new ArrayList<SingleVariableRule>();
        Object object = list2.iterator();
        while (object.hasNext()) {
            Object object2;
            object2 = (SingleVariableRule)object.next();
            if (arrayList.contains(object2)) continue;
            arrayList2.add((SingleVariableRule)object2);
        }
        this.mRulesTableModel.deleteRules(arrayList2);
        this.mRulesTableModel.addRules(arrayList);
        if (!this.mRulesModified) {
            object = this.getParentValidateDataDlg().getDialogDataModel().getBoolean(ValidateDataSingleRules.SINGLE_RULES_ADDED_UPDATED);
            this.mRulesModified = object != null && ((Boolean)object).booleanValue();
        }
    }

    class FrequenciesThread
    extends Thread {
        private long mMaxCases;

        public FrequenciesThread(long l) {
            this.mMaxCases = l;
        }

        @Override
        public void run() {
            super.run();
            DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
            LocallyUniqueId locallyUniqueId = dataFrame.getDatasetId();
            Vector<LocallyUniqueId> vector = new Vector<LocallyUniqueId>();
            for (ISpssVariable iSpssVariable : SingleVarRulesTab.this.mScanVars) {
                vector.add(iSpssVariable.getId());
            }
            int n = 500;
            SingleVarRulesTab.this.mCoreFrequencies.wantWeighted(true);
            SingleVarRulesTab.this.mCoreFrequencies.run(locallyUniqueId, vector, n, this.mMaxCases);
        }
    }
}

