/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class SingleRulesTableModel
extends AbstractTableModel
implements ListSelectionListener,
TableModelListener {
    static final int APPLY_COL = 0;
    static final int NAME_COL = 1;
    static final int NUM_COLS = 2;
    private String[] mColumnNames;
    private List<SingleVariableRule> mUniversalRules = new ArrayList<SingleVariableRule>();
    private List<SingleVariableRule> mCurrentRules = new ArrayList<SingleVariableRule>();
    private Map<ISpssVariable, Set<SingleVariableRule>> mSelectionsMap = new HashMap<ISpssVariable, Set<SingleVariableRule>>();
    private List<ISpssVariable> mCurrentVars = new ArrayList<ISpssVariable>();
    private JTable mAnalysisVarsTable;
    private SingleVariableRule.Type mCurrentRuleType;

    public SingleRulesTableModel(JTable jTable) {
        this.mAnalysisVarsTable = jTable;
        this.mAnalysisVarsTable.getSelectionModel().addListSelectionListener(this);
    }

    public void setColumnNames(List<String> list) {
        this.mColumnNames = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.mColumnNames[i] = list.get(i);
        }
    }

    public void addRule(SingleVariableRule singleVariableRule) {
        this.mUniversalRules.add(singleVariableRule);
        if (singleVariableRule.getType().equals((Object)this.mCurrentRuleType)) {
            this.mCurrentRules.add(singleVariableRule);
            this.fireTableRowsInserted(this.mCurrentRules.size() - 1, this.mCurrentRules.size() - 1);
        }
    }

    public void addRules(List<SingleVariableRule> list) {
        for (SingleVariableRule singleVariableRule : list) {
            if (this.mUniversalRules.contains(singleVariableRule)) continue;
            this.mUniversalRules.add(singleVariableRule);
            if (!singleVariableRule.getType().equals((Object)this.mCurrentRuleType)) continue;
            this.mCurrentRules.add(singleVariableRule);
            this.fireTableRowsInserted(this.mCurrentRules.size() - 1, this.mCurrentRules.size() - 1);
        }
        this.fireTableDataChanged();
    }

    public void deleteRules(List<SingleVariableRule> list) {
        Collection<Set<SingleVariableRule>> collection = this.mSelectionsMap.values();
        for (SingleVariableRule singleVariableRule : list) {
            for (Set<SingleVariableRule> set : collection) {
                if (!set.contains(singleVariableRule)) continue;
                set.remove(singleVariableRule);
            }
            if (this.mCurrentRules.contains(singleVariableRule)) {
                this.mCurrentRules.remove(singleVariableRule);
            }
            this.mUniversalRules.remove(singleVariableRule);
        }
        this.fireTableDataChanged();
    }

    public List<SingleVariableRule> getRules() {
        return this.mUniversalRules;
    }

    public int getRulesCount(ISpssVariable iSpssVariable) {
        Set<SingleVariableRule> set = this.mSelectionsMap.get(iSpssVariable);
        return set != null ? set.size() : 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.refreshRulesVisibleModel();
    }

    public Map<ISpssVariable, Set<SingleVariableRule>> getSelectionsMap() {
        return this.mSelectionsMap;
    }

    public void setSelectionsMap(Map<ISpssVariable, Set<SingleVariableRule>> map) {
        this.mSelectionsMap.clear();
        this.mSelectionsMap.putAll(map);
        this.fireTableDataChanged();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.refreshRulesVisibleModel();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.mCurrentRules != null ? this.mCurrentRules.size() : 0;
    }

    @Override
    public String getColumnName(int n) {
        return this.mColumnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        SingleVariableRule singleVariableRule = this.mCurrentRules.get(n);
        if (n2 == 1) {
            object = singleVariableRule.getName();
        } else if (n2 == 0) {
            if (this.mCurrentVars.size() == 1) {
                object = this.mSelectionsMap.get(this.mCurrentVars.get(0)).contains(singleVariableRule);
            } else if (this.mCurrentVars.size() > 1) {
                Boolean bl = true;
                Iterator<ISpssVariable> iterator = this.mCurrentVars.iterator();
                while (iterator.hasNext() && bl.booleanValue()) {
                    bl = this.mSelectionsMap.get(iterator.next()).contains(singleVariableRule);
                }
                object = bl;
            }
        }
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            SingleVariableRule singleVariableRule = this.mCurrentRules.get(n);
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    for (ISpssVariable iSpssVariable : this.mCurrentVars) {
                        this.mSelectionsMap.get(iSpssVariable).add(singleVariableRule);
                    }
                } else {
                    for (ISpssVariable iSpssVariable : this.mCurrentVars) {
                        this.mSelectionsMap.get(iSpssVariable).remove(singleVariableRule);
                    }
                }
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    public Class getColumnClass(int n) {
        return n == 0 ? Boolean.class : String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public void clearAllRules() {
        this.mUniversalRules.clear();
    }

    private void refreshRulesVisibleModel() {
        this.mCurrentVars.clear();
        int[] nArray = this.mAnalysisVarsTable.getSelectedRows();
        TableModel tableModel = this.mAnalysisVarsTable.getModel();
        HashSet<SingleVariableRule.Type> hashSet = new HashSet<SingleVariableRule.Type>();
        for (int n : nArray) {
            ISpssVariable iSpssVariable = (ISpssVariable)tableModel.getValueAt(n, 0);
            this.mCurrentVars.add(iSpssVariable);
            if (iSpssVariable.getType() > 0) {
                hashSet.add(SingleVariableRule.Type.eSTRING);
                continue;
            }
            hashSet.add(iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat() ? SingleVariableRule.Type.eDATE : SingleVariableRule.Type.eNUMERIC);
        }
        if (hashSet.size() == 0) {
            this.mCurrentRuleType = null;
            this.mCurrentRules.clear();
            this.fireTableDataChanged();
            return;
        }
        if (hashSet.size() > 1) {
            this.mCurrentVars.clear();
            this.mCurrentRules.clear();
        } else {
            Object object = hashSet.iterator();
            this.mCurrentRuleType = (SingleVariableRule.Type)((Object)object.next());
            this.mCurrentRules.clear();
            for (SingleVariableRule singleVariableRule : this.mUniversalRules) {
                if (!singleVariableRule.getType().equals((Object)this.mCurrentRuleType)) continue;
                this.mCurrentRules.add(singleVariableRule);
            }
            for (ISpssVariable iSpssVariable : this.mCurrentVars) {
                if (this.mSelectionsMap.containsKey(iSpssVariable)) continue;
                this.mSelectionsMap.put(iSpssVariable, new HashSet());
            }
        }
        this.fireTableDataChanged();
    }
}

