/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.BackgroundColoredCellRenderer;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.DisableBooleanTableCellRenderer;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.DisableCellRenderer;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.SummaryVariable;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.SummaryVarsTableModel;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.TableHeaderToolTipDisplay;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.ValidateDataDlg;
import com.spss.shared.core_tools.utils.SerializableObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class SaveTab
extends BaseProcedureTab
implements TableModelListener {
    private static final int SUMMARIES_TABLE_WIDTH = 500;
    private static final int SUMMARIES_TABLE_HEIGHT = 110;
    static final String VLD_SAVE_REPLACE_CHECK = "IDS_VLD_SAVE_REPLACE";
    static final String VLD_SAVE_INDICATOR_CHECK = "IDS_VLD_SAVE_INDICATOR";
    static final String VLD_SAVE_SUMMARY_VARS_TABLE_MODEL = "IDS_VLD_SAVE_SUMMARY_VARS_TABLE_MODEL";
    static final int SUM_VARS_NAME_COL_IND = 2;
    private JCheckBox mReplaceCheck;
    private JCheckBox mIndicatorCheck;
    private JPanel mVarsTellPanel;
    private JPanel mFacilitatePanel;
    private JLabel mNumberLabel;
    private JTable mSummaryVarsTable;
    private SummaryVarsTableModel mSummaryVarsTableModel;
    private TableHeaderToolTipDisplay mTableHeaderToolTipDisplay;

    public SaveTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.mSummaryVarsTableModel.clear();
        this.mSummaryVarsTableModel.setEnableRow(0, true);
        this.mSummaryVarsTableModel.setEnableRow(1, false);
        this.mSummaryVarsTableModel.setEnableRow(2, false);
        boolean bl = ((ValidateDataDlg)this.mParent).getSingleVarRulesTab().isSingleRulesApplied();
        boolean bl2 = ((ValidateDataDlg)this.mParent).getCrossVarRulesTab().isCrossRulesApplied();
        this.mSummaryVarsTableModel.setEnableRow(3, bl || bl2);
        this.mIndicatorCheck.setEnabled(bl || bl2);
        this.setEnableState(this.mVarsTellPanel, bl || bl2);
        this.setEnableState(this.mFacilitatePanel, bl || bl2);
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_vdtab_save";
    }

    public SummaryVarsTableModel getSummaryVarsTableModel() {
        return this.mSummaryVarsTableModel;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getSource() == this.mSummaryVarsTableModel) {
            this.updateNumberLabel();
        }
    }

    public void populateSummaryData() {
        SummaryVarsTableModel summaryVarsTableModel = this.getSummaryVarsTableModel();
        summaryVarsTableModel.addSummaryVariable(new SummaryVariable(this.getResString("IDS_VLD_SAVE_EMPTYCASE_DESC"), false, this.getResString("IDS_VLD_SAVE_EMPTYCASE_NAME")));
        summaryVarsTableModel.addSummaryVariable(new SummaryVariable(this.getResString("IDS_VLD_SAVE_DUP_ID_DESC"), false, this.getResString("IDS_VLD_SAVE_DUP_ID_NAME")));
        summaryVarsTableModel.addSummaryVariable(new SummaryVariable(this.getResString("IDS_VLD_SAVE_INCOMPL_ID_DESC"), false, this.getResString("IDS_VLD_SAVE_INCOMPL_ID_NAME")));
        summaryVarsTableModel.addSummaryVariable(new SummaryVariable(this.getResString("IDS_VLD_SAVE_VIOLATIONS_DESC"), false, this.getResString("IDS_VLD_SAVE_VIOLATIONS_NAME")));
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        DialogDataModel dialogDataModel = ((ValidateDataDlg)this.mParent).getDialogDataModel();
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray(VLD_SAVE_SUMMARY_VARS_TABLE_MODEL);
        SummaryVarsTableModel summaryVarsTableModel = this.getSummaryVarsTableModel();
        if (serializableObjectArray != null && serializableObjectArray.length == 4) {
            for (SerializableObject serializableObject : serializableObjectArray) {
                summaryVarsTableModel.addSummaryVariable((SummaryVariable)serializableObject);
            }
        } else {
            this.populateSummaryData();
        }
        Object object = dialogDataModel.getBoolean("IDS_VLD_BC_FLAG_EMPTY_CHECK");
        int n = 1;
        if (object != null) {
            n = ((Boolean)object).booleanValue() ? 1 : 0;
        }
        this.mSummaryVarsTableModel.setEnableRow(0, n != 0);
        int n2 = ((ValidateDataDlg)this.mParent).getVariablesTab().getCaseIdTargetVarList().getModel().getSize() > 0 ? 1 : 0;
        object = dialogDataModel.getBoolean("IDS_VLD_BC_FLAG_DUPLICATE_CHECK");
        this.mSummaryVarsTableModel.setEnableRow(1, object != null && ((Boolean)object).booleanValue() && n2 != 0);
        object = dialogDataModel.getBoolean("IDS_VLD_BC_FLAG_INCOMLETE_CHECK");
        this.mSummaryVarsTableModel.setEnableRow(2, object != null && ((Boolean)object).booleanValue() && n2 != 0);
        boolean bl = ((ValidateDataDlg)this.mParent).getSingleVarRulesTab().isSingleRulesApplied();
        boolean bl2 = ((ValidateDataDlg)this.mParent).getCrossVarRulesTab().isCrossRulesApplied();
        this.mSummaryVarsTableModel.setEnableRow(3, bl || bl2);
        this.mIndicatorCheck.setEnabled(bl || bl2);
        this.setEnableState(this.mVarsTellPanel, bl || bl2);
        this.setEnableState(this.mFacilitatePanel, bl || bl2);
        this.updateNumberLabel();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mSummaryVarsTable;
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        List<SummaryVariable> list = this.mSummaryVarsTableModel.getSummaryVariables();
        dialogDataModel.putSerializableArray(VLD_SAVE_SUMMARY_VARS_TABLE_MODEL, list.toArray(new SerializableObject[list.size()]));
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_VLD_SAVE_VARS_COLON");
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mSummaryVarsTable);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(this, this.mReplaceCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        Insets insets2 = new Insets(n2 * 2, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(this, this.mIndicatorCheck, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        insets2 = new Insets(n2, n2 * 2, 0, 0);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mVarsTellPanel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mFacilitatePanel, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets2 = new Insets(n2 * 4, insets.left, 0, 0);
        DialogUtil.addUsingGBL(this, this.setupNumberOfVarsPanel(), gridBagConstraints, 0, 6, 1, 1, n, insets2);
    }

    private JPanel setupNumberOfVarsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_VLD_SAVE_NUMBER_VARS");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNumberLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        return jPanel;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, VLD_SAVE_REPLACE_CHECK);
        this.mReplaceCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, VLD_SAVE_INDICATOR_CHECK);
        this.mIndicatorCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mReplaceCheck);
        spssButtonGroup.add(this.mIndicatorCheck);
        this.mVarsTellPanel = this.setupVarsTellPanel();
        this.mFacilitatePanel = this.setupFaciliatePanel();
        this.mNumberLabel = new JLabel(" ", 10);
        this.mSummaryVarsTableModel = new SummaryVarsTableModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getResString("IDS_VLD_SAVE_HEADER_DESC");
        String string2 = this.getResString("IDS_VLD_SAVE_HEADER_SAVE");
        String string3 = this.getResString("IDS_VLD_SAVE_HEADER_NAME");
        arrayList.add("<HTML><B>" + string + "</B></HTML>");
        arrayList.add("<HTML><B>" + string2 + "</B></HTML>");
        arrayList.add("<HTML><B>" + string3 + "</B></HTML>");
        this.mSummaryVarsTableModel.setColumnNames(arrayList);
        this.mSummaryVarsTable = new JTable(this.mSummaryVarsTableModel){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent && ComponentState.isBtdRtlOrLtr() && n2 == 2 && (JTextComponent)component != null && ((JTextComponent)component).getDocument() != null) {
                    if (ComponentState.getBTD() == 1) {
                        ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    } else {
                        ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    }
                }
                return bl;
            }
        };
        this.mSummaryVarsTable.setPreferredScrollableViewportSize(new Dimension(500, 110));
        this.setupColumnWidths();
        this.setDefaults();
        this.mSummaryVarsTableModel.addTableModelListener(this);
        BackgroundColoredCellRenderer backgroundColoredCellRenderer = new BackgroundColoredCellRenderer(this);
        this.mSummaryVarsTable.getColumnModel().getColumn(0).setCellRenderer(backgroundColoredCellRenderer);
        DisableCellRenderer disableCellRenderer = new DisableCellRenderer();
        this.mSummaryVarsTable.getColumnModel().getColumn(2).setCellRenderer(disableCellRenderer);
        DisableBooleanTableCellRenderer disableBooleanTableCellRenderer = new DisableBooleanTableCellRenderer();
        this.mSummaryVarsTable.getColumnModel().getColumn(1).setCellRenderer(disableBooleanTableCellRenderer);
        this.mSummaryVarsTable.getTableHeader().setReorderingAllowed(false);
        JTableHeader jTableHeader = this.mSummaryVarsTable.getTableHeader();
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        this.mTableHeaderToolTipDisplay = new TableHeaderToolTipDisplay();
        this.mTableHeaderToolTipDisplay.addToolTip(tableColumnModel.getColumn(0), string);
        this.mTableHeaderToolTipDisplay.addToolTip(tableColumnModel.getColumn(1), string2);
        this.mTableHeaderToolTipDisplay.addToolTip(tableColumnModel.getColumn(2), string3);
        jTableHeader.addMouseMotionListener(this.mTableHeaderToolTipDisplay);
        this.addToComponentOrder(this.mSummaryVarsTable);
        this.addToComponentOrder(this.mReplaceCheck);
        this.addToComponentOrder(this.mIndicatorCheck);
        this.mSummaryVarsTable.setFocusable(true);
        this.mSummaryVarsTable.setFocusable(true);
        this.mSummaryVarsTable.setFocusTraversalKeys(0, null);
        this.setupVarsTellPanel();
    }

    private JPanel setupVarsTellPanel() {
        JLabel jLabel;
        String string;
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string2 = this.getResString("IDS_VLD_SAVE_VARS_TELL");
        String string3 = "<br>";
        int n = 0;
        int n2 = 0;
        Insets insets = new Insets(0, 0, 0, 0);
        int n3 = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        String string4 = string2.toLowerCase();
        int n4 = string4.indexOf(string3);
        while (n4 > 0) {
            string = string2.substring(n, n4);
            jLabel = new JLabel(string, 10);
            DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, n2, 1, 1, n3, insets);
            n = n4 + string3.length();
            n4 = string4.indexOf(string3, n);
            ++n2;
        }
        string = string2.substring(n, string2.length());
        jLabel = new JLabel(string, 10);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, n2, 1, 1, n3, insets);
        return jPanel;
    }

    private JPanel setupFaciliatePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_VLD_SAVE_FACILITATE"));
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setFont(this.mIndicatorCheck.getFont());
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setEditable(false);
        jTextArea.setMinimumSize(new Dimension(300, 70));
        jTextArea.setPreferredSize(new Dimension(300, 70));
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 0, 1, 1, n, null);
        return jPanel;
    }

    private void setEnableState(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.setEnableState(component2, bl);
            }
        }
    }

    private void setupColumnWidths() {
        TableColumnModel tableColumnModel = this.mSummaryVarsTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.mSummaryVarsTable.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.mSummaryVarsTable, tableColumn.getHeaderValue(), false, false, 0, 0);
        int n = component.getPreferredSize().width;
        tableColumn.setPreferredWidth(n);
        int n2 = 500 - n;
        tableColumnModel.getColumn(0).setPreferredWidth(n2 / 2);
        tableColumnModel.getColumn(2).setPreferredWidth(n2 / 2);
    }

    private void setDefaults() {
        this.mIndicatorCheck.setEnabled(false);
        this.mReplaceCheck.setSelected(false);
        this.mIndicatorCheck.setSelected(false);
    }

    private void updateNumberLabel() {
        Map<ISpssVariable, Set<SingleVariableRule>> map = ((ValidateDataDlg)this.mParent).getSingleVarRulesTab().getRulesSelectionMap();
        int n = 0;
        List<ISpssVariable> list = ((ValidateDataDlg)this.mParent).getVariablesTab().getAnalysisVarsList();
        for (ISpssVariable iSpssVariable : list) {
            if (!map.containsKey(iSpssVariable)) continue;
            n += map.get(iSpssVariable).size();
        }
        n += ((ValidateDataDlg)this.mParent).getCrossVarRulesTab().getSelectedRules().size();
        int n2 = this.mSummaryVarsTableModel.getRowCount();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                Object object;
                if (!this.mSummaryVarsTableModel.isCellEditable(i, 1) || (object = this.mSummaryVarsTableModel.getValueAt(i, 1)) == null || !(object instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
                ++n;
            }
        }
        this.mNumberLabel.setText(Integer.toString(n));
    }
}

