/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.ValidateDataDlg;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;

public class OutputTab
extends BaseProcedureTab
implements ItemListener {
    private static final int TEXT_BOX_GAP = 6;
    static final int VLD_OUT_MIN_NUM_EDIT_DEFAULT = 1;
    static final int VLD_OUT_MAX_NUM_EDIT_DEFAULT = 100;
    static final String VLD_OUT_MIN_NUM_EDIT = "IDS_VLD_OUT_MIN_NUM_EDIT";
    static final String VLD_OUT_MAX_NUM_EDIT = "IDS_VLD_OUT_MAX_NUM_EDIT";
    static final String VLD_OUT_LISTALL_CHECK = "IDS_VLD_OUT_LISTALL_CHECK";
    static final String VLD_OUT_SUM_VIOL_VAR_CHECK = "IDS_VLD_OUT_SUM_VIOL_VAR_CHECK";
    static final String VLD_OUT_SUM_VIOL_RULE_CHECK = "IDS_VLD_OUT_SUM_VIOL_RULE_CHECK";
    static final String VLD_OUT_DISPLAY_CHECK = "IDS_VLD_OUT_DISPLAY_CHECK";
    static final String VLD_OUT_MOVE_CHECK = "IDS_VLD_OUT_MOVE_CHECK";
    private JCheckBox mListCheck;
    private JCheckBox mSumVarCheck;
    private JCheckBox mSumRuleCheck;
    private JCheckBox mDisplayCheck;
    private JCheckBox mMoveCheck;
    private JLabel mMinimumLabel;
    private IntTextField mMinNumEdit;
    private JLabel mMaximumLabel;
    private IntTextField mMaxNumEdit;

    public OutputTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mListCheck) {
            boolean bl = this.mListCheck.isSelected() && this.mListCheck.isEnabled();
            this.mMinimumLabel.setEnabled(bl);
            this.mMinNumEdit.setEnabled(bl);
            this.mMinNumEdit.setOpaque(bl);
            this.mMaximumLabel.setEnabled(bl);
            this.mMaxNumEdit.setEnabled(bl);
            this.mMaxNumEdit.setOpaque(bl);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_vdtab_output";
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mListCheck;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        boolean bl = ((ValidateDataDlg)this.mParent).getVariablesTab().isAnalysisVarPresent();
        boolean bl2 = ((ValidateDataDlg)this.mParent).getSingleVarRulesTab().isSingleRulesApplied();
        boolean bl3 = ((ValidateDataDlg)this.mParent).getCrossVarRulesTab().isCrossRulesApplied();
        this.mSumVarCheck.setEnabled(bl2);
        this.mSumRuleCheck.setEnabled(bl2);
        this.mListCheck.setEnabled(bl2 || bl3);
        this.mMinimumLabel.setEnabled(bl2 || bl3);
        this.mMinNumEdit.setEnabled(bl2 || bl3);
        this.mMinNumEdit.setOpaque(bl2 || bl3);
        this.mMaximumLabel.setEnabled(bl2 || bl3);
        this.mMaxNumEdit.setEnabled(bl2 || bl3);
        this.mMaxNumEdit.setOpaque(bl2 || bl3);
        this.mDisplayCheck.setEnabled(bl);
        this.mMoveCheck.setEnabled(bl2 || bl3);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.setLayout(new GridBagLayout());
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(this, this.setupCasewiseReportPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(this, this.setupSingleValidationPanel(), gridBagConstraints, 0, 1, 1, 1, n, null);
        Insets insets = DialogUtil.getStandardControlInsets();
        insets = new Insets(insets.top, insets.left * 2, insets.bottom, insets.right);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mDisplayCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.mMoveCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
    }

    @Override
    protected boolean validateTab() {
        if (!this.checkMinimumEdit()) {
            return false;
        }
        if (!this.checkMaximumEdit()) {
            return false;
        }
        return super.validateTab();
    }

    private boolean checkMinimumEdit() {
        boolean bl = false;
        String string = this.mMinNumEdit.getText();
        long l = 0L;
        if (string != null && string.length() > 0) {
            try {
                l = Long.parseLong(string);
                if (l > 0L && l <= 99999999999L) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ComponentState.trace1((String)numberFormatException.getMessage(), (int)15);
            }
        }
        if (!bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_VLD_OUT_ENTER_POSITIVE_INT"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OutputTab.this.mMinNumEdit.requestFocus();
                    OutputTab.this.mMinNumEdit.setSelectionStart(0);
                    OutputTab.this.mMinNumEdit.setCaretPosition(0);
                }
            });
        }
        return bl;
    }

    private boolean checkMaximumEdit() {
        boolean bl = false;
        String string = this.mMaxNumEdit.getText();
        int n = 0;
        if (string != null && string.length() > 0) {
            try {
                n = Integer.parseInt(string);
                if (n > 0 && n <= 1000) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ComponentState.trace1((String)numberFormatException.getMessage(), (int)15);
            }
        }
        if (!bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_VLD_OUT_ENTER_WITHIN_1000_VALUE"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OutputTab.this.mMaxNumEdit.requestFocus();
                    OutputTab.this.mMaxNumEdit.setSelectionStart(0);
                    OutputTab.this.mMaxNumEdit.setCaretPosition(0);
                }
            });
        }
        return bl;
    }

    private JPanel setupCasewiseReportPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_VLD_OUT_REPORT_CAPTION")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, insets.left, n2, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mListCheck, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        gridBagConstraints.fill = 0;
        Insets insets3 = new Insets(insets.top, n2 * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mMinimumLabel, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinNumEdit, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets3 = new Insets(6, n2 * 2, n2 * 2, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mMaximumLabel, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets4 = new Insets(6, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxNumEdit, gridBagConstraints, 1, 2, 1, 1, n, insets4);
        return jPanel;
    }

    private JPanel setupSingleValidationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_VLD_OUT_SINGLE_VALIDATION_CAPTION")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSumVarCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mSumRuleCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, VLD_OUT_LISTALL_CHECK);
        this.mListCheck = new JCheckBox(toggleButtonAction);
        this.mMinNumEdit = new IntTextField(true);
        this.mMinNumEdit.setColumns(5);
        this.mMinNumEdit.setDocument((Document)new FixedLengthNumericDocument(30000, true, false));
        this.mMinNumEdit.setAction((Action)new TextFieldAction(this.mParent, VLD_OUT_MIN_NUM_EDIT));
        this.removeFocusListenerFrom(this.mMinNumEdit);
        this.mMaxNumEdit = new IntTextField(true);
        this.mMaxNumEdit.setColumns(5);
        this.mMaxNumEdit.setDocument((Document)new FixedLengthNumericDocument(30000, true, false));
        this.mMaxNumEdit.setAction((Action)new TextFieldAction(this.mParent, VLD_OUT_MAX_NUM_EDIT));
        this.removeFocusListenerFrom(this.mMaxNumEdit);
        this.mMinimumLabel = DialogUtil.createLabel(this.mParent, "IDS_VLD_OUT_MIN_VIOL_COLON");
        this.mMinimumLabel.setLabelFor((Component)this.mMinNumEdit);
        this.mMaximumLabel = DialogUtil.createLabel(this.mParent, "IDS_VLD_OUT_MAXCASES_COLON");
        this.mMaximumLabel.setLabelFor((Component)this.mMaxNumEdit);
        toggleButtonAction = new ToggleButtonAction(this.mParent, VLD_OUT_SUM_VIOL_VAR_CHECK);
        this.mSumVarCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, VLD_OUT_SUM_VIOL_RULE_CHECK);
        this.mSumRuleCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mSumVarCheck);
        spssButtonGroup.add(this.mSumRuleCheck);
        toggleButtonAction = new ToggleButtonAction(this.mParent, VLD_OUT_DISPLAY_CHECK);
        this.mDisplayCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, VLD_OUT_MOVE_CHECK);
        this.mMoveCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mDisplayCheck);
        spssButtonGroup2.add(this.mMoveCheck);
        this.mListCheck.addItemListener(this);
        this.setDefaults();
        this.addToComponentOrder(this.mListCheck);
        this.addToComponentOrder(this.mMinNumEdit);
        this.addToComponentOrder(this.mMaxNumEdit);
        this.addToComponentOrder(this.mSumVarCheck);
        this.addToComponentOrder(this.mSumRuleCheck);
        this.addToComponentOrder(this.mDisplayCheck);
        this.addToComponentOrder(this.mMoveCheck);
    }

    private void removeFocusListenerFrom(IntTextField intTextField) {
        FocusListener[] focusListenerArray = intTextField.getFocusListeners();
        if (focusListenerArray != null) {
            for (FocusListener focusListener : focusListenerArray) {
                if (!(focusListener instanceof IntTextField)) continue;
                intTextField.removeFocusListener(focusListener);
            }
        }
    }

    private void setDefaults() {
        this.mListCheck.setSelected(true);
        this.mMinNumEdit.setText(Integer.toString(1));
        this.mMaxNumEdit.setText(Integer.toString(100));
        this.mSumVarCheck.setSelected(true);
        this.mSumRuleCheck.setSelected(false);
        this.mDisplayCheck.setSelected(false);
        this.mMoveCheck.setSelected(false);
        this.mSumRuleCheck.setEnabled(false);
        this.mSumVarCheck.setEnabled(false);
        this.mDisplayCheck.setEnabled(false);
        this.mMoveCheck.setEnabled(false);
    }
}

