/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.server.messages.sysfilemsg.ObsVecMap;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.HistoBin;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.HistoRenderer;
import com.spss.shared.core_tools.format.CellValueFormatter;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class HistogramData {
    private static final double SPSS_SYSTEM_MISSING = -1.7976931348623157E308;
    private Map<String, Image> mMapImages = new HashMap<String, Image>();
    private Map<String, String> mMapMinimums = new HashMap<String, String>();
    private Map<String, String> mMapMaximums = new HashMap<String, String>();
    private List<HistoBin> mHistoBinList = new ArrayList<HistoBin>();
    private Map<Double, Double> mFreqData = new TreeMap<Double, Double>();
    private Map<String, ObsVecMap> mCoreFreq = new HashMap<String, ObsVecMap>();
    private String mStrMin;
    private String mStrMax;
    private int mNumBins;
    private int mNumFreqs;
    private double mStartPos;
    private OBS mMinOBS;
    private HistoRenderer mHistoRenderer = new HistoRenderer();
    private static final int MIN_BIN = 3;
    private static final int MAX_BIN = 40;
    static final int IMAGE_HEIGHT = 33;
    static final int IMAGE_WIDTH = 70;
    private static final double DEFAULT_OFFSET = 0.0;

    public void initialize() {
        this.mFreqData.clear();
        this.mMapMinimums.clear();
        this.mMapMaximums.clear();
        this.mMapImages.clear();
    }

    public boolean needScan(ISpssVariable iSpssVariable) {
        return !this.mMapMinimums.containsKey(iSpssVariable.getName());
    }

    public Image getHistogramImage(ISpssVariable iSpssVariable) {
        return this.mMapImages.get(iSpssVariable.getName());
    }

    public String getMinimum(ISpssVariable iSpssVariable) {
        return this.mMapMinimums.get(iSpssVariable.getName());
    }

    public String getMaximum(ISpssVariable iSpssVariable) {
        return this.mMapMaximums.get(iSpssVariable.getName());
    }

    public void prepareHistoData(List<ISpssVariable> list, CoreFrequencies coreFrequencies) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ObsVecMap obsVecMap = coreFrequencies.getVariableMap(i);
            ISpssVariable iSpssVariable = list.get(i);
            this.mCoreFreq.put(iSpssVariable.getName(), obsVecMap);
        }
        for (ISpssVariable iSpssVariable : list) {
            this.addVariableData(iSpssVariable);
        }
    }

    public void addVariableData(ISpssVariable iSpssVariable) {
        long l = this.loadFrequencyData(iSpssVariable);
        if (this.mFreqData.size() > 0) {
            double d = this.mMinOBS.getNum();
            if (iSpssVariable.getType() > 0) {
                this.mMapMinimums.put(iSpssVariable.getName(), this.mStrMin);
            } else {
                this.mMapMinimums.put(iSpssVariable.getName(), CellValueFormatter.obsToString((OBS)this.mMinOBS, (SPSS_Format)iSpssVariable.getFormat()));
            }
            double d2 = (Double)((TreeMap)this.mFreqData).lastKey();
            if (iSpssVariable.getType() > 0) {
                this.mMapMaximums.put(iSpssVariable.getName(), this.mStrMax);
            } else {
                OBS oBS = new OBS(d2);
                this.mMapMaximums.put(iSpssVariable.getName(), CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat()));
            }
            if (d == d2) {
                this.mNumBins = 1;
            } else {
                this.mNumBins = (int)(3.0 + Math.log10(l) * (Math.log(l) / Math.log(2.0)));
                if (this.mNumBins < 3) {
                    this.mNumBins = 3;
                } else if (this.mNumBins > 40) {
                    this.mNumBins = 40;
                }
                if (this.mNumBins > this.mNumFreqs) {
                    this.mNumBins = this.mNumFreqs;
                }
            }
            this.computeHistoData(d, d2);
            this.mMapImages.put(iSpssVariable.getName(), this.drawHistogram());
        } else {
            this.mNumBins = 1;
            this.mFreqData.put(0.0, 0.0);
            if (iSpssVariable.getType() > 0) {
                this.mMapMinimums.put(iSpssVariable.getName(), "");
                this.mMapMaximums.put(iSpssVariable.getName(), "");
            } else {
                this.mMapMinimums.put(iSpssVariable.getName(), ".");
                this.mMapMinimums.put(iSpssVariable.getName(), ".");
            }
            this.computeHistoData(1.0, 2.0);
            this.mMapImages.put(iSpssVariable.getName(), this.drawHistogram());
        }
    }

    private Image drawHistogram() {
        this.mHistoRenderer.setRect(0, 0, 70, 33);
        this.mHistoRenderer.setHistogram(this.mStartPos, this.mHistoBinList);
        return this.mHistoRenderer.createBufferedImage();
    }

    private long loadFrequencyData(ISpssVariable iSpssVariable) {
        int n = 0;
        long l = 0L;
        this.mFreqData.clear();
        ObsVecMap obsVecMap = this.mCoreFreq.get(iSpssVariable.getName());
        if (obsVecMap != null) {
            Set set = obsVecMap.getObsMap().entrySet();
            int n2 = set.size();
            int n3 = 0;
            this.mNumFreqs = 0;
            for (Map.Entry entry : set) {
                OBS oBS = (OBS)entry.getKey();
                double d = (Double)entry.getValue();
                if (iSpssVariable.isMissing(oBS) || oBS.equals((Object)new OBS(-1.7976931348623157E308))) {
                    n += (int)d;
                } else {
                    l = (long)((double)l + d);
                    if (d > 0.0) {
                        ++this.mNumFreqs;
                    }
                    if (this.mFreqData.size() == 0) {
                        this.mMinOBS = oBS;
                        if (iSpssVariable.getType() > 0) {
                            this.mStrMin = oBS.getString().trim();
                            this.mMinOBS.setNum((double)(n3 + 1));
                        }
                    }
                    if (iSpssVariable.getType() > 0) {
                        if (n3 == n2 - 1) {
                            this.mStrMax = oBS.isString() ? oBS.getString().trim() : "";
                        }
                        oBS.setNum((double)(n3 + 1));
                    }
                    this.mFreqData.put(oBS.getNum(), d);
                }
                ++n3;
            }
        }
        return l;
    }

    private void computeHistoData(double d, double d2) {
        double d3 = this.mNumBins > 1 ? (d2 - d) / (double)(this.mNumBins - 1) : d2 - d;
        if (0.0 == d3) {
            d3 = 0.0;
        }
        this.mStartPos = d - d3;
        double[] dArray = new double[this.mNumBins + 1];
        double[] dArray2 = new double[this.mNumBins + 1];
        for (int i = 0; i <= this.mNumBins; ++i) {
            dArray[i] = this.mStartPos + d3 * (double)(i + 1);
            dArray2[i] = 0.0;
        }
        Set<Double> set = this.mFreqData.keySet();
        for (double d4 : set) {
            double d5 = this.mFreqData.get(d4);
            for (int i = 0; i < this.mNumBins; ++i) {
                double d6 = dArray[i];
                double d7 = dArray[i + 1];
                if (d6 != d7 && (!(d4 >= d6) || !(d4 < d7))) continue;
                int n = i + 1;
                dArray2[n] = dArray2[n] + d5;
            }
        }
        this.mHistoBinList.clear();
        for (int i = 1; i <= this.mNumBins; ++i) {
            HistoBin histoBin = new HistoBin(dArray[i], dArray2[i]);
            this.mHistoBinList.add(histoBin);
        }
        this.mStartPos = d;
    }
}

