/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.ui.dialogs.validatedata.validate_data.HistoBin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

class HistoRenderer {
    private Color mBarFillColor;
    private Color mBarLineColor;
    private List<HistoBinPos> mHistoBins = new ArrayList<HistoBinPos>();
    private Rectangle mAxisFrame;
    private double mRangeStart = 0.0;
    private double mRangeEnd = 0.0;

    public HistoRenderer() {
        this.mBarFillColor = new Color(255, 255, 128);
        this.mBarLineColor = new Color(128, 128, 128);
        this.mAxisFrame = new Rectangle(0, 0, 0, 0);
        this.mHistoBins = new ArrayList<HistoBinPos>();
    }

    public void setRect(int n, int n2, int n3, int n4) {
        this.mAxisFrame.setBounds(n, n2, n3, n4);
    }

    public void setHistogram(double d, List<HistoBin> list) {
        int n = list.size();
        double d2 = d;
        if (list.size() > 1) {
            for (HistoBin object : list) {
                if (d2 >= object.getBinBoundary()) {
                    return;
                }
                if (object.getBinCount() < 0.0) {
                    return;
                }
                d2 = object.getBinBoundary();
            }
        }
        this.mHistoBins.clear();
        for (HistoBin histoBin : list) {
            HistoBinPos histoBinPos = new HistoBinPos();
            histoBinPos.setBin(histoBin);
            this.mHistoBins.add(histoBinPos);
        }
        if (n > 0) {
            this.mRangeStart = d;
            this.mRangeEnd = this.mHistoBins.get(n - 1).getBin().getBinBoundary();
        }
        this.recalHistoRenderer();
    }

    public BufferedImage createBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.mAxisFrame.width, this.mAxisFrame.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintContents(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void paintContents(Graphics2D graphics2D) {
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.mAxisFrame.width + 3, this.mAxisFrame.height + 3);
        graphics2D.setColor(this.mBarLineColor);
        for (HistoBinPos histoBinPos : this.mHistoBins) {
            graphics2D.setColor(this.mBarLineColor);
            Rectangle rectangle = histoBinPos.getRcBar();
            graphics2D.draw(rectangle);
            if (rectangle.width <= 0 || rectangle.height <= 0) continue;
            graphics2D.setColor(this.mBarFillColor);
            graphics2D.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1);
        }
    }

    private void recalHistoRenderer() {
        int n = this.mHistoBins.size();
        int n2 = 10;
        double d = 0.0;
        for (HistoBinPos histoBinPos : this.mHistoBins) {
            if (!(histoBinPos.getBin().getBinCount() > d)) continue;
            d = histoBinPos.getBin().getBinCount();
        }
        double d2 = d + d * 0.1;
        int n3 = this.getXAxisPos(this.mRangeStart);
        if (n == 1) {
            HistoBinPos histoBinPos = this.mHistoBins.get(0);
            int n4 = n3 + n2;
            int n5 = this.getYAxisPos(d2, histoBinPos.getBin().getBinCount());
            int n6 = this.mAxisFrame.height - n5 - 1;
            histoBinPos.setRcBar(new Rectangle(n4, n5, (int)((double)this.mAxisFrame.width * 0.75), n6));
        } else {
            for (HistoBinPos histoBinPos : this.mHistoBins) {
                int n7 = n3;
                int n8 = this.getYAxisPos(d2, histoBinPos.getBin().getBinCount());
                int n9 = this.getXAxisPos(histoBinPos.getBin().getBinBoundary()) - n7 - 1;
                int n10 = this.mAxisFrame.height - n8 - 1;
                histoBinPos.setRcBar(new Rectangle(n7, n8, n9, n10));
                n3 += n9;
            }
        }
    }

    private int getXAxisPos(double d) {
        double d2 = (d - this.mRangeStart) / (this.mRangeEnd - this.mRangeStart);
        int n = this.mAxisFrame.x + (int)((double)(this.mAxisFrame.width - 1) * d2);
        return n;
    }

    private int getYAxisPos(double d, double d2) {
        int n;
        double d3 = d2 / d;
        if (d3 > 0.0 && d3 < 0.02) {
            d3 = 0.02;
        }
        if ((n = this.mAxisFrame.y + (int)((double)(this.mAxisFrame.height - 1) * (1.0 - d3))) == this.mAxisFrame.x + this.mAxisFrame.height && d3 != 0.0) {
            --n;
        }
        return n;
    }

    class HistoBinPos {
        HistoBin mBin;
        Rectangle mRcBar;

        public HistoBinPos() {
            this.mBin = null;
            this.mRcBar = new Rectangle(0, 0, 0, 0);
        }

        public HistoBinPos(HistoBin histoBin, Rectangle rectangle) {
            this.mBin = histoBin;
            this.mRcBar = rectangle;
        }

        public HistoBin getBin() {
            return this.mBin;
        }

        public void setBin(HistoBin histoBin) {
            this.mBin = histoBin;
        }

        public Rectangle getRcBar() {
            return this.mRcBar;
        }

        public void setRcBar(Rectangle rectangle) {
            this.mRcBar = rectangle;
        }
    }
}

