/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.CrossVarRulesTableModel;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.TableHeaderToolTipDisplay;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.ValidateDataCrossRules;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.ValidateDataDlg;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.ValidateDataSingleRules;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CrossVarRulesTab
extends BaseProcedureTab {
    private static final int RULES_TABLE_HEIGHT = 380;
    private static final int RULES_TABLE_WIDTH = 600;
    static final String SELECTED_CROSS_VARIABLE_RULES = "IDS_SELECTED_CROSS_VARIABLE_RULES";
    static final String CROSS_VARIABLE_RULES = "IDS_CROSS_VARIABLE_RULES";
    private JTable mRulesTable;
    private CrossVarRulesTableModel mTableModel;
    private JButton mDefineRulesButton;
    private boolean mNotTemporary;
    private int mRuleNumber;
    private StringBuffer mListDatafileAttrib = new StringBuffer();
    private StringBuffer mDatafileAttribSyntax = new StringBuffer();
    private StringBuffer mListOutVars = new StringBuffer();
    private StringBuffer mListCustomRules = new StringBuffer();
    private StringBuffer mComputeSyntax = new StringBuffer();
    private StringBuffer mVarLabelsSyntax = new StringBuffer();
    private StringBuffer mDatafileDeleteSyntax = new StringBuffer();
    private StringBuffer mCrossRulesSyntax = new StringBuffer();
    private boolean mRulesLoaded = false;
    private boolean mRulesModified = false;
    private List<String> mCrossVarLoadedOutComeVars;
    private boolean msShowPressDefineRules = false;

    public CrossVarRulesTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.mTableModel.clear();
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.msShowPressDefineRules = this.mTableModel.getCrossRules().size() <= 0;
    }

    public void generateSyntax() {
        this.initializeSyntaxData();
        List<CrossVariableRule> list = this.mTableModel.getCrossRules();
        Set<CrossVariableRule> set = this.mTableModel.getSelectedRules();
        if (list.size() > 0) {
            this.mRuleNumber = 0;
            for (CrossVariableRule crossVariableRule : list) {
                boolean bl = set.contains(crossVariableRule);
                this.addRuleToSyntax(crossVariableRule, bl);
            }
        }
        this.assembleSyntax();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_vdtab_custom_rules";
    }

    public void setRules(List<CrossVariableRule> list) {
        if (list != null) {
            this.mRulesLoaded = list.size() > 0;
            for (CrossVariableRule crossVariableRule : list) {
                this.mTableModel.addRule(crossVariableRule);
            }
        }
    }

    public void setSelectedRules(Set<CrossVariableRule> set) {
        if (set != null) {
            this.mTableModel.setSelections(set);
        }
    }

    public List<CrossVariableRule> getCrossVariableRules() {
        return this.mTableModel.getCrossRules();
    }

    public Set<CrossVariableRule> getSelectedRules() {
        return this.mTableModel.getSelectedRules();
    }

    public void setTemporary(boolean bl) {
        this.mNotTemporary = bl;
    }

    public List<String> getCrossVarLoadedOutComeVars() {
        return this.mCrossVarLoadedOutComeVars;
    }

    public void setCrossVarLoadedOutComeVars(List<String> list) {
        this.mCrossVarLoadedOutComeVars = list;
    }

    public String getDatafileDeleteSyntax() {
        return this.mDatafileDeleteSyntax.toString();
    }

    public String getDatafileAttribSyntax() {
        return this.mDatafileAttribSyntax.toString();
    }

    public String getComputeSyntax() {
        return this.mComputeSyntax.toString();
    }

    public String getOutcomeVarsList() {
        return this.mListOutVars.toString();
    }

    public String getVarLabelsSyntax() {
        return this.mVarLabelsSyntax.toString();
    }

    public String getCrossRulesSyntax() {
        return this.mCrossRulesSyntax.toString();
    }

    public boolean isCrossRulesApplied() {
        return this.mTableModel.getSelectedRules().size() > 0;
    }

    public boolean isRulesModified() {
        return this.mRulesModified;
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mRulesTable;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_VLD_CVR_RULES_COLON");
        jLabel.setLabelFor(this.mRulesTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        JScrollPane jScrollPane = new JScrollPane(this.mRulesTable){

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (CrossVarRulesTab.this.msShowPressDefineRules) {
                    String string = CrossVarRulesTab.this.getResString("IDS_VLD_CVR_PRESS_DEFINE");
                    Font font = graphics.getFont();
                    graphics.setFont(CrossVarRulesTab.this.mRulesTable.getFont());
                    graphics.drawString(string, 50, 100);
                    graphics.setFont(font);
                }
            }
        };
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mDefineRulesButton, gridBagConstraints, 0, 2, 1, 1, n, null);
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        Set<CrossVariableRule> set = this.mTableModel.getSelectedRules();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CrossVariableRule crossVariableRule : set) {
            arrayList.add(crossVariableRule.getName());
        }
        dialogDataModel.putArray(SELECTED_CROSS_VARIABLE_RULES, arrayList.toArray());
    }

    private void initializeSyntaxData() {
        this.mListDatafileAttrib.setLength(0);
        this.mDatafileAttribSyntax.setLength(0);
        this.mListOutVars.setLength(0);
        this.mListCustomRules.setLength(0);
        this.mComputeSyntax.setLength(0);
        this.mVarLabelsSyntax.setLength(0);
        this.mDatafileDeleteSyntax.setLength(0);
        this.mCrossRulesSyntax.setLength(0);
    }

    private void assembleSyntax() {
        if (this.mRulesLoaded) {
            this.mDatafileDeleteSyntax.append("\n* ").append(this.getResString("IDS_VLD_CVR_EXISTING_CROSS_RULES_COMMENT")).append(".");
            this.mDatafileDeleteSyntax.append("\n").append(SyntaxUtil.getMainCommand("DATAFILE ATTRIBUTE"));
            this.mDatafileDeleteSyntax.append(SyntaxUtil.getMainCommandParamters("DELETE=$VD.CRule."));
        } else {
            this.mDatafileDeleteSyntax.setLength(0);
        }
        if (this.mTableModel.getCrossRules().size() < 1) {
            return;
        }
        this.mDatafileAttribSyntax.append("\n* ");
        this.mDatafileAttribSyntax.append(this.getResString("IDS_VLD_CVR_REDEFINE_CROSS_RULES_COMMENT")).append(".");
        this.mDatafileAttribSyntax.append("\n").append(SyntaxUtil.getMainCommand("DATAFILE ATTRIBUTE"));
        this.mDatafileAttribSyntax.append(SyntaxUtil.getMainCommandParamters("ATTRIBUTE="));
        this.mDatafileAttribSyntax.append(this.mListDatafileAttrib.toString());
        this.mDatafileAttribSyntax.append(".");
        if (this.mListCustomRules.length() > 0) {
            this.mCrossRulesSyntax.append(" CROSSVARRULES=");
            this.mCrossRulesSyntax.append(this.mListCustomRules);
        } else {
            this.mCrossRulesSyntax.setLength(0);
        }
    }

    private void addRuleToSyntax(CrossVariableRule crossVariableRule, boolean bl) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        String string = VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)(crossVariableRule.getName() + "_"), (int)0);
        ++this.mRuleNumber;
        String string2 = "$VD.CRule[" + this.mRuleNumber + "]";
        this.mListDatafileAttrib.append("\n   ").append(string2);
        this.mListDatafileAttrib.append("(\"Label=");
        this.mListDatafileAttrib.append(CharacterUtil.smartQuote((String)crossVariableRule.getName())).append(",");
        this.mListDatafileAttrib.append("OutcomeVar=");
        this.mListDatafileAttrib.append(CharacterUtil.smartQuote((String)string)).append(",");
        String string3 = this.fixQuotes(crossVariableRule.getLogicalExpression());
        this.mListDatafileAttrib.append("Expression='");
        this.mListDatafileAttrib.append(string3).append("'\")");
        if (bl) {
            if (this.mRuleNumber > 1) {
                this.mListOutVars.append(" ");
                this.mListCustomRules.append(" ");
            }
            this.mListOutVars.append(string);
            this.mListCustomRules.append(string2);
            this.mComputeSyntax.append("\n* ");
            this.mComputeSyntax.append(crossVariableRule.getName());
            this.mComputeSyntax.append(SyntaxUtil.terminateSyntax().toString()).append(SyntaxUtil.getMainCommand("COMPUTE"));
            this.mComputeSyntax.append(SyntaxUtil.getMainCommandParamters(string));
            this.mComputeSyntax.append("=");
            this.mComputeSyntax.append(crossVariableRule.getLogicalExpression());
            this.mComputeSyntax.append(".");
            if (this.mNotTemporary) {
                this.mVarLabelsSyntax.append("\n").append(SyntaxUtil.getMainCommand("VARIABLE LABELS"));
                this.mVarLabelsSyntax.append(SyntaxUtil.getMainCommandParamters(string));
                this.mVarLabelsSyntax.append(" ");
                this.mVarLabelsSyntax.append(CharacterUtil.smartQuote((String)(crossVariableRule.getName().trim() + ":" + crossVariableRule.getLogicalExpression().trim())));
                this.mVarLabelsSyntax.append(".");
            }
        }
    }

    private String fixQuotes(String string) {
        String string2 = string.replace("\"", "\"\"");
        string2 = string2.replace("'", "''");
        return string2;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_VLD_CVR_DEFINE_RULES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CrossVarRulesTab.this.runDefineRulesSubDialog();
            }
        };
        this.mDefineRulesButton = new JButton(toggleButtonAction);
        this.mTableModel = new CrossVarRulesTableModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getResString("IDS_VLD_CVR_HEADER_APPLY");
        String string2 = this.getResString("IDS_VLD_CVR_HEADER_NAME");
        String string3 = this.getResString("IDS_VLD_CVR_HEADER_EXPRESSION");
        arrayList.add("<HTML><B>" + string + "</B></HTML>");
        arrayList.add("<HTML><B>" + string2 + "</B></HTML>");
        arrayList.add("<HTML><B>" + string3 + "</B></HTML>");
        this.mTableModel.setColumnNames(arrayList);
        this.mRulesTable = new JTable(this.mTableModel);
        this.mRulesTable.setRowSelectionAllowed(false);
        this.mRulesTable.setColumnSelectionAllowed(false);
        JTableHeader jTableHeader = this.mRulesTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        TableHeaderToolTipDisplay tableHeaderToolTipDisplay = new TableHeaderToolTipDisplay();
        tableHeaderToolTipDisplay.addToolTip(tableColumnModel.getColumn(0), string);
        tableHeaderToolTipDisplay.addToolTip(tableColumnModel.getColumn(1), string2);
        tableHeaderToolTipDisplay.addToolTip(tableColumnModel.getColumn(2), string3);
        jTableHeader.addMouseMotionListener(tableHeaderToolTipDisplay);
        ((DefaultTableCellRenderer)jTableHeader.getDefaultRenderer()).setHorizontalAlignment(2);
        this.setupColumnWidths();
        this.mRulesTable.setPreferredScrollableViewportSize(new Dimension(600, 380));
        this.addToComponentOrder(this.mRulesTable);
        this.addToComponentOrder(this.mDefineRulesButton);
        this.mRulesTable.setFocusable(true);
        this.mRulesTable.setFocusTraversalKeys(0, null);
    }

    private void setupColumnWidths() {
        TableColumnModel tableColumnModel = this.mRulesTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.mRulesTable.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.mRulesTable, tableColumn.getHeaderValue(), false, false, 0, 0);
        int n = component.getPreferredSize().width;
        tableColumn.setPreferredWidth(n);
        int n2 = 600 - n;
        tableColumnModel.getColumn(1).setPreferredWidth(n2 / 3);
        tableColumnModel.getColumn(2).setPreferredWidth(n2 / 3 * 2);
    }

    private void runDefineRulesSubDialog() {
        List<CrossVariableRule> list = this.mTableModel.getCrossRules();
        DialogDataModel dialogDataModel = ((ValidateDataDlg)this.mParent).getDialogDataModel();
        SerializableObject[] serializableObjectArray = list.toArray(new SerializableObject[list.size()]);
        dialogDataModel.putSerializableArray(CROSS_VARIABLE_RULES, serializableObjectArray);
        ((ValidateDataDlg)this.mParent).runSubDialog(new ValidateDataCrossRules((BaseProcedureDialog)this.mParent));
        SerializableObject[] serializableObjectArray2 = dialogDataModel.getSerializableArray(CROSS_VARIABLE_RULES);
        if (serializableObjectArray2 != serializableObjectArray) {
            this.msShowPressDefineRules = false;
        }
        ArrayList<CrossVariableRule> arrayList = new ArrayList<CrossVariableRule>();
        for (SerializableObject object2 : serializableObjectArray2) {
            arrayList.add((CrossVariableRule)object2);
        }
        List<CrossVariableRule> list2 = this.mTableModel.getCrossRules();
        ArrayList<CrossVariableRule> arrayList2 = new ArrayList<CrossVariableRule>();
        Object object3 = list2.iterator();
        while (object3.hasNext()) {
            CrossVariableRule crossVariableRule = (CrossVariableRule)object3.next();
            if (arrayList.contains(crossVariableRule)) continue;
            arrayList2.add(crossVariableRule);
        }
        if (arrayList2.size() > 0) {
            this.mTableModel.deleteRules(arrayList2);
        }
        object3 = new ArrayList();
        for (CrossVariableRule crossVariableRule : arrayList) {
            if (list.contains(crossVariableRule)) continue;
            object3.add(crossVariableRule);
        }
        this.mTableModel.addRules((List<CrossVariableRule>)object3);
        if (!this.mRulesModified) {
            Boolean bl = ((ValidateDataDlg)this.mParent).getDialogDataModel().getBoolean(ValidateDataSingleRules.SINGLE_RULES_ADDED_UPDATED);
            this.mRulesModified = bl != null && bl != false;
        }
    }
}

