/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.ValidateDataDlg;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class BasicChecksTab
extends BaseProcedureTab
implements ItemListener {
    private static final int TEXT_BOX_GAP = 6;
    static final String VLD_BC_MAX_MIS_VAL_EDIT_DEFAULT = "70";
    static final String VLD_BC_MAX_CASES_SINGLE_CAT_EDIT_DEFAULT = "95";
    static final String VLD_BC_MAX_CAT_COUNTONE_EDIT_DEFAULT = "90";
    static final String VLD_BC_MIN_COEF_VAR_EDIT_DEFAULT = "0.001";
    static final String VLD_BC_MIN_STD_DEV_EDIT_DEFAULT = "0";
    static final String VLD_BC_FLAG_VAR_CHECK = "IDS_VLD_BC_FLAG_VAR_CHECK";
    static final String VLD_BC_MAX_MIS_VAL_EDIT = "IDS_VLD_BC_MAX_MIS_VAL_EDIT";
    static final String VLD_BC_MAX_CASES_SINGLE_CAT_EDIT = "IDS_VLD_BC_MAX_CASES_SINGLE_CAT_EDIT";
    static final String VLD_BC_MAX_CAT_COUNTONE_EDIT = "IDS_VLD_BC_MAX_CAT_COUNTONE_EDIT";
    static final String VLD_BC_MIN_COEF_VAR_EDIT = "IDS_VLD_BC_MIN_COEF_VAR_EDIT";
    static final String VLD_BC_MIN_STD_DEV_EDIT = "IDS_VLD_BC_MIN_STD_DEV_EDIT";
    static final String VLD_BC_FLAG_INCOMLETE_CHECK = "IDS_VLD_BC_FLAG_INCOMLETE_CHECK";
    static final String VLD_BC_FLAG_DUPLICATE_CHECK = "IDS_VLD_BC_FLAG_DUPLICATE_CHECK";
    static final String VLD_BC_FLAG_EMPTY_CHECK = "IDS_VLD_BC_FLAG_EMPTY_CHECK";
    static final String VLD_BC_DEFINE_CASES_COMBO = "IDS_VLD_BC_DEFINE_CASES_COMBO";
    private JCheckBox mFlagCheck;
    private JCheckBox mFlagIncomleteCheck;
    private JCheckBox mFlagDuplicateCheck;
    private JCheckBox mFlagEmptyCheck;
    private FloatTextField mMisValEdit;
    private FloatTextField mSingleCatEdit;
    private FloatTextField mCatCountOneEdit;
    private FloatTextField mCoeffVarEdit;
    private FloatTextField mStdDevEdit;
    private JLabel mDefineLabel;
    private JComboBox mDefineCasesCombo;
    private JLabel mMisValLabel1;
    private JLabel mMisValLabel2;
    private JLabel mSingleCatLabel1;
    private JLabel mSingleCatLabel2;
    private JLabel mCatCountOneLabel1;
    private JLabel mCatCountOneLabel2;
    private JLabel mCoefVarLabel1;
    private JLabel mCoefVarLabel2;
    private JLabel mStdDeveLabel1;
    private JLabel mStdDeveLabel2;

    public BasicChecksTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mFlagCheck) {
            this.enableAnalysisPanelControls();
        } else if (object == this.mFlagEmptyCheck) {
            this.enableDefineCombo();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_vdtab_basic_checks";
    }

    public void enableControls() {
        this.enableAnalysisPanelControls();
        this.enableDefineCombo();
    }

    public void enableFlags(boolean bl) {
        DialogDataModel dialogDataModel = ((ValidateDataDlg)this.mParent).getDialogDataModel();
        dialogDataModel.putBoolean(VLD_BC_FLAG_INCOMLETE_CHECK, bl);
        dialogDataModel.putBoolean(VLD_BC_FLAG_DUPLICATE_CHECK, bl);
        this.mFlagIncomleteCheck.setEnabled(bl);
        this.mFlagDuplicateCheck.setEnabled(bl);
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        if (this.mFlagCheck.isEnabled()) {
            return this.mFlagCheck;
        }
        if (this.mFlagIncomleteCheck.isEnabled()) {
            return this.mFlagIncomleteCheck;
        }
        return this.mFlagEmptyCheck;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(this, this.setupAnalysisVariblesPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(this, this.setupCaseIdentifiersPanel(), gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(this, this.setupEmptyCasesPanel(), gridBagConstraints, 0, 2, 1, 1, n, null);
    }

    @Override
    protected boolean validateTab() {
        if (this.checkEmpty((JTextField)this.mMisValEdit)) {
            return false;
        }
        if (this.checkEmpty((JTextField)this.mSingleCatEdit)) {
            return false;
        }
        if (this.checkEmpty((JTextField)this.mCatCountOneEdit)) {
            return false;
        }
        if (this.checkEmpty((JTextField)this.mCoeffVarEdit)) {
            return false;
        }
        if (this.checkEmpty((JTextField)this.mStdDevEdit)) {
            return false;
        }
        if (this.checkOutOfRange((JTextField)this.mMisValEdit)) {
            return false;
        }
        if (this.checkOutOfRange((JTextField)this.mSingleCatEdit)) {
            return false;
        }
        if (this.checkOutOfRange((JTextField)this.mCatCountOneEdit)) {
            return false;
        }
        return super.validateTab();
    }

    private boolean checkEmpty(final JTextField jTextField) {
        if (jTextField.getText() == null || jTextField.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_VLD_BC_ENTER_VALUE"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTextField.requestFocus();
                }
            });
            return true;
        }
        return false;
    }

    private boolean checkOutOfRange(final JTextField jTextField) {
        String string = jTextField.getText();
        double d = 0.0;
        if (string != null || string.length() != 0) {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                ComponentState.trace1((String)numberFormatException.getMessage(), (int)15);
            }
        }
        if (d <= 0.0 || d > 100.0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_VLD_BC_ENTER_WITHIN_100_VALUE"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTextField.requestFocus();
                    jTextField.setSelectionStart(0);
                    jTextField.setCaretPosition(0);
                }
            });
            return true;
        }
        return false;
    }

    private void enableAnalysisPanelControls() {
        boolean bl = this.mFlagCheck.isSelected();
        boolean bl2 = ((ValidateDataDlg)this.mParent).getVariablesTab().isCatVarsPresent();
        boolean bl3 = ((ValidateDataDlg)this.mParent).getVariablesTab().isScaleVarsPresent();
        this.mFlagCheck.setEnabled(bl2 || bl3);
        this.mMisValEdit.setEnabled(bl && (bl2 || bl3));
        this.mMisValEdit.setOpaque(bl && (bl2 || bl3));
        this.mSingleCatEdit.setEnabled(bl && bl2);
        this.mSingleCatEdit.setOpaque(bl && bl2);
        this.mCatCountOneEdit.setEnabled(bl && bl2);
        this.mCatCountOneEdit.setOpaque(bl && bl2);
        this.mCoeffVarEdit.setEnabled(bl && bl3);
        this.mCoeffVarEdit.setOpaque(bl && bl3);
        this.mStdDevEdit.setEnabled(bl && bl3);
        this.mStdDevEdit.setOpaque(bl && bl3);
        this.mMisValLabel1.setEnabled(bl2 || bl3);
        this.mMisValLabel2.setEnabled(bl2 || bl3);
        this.mSingleCatLabel1.setEnabled(bl2);
        this.mSingleCatLabel2.setEnabled(bl2);
        this.mCatCountOneLabel1.setEnabled(bl2);
        this.mCatCountOneLabel2.setEnabled(bl2);
        this.mCoefVarLabel1.setEnabled(bl3);
        this.mCoefVarLabel2.setEnabled(bl3);
        this.mStdDeveLabel1.setEnabled(bl3);
        this.mStdDeveLabel2.setEnabled(bl3);
    }

    private void enableDefineCombo() {
        boolean bl = this.mFlagEmptyCheck.isSelected() && ((ValidateDataDlg)this.mParent).getVariablesTab().getAnalysisTargetVarList().getModel().getSize() > 0;
        this.mDefineLabel.setEnabled(bl);
        this.mDefineCasesCombo.setEnabled(bl);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, VLD_BC_FLAG_VAR_CHECK);
        this.mFlagCheck = new JCheckBox(toggleButtonAction);
        this.mMisValEdit = new FloatTextField();
        this.mMisValEdit.setColumns(5);
        this.mMisValEdit.setDocument((Document)new FixedLengthNumericDocument(30000, true, true));
        this.mMisValEdit.setAction((Action)new TextFieldAction(this.mParent, VLD_BC_MAX_MIS_VAL_EDIT));
        this.mSingleCatEdit = new FloatTextField();
        this.mSingleCatEdit.setColumns(5);
        this.mSingleCatEdit.setDocument((Document)new FixedLengthNumericDocument(30000, true, true));
        this.mSingleCatEdit.setAction((Action)new TextFieldAction(this.mParent, VLD_BC_MAX_CASES_SINGLE_CAT_EDIT));
        this.mCatCountOneEdit = new FloatTextField();
        this.mCatCountOneEdit.setColumns(5);
        this.mCatCountOneEdit.setDocument((Document)new FixedLengthNumericDocument(30000, true, true));
        this.mCatCountOneEdit.setAction((Action)new TextFieldAction(this.mParent, VLD_BC_MAX_CAT_COUNTONE_EDIT));
        this.mCoeffVarEdit = new FloatTextField();
        this.mCoeffVarEdit.setColumns(5);
        this.mCoeffVarEdit.setDocument((Document)new FixedLengthNumericDocument(30000, true, true));
        this.mCoeffVarEdit.setAction((Action)new TextFieldAction(this.mParent, VLD_BC_MIN_COEF_VAR_EDIT));
        this.mStdDevEdit = new FloatTextField();
        this.mStdDevEdit.setColumns(5);
        this.mStdDevEdit.setDocument((Document)new FixedLengthNumericDocument(30000, true, true));
        this.mStdDevEdit.setAction((Action)new TextFieldAction(this.mParent, VLD_BC_MIN_STD_DEV_EDIT));
        toggleButtonAction = new ToggleButtonAction(this.mParent, VLD_BC_FLAG_INCOMLETE_CHECK);
        this.mFlagIncomleteCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, VLD_BC_FLAG_DUPLICATE_CHECK);
        this.mFlagDuplicateCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mFlagIncomleteCheck);
        spssButtonGroup.add(this.mFlagDuplicateCheck);
        toggleButtonAction = new ToggleButtonAction(this.mParent, VLD_BC_FLAG_EMPTY_CHECK);
        this.mFlagEmptyCheck = new JCheckBox(toggleButtonAction);
        String[] stringArray = ((ValidateDataDlg)this.mParent).getResStringArray("IDS_VLD_SVR_DEFINE_CASES_COMBO_VALUES");
        this.mDefineCasesCombo = new JComboBox<String>(stringArray);
        this.mDefineCasesCombo.setAction(new ComboboxAction(this.mParent, VLD_BC_DEFINE_CASES_COMBO));
        this.mDefineLabel = DialogUtil.createLabel(this.mParent, "IDS_VLD_BC_DEFINE_CASES_COLON");
        this.mDefineLabel.setLabelFor(this.mDefineCasesCombo);
        this.mMisValLabel1 = DialogUtil.createLabel(this.mParent, "IDS_VLD_BC_MAX_MIS_VAL_COLON");
        this.mMisValLabel1.setLabelFor((Component)this.mMisValEdit);
        this.mMisValLabel2 = DialogUtil.createLabel(this.mParent, "IDS_VLD_BC_ALL_VARS");
        this.mSingleCatLabel1 = DialogUtil.createLabel(this.mParent, "IDS_VLD_BC_MAX_CASES_SINGLE_CAT_COLON");
        this.mSingleCatLabel1.setLabelFor((Component)this.mSingleCatEdit);
        this.mSingleCatLabel2 = DialogUtil.createLabel(this.mParent, "IDS_VLD_BC_CAT_VARS_ONLY");
        this.mCatCountOneLabel1 = DialogUtil.createLabel(this.mParent, "IDS_VLD_BC_MAX_CAT_COUNTONE_COLON");
        this.mCatCountOneLabel1.setLabelFor((Component)this.mCatCountOneEdit);
        this.mCatCountOneLabel2 = DialogUtil.createLabel(this.mParent, "IDS_VLD_BC_CAT_VARS_ONLY2");
        this.mCoefVarLabel1 = DialogUtil.createLabel(this.mParent, "IDS_VLD_BC_MIN_COEF_VAR_COLON");
        this.mCoefVarLabel1.setLabelFor((Component)this.mCoeffVarEdit);
        this.mCoefVarLabel2 = DialogUtil.createLabel(this.mParent, "IDS_VLD_BC_SACALE_VARS_ONLY");
        this.mStdDeveLabel1 = DialogUtil.createLabel(this.mParent, "IDS_VLD_BC_MIN_STD_DEV_COLON");
        this.mStdDeveLabel1.setLabelFor((Component)this.mStdDevEdit);
        this.mStdDeveLabel2 = DialogUtil.createLabel(this.mParent, "IDS_VLD_BC_SACALE_VARS_ONLY2");
        this.mFlagCheck.addItemListener(this);
        this.mFlagEmptyCheck.addItemListener(this);
        this.setDefaults();
        this.addToComponentOrder(this.mFlagCheck);
        this.addToComponentOrder(this.mMisValEdit);
        this.addToComponentOrder(this.mSingleCatEdit);
        this.addToComponentOrder(this.mCatCountOneEdit);
        this.addToComponentOrder(this.mCoeffVarEdit);
        this.addToComponentOrder(this.mStdDevEdit);
        this.addToComponentOrder(this.mFlagIncomleteCheck);
        this.addToComponentOrder(this.mFlagDuplicateCheck);
        this.addToComponentOrder(this.mFlagEmptyCheck);
        this.addToComponentOrder(this.mDefineCasesCombo);
    }

    private void setDefaults() {
        this.mFlagCheck.setSelected(true);
        this.mFlagIncomleteCheck.setSelected(true);
        this.mFlagDuplicateCheck.setSelected(true);
        this.mFlagEmptyCheck.setSelected(true);
        this.mMisValEdit.setText(VLD_BC_MAX_MIS_VAL_EDIT_DEFAULT);
        this.mSingleCatEdit.setText(VLD_BC_MAX_CASES_SINGLE_CAT_EDIT_DEFAULT);
        this.mCatCountOneEdit.setText(VLD_BC_MAX_CAT_COUNTONE_EDIT_DEFAULT);
        this.mCoeffVarEdit.setText(VLD_BC_MIN_COEF_VAR_EDIT_DEFAULT);
        this.mStdDevEdit.setText(VLD_BC_MIN_STD_DEV_EDIT_DEFAULT);
        this.mMisValEdit.setEnabled(false);
        this.mMisValEdit.setOpaque(false);
        this.mSingleCatEdit.setEnabled(false);
        this.mSingleCatEdit.setOpaque(false);
        this.mCatCountOneEdit.setEnabled(false);
        this.mCatCountOneEdit.setOpaque(false);
        this.mCoeffVarEdit.setEnabled(false);
        this.mCoeffVarEdit.setOpaque(false);
        this.mStdDevEdit.setEnabled(false);
        this.mStdDevEdit.setOpaque(false);
        this.mFlagCheck.setEnabled(false);
        this.mFlagIncomleteCheck.setEnabled(false);
        this.mFlagDuplicateCheck.setEnabled(false);
        this.mDefineCasesCombo.setEnabled(false);
        this.mMisValLabel1.setEnabled(false);
        this.mMisValLabel2.setEnabled(false);
        this.mSingleCatLabel1.setEnabled(false);
        this.mSingleCatLabel2.setEnabled(false);
        this.mCatCountOneLabel1.setEnabled(false);
        this.mCatCountOneLabel2.setEnabled(false);
        this.mCatCountOneLabel1.setEnabled(false);
        this.mCatCountOneLabel2.setEnabled(false);
        this.mStdDeveLabel1.setEnabled(false);
        this.mStdDeveLabel2.setEnabled(false);
        this.mDefineLabel.setEnabled(false);
        this.mDefineCasesCombo.setEnabled(false);
    }

    private JPanel setupAnalysisVariblesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_VLD_BC_ANALYSIS_VARS_CAPTION")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, insets.left, n2, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mFlagCheck, gridBagConstraints, 0, 0, 3, 1, n, insets2);
        insets = new Insets(insets.top, insets.left * 2, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets3 = new Insets(6, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mMisValLabel1, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMisValEdit, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMisValLabel2, gridBagConstraints, 2, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSingleCatLabel1, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSingleCatEdit, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSingleCatLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCatCountOneLabel1, gridBagConstraints, 0, 3, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCatCountOneEdit, gridBagConstraints, 1, 3, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mCatCountOneLabel2, gridBagConstraints, 2, 3, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCoefVarLabel1, gridBagConstraints, 0, 4, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCoeffVarEdit, gridBagConstraints, 1, 4, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mCoefVarLabel2, gridBagConstraints, 2, 4, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mStdDeveLabel1, gridBagConstraints, 0, 5, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStdDevEdit, gridBagConstraints, 1, 5, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mStdDeveLabel2, gridBagConstraints, 2, 5, 1, 1, n, insets3);
        return jPanel;
    }

    private JPanel setupCaseIdentifiersPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_VLD_BC_CASE_ID_CAPTION")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mFlagIncomleteCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFlagDuplicateCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupEmptyCasesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n2, insets.left * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mFlagEmptyCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        n = 21;
        Insets insets3 = new Insets(n2, n2 * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDefineLabel, gridBagConstraints, 1, 0, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mDefineCasesCombo, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "ERR_VLD_BC_EMPTY_CASE");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets3 = new Insets(n2, n2 * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 3, 1, n, insets3);
        return jPanel;
    }
}

