/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.validate_data;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.AnalysisData;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.SingleRulesTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class AnalysisVarsTableModel
extends AbstractTableModel
implements TableModelListener {
    static final int VAR_COL = 0;
    static final int DIST_COL = 1;
    static final int MIN_COL = 2;
    static final int MAX_COL = 3;
    static final int RULES_COL = 4;
    static final int NUM_COLS = 5;
    private String[] mColumnNames;
    private List<AnalysisData> mAnalysisDataList = new ArrayList<AnalysisData>();
    private List<AnalysisData> mCurrentAnalysisData = new ArrayList<AnalysisData>();
    private SingleRulesTableModel mRulesTableModel;
    private VisibleVars mVisibleVarsType = VisibleVars.eALL;

    public AnalysisVarsTableModel() {
        this(null);
    }

    public AnalysisVarsTableModel(List<AnalysisData> list) {
        if (list != null) {
            this.mAnalysisDataList = list;
            this.mCurrentAnalysisData.addAll(list);
        }
    }

    public void setColumnNames(List<String> list) {
        this.mColumnNames = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.mColumnNames[i] = list.get(i);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getSource() == this.mRulesTableModel && tableModelEvent.getColumn() == 0) {
            this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, 4));
        }
    }

    public void setVisibleVarType(VisibleVars visibleVars) {
        this.mVisibleVarsType = visibleVars;
        this.mCurrentAnalysisData.clear();
        if (visibleVars.equals((Object)VisibleVars.eALL)) {
            this.mCurrentAnalysisData.addAll(this.mAnalysisDataList);
        } else {
            for (AnalysisData analysisData : this.mAnalysisDataList) {
                if (!this.mVisibleVarsType.equals((Object)this.getVarType(analysisData.getSpssVariable()))) continue;
                this.mCurrentAnalysisData.add(analysisData);
            }
        }
        this.fireTableDataChanged();
    }

    public void setRulesTableModel(SingleRulesTableModel singleRulesTableModel) {
        this.mRulesTableModel = singleRulesTableModel;
        this.mRulesTableModel.addTableModelListener(this);
    }

    public void addAnalysisData(AnalysisData analysisData) {
        if (this.mAnalysisDataList.contains(analysisData)) {
            return;
        }
        this.mAnalysisDataList.add(analysisData);
        if (this.mVisibleVarsType.equals((Object)VisibleVars.eALL) || this.mVisibleVarsType.equals((Object)this.getVarType(analysisData.getSpssVariable()))) {
            this.mCurrentAnalysisData.add(analysisData);
            this.fireTableRowsInserted(this.mCurrentAnalysisData.size() - 1, this.mCurrentAnalysisData.size() - 1);
        }
    }

    public void removeAnalysisData(AnalysisData analysisData) {
        this.mAnalysisDataList.remove(analysisData);
        int n = this.mCurrentAnalysisData.indexOf(analysisData);
        if (n != -1) {
            this.mCurrentAnalysisData.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void removeAnalysisData(ISpssVariable iSpssVariable) {
        this.removeAnalysisData(this.getAnalysisData(iSpssVariable));
    }

    public AnalysisData getAnalysisData(ISpssVariable iSpssVariable) {
        for (AnalysisData analysisData : this.mAnalysisDataList) {
            if (analysisData.getSpssVariable().getId() != iSpssVariable.getId()) continue;
            return analysisData;
        }
        return null;
    }

    public void removeAll() {
        this.mAnalysisDataList.clear();
        int n = this.mCurrentAnalysisData.size();
        if (n > 0) {
            this.mCurrentAnalysisData.clear();
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    public List<ISpssVariable> getSPSSVars() {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (AnalysisData analysisData : this.mAnalysisDataList) {
            arrayList.add(analysisData.getSpssVariable());
        }
        return arrayList;
    }

    @Override
    public int getRowCount() {
        return this.mCurrentAnalysisData != null ? this.mCurrentAnalysisData.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int n) {
        return this.mColumnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        AnalysisData analysisData = this.mCurrentAnalysisData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = analysisData != null ? analysisData.getSpssVariable() : null;
                break;
            }
            case 1: {
                object = analysisData != null ? analysisData.getHistogramImage() : null;
                break;
            }
            case 2: {
                object = analysisData != null ? analysisData.getMinimum() : null;
                break;
            }
            case 3: {
                object = analysisData != null ? analysisData.getMaximum() : null;
                break;
            }
            case 4: {
                object = this.mRulesTableModel.getRulesCount(analysisData.getSpssVariable());
                break;
            }
        }
        return object;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    private VisibleVars getVarType(ISpssVariable iSpssVariable) {
        if (iSpssVariable.getType() > 0) {
            return VisibleVars.eSTRING;
        }
        if (iSpssVariable.getType() == 0) {
            if (iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) {
                return VisibleVars.eDATE;
            }
            return VisibleVars.eNUMERIC;
        }
        return null;
    }

    static enum VisibleVars {
        eALL,
        eNUMERIC,
        eSTRING,
        eDATE;

    }
}

