/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.unusual_cases;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.validatedata.unusual_cases.IdUnusualCasesDlg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VariablesTab
extends BaseProcedureTab
implements ListDataListener {
    private static final String IDS_ANALYSIS_VARIABLES_LIST = "IDS_ANALYSIS_VARIABLES_LIST";
    private SrcVariableList mVarList;
    private TargetVariableList mTargetList;
    private TargetVariableList mCaseIdentifierList;
    private ArrowButton mAnalysisArrowButton;
    private ArrowButton mCaseIdentifyArrowButton;
    private JTextArea measurementLabel;

    public VariablesTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.checkEnableOKPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.checkEnableOKPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.checkEnableOKPaste();
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetList.removeAll();
        this.mCaseIdentifierList.removeAll();
        this.mVarList.getModel().removeAll();
        this.mVarList.loadFromActiveDataset();
        this.mVarList.setSelectedIndex(0);
        this.mVarList.requestFocus();
        ((IdUnusualCasesDlg)this.mParent).enableOkPaste(false);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_page_unus_variables";
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VariablesTab.this.mVarList.requestFocus();
                if (VariablesTab.this.mVarList.getSelectedIndex() == -1) {
                    VariablesTab.this.mVarList.setSelectedIndex(0);
                }
            }
        });
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.mVarList.loadFromActiveDataset();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_VARIABLES");
        jLabel.setLabelFor(this.mVarList);
        int n = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n, n, insets.bottom, insets.right);
        int n2 = 23;
        DialogUtil.setupNoSize(gridBagConstraints);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        JScrollPane jScrollPane = new JScrollPane(this.mVarList);
        jScrollPane.setSize(this.mVarList.getPreferredSize());
        insets2 = new Insets(insets.top, n, insets.bottom, insets.right);
        n2 = 23;
        DialogUtil.setupBothFill(gridBagConstraints, 0.5, 1.0);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 1, 1, 3, n2, insets2);
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        n2 = 10;
        DialogUtil.setupNoSize(gridBagConstraints);
        DialogUtil.addUsingGBL(this, this.mAnalysisArrowButton, gridBagConstraints, 1, 1, 1, 1, n2, insets3);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_ANALYSIS_VARIABLES");
        jLabel2.setLabelFor(this.mTargetList);
        insets2 = new Insets(n, insets.left, insets.bottom, insets.right);
        n2 = 23;
        DialogUtil.setupNoSize(gridBagConstraints);
        DialogUtil.addUsingGBL(this, jLabel2, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        jScrollPane = new JScrollPane(this.mTargetList);
        jScrollPane.setPreferredSize(this.mTargetList.getMinimumSize());
        n2 = 23;
        DialogUtil.setupBothFill(gridBagConstraints, 0.5, 1.0);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_CASE_IDENTIFIER_VARIABLES");
        jLabel3.setLabelFor(this.mCaseIdentifierList);
        insets2 = new Insets(n, insets.left, 0, insets.right);
        n2 = 23;
        DialogUtil.setupNoSize(gridBagConstraints);
        DialogUtil.addUsingGBL(this, jLabel3, gridBagConstraints, 2, 2, 1, 1, n2, insets2);
        jScrollPane = new JScrollPane(this.mCaseIdentifierList);
        jScrollPane.setPreferredSize(this.mCaseIdentifierList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        n2 = 20;
        DialogUtil.setupHorizontalFill(gridBagConstraints, 0.5, 0.0);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 2, 3, 1, 1, n2, insets);
        n2 = 20;
        DialogUtil.setupNoSize(gridBagConstraints);
        DialogUtil.addUsingGBL(this, this.mCaseIdentifyArrowButton, gridBagConstraints, 1, 2, 1, 2, n2, insets);
        this.measurementLabel = this.createMeasurementLabel();
        insets2 = new Insets(insets.top, n, insets.bottom, insets.right);
        n2 = 23;
        DialogUtil.setupHorizontalFill(gridBagConstraints, 0.0, 0.0);
        DialogUtil.addUsingGBL(this, this.measurementLabel, gridBagConstraints, 0, 4, 1, 1, n2, insets2);
        this.mAnalysisArrowButton.registerVariableList(this.mVarList, SpssArrowButton.ButtonOrientation.right);
        this.mAnalysisArrowButton.registerVariableList(this.mTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mCaseIdentifyArrowButton.registerVariableList(this.mVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCaseIdentifyArrowButton.registerVariableList(this.mCaseIdentifierList, SpssArrowButton.ButtonOrientation.left);
        this.setTabTraversal();
    }

    private JTextArea createMeasurementLabel() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setPreferredSize(new Dimension(this.mVarList.getMinimumSize().width, 60));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(true);
        jTextArea.setEditable(false);
        jTextArea.setEnabled(true);
        jTextArea.setText(this.getResString("IDS_MEASUREMENT_LABELS"));
        return jTextArea;
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mVarList;
    }

    VarListModel getTargetListModel() {
        return this.mTargetList.getModel();
    }

    VarListModel getSourceListModel() {
        return this.mVarList.getModel();
    }

    VarListModel getCaseIdentifierModel() {
        return this.mCaseIdentifierList.getModel();
    }

    private void initVars() {
        this.mVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetList = new TargetVariableList();
        this.mTargetList.setIdentifier(IDS_ANALYSIS_VARIABLES_LIST);
        this.mTargetList.getModel().addListDataListener(this);
        this.mCaseIdentifierList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mAnalysisArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCaseIdentifyArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVarList.setContextMenuFlags(15);
    }

    private void setTabTraversal() {
        this.mComponentOrder.clear();
        this.addToComponentOrder(this.mVarList);
        this.addToComponentOrder(this.measurementLabel);
        this.addToComponentOrder(this.mAnalysisArrowButton);
        this.addToComponentOrder(this.mCaseIdentifyArrowButton);
        this.addToComponentOrder(this.mTargetList);
        this.addToComponentOrder(this.mCaseIdentifierList);
        for (Component component : ((BaseTabbedDialog)this.mParent).getCmdButtonPanel().getComponents()) {
            this.addToComponentOrder(component);
        }
    }

    private void checkEnableOKPaste() {
        ((IdUnusualCasesDlg)this.mParent).enableOkPaste(this.mTargetList.getModel().getSize() > 0);
    }
}

