/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.unusual_cases;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.validatedata.unusual_cases.IdUnusualCasesDlg;
import com.spss.java_client.ui.dialogs.validatedata.unusual_cases.ReplaceDuplicateVarDlg;
import com.spss.uitools.util.TraceSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

public class SaveTab
extends BaseProcedureTab
implements ItemListener {
    static final String UNUSUAL_SAVE_FILE_EDIT = "IDS_UNUSUAL_SAVE_FILE_EDIT";
    static final String UNUSUAL_SAVE_REASON_EDIT = "IDS_UNUSUAL_SAVE_REASON_EDIT";
    static final String UNUSUAL_SAVE_PEER_EDIT = "IDS_UNUSUAL_SAVE_PEER_EDIT";
    static final String UNUSUAL_SAVE_ANOMALY_EDIT = "IDS_UNUSUAL_SAVE_ANOMALY_EDIT";
    static final String REASON_EDIT_DEFAULT = "Reason";
    static final String PEER_EDIT_DEFAULT = "Peer";
    static final String ANOMALY_EDIT_DEFAULT = "AnomalyIndex";
    static final String PEER_GROUPS_CHECK = "IDS_PEER_GROUPS_CHECK";
    static final String ANOMALY_INDEX_CHECK = "IDS_ANOMALY_INDEX_CHECK";
    static final String REASONS_CHECK = "IDS_REASONS_CHECK";
    static final String REPLACE_CHECK = "IDS_REPLACE_CHECK";
    private static final String NORM = "Norm";
    private static final String VALUE = "Value";
    private static final String MEASURE = "Measure";
    private static final String VAR = "Var";
    private static final String PCT_SIZE = "PctSize";
    private static final String SIZE = "Size";
    private static final String ID = "Id";
    private static final String EMPTY_STR = "";
    private JCheckBox mAnomalyIndexCheck;
    private JCheckBox mPeerGroupsCheck;
    private JCheckBox mReasonsCheck;
    private JCheckBox mReplaceCheck;
    private StringTextField mAnomalyNameText;
    private StringTextField mPeerRootNameText;
    private StringTextField mReasonRootNameText;
    private FileTextField mFileText;
    private JLabel mAnomalyNameLabel;
    private JLabel mPeerRootNameLabel;
    private JLabel mReasonRootNameLabel;
    private JTextArea mAnomalyIndexLabel;
    private JTextArea mPeerGroupsLabel;
    private JTextArea mReasonsLabel;
    private JButton mBrowseButton;
    private String mDropStringForSyntax;
    private static final String XML_FILE_EXT = ".xml";

    public SaveTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mAnomalyNameText.setEnabled(this.mAnomalyIndexCheck.isSelected());
        this.mAnomalyNameText.setOpaque(this.mAnomalyIndexCheck.isSelected());
        this.mAnomalyNameLabel.setEnabled(this.mAnomalyIndexCheck.isSelected());
        this.mPeerRootNameText.setEnabled(this.mPeerGroupsCheck.isSelected());
        this.mPeerRootNameText.setOpaque(this.mPeerGroupsCheck.isSelected());
        this.mPeerRootNameLabel.setEnabled(this.mPeerGroupsCheck.isSelected());
        this.mReasonRootNameText.setEnabled(this.mReasonsCheck.isSelected());
        this.mReasonRootNameText.setOpaque(this.mReasonsCheck.isSelected());
        this.mReasonRootNameLabel.setEnabled(this.mReasonsCheck.isSelected());
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.mAnomalyIndexCheck.setSelected(false);
        this.mPeerGroupsCheck.setSelected(false);
        this.mReasonsCheck.setSelected(false);
        this.mReplaceCheck.setSelected(false);
        this.mFileText.setText(EMPTY_STR);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_page_unus_save";
    }

    void setReplaceCheck(boolean bl) {
        this.mReplaceCheck.setSelected(bl);
    }

    void setReasonEnable(boolean bl) {
        this.mReasonsCheck.setEnabled(bl);
    }

    JCheckBox getReasonCheck() {
        return this.mReasonsCheck;
    }

    void setReasonNameLabel(boolean bl) {
        this.mReasonRootNameText.setEnabled(bl);
        this.mReasonRootNameLabel.setEnabled(bl);
    }

    String getDropStringForSyntax() {
        return this.mDropStringForSyntax;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = this.setupSaveVariablePanel();
        Insets insets2 = new Insets(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JPanel jPanel2 = this.setupExportPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setTabTraversal();
    }

    @Override
    protected boolean validateTab() {
        boolean bl = super.validateTab();
        String string = ((BaseProcedureDialog)this.mParent).getDialogDataModel().getString("IDS_UNUSUAL_OPTIONS_MAX_REASONS_EDIT");
        if (string != null && string.length() > 0) {
            boolean bl2 = Integer.parseInt(string) == 0;
            this.mReasonsCheck.setEnabled(!bl2);
            if (this.mReasonsCheck.isSelected() && this.mReasonsCheck.isEnabled()) {
                this.mReasonRootNameText.setEnabled(true);
                this.mReasonRootNameLabel.setEnabled(true);
            }
        }
        if (this.mAnomalyIndexCheck.isSelected() && !(bl = this.validateName(this.mAnomalyNameText.getText()))) {
            this.mAnomalyNameText.requestFocus();
            this.mAnomalyNameText.selectAll();
        }
        if (bl && this.mPeerGroupsCheck.isSelected() && !(bl = this.validateName(this.mPeerRootNameText.getText()))) {
            this.mPeerRootNameText.requestFocus();
            this.mPeerRootNameText.selectAll();
        }
        if (bl && this.mReasonsCheck.isSelected() && !(bl = this.validateName(this.mReasonRootNameText.getText()))) {
            this.mReasonRootNameText.requestFocus();
            this.mReasonRootNameText.selectAll();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl3 = false;
        String string2 = this.mPeerRootNameText.getText() + ID;
        String string3 = this.mPeerRootNameText.getText() + SIZE;
        String string4 = this.mPeerRootNameText.getText() + PCT_SIZE;
        if (this.mPeerGroupsCheck.isSelected() && this.isVariableExist(string2) && this.isVariableExist(string3) && this.isVariableExist(string4)) {
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            bl3 = true;
        }
        String string5 = this.mReasonRootNameText.getText() + VAR + "_1";
        String string6 = this.mReasonRootNameText.getText() + MEASURE + "_1";
        String string7 = this.mReasonRootNameText.getText() + VALUE + "_1";
        String string8 = this.mReasonRootNameText.getText() + NORM + "_1";
        if (this.mReasonsCheck.isSelected() && this.isVariableExist(string5) && this.isVariableExist(string6) && this.isVariableExist(string7) && this.isVariableExist(string8)) {
            arrayList.add(string5);
            arrayList.add(string6);
            arrayList.add(string7);
            arrayList.add(string8);
            bl3 = true;
        }
        String string9 = this.mAnomalyNameText.getText();
        if (this.mAnomalyIndexCheck.isSelected() && this.isVariableExist(string9)) {
            arrayList.add(string9);
            bl3 = true;
        }
        if (bl && bl3) {
            if (!this.mReplaceCheck.isSelected()) {
                ReplaceDuplicateVarDlg replaceDuplicateVarDlg = new ReplaceDuplicateVarDlg(this.mParent, this.getResString("IDS_IDENTIFY_UNUSUAL_CASES"), true, arrayList);
                if (replaceDuplicateVarDlg.isOKPressed()) {
                    this.generateDropSyntax(arrayList);
                } else {
                    bl = false;
                }
            } else {
                this.generateDropSyntax(arrayList);
            }
        }
        arrayList.clear();
        if (bl) {
            bl = FileValidator.validatePath(this, this.mFileText.getText(), true, true);
        }
        return bl;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        String string = ((BaseProcedureDialog)this.mParent).getDialogDataModel().getString("IDS_UNUSUAL_OPTIONS_MAX_REASONS_EDIT");
        if (string != null && string.length() > 0) {
            boolean bl = Integer.parseInt(string) == 0;
            this.mReasonsCheck.setEnabled(!bl);
            boolean bl2 = this.mReasonsCheck.isSelected() && this.mReasonsCheck.isEnabled();
            this.mReasonRootNameText.setEnabled(bl2);
            this.mReasonRootNameLabel.setEnabled(bl2);
        }
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mAnomalyIndexCheck;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, ANOMALY_INDEX_CHECK);
        this.mAnomalyIndexCheck = new JCheckBox(toggleButtonAction);
        this.mAnomalyIndexCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, PEER_GROUPS_CHECK);
        this.mPeerGroupsCheck = new JCheckBox(toggleButtonAction);
        this.mPeerGroupsCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, REASONS_CHECK);
        this.mReasonsCheck = new JCheckBox(toggleButtonAction);
        this.mReasonsCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, REPLACE_CHECK);
        this.mReplaceCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mAnomalyIndexCheck);
        spssButtonGroup.add(this.mPeerGroupsCheck);
        spssButtonGroup.add(this.mReasonsCheck);
        spssButtonGroup.add(this.mReplaceCheck);
        this.mAnomalyNameText = new StringTextField(15);
        this.mAnomalyNameText.setAction(new TextFieldAction(this.mParent, UNUSUAL_SAVE_ANOMALY_EDIT));
        this.mPeerRootNameText = new StringTextField(15);
        this.mPeerRootNameText.setAction(new TextFieldAction(this.mParent, UNUSUAL_SAVE_PEER_EDIT));
        this.mReasonRootNameText = new StringTextField(15);
        this.mReasonRootNameText.setAction(new TextFieldAction(this.mParent, UNUSUAL_SAVE_REASON_EDIT));
        this.mFileText = new FileTextField();
        this.mFileText.setColumns(20);
        this.mFileText.setAction(new TextFieldAction(this.mParent, UNUSUAL_SAVE_FILE_EDIT));
        this.mAnomalyNameLabel = DialogUtil.createLabel(this.mParent, "IDS_ANOMALY_NAME_LABEL");
        this.mPeerRootNameLabel = DialogUtil.createLabel(this.mParent, "IDS_PEER_ROOT_NAME_LABEL");
        this.mReasonRootNameLabel = DialogUtil.createLabel(this.mParent, "IDS_REASONS_ROOT_NAME_LABEL");
        this.mAnomalyIndexLabel = new JTextArea(this.getResString("IDS_ANOMALY_INDEX_LABEL"));
        this.mAnomalyIndexLabel.setPreferredSize(new Dimension(150, 20));
        this.mAnomalyIndexLabel.addFocusListener(this);
        this.mAnomalyIndexLabel.setLineWrap(true);
        this.mAnomalyIndexLabel.setWrapStyleWord(true);
        this.mAnomalyIndexLabel.setBorder(null);
        this.mAnomalyIndexLabel.setOpaque(false);
        this.mAnomalyIndexLabel.setEditable(false);
        this.mAnomalyIndexLabel.setFocusable(true);
        this.mAnomalyIndexLabel.setEnabled(true);
        this.mPeerGroupsLabel = new JTextArea(this.getResString("IDS_PEER_GROUPS_LABEL"));
        this.mPeerGroupsLabel.setPreferredSize(new Dimension(150, 40));
        this.mPeerGroupsLabel.addFocusListener(this);
        this.mPeerGroupsLabel.setLineWrap(true);
        this.mPeerGroupsLabel.setWrapStyleWord(true);
        this.mPeerGroupsLabel.setBorder(null);
        this.mPeerGroupsLabel.setOpaque(false);
        this.mPeerGroupsLabel.setEditable(false);
        this.mPeerGroupsLabel.setFocusable(true);
        this.mPeerGroupsLabel.setEnabled(true);
        this.mReasonsLabel = new JTextArea(this.getResString("IDS_REASONS_LABEL"));
        this.mReasonsLabel.setPreferredSize(new Dimension(150, 45));
        this.mReasonsLabel.addFocusListener(this);
        this.mReasonsLabel.setLineWrap(true);
        this.mReasonsLabel.setWrapStyleWord(true);
        this.mReasonsLabel.setBorder(null);
        this.mReasonsLabel.setOpaque(false);
        this.mReasonsLabel.setEditable(false);
        this.mReasonsLabel.setFocusable(true);
        this.mReasonsLabel.setEnabled(true);
        this.mDropStringForSyntax = EMPTY_STR;
        this.setDefaults();
    }

    private JPanel setupSaveVariablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SAVE_VARIABLES")));
        this.mAnomalyNameLabel.setLabelFor((Component)((Object)this.mAnomalyNameText));
        this.mPeerRootNameLabel.setLabelFor((Component)((Object)this.mPeerRootNameText));
        this.mReasonRootNameLabel.setLabelFor((Component)((Object)this.mReasonRootNameText));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = new Insets(n2, n2, n2, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mAnomalyIndexCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mAnomalyNameLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mAnomalyNameText), gridBagConstraints, 2, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        insets2.left = n2 * 2;
        DialogUtil.addUsingGBL(jPanel, this.mAnomalyIndexLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.left = n2;
        DialogUtil.addUsingGBL(jPanel, this.mPeerGroupsCheck, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mPeerRootNameLabel, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mPeerRootNameText), gridBagConstraints, 2, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.left = n2 * 2;
        DialogUtil.addUsingGBL(jPanel, this.mPeerGroupsLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        insets2.left = n2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mReasonsCheck, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mReasonRootNameLabel, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mReasonRootNameText), gridBagConstraints, 2, 4, 1, 1, n, insets2);
        insets2.left = n2 * 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mReasonsLabel, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        JSeparator jSeparator = new JSeparator(0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        Insets insets3 = new Insets(n2, n2, 0, n2);
        insets2.left = n2;
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 6, 3, 1, n, insets3);
        insets2.left = n2;
        insets2.top = n2 * 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mReplaceCheck, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        return jPanel;
    }

    private void setTabTraversal() {
        this.mComponentOrder.clear();
        this.addToComponentOrder(this.mAnomalyIndexCheck);
        this.addToComponentOrder(this.mAnomalyNameText);
        this.addToComponentOrder(this.mAnomalyNameLabel);
        this.addToComponentOrder(this.mAnomalyIndexLabel);
        this.addToComponentOrder(this.mPeerGroupsCheck);
        this.addToComponentOrder(this.mPeerRootNameText);
        this.addToComponentOrder(this.mPeerRootNameLabel);
        this.addToComponentOrder(this.mPeerGroupsLabel);
        this.addToComponentOrder(this.mReasonsCheck);
        this.addToComponentOrder(this.mReasonRootNameText);
        this.addToComponentOrder(this.mReasonRootNameLabel);
        this.addToComponentOrder(this.mReasonsLabel);
        this.addToComponentOrder(this.mReplaceCheck);
        this.addToComponentOrder(this.mFileText);
        this.addToComponentOrder(this.mBrowseButton);
        for (Component component : this.mParent.getCmdButtonPanel().getComponents()) {
            this.addToComponentOrder(component);
        }
    }

    private JPanel setupExportPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXPORT_MODEL_FILE")));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_FILE_LABEL");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        jLabel.setLabelFor((Component)((Object)this.mFileText));
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileText), gridBagConstraints, 1, 0, 1, 1, n, insets);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_BROWSE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DataServerProxy.getDataProxy().isRemoteConnection();
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), bl);
                remoteFileChooser.setDialogTitle(SaveTab.this.getResString("IDS_FILE_CHOOSER_TITLE"));
                RefFileFilter refFileFilter = new RefFileFilter(SaveTab.this.getResString("IDS_FILE_CHOOSER_FILE_DESC"), SaveTab.this.getResString("IDS_FILE_CHOOSER_FILE_EXT"));
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                int n = remoteFileChooser.showSaveDialog((Component)SaveTab.this.mParent);
                if (n == 0) {
                    FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = remoteFileChooser.getSelectedFilePath();
                    if (!SaveTab.XML_FILE_EXT.regionMatches(true, 0, string, string.length() - SaveTab.XML_FILE_EXT.length(), SaveTab.XML_FILE_EXT.length())) {
                        string = string + SaveTab.XML_FILE_EXT;
                    }
                    SaveTab.this.mFileText.setText(string);
                } else {
                    TraceSettings.trace1((String)"No Selection", (int)15);
                }
            }
        };
        this.mBrowseButton = new JButton(toggleButtonAction);
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = new Insets(-3, insets.left, insets.bottom + 2, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private void setDefaults() {
        this.mAnomalyNameText.setEnabled(false);
        this.mAnomalyNameText.setOpaque(false);
        this.mAnomalyNameText.setText(ANOMALY_EDIT_DEFAULT);
        this.mPeerRootNameText.setEnabled(false);
        this.mPeerRootNameText.setOpaque(false);
        this.mPeerRootNameText.setText(PEER_EDIT_DEFAULT);
        this.mReasonRootNameText.setEnabled(false);
        this.mReasonRootNameText.setOpaque(false);
        this.mReasonRootNameText.setText(REASON_EDIT_DEFAULT);
        this.mAnomalyNameLabel.setEnabled(false);
        this.mPeerRootNameLabel.setEnabled(false);
        this.mReasonRootNameLabel.setEnabled(false);
    }

    private boolean validateName(String string) {
        boolean bl;
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        boolean bl2 = bl = n == 0 || n == 100;
        if (!bl) {
            DialogUtil.showBadSpssVarNameWarning(n, this.mParent);
        }
        return bl;
    }

    private boolean isVariableExist(String string) {
        VarListModel varListModel = ((IdUnusualCasesDlg)this.mParent).getVariablestab().getSourceListModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            if (!varListModel.getElementAt(i).getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void generateDropSyntax(ArrayList<String> arrayList) {
        this.mReplaceCheck.setSelected(true);
        this.mDropStringForSyntax = "DELETE VARIABLES ";
        for (String string : arrayList) {
            this.mDropStringForSyntax = this.mDropStringForSyntax + string + " ";
        }
        this.mDropStringForSyntax = this.mDropStringForSyntax.trim() + ".";
    }
}

