/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.unusual_cases;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.util.AccessibilityUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.text.Document;

public class OptionsTab
extends BaseProcedureTab
implements ItemListener {
    static final String UNUSUAL_OPTIONS_PERCENT_CASES_RADIO = "IDS_UNUSUAL_OPTIONS_PERCENT_CASES_RADIO";
    static final String UNUSUAL_OPTIONS_FIXED_RADIO = "IDS_UNUSUAL_OPTIONS_FIXED_RADIO";
    static final String UNUSUAL_OPTIONS_IDENTIFY_CHECK = "IDS_UNUSUAL_OPTIONS_IDENTIFY_CHECK";
    static final String UNUSUAL_OPTIONS_PERCENT_EDIT = "IDS_UNUSUAL_OPTIONS_PERCENT_EDIT";
    static final String UNUSUAL_OPTIONS_NUMBER_EDIT = "IDS_UNUSUAL_OPTIONS_NUMBER_EDIT";
    static final String UNUSUAL_OPTIONS_CUTOFF_EDIT = "IDS_UNUSUAL_OPTIONS_CUTOFF_EDIT";
    static final String UNUSUAL_OPTIONS_MAX_REASONS_EDIT = "IDS_UNUSUAL_OPTIONS_MAX_REASONS_EDIT";
    static final String UNUSUAL_OPTIONS_MIN_EDIT = "IDS_UNUSUAL_OPTIONS_MIN_EDIT";
    static final String UNUSUAL_OPTIONS_MAX_EDIT = "IDS_UNUSUAL_OPTIONS_MAX_EDIT";
    static final int PERCENTAGE_EDIT_DEFAULT = 5;
    static final int CUTOFF_EDIT_DEFAULT = 2;
    static final int REASONS_EDIT_DEFAULT = 1;
    static final int MINIMUM_EDIT_DEFAULT = 1;
    static final int MAXIMUM_EDIT_DEFAULT = 15;
    private JRadioButton mPercentageRadio;
    private JRadioButton mFixedRadio;
    private JCheckBox mIdentifyCheck;
    private FloatTextField mPercentageEdit;
    private IntTextField mNumberEdit;
    private FloatTextField mCutoffEdit;
    private IntTextField mReasonsEdit;
    private IntTextField mMaximumEdit;
    private IntTextField mMinimumEdit;
    private JLabel mNumberLabel;
    private JLabel mCutoffLabel;
    private JLabel mPercentageLabel;
    private JLabel mSpecifyLabel;
    private SpssButtonGroup mButtonGroup;

    public OptionsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mNumberLabel.setEnabled(this.mFixedRadio.isSelected());
        this.mNumberEdit.setEnabled(this.mFixedRadio.isSelected());
        this.mNumberEdit.setOpaque(this.mFixedRadio.isSelected());
        this.mCutoffLabel.setEnabled(this.mIdentifyCheck.isSelected());
        this.mCutoffEdit.setEnabled(this.mIdentifyCheck.isSelected());
        this.mCutoffEdit.setOpaque(this.mIdentifyCheck.isSelected());
        this.mPercentageEdit.setEnabled(this.mPercentageRadio.isSelected());
        this.mPercentageEdit.setOpaque(this.mPercentageRadio.isSelected());
        this.mPercentageLabel.setEnabled(this.mPercentageRadio.isSelected());
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.mNumberEdit.setText("");
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_page_unus_options";
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, this.setupCriteriaPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.setupPeerGroupsPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.setupReasonsPanel(), gridBagConstraints, 0, 2, 2, 1, n, null);
        this.setTabTraversal();
    }

    @Override
    protected boolean validateTab() {
        int n;
        int n2;
        boolean bl = super.validateTab();
        int n3 = this.mMinimumEdit.getText().length() == 0 ? 0 : Integer.parseInt(this.mMinimumEdit.getText());
        int n4 = this.mMaximumEdit.getText().length() == 0 ? 0 : Integer.parseInt(this.mMaximumEdit.getText());
        float f = this.mCutoffEdit.getText().length() == 0 ? 0.0f : Float.parseFloat(this.mCutoffEdit.getText());
        int n5 = n2 = this.mNumberEdit.getText().length() == 0 ? 0 : Integer.parseInt(this.mNumberEdit.getText());
        if (this.mFixedRadio.isSelected() && n2 == 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_UNUSUAL_OPTIONS_INTEGER_ERROR"), VersionInfo.getAppVersionString());
            this.mNumberEdit.requestFocus();
            this.mNumberEdit.selectAll();
            bl = false;
        } else if (this.mPercentageRadio.isSelected() && this.mPercentageEdit.getText().length() == 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_UNUSUAL_OPTIONS_PERCENTAGE_ERROR"), VersionInfo.getAppVersionString());
            this.mPercentageEdit.requestFocus();
            this.mPercentageEdit.selectAll();
            bl = false;
        } else if (this.mIdentifyCheck.isSelected() && f == 0.0f) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_UNUSUAL_OPTIONS_CUTOFF_ERROR"), VersionInfo.getAppVersionString());
            this.mCutoffEdit.requestFocus();
            this.mCutoffEdit.selectAll();
            bl = false;
        } else if (this.mReasonsEdit.getText().length() == 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_UNUSUAL_OPTIONS_REASON_ERROR"), VersionInfo.getAppVersionString());
            this.mReasonsEdit.requestFocus();
            bl = false;
        } else if (this.mReasonsEdit.getText().length() > 0 && (n = Integer.parseInt(this.mReasonsEdit.getText())) > 100) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_UNUSUAL_OPTIONS_MAX_REASON_ERROR"), VersionInfo.getAppVersionString());
            this.mReasonsEdit.requestFocus();
            this.mReasonsEdit.selectAll();
            bl = false;
        }
        if (bl && n3 == 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_UNUSUAL_OPTIONS_INTEGER_ERROR"), VersionInfo.getAppVersionString());
            this.mMinimumEdit.requestFocus();
            this.mMinimumEdit.selectAll();
            bl = false;
        }
        if (bl && n4 == 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_UNUSUAL_OPTIONS_INTEGER_ERROR"), VersionInfo.getAppVersionString());
            this.mMaximumEdit.requestFocus();
            this.mMaximumEdit.selectAll();
            bl = false;
        }
        if (bl && n3 > n4) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_UNUSUAL_OPTIONS_MINMAX_ERROR"), VersionInfo.getAppVersionString());
            this.mMinimumEdit.requestFocus();
            this.mMinimumEdit.selectAll();
            bl = false;
        }
        return bl;
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mPercentageRadio;
    }

    private void setDefaults() {
        this.mPercentageRadio.setSelected(true);
        this.mPercentageEdit.setText(Integer.toString(5));
        this.mCutoffEdit.setText(Integer.toString(2));
        this.mReasonsEdit.setText(Integer.toString(1));
        this.mMinimumEdit.setText(Integer.toString(1));
        this.mMaximumEdit.setText(Integer.toString(15));
        this.mNumberLabel.setEnabled(false);
        this.mNumberEdit.setEnabled(false);
        this.mNumberEdit.setOpaque(false);
        this.mIdentifyCheck.setSelected(true);
    }

    private void setTabTraversal() {
        this.mComponentOrder.clear();
        this.addToComponentOrder(this.mButtonGroup);
        this.addToComponentOrder(this.mPercentageEdit);
        this.addToComponentOrder(this.mNumberEdit);
        this.addToComponentOrder(this.mIdentifyCheck);
        this.addToComponentOrder(this.mCutoffEdit);
        this.addToComponentOrder(this.mMinimumEdit);
        this.addToComponentOrder(this.mMaximumEdit);
        this.addToComponentOrder(this.mReasonsEdit);
        this.addToComponentOrder(this.mSpecifyLabel);
        for (Component component : this.mParent.getCmdButtonPanel().getComponents()) {
            this.addToComponentOrder(component);
        }
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, UNUSUAL_OPTIONS_PERCENT_CASES_RADIO);
        this.mPercentageRadio = new SpssMultiLineRadioButton(toggleButtonAction);
        AccessibilityUtil.setAccessibleText((Component)this.mPercentageRadio, (Object)this.mPercentageRadio.getText());
        toggleButtonAction = new ToggleButtonAction(this.mParent, UNUSUAL_OPTIONS_FIXED_RADIO);
        this.mFixedRadio = new SpssMultiLineRadioButton(toggleButtonAction);
        AccessibilityUtil.setAccessibleText((Component)this.mFixedRadio, (Object)this.mFixedRadio.getText());
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mPercentageRadio);
        this.mButtonGroup.add(this.mFixedRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, UNUSUAL_OPTIONS_IDENTIFY_CHECK);
        this.mIdentifyCheck = new SpssMultiLineCheckBox(toggleButtonAction);
        this.mPercentageLabel = DialogUtil.createLabel(this.mParent, "IDS_UNUSUAL_OPTIONS_PERCENT_COLON");
        this.mPercentageEdit = new FloatTextField(0.0, 100.0, 6, true);
        this.mPercentageEdit.setAction((Action)new TextFieldAction(this.mParent, UNUSUAL_OPTIONS_PERCENT_EDIT));
        this.mPercentageEdit.setColumns(8);
        this.mNumberLabel = DialogUtil.createLabel(this.mParent, "IDS_UNUSUAL_OPTIONS_NUMBER");
        this.mNumberEdit = new IntTextField(true);
        this.mNumberEdit.setDocument((Document)new FixedLengthNumericDocument(8, true, false));
        this.mNumberEdit.setAction((Action)new TextFieldAction(this.mParent, UNUSUAL_OPTIONS_NUMBER_EDIT));
        this.mNumberEdit.setColumns(8);
        this.mCutoffLabel = DialogUtil.createLabel(this.mParent, "IDS_UNUSUAL_OPTIONS_CUTOFF_COLON");
        this.mCutoffEdit = new FloatTextField(true);
        this.mCutoffEdit.setDocument((Document)new FixedLengthNumericDocument(8, true, true));
        this.mCutoffEdit.setAction((Action)new TextFieldAction(this.mParent, UNUSUAL_OPTIONS_CUTOFF_EDIT));
        this.mCutoffEdit.setColumns(8);
        this.mReasonsEdit = new IntTextField(true);
        this.mReasonsEdit.setAction((Action)new TextFieldAction(this.mParent, UNUSUAL_OPTIONS_MAX_REASONS_EDIT));
        this.mReasonsEdit.setDocument((Document)new FixedLengthNumericDocument(8, true, false));
        this.mReasonsEdit.setColumns(8);
        this.mMinimumEdit = new IntTextField(true);
        this.mMinimumEdit.setAction((Action)new TextFieldAction(this.mParent, UNUSUAL_OPTIONS_MIN_EDIT));
        this.mMinimumEdit.setDocument((Document)new FixedLengthNumericDocument(8, true, false));
        this.mMinimumEdit.setColumns(8);
        this.mMaximumEdit = new IntTextField(true);
        this.mMaximumEdit.setAction((Action)new TextFieldAction(this.mParent, UNUSUAL_OPTIONS_MAX_EDIT));
        this.mMaximumEdit.setDocument((Document)new FixedLengthNumericDocument(8, true, false));
        this.mMaximumEdit.setColumns(8);
        this.mFixedRadio.addItemListener(this);
        this.mPercentageRadio.addItemListener(this);
        this.mIdentifyCheck.addItemListener(this);
        this.mSpecifyLabel = DialogUtil.createMultiLineLabel(this.mParent, "IDS_UNUSUAL_OPTIONS_SPECIFY_TEXT", 680);
        AccessibilityUtil.setAccessibleText((Component)this.mSpecifyLabel, (Object)((SpssMultiLineLabel)this.mSpecifyLabel).getLabelText());
        this.mSpecifyLabel.setLabelFor((Component)this.mReasonsEdit);
        this.setDefaults();
    }

    private JPanel setupCriteriaPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_UNUSUAL_OPTIONS_CRITERIA_CAPTION")));
        this.mPercentageLabel.setLabelFor((Component)this.mPercentageEdit);
        this.mNumberLabel.setLabelFor((Component)this.mNumberEdit);
        this.mCutoffLabel.setLabelFor((Component)this.mCutoffEdit);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_UNUSUAL_OPTIONS_MAX_REASONS_COLON");
        jLabel.setLabelFor((Component)this.mReasonsEdit);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mPercentageRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n2, n2 * 2, insets.bottom, insets.right);
        Insets insets3 = new Insets(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mPercentageLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPercentageEdit, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mFixedRadio, gridBagConstraints, 0, 2, 2, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mNumberLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberEdit, gridBagConstraints, 1, 3, 1, 1, n, insets3);
        JSeparator jSeparator = new JSeparator(0);
        gridBagConstraints.fill = 2;
        Insets insets4 = new Insets(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 4, 2, 1, n, insets4);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mIdentifyCheck, gridBagConstraints, 0, 5, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCutoffLabel, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCutoffEdit, gridBagConstraints, 1, 6, 1, 1, n, insets3);
        return jPanel;
    }

    private JPanel setupPeerGroupsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_UNUSUAL_OPTIONS_NUMBER_CAPTION")));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_UNUSUAL_OPTIONS_MIN_COLON");
        jLabel.setLabelFor((Component)this.mMinimumEdit);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_UNUSUAL_OPTIONS_MAX_COLON");
        jLabel2.setLabelFor((Component)this.mMaximumEdit);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinimumEdit, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaximumEdit, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupReasonsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_UNUSUAL_OPTIONS_MAX_REASONS_COLON");
        jLabel.setLabelFor((Component)this.mReasonsEdit);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2 = new Insets(n2, n2 * 3, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mReasonsEdit, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets2 = new Insets(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSpecifyLabel, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        return jPanel;
    }
}

