/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.define_rules;

import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import com.spss.uitools.dialogs.BaseDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SingleVariableRulesTableModel
extends AbstractTableModel {
    private BaseDialog mParent;
    private List<SingleVariableRule> mRulesList = new ArrayList<SingleVariableRule>();
    private boolean sortOrderAscending = false;

    public SingleVariableRulesTableModel(BaseDialog baseDialog) {
        this.mParent = baseDialog;
    }

    public void addRule(SingleVariableRule singleVariableRule) {
        this.mRulesList.add(singleVariableRule);
        this.fireTableRowsInserted(this.mRulesList.size() - 1, this.mRulesList.size() - 1);
    }

    public void addDuplicateRule(int n) {
        String string;
        SingleVariableRule singleVariableRule = this.mRulesList.get(n);
        SingleVariableRule singleVariableRule2 = null;
        try {
            singleVariableRule2 = singleVariableRule.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        String string2 = this.getLocalizedString("IDS_DEFINE_RULES_COPY_OF_PART1");
        String string3 = this.getLocalizedString("IDS_DEFINE_RULES_COPY_OF_PART2");
        String string4 = singleVariableRule.getName();
        if (string4.startsWith(string2)) {
            string4 = string4.substring(string4.indexOf(string3) + string3.length(), string4.length());
        }
        int n2 = 0;
        while (!this.isNameUniqueAmongAllRules(string = ++n2 == 1 ? string2 + string3 + string4 : string2 + "(" + n2 + ")" + string3 + string4)) {
        }
        if (singleVariableRule2 != null) {
            singleVariableRule2.setName(string);
            this.mRulesList.add(singleVariableRule2);
            this.fireTableRowsInserted(this.mRulesList.size() - 1, this.mRulesList.size() - 1);
        }
    }

    public void addNewRule() {
        SingleVariableRule singleVariableRule = new SingleVariableRule();
        String string = this.getLocalizedString("IDS_SINGLE_VARIABLE_RULE_DEFAULT_NAME");
        int n = 0;
        for (SingleVariableRule singleVariableRule2 : this.mRulesList) {
            if (!singleVariableRule2.getName().startsWith(string)) continue;
            ++n;
        }
        Object object = string + ++n;
        while (!this.isNameUniqueAmongAllRules((String)object)) {
            object = string + ++n;
        }
        singleVariableRule.setName((String)object);
        singleVariableRule.setFlagUnlabeledValues(false);
        singleVariableRule.setFlagNonIntegerValues(false);
        singleVariableRule.setFlagUserMissingValues(false);
        singleVariableRule.setFlagSystemMissingValues(false);
        singleVariableRule.setFlagBlankValues(false);
        this.mRulesList.add(singleVariableRule);
        this.fireTableRowsInserted(this.mRulesList.size() - 1, this.mRulesList.size() - 1);
    }

    public void deleteRule(int n) {
        this.mRulesList.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void updateRuleType(int n, SingleVariableRule.Type type) {
        SingleVariableRule singleVariableRule = this.mRulesList.get(n);
        singleVariableRule.setType(type);
        this.fireTableCellUpdated(n, 1);
    }

    public void updateRuleName(int n, String string) {
        SingleVariableRule singleVariableRule = this.mRulesList.get(n);
        singleVariableRule.setName(string);
        this.fireTableCellUpdated(n, 0);
    }

    public void clear() {
        this.mRulesList.clear();
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return this.getLocalizedString("IDS_RULE_NAME_COLOUMN");
        }
        return this.getLocalizedString("IDS_RULE_TYPE_COLOUMN");
    }

    @Override
    public int getRowCount() {
        return this.mRulesList.size();
    }

    public SingleVariableRule getRule(int n) {
        if (n >= 0 && n < this.mRulesList.size()) {
            return this.mRulesList.get(n);
        }
        return null;
    }

    public List<SingleVariableRule> getRules() {
        return this.mRulesList;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SingleVariableRule singleVariableRule = this.mRulesList.get(n);
        if (n2 == 0) {
            return singleVariableRule.getName();
        }
        return this.mParent.getResString(singleVariableRule.getType().getKey());
    }

    public void refresh(int n) {
        this.fireTableRowsUpdated(n, n);
    }

    public void sort() {
        this.sortOrderAscending = !this.sortOrderAscending;
        Comparator<SingleVariableRule> comparator = new Comparator<SingleVariableRule>(){

            @Override
            public int compare(SingleVariableRule singleVariableRule, SingleVariableRule singleVariableRule2) {
                return singleVariableRule.compareTo(singleVariableRule2);
            }
        };
        if (this.sortOrderAscending) {
            Collections.sort(this.mRulesList, comparator);
        } else {
            Collections.sort(this.mRulesList, Collections.reverseOrder());
        }
        this.fireTableDataChanged();
    }

    private String getLocalizedString(String string) {
        return this.mParent.getResString(string);
    }

    private boolean isNameUniqueAmongAllRules(String string) {
        for (SingleVariableRule singleVariableRule : this.mRulesList) {
            if (!singleVariableRule.getName().equals(string)) continue;
            return false;
        }
        return true;
    }
}

