/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.define_rules;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.IRetrieveFormatCallBack;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarFormatDocument;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SpssFocusCellRenderer;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.DateFormat;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.EditableListTableModel;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRulesTableModel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SingleVariableRulesTab
extends BaseProcedureTab
implements ListSelectionListener,
MouseListener,
ActionListener,
FocusListener,
ItemListener,
TableModelListener,
IRetrieveFormatCallBack {
    private JCheckBox mAllowBlankValuesCheckBox;
    private JCheckBox mAllowIgnoreCaseValuesCheckBox;
    private JCheckBox mAllowNonintegerValuesCheckBox;
    private JCheckBox mAllowSystemMissingValuesCheckBox;
    private JCheckBox mAllowUserMissingValuesCheckBox;
    private SingleVariableRule mCurrentRule;
    private JComboBox mDateFormatsCombobox;
    private JLabel mDateFormatsLabel;
    private JButton mNewRuleButton;
    private JButton mDeleteRuleButton;
    private JButton mDuplicateRuleButton;
    private JPanel mListPanel;
    private StringTextField mMaximumField;
    private StringTextField mMinimumField;
    private JPanel mRangePanel;
    private JPanel mRuleDefinitionPanel;
    private StringTextField mRuleNameField;
    private JTable mRulesTable;
    private SingleVariableRulesTableModel mRulesTableModel;
    private RefusableComboBox mRuleTypeCombobox;
    private JComboBox mValidValuesComboBox;
    private JTextArea mValidValuesMessage;
    private JPanel mValidValuesPanel;
    private JTable mValidValuesTable;
    private EditableListTableModel mValidValuesTableModel;
    boolean mRevertingBackTable = false;
    boolean mDeletingRules = false;
    private List<CrossVariableRule> mCrossRules;
    private Map<ISpssVariable, Set<SingleVariableRule>> mVarRuleMap;
    static final int STANDARD_FONT_SIZE = 11;

    public SingleVariableRulesTab(BaseDialog baseDialog) {
        super(baseDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_page_std_rules";
    }

    public void afterPack() {
        this.mRuleNameField.setMinimumSize(this.mRuleNameField.getSize());
    }

    public void setRules(List<SingleVariableRule> list, Map<ISpssVariable, Set<SingleVariableRule>> map) {
        this.mVarRuleMap = map;
        this.mRulesTable.getSelectionModel().removeListSelectionListener(this);
        if (list.isEmpty()) {
            this.mRulesTableModel.clear();
            this.mRulesTableModel.addNewRule();
        } else {
            this.mRulesTableModel.clear();
            for (SingleVariableRule singleVariableRule : list) {
                this.mRulesTableModel.addRule(singleVariableRule);
            }
        }
        this.setCurrentRule(this.mRulesTableModel.getRule(0));
        this.mRulesTable.getSelectionModel().setSelectionInterval(0, 0);
        this.mRulesTable.getSelectionModel().addListSelectionListener(this);
    }

    public void setCrossRules(List<CrossVariableRule> list) {
        this.mCrossRules = list;
    }

    public List<SingleVariableRule> getRules() {
        return this.mRulesTableModel.getRules();
    }

    public boolean isStandardRulesApplied() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mNewRuleButton) {
            boolean bl = true;
            if (this.mCurrentRule != null) {
                bl = this.validateRule();
            }
            if (bl) {
                if (this.mRulesTableModel.getRowCount() == 0) {
                    this.mCurrentRule = null;
                }
                this.mRulesTableModel.addNewRule();
                int n = this.mRulesTableModel.getRowCount() - 1;
                this.mRulesTable.setRowSelectionInterval(n, n);
            }
        } else if (object == this.mDuplicateRuleButton) {
            if (this.validateRule() && this.mRulesTable.getSelectedRow() != -1) {
                this.setCurrentRule(this.mRulesTableModel.getRule(this.mRulesTable.getSelectedRow()));
                this.mRulesTableModel.addDuplicateRule(this.mRulesTable.getSelectedRow());
                this.mRulesTable.setRowSelectionInterval(this.mRulesTableModel.getRowCount() - 1, this.mRulesTableModel.getRowCount() - 1);
            }
        } else if (object == this.mDeleteRuleButton) {
            this.deleteRules();
        }
    }

    private void deleteRules() {
        int n = this.mRulesTable.getSelectedRow();
        if (n != -1) {
            this.mDeletingRules = true;
            this.mRulesTableModel.deleteRule(n);
            if (this.mRulesTableModel.getRules().isEmpty()) {
                this.setCurrentRule(new SingleVariableRule());
            } else {
                int n2 = n > 0 ? n - 1 : 0;
                this.mRulesTable.requestFocus();
                this.setCurrentRule(this.mRulesTableModel.getRule(n2));
                this.mRulesTable.setRowSelectionInterval(n2, n2);
            }
            this.mDeletingRules = false;
            if (this.mRulesTable.getRowCount() == 0) {
                this.mNewRuleButton.requestFocus();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mDeletingRules) {
            return;
        }
        if (!this.mRevertingBackTable) {
            int n = this.mRulesTable.getSelectedRow();
            if (this.mCurrentRule != null && !this.validateRule()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SingleVariableRulesTab.this.mRevertingBackTable = true;
                        int n = SingleVariableRulesTab.this.mRulesTableModel.getRules().indexOf(SingleVariableRulesTab.this.mCurrentRule);
                        if (SingleVariableRulesTab.this.mRulesTable.getSelectedRow() != n) {
                            SingleVariableRulesTab.this.mRulesTable.setRowSelectionInterval(n, n);
                        }
                    }
                });
            } else {
                this.setCurrentRule(this.mRulesTableModel.getRule(n));
            }
        } else {
            this.mRevertingBackTable = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        TableColumnModel tableColumnModel;
        int n;
        Object object = mouseEvent.getSource();
        if (object == this.mRulesTable.getTableHeader() && (n = (tableColumnModel = ((JTableHeader)mouseEvent.getSource()).getColumnModel()).getColumn(tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex()) == 0) {
            this.mRulesTableModel.sort();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public SPSS_Format getCurrentVarFormat() {
        if (this.mRuleTypeCombobox.getSelectedIndex() == 0) {
            return new SPSS_Format(FormatType.F, 8, 0);
        }
        if (this.mRuleTypeCombobox.getSelectedIndex() == 1) {
            return new SPSS_Format(FormatType.A, 8, 0);
        }
        if (this.mRuleTypeCombobox.getSelectedIndex() == 2) {
            return DateFormat.values()[this.mDateFormatsCombobox.getSelectedIndex()].getSpssFormat();
        }
        return null;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!this.mRulesTableModel.getRules().isEmpty() && this.mRulesTable.getSelectedRow() != -1) {
            Object object = focusEvent.getSource();
            Component component = focusEvent.getOppositeComponent();
            JButton jButton = null;
            if (component instanceof JButton) {
                jButton = (JButton)component;
            }
            if (object == this.mRuleNameField && jButton != null && jButton.getActionCommand().equals(ResUtil.getCommonDlgString("IDS_HELP"))) {
                String string = this.mRuleNameField.getText();
                if (string == null || string.equals("") || this.checkNotUniqueRuleName()) {
                    this.mRuleNameField.setText(this.mCurrentRule.getName());
                }
            } else if (!(focusEvent.getOppositeComponent() == null || focusEvent.getOppositeComponent() == this.mRulesTable || focusEvent.getOppositeComponent() == this.mDeleteRuleButton || jButton != null && jButton.getActionCommand().equals(ResUtil.getCommonDlgString("IDS_CANCEL")))) {
                if (object == this.mRuleNameField) {
                    if (!this.checkNotUniqueRuleNameShowWarning()) {
                        this.mRulesTableModel.updateRuleName(this.mRulesTable.getSelectedRow(), this.mRuleNameField.getText());
                    }
                } else if (object == this.mMinimumField) {
                    if (!this.verifyFormat(((JTextField)focusEvent.getComponent()).getText())) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SingleVariableRulesTab.this.mMinimumField.selectAll();
                                SingleVariableRulesTab.this.mMinimumField.requestFocus();
                            }
                        });
                    }
                } else if (object == this.mMaximumField && !this.verifyFormat(((JTextField)focusEvent.getComponent()).getText())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SingleVariableRulesTab.this.mMaximumField.selectAll();
                            SingleVariableRulesTab.this.mMaximumField.requestFocus();
                        }
                    });
                }
            }
        }
    }

    private boolean checkNotUniqueRuleNameShowWarning() {
        boolean bl = this.checkNotUniqueRuleName();
        if (bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RULE_NAME_ERROR"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SingleVariableRulesTab.this.mRuleNameField.selectAll();
                    SingleVariableRulesTab.this.mRuleNameField.requestFocus();
                }
            });
        }
        return bl;
    }

    private boolean checkNotUniqueRuleName() {
        String string = this.mRuleNameField.getText().trim();
        boolean bl = false;
        List<SingleVariableRule> list = this.mRulesTableModel.getRules();
        for (SingleVariableRule serializableObject : list) {
            if (serializableObject == this.mCurrentRule || !serializableObject.getName().equals(string)) continue;
            bl = true;
            break;
        }
        if (this.mCrossRules != null) {
            for (CrossVariableRule crossVariableRule : this.mCrossRules) {
                if (!crossVariableRule.getName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        if (!bl && string.equals("")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mRuleTypeCombobox && !this.mDeletingRules && itemEvent.getStateChange() == 1) {
            int n = this.mRulesTable.getSelectedRow();
            if (this.mRuleTypeCombobox.getSelectedIndex() == 0) {
                this.mDateFormatsLabel.setEnabled(false);
                this.mDateFormatsCombobox.setEnabled(false);
                this.mDateFormatsLabel.setEnabled(false);
                this.mAllowSystemMissingValuesCheckBox.setEnabled(true);
                this.mAllowBlankValuesCheckBox.setEnabled(false);
                this.mAllowNonintegerValuesCheckBox.setEnabled(true);
                this.mAllowIgnoreCaseValuesCheckBox.setEnabled(false);
                if (n != -1) {
                    this.mRulesTableModel.updateRuleType(n, SingleVariableRule.Type.eNUMERIC);
                }
            } else if (this.mRuleTypeCombobox.getSelectedIndex() == 1) {
                this.mDateFormatsLabel.setEnabled(false);
                this.mDateFormatsCombobox.setEnabled(false);
                this.mDateFormatsLabel.setEnabled(false);
                this.mAllowSystemMissingValuesCheckBox.setEnabled(false);
                this.mAllowBlankValuesCheckBox.setEnabled(true);
                this.mAllowNonintegerValuesCheckBox.setEnabled(false);
                this.mAllowIgnoreCaseValuesCheckBox.setEnabled(true);
                if (n != -1) {
                    this.mRulesTableModel.updateRuleType(n, SingleVariableRule.Type.eSTRING);
                }
            } else {
                this.mDateFormatsLabel.setEnabled(true);
                this.mDateFormatsCombobox.setEnabled(true);
                this.mDateFormatsLabel.setEnabled(true);
                this.mAllowSystemMissingValuesCheckBox.setEnabled(true);
                this.mAllowBlankValuesCheckBox.setEnabled(false);
                this.mAllowNonintegerValuesCheckBox.setEnabled(false);
                this.mAllowIgnoreCaseValuesCheckBox.setEnabled(false);
                if (n != -1) {
                    this.mRulesTableModel.updateRuleType(n, SingleVariableRule.Type.eDATE);
                }
            }
            this.mMaximumField.setText("");
            this.mMinimumField.setText("");
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.mRulesTableModel.getRowCount() > 0) {
            this.mDeleteRuleButton.setEnabled(true);
            this.mDuplicateRuleButton.setEnabled(true);
            this.setEnableState(this.mListPanel, true);
            this.setEnableState(this.mRangePanel, true);
            this.setEnableState(this.mRuleDefinitionPanel, true);
            this.changeValidValuesPanelEnableState(this.mValidValuesComboBox.getSelectedIndex() == 1, this.mValidValuesComboBox.getSelectedIndex() == 0);
            if (this.mCurrentRule != null) {
                boolean bl;
                boolean bl2 = this.mCurrentRule.getType() == SingleVariableRule.Type.eNUMERIC;
                boolean bl3 = this.mCurrentRule.getType() == SingleVariableRule.Type.eSTRING;
                boolean bl4 = bl = this.mCurrentRule.getType() == SingleVariableRule.Type.eDATE;
                if (bl2) {
                    this.mDateFormatsLabel.setEnabled(false);
                    this.mDateFormatsCombobox.setEnabled(false);
                    this.mAllowIgnoreCaseValuesCheckBox.setEnabled(false);
                    this.mAllowBlankValuesCheckBox.setEnabled(false);
                } else if (bl3) {
                    this.mDateFormatsLabel.setEnabled(false);
                    this.mDateFormatsCombobox.setEnabled(false);
                    this.mAllowNonintegerValuesCheckBox.setEnabled(false);
                    this.mAllowSystemMissingValuesCheckBox.setEnabled(false);
                } else if (bl) {
                    this.mAllowNonintegerValuesCheckBox.setEnabled(false);
                    this.mAllowIgnoreCaseValuesCheckBox.setEnabled(false);
                    this.mAllowBlankValuesCheckBox.setEnabled(false);
                }
            }
        } else {
            this.mCurrentRule = null;
            this.mRuleNameField.setText("");
            this.mDeleteRuleButton.setEnabled(false);
            this.mDuplicateRuleButton.setEnabled(false);
            this.setEnableState(this.mListPanel, false);
            this.setEnableState(this.mRangePanel, false);
            this.setEnableState(this.mRuleDefinitionPanel, false);
        }
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mRulesTable;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardDialogInsets();
        JScrollPane jScrollPane = new JScrollPane(this.mRulesTable);
        jScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight()));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_RULES_TABLE_TITLE");
        jLabel.setLabelFor(this.mRulesTable);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, 10, new Insets(insets.top, insets.left, 0, 0));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 1, 1, 1, 10, new Insets(0, insets.left, 0, 0));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mRuleDefinitionPanel = this.setupRuleDefinitionPanel();
        DialogUtil.addUsingGBL(this, this.mRuleDefinitionPanel, gridBagConstraints, 1, 0, 1, 3, 10, insets);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNewRuleButton, gridBagConstraints, 0, 0, 1, 1, 10, DialogUtil.getStandardButtonInsets());
        DialogUtil.addUsingGBL(jPanel, this.mDuplicateRuleButton, gridBagConstraints, 1, 0, 1, 1, 10, DialogUtil.getStandardButtonInsets());
        DialogUtil.addUsingGBL(jPanel, this.mDeleteRuleButton, gridBagConstraints, 2, 0, 1, 1, 10, DialogUtil.getStandardButtonInsets());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 2, 1, 1, 10, new Insets(0, insets.left, insets.bottom, 0));
    }

    @Override
    protected boolean validateTab() {
        if (this.mRulesTableModel.getRowCount() > 0) {
            if (this.validateRule() && !this.mRulesTableModel.getRules().isEmpty() && this.mRulesTable.getSelectedRow() != -1) {
                this.saveToCurrentRule();
                if (this.mCurrentRule.getCurrentValidValues() == SingleVariableRule.ValidValues.eWITHIN_LIST) {
                    this.mValidValuesTableModel.setData(this.mCurrentRule.getValues());
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean validateRule() {
        if (this.mRulesTableModel.getRules().isEmpty() || this.mRulesTable.getSelectedRow() == -1) {
            return true;
        }
        if (this.checkNotUniqueRuleNameShowWarning()) {
            return false;
        }
        if (this.mValidValuesComboBox.getSelectedIndex() == 1) {
            this.mValidValuesTableModel.sanitize();
            if (this.mValidValuesTableModel.getData().isEmpty()) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GRID_EMPTY_ERROR"), VersionInfo.getAppVersionString());
                return false;
            }
        } else if (!this.mMaximumField.getText().equals("") && !this.mMinimumField.getText().equals("")) {
            boolean bl;
            if (this.mRuleTypeCombobox.getSelectedIndex() == 0) {
                double d;
                double d2 = Double.parseDouble(this.mMaximumField.getText());
                bl = d2 < (d = Double.parseDouble(this.mMinimumField.getText()));
            } else if (this.mRuleTypeCombobox.getSelectedIndex() == 1) {
                bl = this.mMaximumField.getText().compareTo(this.mMinimumField.getText()) < 0;
            } else {
                SPSS_Format sPSS_Format = DateFormat.values()[this.mDateFormatsCombobox.getSelectedIndex()].getSpssFormat();
                OBS oBS = new OBS();
                OBS oBS2 = new OBS();
                CellValueFormatter.stringToObs((String)this.mMaximumField.getText(), (SPSS_Format)sPSS_Format, (OBS)oBS);
                CellValueFormatter.stringToObs((String)this.mMinimumField.getText(), (SPSS_Format)sPSS_Format, (OBS)oBS2);
                boolean bl2 = bl = oBS.getNum() < oBS2.getNum();
            }
            if (bl) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_MIN_MAX_ERROR"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        return true;
    }

    protected boolean verifyFormat(String string) {
        if (string.equals("") || this.mRuleTypeCombobox.getSelectedIndex() == 1) {
            return true;
        }
        if (this.mRuleTypeCombobox.getSelectedIndex() == 0) {
            try {
                Double.parseDouble(string);
                if (this.mValidValuesComboBox.getSelectedIndex() == 0 && !this.mAllowNonintegerValuesCheckBox.isSelected() && string.indexOf(46) != -1) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RULE_VALUE_ERROR"), VersionInfo.getAppVersionString());
                    return false;
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RULE_VALUE_ERROR"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        if (this.isValidDate(string) && CellValueFormatter.stringToObs((String)string, (SPSS_Format)DateFormat.values()[this.mDateFormatsCombobox.getSelectedIndex()].getSpssFormat(), (OBS)new OBS())) {
            return true;
        }
        SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RULE_VALUE_ERROR"), VersionInfo.getAppVersionString());
        return false;
    }

    private boolean isValidDate(String string) {
        return string.length() <= DateFormat.values()[this.mDateFormatsCombobox.getSelectedIndex()].getSpssFormat().getWidth();
    }

    private void setupTableForFocusRepainting(final JTable jTable) {
        SpssFocusCellRenderer spssFocusCellRenderer = new SpssFocusCellRenderer();
        jTable.setDefaultRenderer(Object.class, spssFocusCellRenderer);
        jTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jTable.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                jTable.repaint();
            }
        });
    }

    private void initVars() {
        this.mRulesTableModel = new SingleVariableRulesTableModel(this.mParent);
        this.mRulesTable = new JTable(this.mRulesTableModel);
        this.setupTableForFocusRepainting(this.mRulesTable);
        this.mRulesTable.setRowSelectionAllowed(true);
        this.mRulesTable.setColumnSelectionAllowed(false);
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.mRulesTable.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(2);
        this.mRulesTable.setSelectionMode(0);
        this.mRulesTable.getSelectionModel().addListSelectionListener(this);
        this.mRulesTable.getTableHeader().setReorderingAllowed(false);
        this.mRulesTable.getTableHeader().addMouseListener(this);
        this.mRulesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    SingleVariableRulesTab.this.deleteRules();
                }
            }
        });
        this.mNewRuleButton = new JButton(new ToggleButtonAction(this.mParent, "IDS_SINGLE_NEW_RULE"));
        this.mNewRuleButton.addActionListener(this);
        this.mDuplicateRuleButton = new JButton(new ToggleButtonAction(this.mParent, "IDS_SINGLE_DUPLICATE_RULE"));
        this.mDuplicateRuleButton.addActionListener(this);
        this.mDeleteRuleButton = new JButton(new ToggleButtonAction(this.mParent, "IDS_SINGLE_DELETE_RULE"));
        this.mDeleteRuleButton.addActionListener(this);
        this.mRuleNameField = new StringTextField();
        this.mRuleNameField.setColumns(14);
        this.mRuleNameField.setDocument(new FixedLengthDocument(30000));
        this.mRuleNameField.setText(this.getResString("IDS_SINGLE_VARIABLE_RULE_DEFAULT_NAME"));
        this.mRuleNameField.addFocusListener(this);
        this.mRuleTypeCombobox = new RefusableComboBox();
        this.mRuleTypeCombobox.setAction(new ComboboxAction(this.mParent, "IDS_RULE_TYPE"));
        for (SingleVariableRule.Type type : SingleVariableRule.Type.values()) {
            this.mRuleTypeCombobox.addItem(this.getResString(type.getKey()));
        }
        this.mRuleTypeCombobox.addItemListener(this);
        this.mDateFormatsCombobox = new JComboBox();
        this.mDateFormatsCombobox.setAction(new ComboboxAction(this.mParent, "IDS_RULE_DATE_FORMAT"));
        for (DateFormat dateFormat : DateFormat.values()) {
            this.mDateFormatsCombobox.addItem(this.getResString(dateFormat.getKey()));
        }
        this.mDateFormatsCombobox.setSelectedIndex(2);
        this.mDateFormatsLabel = DialogUtil.createLabel(this.mParent, "IDS_RULE_DATE_FORMAT");
        this.mDateFormatsLabel.setLabelFor(this.mDateFormatsCombobox);
        this.mDateFormatsCombobox.addItemListener(new ItemListener(){
            private int mLastSelected = 2;

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SPSS_Format sPSS_Format = DateFormat.values()[SingleVariableRulesTab.this.mDateFormatsCombobox.getSelectedIndex()].getSpssFormat();
                SPSS_Format sPSS_Format2 = DateFormat.values()[this.mLastSelected].getSpssFormat();
                if (SingleVariableRulesTab.this.mValidValuesComboBox.getSelectedIndex() == 0) {
                    SingleVariableRulesTab.this.mMaximumField.setText(this.convertToNewFormat(SingleVariableRulesTab.this.mMaximumField.getText(), sPSS_Format2, sPSS_Format));
                    SingleVariableRulesTab.this.mMinimumField.setText(this.convertToNewFormat(SingleVariableRulesTab.this.mMinimumField.getText(), sPSS_Format2, sPSS_Format));
                } else {
                    List<String> list = SingleVariableRulesTab.this.mValidValuesTableModel.getData();
                    for (int i = 0; i < list.size(); ++i) {
                        list.set(i, this.convertToNewFormat(list.get(i), sPSS_Format2, sPSS_Format));
                    }
                    SingleVariableRulesTab.this.mValidValuesTableModel.refresh();
                }
                this.mLastSelected = SingleVariableRulesTab.this.mDateFormatsCombobox.getSelectedIndex();
            }

            private String convertToNewFormat(String string, SPSS_Format sPSS_Format, SPSS_Format sPSS_Format2) {
                if (string.equals("")) {
                    return string;
                }
                OBS oBS = new OBS();
                if (CellValueFormatter.stringToObs((String)string, (SPSS_Format)sPSS_Format2, (OBS)oBS)) {
                    return CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format2);
                }
                return "";
            }
        });
        this.mMinimumField = new StringTextField(10);
        Dimension dimension = this.mMinimumField.getPreferredSize();
        this.mMinimumField.setMinimumSize(dimension);
        this.mMinimumField.addFocusListener(this);
        this.mMaximumField = new StringTextField(10);
        Dimension dimension2 = this.mMaximumField.getPreferredSize();
        this.mMaximumField.setMinimumSize(dimension2);
        this.mMaximumField.addFocusListener(this);
        this.mValidValuesTableModel = new EditableListTableModel(){
            private int mCurrentlyEditingRow;

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (CellValueFormatter.stringToObs((String)object.toString(), (SPSS_Format)SingleVariableRulesTab.this.getCurrentVarFormat(), (OBS)new OBS())) {
                    super.setValueAt(object, n, n2);
                } else {
                    this.mCurrentlyEditingRow = n;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SingleVariableRulesTab.this.mValidValuesTable.setRowSelectionInterval(mCurrentlyEditingRow, mCurrentlyEditingRow);
                            SingleVariableRulesTab.this.mValidValuesTable.editCellAt(mCurrentlyEditingRow, 0);
                        }
                    });
                }
            }
        };
        this.mValidValuesTable = new JTable(this.mValidValuesTableModel){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                Component component = this.getEditorComponent();
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
                return bl;
            }
        };
        ContextEnabledTextField contextEnabledTextField = new ContextEnabledTextField();
        contextEnabledTextField.setDocument((Document)new VarFormatDocument(this));
        this.mValidValuesTable.setDefaultEditor(String.class, new DefaultCellEditor((JTextField)contextEnabledTextField));
        this.mValidValuesTable.setTableHeader(null);
        this.mValidValuesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.mAllowUserMissingValuesCheckBox = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_ALLOW_USER_MISSING_VALUES"));
        this.mAllowSystemMissingValuesCheckBox = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_ALLOW_SYSTEM_MISSING_VALUES"));
        this.mAllowBlankValuesCheckBox = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_ALLOW_BLANK_VALUES"));
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mAllowUserMissingValuesCheckBox);
        spssButtonGroup.add(this.mAllowSystemMissingValuesCheckBox);
        spssButtonGroup.add(this.mAllowBlankValuesCheckBox);
        this.mValidValuesMessage = new JTextArea(this.getResString("IDS_RULE_VALID_VALUES_MESSAGE_TEXT"));
        this.mValidValuesMessage.setOpaque(false);
        this.mValidValuesMessage.setFont(this.mAllowBlankValuesCheckBox.getFont());
        this.mValidValuesMessage.setFocusable(false);
        this.mValidValuesMessage.setEditable(false);
        this.mValidValuesMessage.setLineWrap(true);
        this.mValidValuesMessage.setWrapStyleWord(true);
        double d = this.mValidValuesMessage.getFont().getSize();
        double d2 = d / 11.0;
        int n = 50;
        int n2 = 260;
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        if (d2 > 1.0) {
            d2 = 1.25;
        }
        n = (int)((double)n * d2);
        n2 = (int)((double)n2 * d2);
        this.mValidValuesMessage.setMinimumSize(new Dimension(n2, n));
        this.mValidValuesMessage.setPreferredSize(new Dimension(n2, n));
        this.mAllowNonintegerValuesCheckBox = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_ALLOW_NONINTEGER_VALUES"));
        this.mAllowIgnoreCaseValuesCheckBox = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_IGNORE_CASE_CHECKING_VALUES"));
        this.mRangePanel = this.setupRangeValidValues();
        this.mListPanel = this.setupListValidValues();
        this.mValidValuesComboBox = new JComboBox();
        this.mValidValuesComboBox.setAction(new ComboboxAction(this.mParent, "IDS_RULE_VALID_VALUES"));
        for (SingleVariableRule.ValidValues validValues : SingleVariableRule.ValidValues.values()) {
            this.mValidValuesComboBox.addItem(this.getResString(validValues.getKey()));
        }
        this.mValidValuesPanel = this.setupValidValuesPanel();
        this.mValidValuesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().bottom, DialogUtil.getStandardControlInsets().right);
                if (SingleVariableRulesTab.this.mValidValuesComboBox.getSelectedIndex() == 0) {
                    SingleVariableRulesTab.this.mValidValuesPanel.remove(SingleVariableRulesTab.this.mListPanel);
                    insets.top = DialogUtil.getComponentGroupGap() * 2;
                    DialogUtil.addUsingGBL(SingleVariableRulesTab.this.mValidValuesPanel, SingleVariableRulesTab.this.mRangePanel, gridBagConstraints, 0, 2, 1, 1, 21, insets);
                    SingleVariableRulesTab.this.mValidValuesTableModel.setData(null);
                    SingleVariableRulesTab.this.changeValidValuesPanelEnableState(false, true);
                } else {
                    SingleVariableRulesTab.this.mValidValuesPanel.remove(SingleVariableRulesTab.this.mRangePanel);
                    DialogUtil.addUsingGBL(SingleVariableRulesTab.this.mValidValuesPanel, SingleVariableRulesTab.this.mListPanel, gridBagConstraints, 0, 2, 1, 1, 21, insets);
                    if (SingleVariableRulesTab.this.mCurrentRule != null) {
                        SingleVariableRulesTab.this.mValidValuesTableModel.setData(SingleVariableRulesTab.this.mCurrentRule.getValues());
                    } else {
                        SingleVariableRulesTab.this.mValidValuesTableModel.setData(null);
                    }
                    SingleVariableRulesTab.this.changeValidValuesPanelEnableState(true, false);
                }
                SingleVariableRulesTab.this.mValidValuesPanel.validate();
                SingleVariableRulesTab.this.mValidValuesPanel.repaint();
            }
        });
        this.setDefaults();
        this.mRulesTableModel.addTableModelListener(this);
        this.addToComponentOrder(this.mRulesTable);
        this.addToComponentOrder(this.mNewRuleButton);
        this.addToComponentOrder(this.mDuplicateRuleButton);
        this.addToComponentOrder(this.mDeleteRuleButton);
        this.addToComponentOrder(this.mRuleNameField);
        this.addToComponentOrder(this.mRuleTypeCombobox);
        this.addToComponentOrder(this.mDateFormatsCombobox);
        this.addToComponentOrder(this.mValidValuesComboBox);
        this.addToComponentOrder(this.mMinimumField);
        this.addToComponentOrder(this.mMaximumField);
        this.addToComponentOrder(this.mAllowNonintegerValuesCheckBox);
        this.addToComponentOrder(this.mValidValuesTable);
        this.addToComponentOrder(this.mAllowIgnoreCaseValuesCheckBox);
        this.addToComponentOrder(this.mAllowUserMissingValuesCheckBox);
        this.addToComponentOrder(this.mAllowSystemMissingValuesCheckBox);
        this.addToComponentOrder(this.mAllowBlankValuesCheckBox);
        this.mRulesTable.setFocusable(true);
        this.mRulesTable.setFocusTraversalKeys(0, null);
        this.mValidValuesTable.setFocusable(true);
        this.mValidValuesMessage.setBackground(this.mValidValuesComboBox.getBackground());
    }

    private void changeValidValuesPanelEnableState(boolean bl, boolean bl2) {
        this.mValidValuesTable.setEnabled(bl);
        this.mAllowIgnoreCaseValuesCheckBox.setEnabled(bl && this.mRuleTypeCombobox.getSelectedIndex() == 1);
        this.mMinimumField.setEnabled(bl2);
        this.mMaximumField.setEnabled(bl2);
        this.mAllowNonintegerValuesCheckBox.setEnabled(bl2 && this.mRuleTypeCombobox.getSelectedIndex() == 0);
    }

    private void loadFromCurrentRule() {
        this.mRuleNameField.setText(this.mCurrentRule.getName());
        this.mRuleTypeCombobox.setSelectedItemNoPrompt(this.getResString(this.mCurrentRule.getType().getKey()));
        this.mValidValuesComboBox.setSelectedItem(this.getResString(this.mCurrentRule.getCurrentValidValues().getKey()));
        this.mAllowUserMissingValuesCheckBox.setSelected(!this.mCurrentRule.isFlagUserMissingValues());
        if (this.mCurrentRule.getType() == SingleVariableRule.Type.eNUMERIC) {
            this.mAllowSystemMissingValuesCheckBox.setSelected(!this.mCurrentRule.isFlagSystemMissingValues());
            this.mDateFormatsLabel.setEnabled(false);
            this.mDateFormatsCombobox.setEnabled(false);
            this.mAllowIgnoreCaseValuesCheckBox.setEnabled(false);
            this.mAllowBlankValuesCheckBox.setEnabled(false);
        } else if (this.mCurrentRule.getType() == SingleVariableRule.Type.eSTRING) {
            this.mDateFormatsLabel.setEnabled(false);
            this.mAllowBlankValuesCheckBox.setSelected(!this.mCurrentRule.isFlagBlankValues());
            this.mDateFormatsCombobox.setEnabled(false);
            this.mAllowNonintegerValuesCheckBox.setEnabled(false);
            this.mAllowSystemMissingValuesCheckBox.setEnabled(false);
        } else {
            this.mDateFormatsCombobox.setSelectedItem(this.getResString(this.mCurrentRule.getDateFormat().getKey()));
            this.mAllowSystemMissingValuesCheckBox.setSelected(!this.mCurrentRule.isFlagSystemMissingValues());
            this.mAllowNonintegerValuesCheckBox.setEnabled(false);
            this.mAllowIgnoreCaseValuesCheckBox.setEnabled(false);
            this.mAllowBlankValuesCheckBox.setEnabled(false);
        }
        if (this.mCurrentRule.getCurrentValidValues() == SingleVariableRule.ValidValues.eWITHIN_RANGE) {
            this.mMaximumField.setText(this.mCurrentRule.getMaximumValue());
            this.mMinimumField.setText(this.mCurrentRule.getMinimumValue());
            if (this.mCurrentRule.getType() == SingleVariableRule.Type.eNUMERIC) {
                this.mAllowNonintegerValuesCheckBox.setSelected(!this.mCurrentRule.isFlagNonIntegerValues());
            }
        } else {
            this.mValidValuesTableModel.setData(this.mCurrentRule.getValues());
            if (this.mCurrentRule.getType() == SingleVariableRule.Type.eSTRING) {
                this.mAllowIgnoreCaseValuesCheckBox.setSelected(!this.mCurrentRule.isCaseSensitive());
            }
        }
    }

    private void saveToCurrentRule() {
        this.mCurrentRule.setName(this.mRuleNameField.getText());
        this.mCurrentRule.setType(SingleVariableRule.Type.values()[this.mRuleTypeCombobox.getSelectedIndex()]);
        this.mCurrentRule.setCurrentValidValues(SingleVariableRule.ValidValues.values()[this.mValidValuesComboBox.getSelectedIndex()]);
        this.mCurrentRule.setFlagUserMissingValues(!this.mAllowUserMissingValuesCheckBox.isSelected());
        if (this.mCurrentRule.getType() == SingleVariableRule.Type.eNUMERIC) {
            this.mCurrentRule.setFlagSystemMissingValues(!this.mAllowSystemMissingValuesCheckBox.isSelected());
        } else if (this.mCurrentRule.getType() == SingleVariableRule.Type.eSTRING) {
            this.mCurrentRule.setFlagBlankValues(!this.mAllowBlankValuesCheckBox.isSelected());
        } else {
            this.mCurrentRule.setDateFormat(DateFormat.values()[this.mDateFormatsCombobox.getSelectedIndex()]);
            this.mCurrentRule.setFlagSystemMissingValues(!this.mAllowSystemMissingValuesCheckBox.isSelected());
        }
        if (this.mCurrentRule.getCurrentValidValues() == SingleVariableRule.ValidValues.eWITHIN_RANGE) {
            this.mCurrentRule.setMaximumValue(this.mMaximumField.getText());
            this.mCurrentRule.setMinimumValue(this.mMinimumField.getText());
            if (this.mCurrentRule.getType() == SingleVariableRule.Type.eNUMERIC) {
                this.mCurrentRule.setFlagNonIntegerValues(!this.mAllowNonintegerValuesCheckBox.isSelected());
            }
        } else {
            this.mValidValuesTableModel.sanitize();
            this.mValidValuesTableModel.setData(null);
            if (this.mCurrentRule.getType() == SingleVariableRule.Type.eSTRING) {
                this.mCurrentRule.setCaseSensitive(!this.mAllowIgnoreCaseValuesCheckBox.isSelected());
            }
        }
        this.mRulesTableModel.refresh(this.mRulesTableModel.getRules().indexOf(this.mCurrentRule));
    }

    private void setCurrentRule(SingleVariableRule singleVariableRule) {
        if (this.mCurrentRule != null) {
            this.saveToCurrentRule();
        }
        this.mCurrentRule = singleVariableRule;
        if (this.mCurrentRule != null) {
            this.loadFromCurrentRule();
        }
    }

    private void setDefaults() {
        this.mAllowUserMissingValuesCheckBox.setSelected(true);
        this.mAllowSystemMissingValuesCheckBox.setSelected(true);
        this.mAllowBlankValuesCheckBox.setSelected(true);
        this.mAllowNonintegerValuesCheckBox.setSelected(true);
        this.mAllowIgnoreCaseValuesCheckBox.setSelected(true);
        this.mAllowBlankValuesCheckBox.setEnabled(false);
    }

    private void setEnableState(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setOpaque(bl);
        } else if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.setEnableState(component2, bl);
            }
        }
    }

    private JPanel setupAllowMissingValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mAllowUserMissingValuesCheckBox, gridBagConstraints, 0, 0, 1, 1, 23, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mAllowSystemMissingValuesCheckBox, gridBagConstraints, 0, 1, 1, 1, 23, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mAllowBlankValuesCheckBox, gridBagConstraints, 0, 2, 1, 1, 23, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    private JPanel setupListValidValues() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.mValidValuesTable);
        jScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth() * 2, DialogUtil.getVarListHeight()));
        jScrollPane.setMinimumSize(new Dimension(DialogUtil.getVarListWidth() * 2, DialogUtil.getVarListHeight()));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_VALID_VALUES_VALUES");
        jLabel.setLabelFor((Component)((Object)this.mRuleNameField));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mAllowIgnoreCaseValuesCheckBox, gridBagConstraints, 0, 2, 1, 1, 23, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, 23, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    private JPanel setupNameTypePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_RULE_NAME");
        jLabel.setLabelFor((Component)((Object)this.mRuleNameField));
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_RULE_TYPE");
        jLabel2.setLabelFor(this.mRuleTypeCombobox);
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 21, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mRuleNameField), gridBagConstraints, 1, 0, 1, 1, 22, insets);
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap(), insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, 21, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mRuleTypeCombobox, gridBagConstraints, 3, 0, 1, 1, 21, insets);
        insets2.top = DialogUtil.getComponentGroupGap();
        insets2.bottom = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDateFormatsLabel, gridBagConstraints, 2, 1, 1, 1, 21, insets2);
        insets2.left = insets.left;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDateFormatsCombobox, gridBagConstraints, 3, 1, 1, 1, 21, insets2);
        return jPanel;
    }

    private JPanel setupRangeValidValues() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_RULE_MINIMUM");
        jLabel.setLabelFor((Component)((Object)this.mMinimumField));
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_RULE_MAXIMUM");
        jLabel2.setLabelFor((Component)((Object)this.mMaximumField));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mMinimumField), gridBagConstraints, 1, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        Insets insets = new Insets(DialogUtil.getComponentGroupGap() * 2, DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().bottom, DialogUtil.getStandardControlInsets().right);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mMaximumField), gridBagConstraints, 1, 1, 1, 1, 21, insets);
        insets = new Insets(DialogUtil.getStandardControlInsets().top, DialogUtil.getComponentGroupGap(), DialogUtil.getStandardControlInsets().bottom, DialogUtil.getStandardControlInsets().right);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mValidValuesMessage, gridBagConstraints, 2, 0, 1, 2, 21, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap() * 2, DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().bottom, DialogUtil.getStandardControlInsets().right);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mAllowNonintegerValuesCheckBox, gridBagConstraints, 0, 2, 3, 1, 23, insets);
        return jPanel;
    }

    private JPanel setupRuleDefinitionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RULE_DEFINITION")));
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().bottom, DialogUtil.getStandardControlInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.setupNameTypePanel(), gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 1, 1, 1, 10, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mValidValuesPanel, gridBagConstraints, 0, 2, 1, 1, 10, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 3, 1, 1, 10, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.setupAllowMissingValuesPanel(), gridBagConstraints, 0, 4, 1, 1, 23, insets);
        return jPanel;
    }

    private JPanel setupValidValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_RULE_VALID_VALUES");
        jLabel.setLabelFor(this.mValidValuesComboBox);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mValidValuesComboBox, gridBagConstraints, 0, 1, 1, 1, 21, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().bottom, DialogUtil.getStandardControlInsets().right);
        if (this.mCurrentRule == null || this.mCurrentRule.getCurrentValidValues() == SingleVariableRule.ValidValues.eWITHIN_RANGE) {
            insets.top = DialogUtil.getComponentGroupGap() * 2;
            DialogUtil.addUsingGBL(jPanel, this.mRangePanel, gridBagConstraints, 0, 2, 1, 1, 21, insets);
        } else {
            DialogUtil.addUsingGBL(jPanel, this.mListPanel, gridBagConstraints, 0, 2, 1, 1, 21, insets);
        }
        return jPanel;
    }

    private boolean hasLinks() {
        if (this.mRulesTable.getSelectedRow() == -1) {
            return false;
        }
        SingleVariableRule singleVariableRule = this.mRulesTableModel.getRule(this.mRulesTable.getSelectedRow());
        for (ISpssVariable iSpssVariable : this.mVarRuleMap.keySet()) {
            Set<SingleVariableRule> set = this.mVarRuleMap.get(iSpssVariable);
            for (SingleVariableRule singleVariableRule2 : set) {
                if (!singleVariableRule2.getName().equals(singleVariableRule.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void removeLinks() {
        if (this.mRulesTable.getSelectedRow() == -1) {
            return;
        }
        SingleVariableRule singleVariableRule = this.mRulesTableModel.getRule(this.mRulesTable.getSelectedRow());
        block0: for (ISpssVariable iSpssVariable : this.mVarRuleMap.keySet()) {
            Set<SingleVariableRule> set = this.mVarRuleMap.get(iSpssVariable);
            Iterator<SingleVariableRule> iterator = set.iterator();
            while (iterator.hasNext()) {
                SingleVariableRule singleVariableRule2 = iterator.next();
                if (!singleVariableRule2.getName().equals(singleVariableRule.getName())) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    private class RefusableComboBox
    extends JComboBox {
        private RefusableComboBox() {
        }

        private boolean checkContinue() {
            SingleVariableRulesTab.this.mValidValuesTableModel.sanitize();
            if (SingleVariableRulesTab.this.mValidValuesTableModel.getData() != null && !SingleVariableRulesTab.this.mValidValuesTableModel.getData().isEmpty()) {
                if (0 != SpssAlertOptionPane.showConfirmDialog((Window)SingleVariableRulesTab.this.mParent, SingleVariableRulesTab.this.getResString("ERR_CLEAR_GRID_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                    return false;
                }
                SingleVariableRulesTab.this.mValidValuesTableModel.getData().clear();
                SingleVariableRulesTab.this.mValidValuesTableModel.refresh();
            }
            if (SingleVariableRulesTab.this.hasLinks()) {
                int n = SpssAlertOptionPane.showConfirmDialog(this, SingleVariableRulesTab.this.getResString("ERR_RULE_IS_LINKED"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                if (n == 0) {
                    SingleVariableRulesTab.this.removeLinks();
                } else {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (!this.checkContinue()) {
                return;
            }
            super.setSelectedItem(object);
        }

        @Override
        public void setSelectedIndex(int n) {
            if (!this.checkContinue()) {
                return;
            }
            super.setSelectedIndex(n);
        }

        public void setSelectedItemNoPrompt(Object object) {
            super.setSelectedItem(object);
        }

        public void setSelectedIndexNoPrompt(int n) {
            super.setSelectedIndex(n);
        }
    }
}

