/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.define_rules;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.data_validate.VDTRuleSpecs;
import com.spss.java_client.core.documents.data.data_validate.VDTSpecTypes;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.DateFormat;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class RulesUtil {
    public static List<CrossVariableRule> loadCrossVarRules() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        DataMgr dataMgr = DataMgr.getDataMgr();
        VDTRuleSpecs vDTRuleSpecs = new VDTRuleSpecs(dataMgr.getDataSource(locallyUniqueId), false, -1, false);
        Vector vector = new Vector();
        ArrayList<CrossVariableRule> arrayList = new ArrayList<CrossVariableRule>();
        if (vDTRuleSpecs.getAllValidRules(new Vector(), new Vector(), vector)) {
            for (VDTRuleSpecs vDTRuleSpecs2 : vector) {
                arrayList.add(RulesUtil.convertToCrossVarRule(vDTRuleSpecs2));
            }
        }
        return arrayList;
    }

    public static List<SingleVariableRule> loadSingleVarRules() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        DataMgr dataMgr = DataMgr.getDataMgr();
        VDTRuleSpecs vDTRuleSpecs = new VDTRuleSpecs(dataMgr.getDataSource(locallyUniqueId), true, -1, false);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        ArrayList<SingleVariableRule> arrayList = new ArrayList<SingleVariableRule>();
        if (vDTRuleSpecs.getAllValidRules(vector, vector2, vector3)) {
            for (VDTRuleSpecs vDTRuleSpecs2 : vector2) {
                arrayList.add(RulesUtil.convertToSingleVarRule(vDTRuleSpecs2));
            }
        }
        return arrayList;
    }

    public static List<String> loadSingleVarOutcomeVars() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        DataMgr dataMgr = DataMgr.getDataMgr();
        VDTRuleSpecs vDTRuleSpecs = new VDTRuleSpecs(dataMgr.getDataSource(locallyUniqueId), true, -1, false);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (vDTRuleSpecs.getAllValidRules(vector, vector2, vector3)) {
            for (VDTRuleSpecs vDTRuleSpecs2 : vector) {
                if (vDTRuleSpecs2.getOutcomeVarName().length() <= 0) continue;
                arrayList.add(vDTRuleSpecs2.getOutcomeVarName());
            }
        }
        return arrayList;
    }

    public static List<String> loadCrossVarOutcomeVars() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        DataMgr dataMgr = DataMgr.getDataMgr();
        VDTRuleSpecs vDTRuleSpecs = new VDTRuleSpecs(dataMgr.getDataSource(locallyUniqueId), true, -1, false);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (vDTRuleSpecs.getAllValidRules(vector, vector2, vector3)) {
            for (VDTRuleSpecs vDTRuleSpecs2 : vector3) {
                if (vDTRuleSpecs2.getOutcomeVarName().length() <= 0) continue;
                arrayList.add(vDTRuleSpecs2.getOutcomeVarName());
            }
        }
        return arrayList;
    }

    public static Map<ISpssVariable, Set<SingleVariableRule>> loadSelectionsMap(List<ISpssVariable> list, List<SingleVariableRule> list2) {
        Vector vector;
        HashMap<ISpssVariable, Set<SingleVariableRule>> hashMap = new HashMap<ISpssVariable, Set<SingleVariableRule>>();
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        DataMgr dataMgr = DataMgr.getDataMgr();
        VDTRuleSpecs vDTRuleSpecs = new VDTRuleSpecs(dataMgr.getDataSource(locallyUniqueId), true, -1, false);
        if (vDTRuleSpecs.getAllValidRules(vector = new Vector(), new Vector(), new Vector())) {
            HashMap<String, SingleVariableRule> hashMap2 = new HashMap<String, SingleVariableRule>();
            for (SingleVariableRule iterator : list2) {
                hashMap2.put(iterator.getName(), iterator);
            }
            HashMap hashMap3 = new HashMap();
            for (ISpssVariable iSpssVariable : list) {
                hashMap3.put(iSpssVariable.getName(), iSpssVariable);
            }
            for (ISpssVariable iSpssVariable : vector) {
                ISpssVariable iSpssVariable2 = (ISpssVariable)hashMap3.get(iSpssVariable.getAnalysVarName());
                if (iSpssVariable2 == null) continue;
                HashSet hashSet = (HashSet)hashMap.get(iSpssVariable2);
                if (hashSet == null) {
                    hashSet = new HashSet();
                    hashMap.put(iSpssVariable2, hashSet);
                }
                hashSet.add(hashMap2.get(iSpssVariable.getLabel()));
            }
        }
        return hashMap;
    }

    public static String generateOutVarName(String string, Set<String> set) {
        String string2 = string;
        string2 = VarNameValidator.generateSPSSRootName((String)string2);
        string2 = VarNameValidator.generateOutcomeSpssName((String)string2, set, (boolean)true);
        return string2;
    }

    private static SingleVariableRule convertToSingleVarRule(VDTRuleSpecs vDTRuleSpecs) {
        SingleVariableRule singleVariableRule = new SingleVariableRule();
        singleVariableRule.setName(vDTRuleSpecs.getLabel());
        if (vDTRuleSpecs.getValueType() == VDTSpecTypes.VDTValueType.kValueDate) {
            singleVariableRule.setType(SingleVariableRule.Type.eDATE);
            for (DateFormat dateFormat : DateFormat.values()) {
                if (!dateFormat.getFormat().equals(vDTRuleSpecs.getFormat())) continue;
                singleVariableRule.setDateFormat(dateFormat);
                break;
            }
        } else if (vDTRuleSpecs.getValueType() == VDTSpecTypes.VDTValueType.kValueString) {
            singleVariableRule.setType(SingleVariableRule.Type.eSTRING);
        } else {
            singleVariableRule.setType(SingleVariableRule.Type.eNUMERIC);
        }
        if (vDTRuleSpecs.getDomainType() == VDTSpecTypes.VDTDomainType.kDomainRange) {
            singleVariableRule.setCurrentValidValues(SingleVariableRule.ValidValues.eWITHIN_RANGE);
            singleVariableRule.setMaximumValue(vDTRuleSpecs.getMaximum());
            singleVariableRule.setMinimumValue(vDTRuleSpecs.getMinimum());
            if (singleVariableRule.getType() == SingleVariableRule.Type.eNUMERIC) {
                singleVariableRule.setFlagNonIntegerValues(vDTRuleSpecs.getFlagNointeger());
            }
            singleVariableRule.setFlagUnlabeledValues(vDTRuleSpecs.getFlagUnlabeled());
        } else {
            singleVariableRule.setCurrentValidValues(SingleVariableRule.ValidValues.eWITHIN_LIST);
            singleVariableRule.setValues(new ArrayList<String>(vDTRuleSpecs.getValueList()));
            if (singleVariableRule.getType() == SingleVariableRule.Type.eSTRING) {
                singleVariableRule.setCaseSensitive(vDTRuleSpecs.getCaseSensitive());
            }
        }
        singleVariableRule.setFlagUserMissingValues(vDTRuleSpecs.getFlagUserMissing());
        if (singleVariableRule.getType() == SingleVariableRule.Type.eNUMERIC || singleVariableRule.getType() == SingleVariableRule.Type.eDATE) {
            singleVariableRule.setFlagSystemMissingValues(vDTRuleSpecs.getFlagSystemMissing());
        } else {
            singleVariableRule.setFlagBlankValues(vDTRuleSpecs.getFlagBlank());
        }
        return singleVariableRule;
    }

    private static CrossVariableRule convertToCrossVarRule(VDTRuleSpecs vDTRuleSpecs) {
        CrossVariableRule crossVariableRule = new CrossVariableRule();
        crossVariableRule.setName(vDTRuleSpecs.getLabel());
        crossVariableRule.setLogicalExpression(vDTRuleSpecs.getCustExpression());
        return crossVariableRule;
    }
}

