/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.define_rules;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRulesTab;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.RulesUtil;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRulesTab;
import com.spss.java_client.ui.dialogs.validatedata.res.ValidateDataResBundle;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;

public class DefineRulesDialog
extends BaseTabbedDialog {
    private boolean mDeleteExistingCrossRules;
    private boolean mDeleteExistingSingleRules;
    private CrossVariableRulesTab mCrossVariableRulesTab;
    private SingleVariableRulesTab mSingleVariableRulesTab;
    private Set<String> mVarNames = new HashSet<String>();
    private Map<ISpssVariable, Set<SingleVariableRule>> mVarRuleMap;
    private Map<SingleVariableRule, Integer> mRuleIndexMap = new HashMap<SingleVariableRule, Integer>();

    public DefineRulesDialog(JFrame jFrame) {
        super(jFrame, false, ValidateDataResBundle.getDefaultResourceBundleName(), ValidateDataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DEFINE_RULES_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
        if (changeEvent.getSource() == this.mTabbedPane) {
            Component component = this.mTabbedPane.getSelectedComponent();
            if (component == this.mSingleVariableRulesTab) {
                this.mSingleVariableRulesTab.setCrossRules(this.mCrossVariableRulesTab.getRules());
            } else if (component == this.mCrossVariableRulesTab) {
                this.mCrossVariableRulesTab.setSingleRules(this.mSingleVariableRulesTab.getRules());
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.loadRules();
    }

    @Override
    public String generateSyntax() {
        StringBuilder stringBuilder = new StringBuilder();
        this.loadVarNames();
        stringBuilder.append(this.generateCrossVarsSyntax().toString());
        if (this.mDeleteExistingSingleRules) {
            stringBuilder.append("* ").append(this.getResString("IDS_DEFRULES_SVR_DELETE_SINGLE_VAR_RULES_COMMENT")).append(SyntaxUtil.terminateSyntax());
            stringBuilder.append(SyntaxUtil.getMainCommand("DATAFILE ATTRIBUTE"));
            stringBuilder.append(SyntaxUtil.getMainCommandParamters("DELETE=$VD.SRule"));
            stringBuilder.append(SyntaxUtil.terminateSyntax());
        }
        if (this.isGenerateDeleteLinkRefSyntax()) {
            stringBuilder.append("* ").append(this.getResString("IDS_DEFRULES_SVR_DELETE_EXISTING_LINKS")).append(SyntaxUtil.terminateSyntax());
            stringBuilder.append(SyntaxUtil.getMainCommand("VARIABLE ATTRIBUTE"));
            stringBuilder.append(SyntaxUtil.getMainCommandParamters("VARIABLES=ALL  DELETE=$VD.SRuleRef"));
            stringBuilder.append(SyntaxUtil.terminateSyntax());
        }
        stringBuilder.append(this.generateSingleRuleSyntax().toString());
        stringBuilder.append(this.generateRuleLinksSyntax());
        String string = stringBuilder.toString().trim();
        return string.trim();
    }

    @Override
    public String getIActionKey() {
        return "data_validation_define_rules";
    }

    public ResourceBundle getResourceBundle() {
        return this.mResBundle;
    }

    public SingleVariableRulesTab getSingleVariableRulesTab() {
        return this.mSingleVariableRulesTab;
    }

    public CrossVariableRulesTab getCrossVariableRulesTab() {
        return this.mCrossVariableRulesTab;
    }

    public void changeTabTraversalPolicy(Vector<Object> vector) {
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    protected void init() {
        super.init();
        this.mSingleVariableRulesTab = new SingleVariableRulesTab(this);
        this.mCrossVariableRulesTab = new CrossVariableRulesTab(this);
        this.addTab(this.getResString("IDS_SINGLE_VARIABLE_RULES_TAB_TITLE"), this.mSingleVariableRulesTab);
        this.addTab(this.getResString("IDS_CROSS_VARIABLE_RULES_TAB_TITLE"), this.mCrossVariableRulesTab);
        this.mVarRuleMap = new HashMap<ISpssVariable, Set<SingleVariableRule>>();
        this.pack();
        this.mSingleVariableRulesTab.afterPack();
        this.mTabbedPane.addChangeListener(this);
        this.enableOkPaste(true);
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.loadRules();
    }

    private void loadVarNames() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.columnCount();
        this.mVarNames.clear();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            if (iSpssVariable == null) continue;
            this.mVarNames.add(iSpssVariable.getName().toLowerCase());
        }
    }

    private StringBuilder generateCrossVarsSyntax() {
        StringBuilder stringBuilder = new StringBuilder();
        List<CrossVariableRule> list = this.mCrossVariableRulesTab.getRules();
        Iterator<CrossVariableRule> iterator = list.iterator();
        while (iterator.hasNext()) {
            CrossVariableRule crossVariableRule = iterator.next();
            if (!crossVariableRule.getLogicalExpression().trim().equals("")) continue;
            iterator.remove();
        }
        if (this.mDeleteExistingCrossRules) {
            stringBuilder.append("* ").append(this.getResString("IDS_DEFRULES_CVR_EXISTING_CROSS_RULES_COMMENT")).append(".\n");
            stringBuilder.append("DATAFILE ATTRIBUTE DELETE=$VD.CRule.\n");
        }
        if (!list.isEmpty()) {
            stringBuilder.append("* ").append(this.getResString("IDS_DEFRULES_CVR_REDEFINE_CROSS_RULES_COMMENT")).append(".\n");
            stringBuilder.append(SyntaxUtil.getMainCommand("DATAFILE ATTRIBUTE"));
            stringBuilder.append(SyntaxUtil.getMainCommandParamters("ATTRIBUTE="));
            int n = 1;
            for (CrossVariableRule crossVariableRule : list) {
                stringBuilder.append("\n   ");
                stringBuilder.append("$VD.CRule[").append(n).append("](\"Label='").append(crossVariableRule.getName());
                String string = RulesUtil.generateOutVarName(crossVariableRule.getName().replaceAll(" ", ""), this.mVarNames);
                String string2 = this.fixQuotes(crossVariableRule.getLogicalExpression());
                stringBuilder.append("',OutcomeVar='").append(string).append("',Expression='").append(string2);
                stringBuilder.append("'\")");
                ++n;
            }
            stringBuilder.append(".\n");
        }
        return stringBuilder;
    }

    private String fixQuotes(String string) {
        String string2 = string.replace("\"", "\"\"");
        string2 = string2.replace("'", "''");
        return string2;
    }

    private String generateRuleLinksSyntax() {
        StringBuilder stringBuilder = new StringBuilder();
        List<SingleVariableRule> list = this.mSingleVariableRulesTab.getRules();
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.columnCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            if (iSpssVariable == null || !this.mVarRuleMap.containsKey(iSpssVariable)) continue;
            stringBuilder.append("\n    ");
            if (++n2 > 1) {
                stringBuilder.append("/");
            }
            stringBuilder.append("VARIABLES=").append(iSpssVariable.getName()).append(" ATTRIBUTE=");
            int n3 = 0;
            Set<SingleVariableRule> set = this.mVarRuleMap.get(iSpssVariable);
            for (SingleVariableRule singleVariableRule : list) {
                if (!set.contains(singleVariableRule)) continue;
                String string = singleVariableRule.getName().replaceAll(" ", "") + "_" + iSpssVariable.getName().replaceAll(" ", "");
                String string2 = RulesUtil.generateOutVarName(string, this.mVarNames);
                stringBuilder.append("\n      ");
                stringBuilder.append("$VD.SRuleRef[").append(++n3).append("]");
                stringBuilder.append("(\"Rule=");
                stringBuilder.append("'$VD.SRule[").append(this.mRuleIndexMap.get(singleVariableRule)).append("]'");
                stringBuilder.append(",OutcomeVar='");
                stringBuilder.append(string2);
                stringBuilder.append("'\")");
            }
        }
        if (stringBuilder.length() > 0) {
            String string = "* " + this.getResString("IDS_DEFRULES_SVR_REDEFINE_LINKS_COMMENT") + ".\n" + "VARIABLE ATTRIBUTE";
            stringBuilder.insert(0, string);
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    private boolean isGenerateDeleteLinkRefSyntax() {
        boolean bl = false;
        Set<ISpssVariable> set = this.mVarRuleMap.keySet();
        for (ISpssVariable iSpssVariable : set) {
            Set<SingleVariableRule> set2 = this.mVarRuleMap.get(iSpssVariable);
            if (set2 == null || set2.size() <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private StringBuilder generateSingleRuleSyntax() {
        StringBuilder stringBuilder = new StringBuilder();
        List<SingleVariableRule> list = this.mSingleVariableRulesTab.getRules();
        Iterator<SingleVariableRule> iterator = list.iterator();
        while (iterator.hasNext()) {
            SingleVariableRule singleVariableRule = iterator.next();
            if (singleVariableRule.getCurrentValidValues() != SingleVariableRule.ValidValues.eWITHIN_RANGE) continue;
            if (singleVariableRule.getMaximumValue() == null && singleVariableRule.getMinimumValue() == null) {
                iterator.remove();
                continue;
            }
            if (!singleVariableRule.getMaximumValue().equals("") || !singleVariableRule.getMinimumValue().equals("") || singleVariableRule.isFlagUserMissingValues() || singleVariableRule.isFlagSystemMissingValues() || singleVariableRule.isFlagBlankValues() || singleVariableRule.isFlagUnlabeledValues() || singleVariableRule.isFlagNonIntegerValues()) continue;
            iterator.remove();
        }
        if (!list.isEmpty()) {
            stringBuilder.append("* ").append(this.getResString("IDS_DEFRULES_SVR_REDIFINE_SINGLE_RULES_COMMENT")).append(SyntaxUtil.terminateSyntax());
            stringBuilder.append(SyntaxUtil.getMainCommand("DATAFILE ATTRIBUTE"));
            stringBuilder.append(SyntaxUtil.getMainCommandParamters("ATTRIBUTE="));
            int n = 1;
            for (SingleVariableRule singleVariableRule : list) {
                boolean bl;
                this.mRuleIndexMap.put(singleVariableRule, n);
                stringBuilder.append("\n   ");
                stringBuilder.append("$VD.SRule[").append(n).append("](\"Label='").append(singleVariableRule.getName());
                stringBuilder.append("', Type='");
                if (singleVariableRule.getType() == SingleVariableRule.Type.eNUMERIC) {
                    stringBuilder.append("Numeric");
                } else if (singleVariableRule.getType() == SingleVariableRule.Type.eSTRING) {
                    stringBuilder.append("String");
                } else {
                    stringBuilder.append("Date', Format='").append(singleVariableRule.getDateFormat().getFormat());
                }
                stringBuilder.append("', Domain='");
                boolean bl2 = bl = singleVariableRule.getCurrentValidValues() == SingleVariableRule.ValidValues.eWITHIN_RANGE;
                if (bl) {
                    stringBuilder.append("Range', Minimum='");
                    stringBuilder.append(singleVariableRule.getMinimumValue()).append("', Maximum='").append(singleVariableRule.getMaximumValue());
                } else {
                    stringBuilder.append("List");
                }
                stringBuilder.append("', FlagUserMissing='");
                if (singleVariableRule.isFlagUserMissingValues()) {
                    stringBuilder.append("Yes");
                } else {
                    stringBuilder.append("No");
                }
                stringBuilder.append("', FlagSystemMissing='");
                if (singleVariableRule.isFlagSystemMissingValues() && singleVariableRule.getType() != SingleVariableRule.Type.eSTRING) {
                    stringBuilder.append("Yes");
                } else {
                    stringBuilder.append("No");
                }
                stringBuilder.append("', FlagBlank='");
                if (singleVariableRule.isFlagBlankValues() && singleVariableRule.getType() == SingleVariableRule.Type.eSTRING) {
                    stringBuilder.append("Yes");
                } else {
                    stringBuilder.append("No");
                }
                stringBuilder.append("', ");
                if (bl) {
                    stringBuilder.append("FlagNoninteger='");
                    if (singleVariableRule.isFlagNonIntegerValues() && singleVariableRule.getType() == SingleVariableRule.Type.eNUMERIC) {
                        stringBuilder.append("Yes");
                    } else {
                        stringBuilder.append("No");
                    }
                    stringBuilder.append("', FlagUnlabeled='");
                    if (singleVariableRule.isFlagUnlabeledValues()) {
                        stringBuilder.append("Yes");
                    } else {
                        stringBuilder.append("No");
                    }
                } else {
                    stringBuilder.append("CaseSensitive='");
                    if (singleVariableRule.isCaseSensitive() && singleVariableRule.getType() == SingleVariableRule.Type.eSTRING) {
                        stringBuilder.append("Yes");
                    } else {
                        stringBuilder.append("No");
                    }
                    stringBuilder.append("',List=");
                    for (String string : singleVariableRule.getValues()) {
                        stringBuilder.append("'").append(UIToolResUtil.removeLocale((String)string)).append("' ");
                    }
                }
                stringBuilder.append("'\")");
                ++n;
            }
            stringBuilder.append(SyntaxUtil.terminateSyntax());
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("  ");
        }
        return stringBuilder;
    }

    private void loadRules() {
        List<SingleVariableRule> list = RulesUtil.loadSingleVarRules();
        List<CrossVariableRule> list2 = RulesUtil.loadCrossVarRules();
        this.mDeleteExistingSingleRules = !list.isEmpty();
        this.mDeleteExistingCrossRules = !list2.isEmpty();
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.columnCount();
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            if (iSpssVariable == null) continue;
            arrayList.add(iSpssVariable);
        }
        this.mVarRuleMap = RulesUtil.loadSelectionsMap(arrayList, list);
        this.mSingleVariableRulesTab.setRules(list, this.mVarRuleMap);
        this.mCrossVariableRulesTab.setRules(list2);
    }
}

