/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.define_rules;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRule;
import com.spss.uitools.dialogs.BaseDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class CrossVariableRulesTableModel
extends AbstractTableModel {
    private BaseDialog mParent;
    private List<CrossVariableRule> mRulesList = new ArrayList<CrossVariableRule>();
    private boolean mSortOrderAscending = false;

    public CrossVariableRulesTableModel(BaseDialog baseDialog) {
        this.mParent = baseDialog;
    }

    public void addRule(CrossVariableRule crossVariableRule) {
        this.mRulesList.add(crossVariableRule);
        this.fireTableRowsInserted(this.mRulesList.size() - 1, this.mRulesList.size() - 1);
    }

    public void addDuplicateRule(int n) {
        CrossVariableRule crossVariableRule = this.mRulesList.get(n);
        CrossVariableRule crossVariableRule2 = null;
        try {
            crossVariableRule2 = crossVariableRule.clone();
            crossVariableRule2.setLogicalExpression(crossVariableRule.getLogicalExpression());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ComponentState.trace1((String)cloneNotSupportedException.getMessage(), (int)15);
        }
        String string = this.getLocalizedString("IDS_DEFINE_RULES_COPY_OF_PART1");
        String string2 = this.getLocalizedString("IDS_DEFINE_RULES_COPY_OF_PART2");
        int n2 = 0;
        for (CrossVariableRule crossVariableRule3 : this.mRulesList) {
            if (crossVariableRule3.getName().startsWith(string + string2)) {
                ++n2;
                continue;
            }
            if (!crossVariableRule3.getName().matches(string + "\\([1-9]*\\)" + string2)) continue;
            ++n2;
        }
        Object object = n2 == 0 ? string + string2 + crossVariableRule.getName() : (crossVariableRule.getName().indexOf(string2) < 0 ? string + "(" + ++n2 + ")" + string2 + crossVariableRule.getName() : string + "(" + ++n2 + ")" + string2 + crossVariableRule.getName().substring(crossVariableRule.getName().indexOf(string2) + string2.length(), crossVariableRule.getName().length()));
        while (!this.isNameUniqueAmongAllRules((String)object)) {
            if (crossVariableRule.getName().indexOf(string2) < 0) {
                object = string + "(" + ++n2 + ")" + string2 + crossVariableRule.getName();
                continue;
            }
            object = string + "(" + ++n2 + ")" + string2 + crossVariableRule.getName().substring(crossVariableRule.getName().indexOf(string2) + string2.length(), crossVariableRule.getName().length());
        }
        if (crossVariableRule2 != null) {
            crossVariableRule2.setName((String)object);
            this.mRulesList.add(crossVariableRule2);
            this.fireTableRowsInserted(this.mRulesList.size() - 1, this.mRulesList.size() - 1);
        }
    }

    public void addNewRule() {
        CrossVariableRule crossVariableRule = new CrossVariableRule();
        String string = this.getLocalizedString("IDS_CROSS_VARIABLE_RULE_DEFAULT_NAME");
        int n = 0;
        for (CrossVariableRule crossVariableRule2 : this.mRulesList) {
            if (!crossVariableRule2.getName().startsWith(string)) continue;
            ++n;
        }
        Object object = string + ++n;
        while (!this.isNameUniqueAmongAllRules((String)object)) {
            object = string + ++n;
        }
        crossVariableRule.setName((String)object);
        crossVariableRule.setLogicalExpression("");
        this.mRulesList.add(crossVariableRule);
        this.fireTableRowsInserted(this.mRulesList.size() - 1, this.mRulesList.size() - 1);
    }

    public void deleteRule(int n) {
        this.mRulesList.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int n) {
        return this.getLocalizedString("IDS_RULE_NAME_COLOUMN");
    }

    @Override
    public int getRowCount() {
        return this.mRulesList.size();
    }

    public CrossVariableRule getRule(int n) {
        if (n >= 0 && n < this.mRulesList.size()) {
            return this.mRulesList.get(n);
        }
        return null;
    }

    public List<CrossVariableRule> getRules() {
        return this.mRulesList;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        CrossVariableRule crossVariableRule = this.mRulesList.get(n);
        return crossVariableRule.getName();
    }

    public void refresh(int n) {
        this.fireTableRowsUpdated(n, n);
    }

    public void sort() {
        this.mSortOrderAscending = !this.mSortOrderAscending;
        Comparator<CrossVariableRule> comparator = new Comparator<CrossVariableRule>(){

            @Override
            public int compare(CrossVariableRule crossVariableRule, CrossVariableRule crossVariableRule2) {
                return crossVariableRule.compareTo(crossVariableRule2);
            }
        };
        if (this.mSortOrderAscending) {
            Collections.sort(this.mRulesList, comparator);
        } else {
            Collections.sort(this.mRulesList, Collections.reverseOrder());
        }
        this.fireTableDataChanged();
    }

    private String getLocalizedString(String string) {
        return this.mParent.getResString(string);
    }

    private boolean isNameUniqueAmongAllRules(String string) {
        for (CrossVariableRule crossVariableRule : this.mRulesList) {
            if (!crossVariableRule.getName().equals(string)) continue;
            return false;
        }
        return true;
    }
}

