/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata.define_rules;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ExpressionValidator;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ExpressionBuilderDescArea;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FocusHighlighter;
import com.spss.java_client.ui.controls.FunctionList;
import com.spss.java_client.ui.controls.FunctionObject;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SpssFocusCellRenderer;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRulesTableModel;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class CrossVariableRulesTab
extends BaseProcedureTab
implements FocusListener,
ListSelectionListener,
MouseListener,
ItemListener,
ActionListener,
KeyListener {
    private AbstractAction mCalculatorButtonAction;
    private CrossVariableRule mCurrentRule;
    private JButton mNewButton;
    private JButton mDeleteRuleButton;
    private JButton mDuplicateRuleButton;
    private ExpressionBuilderTextArea mExpressionArea;
    private ExpressionBuilderDescArea mFunctionDescriptionArea;
    private JComboBox mFunctionGroupsComboBox;
    private DefaultListModel mFunctionListModel;
    private PlainList mFunctionsList;
    private JPanel mRuleDefinitionPanel;
    private StringTextField mRuleNameField;
    private JTable mRulesTable;
    private CrossVariableRulesTableModel mRulesTableModel;
    private SrcVariableList mSrcVariableList;
    private boolean mDeletingRule = false;
    private boolean mReverting = false;
    private JButton mFunctionInsertButton;
    private JButton mVarsInsertButton;
    private List<SingleVariableRule> mSingleRules;
    private JPanel mCalculatorButtonsPanel;

    public CrossVariableRulesTab(BaseDialog baseDialog) {
        super(baseDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_page_customrules";
    }

    @Override
    public void reset() {
        super.reset();
        this.mRulesTableModel.getRules().clear();
        this.setEnableState(this.mRuleDefinitionPanel, true);
        this.setDefaults();
    }

    public void setRules(List<CrossVariableRule> list) {
        if (list.isEmpty()) {
            this.mRulesTableModel.addNewRule();
        } else {
            for (CrossVariableRule crossVariableRule : list) {
                this.mRulesTableModel.addRule(crossVariableRule);
            }
        }
        this.mRulesTable.getSelectionModel().setSelectionInterval(0, 0);
    }

    public void setSingleRules(List<SingleVariableRule> list) {
        this.mSingleRules = list;
    }

    public List<CrossVariableRule> getRules() {
        return this.mRulesTableModel.getRules();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mRuleNameField) {
            Component component = focusEvent.getOppositeComponent();
            JButton jButton = null;
            if (component instanceof JButton) {
                jButton = (JButton)component;
            }
            if (!(focusEvent.getOppositeComponent() == null || focusEvent.getOppositeComponent() == this.mDeleteRuleButton || this.mCurrentRule == null || jButton != null && jButton.getActionCommand().equals(ResUtil.getCommonDlgString("IDS_CANCEL")))) {
                if (this.checkNotUniqueName()) {
                    int n = this.mRulesTableModel.getRules().indexOf(this.mCurrentRule);
                    if (this.mRulesTable.getSelectedRow() != n) {
                        this.mReverting = true;
                        this.mRulesTable.setRowSelectionInterval(n, n);
                    }
                    return;
                }
                this.saveToCurrentRule();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 9) {
            Component component = null;
            Component component2 = (Component)keyEvent.getSource();
            FocusTraversalPolicy focusTraversalPolicy = this.mParent.getFocusTraversalPolicy();
            if (focusTraversalPolicy != null) {
                component = keyEvent.isShiftDown() ? focusTraversalPolicy.getComponentBefore((Container)this.mParent, component2) : focusTraversalPolicy.getComponentAfter((Container)this.mParent, component2);
            }
            keyEvent.consume();
            if (component != null) {
                component.requestFocus();
            }
        } else if (keyEvent.getSource() == this.mFunctionDescriptionArea && n != 37 && n != 39 && n != 40 && n != 38) {
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object == this.mRulesTable.getSelectionModel()) {
            int n = this.mRulesTable.getSelectedRow();
            if (!(this.mReverting || this.mDeletingRule || this.mCurrentRule == null || this.validateRule())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = CrossVariableRulesTab.this.mRulesTableModel.getRules().indexOf(CrossVariableRulesTab.this.mCurrentRule);
                        if (CrossVariableRulesTab.this.mRulesTable.getSelectedRow() != n) {
                            CrossVariableRulesTab.this.mReverting = true;
                            CrossVariableRulesTab.this.mRulesTable.setRowSelectionInterval(n, n);
                        }
                    }
                });
            } else {
                this.setCurrentRule(this.mRulesTableModel.getRule(n));
                this.mReverting = false;
                this.mDeletingRule = false;
            }
        } else if (object == this.mFunctionsList.getSelectionModel()) {
            if (this.mFunctionsList.getSelectedIndex() > -1) {
                FunctionObject functionObject = (FunctionObject)this.mFunctionsList.getSelectedValue();
                this.mFunctionDescriptionArea.setText(functionObject.getDesciption());
                this.mFunctionInsertButton.setEnabled(true);
            } else {
                this.mFunctionInsertButton.setEnabled(false);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.mRulesTable.getTableHeader()) {
            TableColumnModel tableColumnModel = ((JTableHeader)mouseEvent.getSource()).getColumnModel();
            int n = tableColumnModel.getColumn(tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n == 0) {
                this.mRulesTableModel.sort();
            }
        } else if (object == this.mSrcVariableList) {
            if (mouseEvent.getClickCount() >= 2 && this.mSrcVariableList.getSelectedIndex() != -1) {
                this.mExpressionArea.replaceSelection(((ISpssVariable)this.mSrcVariableList.getSelectedValue()).getName());
                this.mExpressionArea.requestFocus();
            }
        } else if (object == this.mFunctionsList) {
            if (this.mFunctionsList.getSelectedIndex() != -1) {
                FunctionObject functionObject = (FunctionObject)this.mFunctionsList.getSelectedValue();
                this.mFunctionDescriptionArea.setText(functionObject.getDesciption());
                if (mouseEvent.getClickCount() >= 2) {
                    this.mExpressionArea.replaceSelection(functionObject.getInsertString());
                    this.mExpressionArea.requestFocus();
                }
            } else {
                this.mFunctionDescriptionArea.setText("");
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.mFunctionDescriptionArea.setText("");
            this.mFunctionListModel.clear();
            int n = this.mFunctionGroupsComboBox.getSelectedIndex();
            if (n == 0) {
                this.loadAllFunctions();
            } else {
                List<FunctionObject> list = FunctionList.getInstance().getFunctionList(n);
                for (FunctionObject functionObject : list) {
                    this.mFunctionListModel.addElement(functionObject);
                }
            }
            this.mFunctionsList.setSelectedIndex(-1);
            this.mFunctionInsertButton.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mNewButton && this.validateRule()) {
            if (this.mCurrentRule == null) {
                this.mDuplicateRuleButton.setEnabled(true);
                this.mDeleteRuleButton.setEnabled(true);
                this.setEnableState(this.mRuleDefinitionPanel, true);
            }
            if (this.mRulesTableModel.getRowCount() == 0) {
                this.mCurrentRule = null;
            }
            this.mRulesTableModel.addNewRule();
            int n = this.mRulesTableModel.getRowCount() - 1;
            this.mRulesTable.setRowSelectionInterval(n, n);
        }
        if (object == this.mDuplicateRuleButton) {
            if (this.validateRule()) {
                this.saveToCurrentRule();
                if (this.mRulesTable.getSelectedRow() != -1) {
                    this.mRulesTableModel.addDuplicateRule(this.mRulesTable.getSelectedRow());
                    this.mRulesTable.setRowSelectionInterval(this.mRulesTableModel.getRowCount() - 1, this.mRulesTableModel.getRowCount() - 1);
                }
            }
        } else if (object == this.mDeleteRuleButton) {
            this.deleteRules();
        }
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mRulesTable;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardDialogInsets();
        JScrollPane jScrollPane = new JScrollPane(this.mRulesTable);
        jScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight()));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_RULES_TABLE_TITLE");
        jLabel.setLabelFor(this.mRulesTable);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, 10, new Insets(insets.top, insets.left, 0, 0));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 1, 1, 1, 10, new Insets(0, insets.left, 0, 0));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mRuleDefinitionPanel = this.setupRuleDefinitionPanel();
        DialogUtil.addUsingGBL(this, this.mRuleDefinitionPanel, gridBagConstraints, 1, 0, 1, 3, 10, insets);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNewButton, gridBagConstraints, 0, 0, 1, 1, 10, DialogUtil.getStandardButtonInsets());
        DialogUtil.addUsingGBL(jPanel, this.mDuplicateRuleButton, gridBagConstraints, 1, 0, 1, 1, 10, DialogUtil.getStandardButtonInsets());
        DialogUtil.addUsingGBL(jPanel, this.mDeleteRuleButton, gridBagConstraints, 2, 0, 1, 1, 10, DialogUtil.getStandardButtonInsets());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 2, 1, 1, 10, new Insets(0, insets.left, insets.bottom, 0));
        if (this.mParent.getGlassPane() instanceof DragPane) {
            ExpressionBuilderUtil.addExpressionTextAreaDragAdapter((DragPane)this.mParent.getGlassPane(), this.mExpressionArea);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.mParent.getGlassPane(), this.mFunctionsList);
        }
    }

    protected boolean validateRule() {
        int n = this.mExpressionArea.getCaretPosition();
        boolean bl = this.mExpressionArea.validateContents();
        this.mExpressionArea.setCaretPosition(n);
        String string = this.mExpressionArea.getText();
        if (string.contains("?")) {
            int n2 = string.indexOf(63);
            this.mExpressionArea.select(n2, n2 + 1);
        }
        if (!bl) {
            return false;
        }
        if (string.length() > 0) {
            ExpressionValidator expressionValidator = new ExpressionValidator();
            String string2 = this.getUniqueVariableName();
            StringBuffer stringBuffer = new StringBuffer("_COMPUTE ");
            stringBuffer.append(string2);
            stringBuffer.append("=");
            stringBuffer.append(string);
            stringBuffer.append(".");
            String string3 = stringBuffer.toString();
            if (!expressionValidator.validateGeneralExpression(string3)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, expressionValidator.checkError(), VersionInfo.getAppVersionString());
                this.setFocusOnExpressionField();
                return false;
            }
        }
        return true;
    }

    private String getUniqueVariableName() {
        String string = "VAR";
        Set<String> set = this.getVariableNames();
        string = VarNameValidator.generateUniqueSpssName((String)string, set, (boolean)false);
        return string;
    }

    private Set<String> getVariableNames() {
        LocallyUniqueId locallyUniqueId;
        HashSet<String> hashSet = new HashSet<String>();
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        ISpssDataSrc iSpssDataSrc = null;
        if (spssFrame instanceof DataFrame) {
            locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        if (iSpssDataSrc != null) {
            for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
                locallyUniqueId = iSpssDataSrc.getVariable(i);
                if (locallyUniqueId == null) continue;
                hashSet.add(locallyUniqueId.getName().toLowerCase());
            }
        }
        return hashSet;
    }

    private void setFocusOnExpressionField() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CrossVariableRulesTab.this.mExpressionArea.requestFocus();
            }
        });
    }

    @Override
    protected boolean validateTab() {
        boolean bl = true;
        if (this.mRulesTableModel.getRowCount() > 0) {
            if (!this.checkNotUniqueName() && this.validateRule()) {
                this.saveToCurrentRule();
                bl = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            DragPane dragPane;
            if (this.mParent.getGlassPane() instanceof DragPane) {
                dragPane = new ArrayList();
                DragPane dragPane2 = (DragPane)this.mParent.getGlassPane();
                dragPane.addAll(dragPane2.getDropListeners());
                for (IDropListener iDropListener : dragPane) {
                    if (!(iDropListener instanceof VarListDropListener)) continue;
                    dragPane2.removeDropListener(iDropListener);
                }
            }
            for (DragPane dragPane3 : dragPane = this.mFunctionDescriptionArea.getKeyListeners()) {
                if (!(dragPane3 instanceof TextAreaKeyListener)) continue;
                this.mFunctionDescriptionArea.removeKeyListener((KeyListener)dragPane3);
            }
        }
        return bl;
    }

    private boolean checkNotUniqueName() {
        String string = this.mRuleNameField.getText().trim();
        boolean bl = false;
        for (CrossVariableRule serializableObject : this.mRulesTableModel.getRules()) {
            if (serializableObject == this.mCurrentRule || !serializableObject.getName().equals(string)) continue;
            bl = true;
            break;
        }
        if (this.mSingleRules != null) {
            for (SingleVariableRule singleVariableRule : this.mSingleRules) {
                if (!singleVariableRule.getName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        if (!bl && string.equals("")) {
            bl = true;
        }
        if (bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RULE_NAME_ERROR"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CrossVariableRulesTab.this.mRuleNameField.requestFocus();
                    CrossVariableRulesTab.this.mRuleNameField.selectAll();
                }
            });
        }
        return bl;
    }

    private void loadAllFunctions() {
        int n = this.mFunctionGroupsComboBox.getItemCount();
        for (int i = 1; i < n; ++i) {
            List<FunctionObject> list = FunctionList.getInstance().getFunctionList(i);
            for (FunctionObject functionObject : list) {
                this.mFunctionListModel.addElement(functionObject);
            }
        }
    }

    private JButton createButtonWithAction(String string) {
        JButton jButton = new JButton(this.mCalculatorButtonAction);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jButton.putClientProperty("JButton.buttonType", "square");
        }
        jButton.setText(string);
        return jButton;
    }

    private void initVars() {
        Component[] componentArray;
        this.mRulesTableModel = new CrossVariableRulesTableModel(this.mParent);
        this.mRulesTable = new JTable(this.mRulesTableModel);
        SpssFocusCellRenderer spssFocusCellRenderer = new SpssFocusCellRenderer();
        spssFocusCellRenderer.setHorizontalAlignment(2);
        this.mRulesTable.setDefaultRenderer(Object.class, spssFocusCellRenderer);
        this.mRulesTable.setSelectionMode(0);
        this.mRulesTable.getSelectionModel().addListSelectionListener(this);
        this.mRulesTable.getTableHeader().setReorderingAllowed(false);
        this.mRulesTable.getTableHeader().addMouseListener(this);
        this.mRulesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    CrossVariableRulesTab.this.deleteRules();
                }
            }
        });
        this.mNewButton = new JButton(new ToggleButtonAction(this.mParent, "IDS_CROSS_NEW_RULE"));
        this.mNewButton.addActionListener(this);
        this.mDuplicateRuleButton = new JButton(new ToggleButtonAction(this.mParent, "IDS_CROSS_DUPLICATE_RULE"));
        this.mDuplicateRuleButton.addActionListener(this);
        this.mDeleteRuleButton = new JButton(new ToggleButtonAction(this.mParent, "IDS_CROSS_DELETE_RULE"));
        this.mDeleteRuleButton.addActionListener(this);
        this.mRuleNameField = new StringTextField(16);
        this.mRuleNameField.addFocusListener(this);
        this.mExpressionArea = new ExpressionBuilderTextArea(3, 40){

            @Override
            public void replaceSelection(String string) {
                super.replaceSelection(string);
                String string2 = this.getText();
                if (string2.contains("?")) {
                    int n = string2.indexOf(63);
                    this.select(n, n + 1);
                } else if (string2.contains("()")) {
                    this.setCaretPosition(this.getCaretPosition() - 1);
                }
            }
        };
        this.mExpressionArea.setFocusTraversalKeys(1, null);
        this.mExpressionArea.setLineWrap(true);
        this.mCalculatorButtonAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((JButton)actionEvent.getSource()).getText();
                if (string.compareTo("()") != 0) {
                    string = " " + string + " ";
                }
                CrossVariableRulesTab.this.mExpressionArea.replaceSelection(string);
                CrossVariableRulesTab.this.mExpressionArea.requestFocus();
            }
        };
        this.mCalculatorButtonsPanel = this.setupCalculatorButtonsPanel();
        this.mSrcVariableList = new SrcVariableList();
        this.mSrcVariableList.setSelectionMode(0);
        this.mSrcVariableList.loadFromActiveDataset();
        this.mSrcVariableList.addMouseListener(this);
        this.mVarsInsertButton = new JButton(new ToggleButtonAction(this.mParent, "IDS_INSERT_BUTTON_VARIABLES"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CrossVariableRulesTab.this.mSrcVariableList.getSelectedIndex() != -1) {
                    CrossVariableRulesTab.this.mExpressionArea.replaceSelection(((ISpssVariable)CrossVariableRulesTab.this.mSrcVariableList.getSelectedValue()).getName());
                    CrossVariableRulesTab.this.mExpressionArea.requestFocus();
                }
            }
        });
        FunctionList functionList = FunctionList.getInstance();
        List<String> list = functionList.getFunctionGroups();
        this.mFunctionGroupsComboBox = new JComboBox<String>(new Vector<String>(list));
        this.mFunctionDescriptionArea = new ExpressionBuilderDescArea(5, 20);
        this.mFunctionDescriptionArea.setEditable(false);
        this.mFunctionDescriptionArea.setLineWrap(true);
        this.mFunctionDescriptionArea.setWrapStyleWord(true);
        this.mFunctionDescriptionArea.setOpaque(false);
        this.mFunctionDescriptionArea.addFocusListener(new FocusHighlighter(this.mFunctionDescriptionArea));
        this.mFunctionListModel = new DefaultListModel();
        this.mFunctionsList = new PlainList("FUNCTION_LIST");
        this.mFunctionsList.setModel(this.mFunctionListModel);
        this.mFunctionInsertButton = new JButton(new ToggleButtonAction(this.mParent, "IDS_INSERT_BUTTON_FUNCTIONS"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CrossVariableRulesTab.this.mFunctionsList.getSelectedIndex() != -1) {
                    FunctionObject functionObject = (FunctionObject)CrossVariableRulesTab.this.mFunctionsList.getSelectedValue();
                    CrossVariableRulesTab.this.mExpressionArea.replaceSelection(functionObject.getInsertString());
                    CrossVariableRulesTab.this.mExpressionArea.requestFocus();
                }
            }
        });
        this.mFunctionsList.setSelectionMode(0);
        this.mFunctionGroupsComboBox.addItemListener(this);
        this.setDefaults();
        this.mFunctionsList.addMouseListener(this);
        this.mFunctionsList.getSelectionModel().addListSelectionListener(this);
        this.mRulesTable.getSelectionModel().addListSelectionListener(this);
        this.addToComponentOrder(this.mRulesTable);
        this.addToComponentOrder(this.mNewButton);
        this.addToComponentOrder(this.mDuplicateRuleButton);
        this.addToComponentOrder(this.mDeleteRuleButton);
        this.addToComponentOrder(this.mRuleNameField);
        this.addToComponentOrder((Object)this.mExpressionArea);
        for (Component component : componentArray = this.mCalculatorButtonsPanel.getComponents()) {
            Component[] componentArray2;
            if (component instanceof JButton) {
                this.addToComponentOrder(component);
                continue;
            }
            if (!(component instanceof JPanel)) continue;
            for (Component component2 : componentArray2 = ((JPanel)component).getComponents()) {
                this.addToComponentOrder(component2);
            }
        }
        this.addToComponentOrder(this.mSrcVariableList);
        this.addToComponentOrder(this.mVarsInsertButton);
        this.addToComponentOrder(this.mFunctionsList);
        this.addToComponentOrder(this.mFunctionGroupsComboBox);
        this.addToComponentOrder(this.mFunctionInsertButton);
        this.addToComponentOrder(this.mFunctionDescriptionArea);
        this.mRulesTable.setFocusable(true);
        this.mRulesTable.setFocusTraversalKeys(0, null);
        this.mExpressionArea.setFocusable(true);
        this.mExpressionArea.setFocusTraversalKeys(0, null);
        this.mFunctionDescriptionArea.addKeyListener(this);
    }

    private void setDefaults() {
        this.mExpressionArea.setText("");
        this.mRuleNameField.setText("");
        this.mFunctionGroupsComboBox.setSelectedIndex(0);
        this.mFunctionInsertButton.setEnabled(false);
        this.loadAllFunctions();
        this.mFunctionsList.clearSelection();
        this.mSrcVariableList.setSelectedIndex(0);
        this.mFunctionDescriptionArea.setText("");
    }

    private void loadFromCurrentRule() {
        this.mRuleNameField.setText(this.mCurrentRule.getName());
        this.mExpressionArea.setText(this.mCurrentRule.getLogicalExpression());
    }

    private void saveToCurrentRule() {
        this.mCurrentRule.setName(this.mRuleNameField.getText());
        this.mCurrentRule.setLogicalExpression(this.mExpressionArea.getText());
        this.mRulesTableModel.refresh(this.mRulesTableModel.getRules().indexOf(this.mCurrentRule));
    }

    private void setCurrentRule(CrossVariableRule crossVariableRule) {
        if (this.mCurrentRule != null) {
            this.saveToCurrentRule();
        }
        this.mCurrentRule = crossVariableRule;
        if (this.mCurrentRule != null) {
            this.loadFromCurrentRule();
        }
    }

    private void setEnableState(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof JTextComponent || component == this.mFunctionsList) {
            ((JComponent)component).setOpaque(bl);
        } else if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.setEnableState(component2, bl);
            }
        }
    }

    private JPanel setupCalculatorButtonsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, n / 2);
        DialogUtil.addUsingGBL(jPanel, this.createButtonWithAction("+"), gridBagConstraints, 0, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, this.createButtonWithAction("-"), gridBagConstraints, 1, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, this.createButtonWithAction("*"), gridBagConstraints, 2, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, this.createButtonWithAction("/"), gridBagConstraints, 3, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, this.createButtonWithAction("**"), gridBagConstraints, 4, 0, 1, 1, 21, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.createButtonWithAction("<"), gridBagConstraints, 0, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel2, this.createButtonWithAction(">"), gridBagConstraints, 1, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel2, this.createButtonWithAction("<="), gridBagConstraints, 2, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel2, this.createButtonWithAction(">="), gridBagConstraints, 3, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel2, this.createButtonWithAction("="), gridBagConstraints, 4, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel2, this.createButtonWithAction("~="), gridBagConstraints, 5, 0, 1, 1, 21, insets);
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = new Insets(0, n * 2, 0, n * 2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 5, 0, 1, 1, 10, insets2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.createButtonWithAction("&"), gridBagConstraints, 6, 0, 1, 1, 22, insets);
        DialogUtil.addUsingGBL(jPanel, this.createButtonWithAction("|"), gridBagConstraints, 7, 0, 1, 1, 22, insets);
        DialogUtil.addUsingGBL(jPanel, this.createButtonWithAction("~"), gridBagConstraints, 8, 0, 1, 1, 22, insets);
        DialogUtil.addUsingGBL(jPanel, this.createButtonWithAction("()"), gridBagConstraints, 9, 0, 1, 1, 22, null);
        this.normalizeButtonSizes(jPanel, 10);
        return jPanel;
    }

    private void normalizeButtonSizes(JPanel jPanel, int n) {
        JButton jButton;
        Object object;
        int n2 = 25;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            n2 = 30;
        }
        for (Component component : jPanel.getComponents()) {
            if (component instanceof JButton) {
                object = (Component[])component;
                ((JComponent)object).setMinimumSize(null);
                ((JComponent)object).setPreferredSize(null);
                ((JComponent)object).setMaximumSize(null);
                int n3 = ((JComponent)object).getPreferredSize().width;
                n = n > n3 ? n : n3;
                continue;
            }
            if (!(component instanceof JPanel)) continue;
            for (Component object2 : ((JPanel)component).getComponents()) {
                if (!(object2 instanceof JButton)) continue;
                jButton = (JButton)object2;
                jButton.setMinimumSize(null);
                jButton.setPreferredSize(null);
                jButton.setMaximumSize(null);
                int n3 = jButton.getPreferredSize().width;
                n = n > n3 ? n : n3;
            }
        }
        for (Component component : jPanel.getComponents()) {
            if (component instanceof JButton) {
                object = (JButton)component;
                Dimension dimension = new Dimension(n, n2);
                ((JComponent)object).setPreferredSize(dimension);
                ((JComponent)object).setMaximumSize(dimension);
                ((JComponent)object).setMinimumSize(dimension);
                continue;
            }
            if (!(component instanceof JPanel)) continue;
            for (Component component2 : ((JPanel)component).getComponents()) {
                if (!(component2 instanceof JButton)) continue;
                jButton = (JButton)component2;
                Dimension dimension = new Dimension(n, n2);
                jButton.setPreferredSize(dimension);
                jButton.setMaximumSize(dimension);
                jButton.setMinimumSize(dimension);
            }
        }
    }

    private JPanel setupFunctionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_FUNCTIONS_AND_SPECIAL_VARIABLES")));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_FUNCTIONS_TITLE");
        jLabel.setLabelFor(this.mFunctionsList);
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.top = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 3, 1, 21, DialogUtil.getStandardControlInsets());
        jLabel = DialogUtil.createLabel(this.mParent, "IDS_DESCRIPTION_TITLE");
        jLabel.setLabelFor(this.mFunctionDescriptionArea);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 3, 1, 21, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.mFunctionsList);
        jScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight() / 2));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 3, 1, 21, DialogUtil.getStandardControlInsets());
        jScrollPane = new JScrollPane(this.mFunctionDescriptionArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight() / 2));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 4, 3, 1, 21, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jLabel = DialogUtil.createLabel(this.mParent, "IDS_DISPLAY_GROUP");
        jLabel.setLabelFor(this.mFunctionGroupsComboBox);
        Insets insets2 = (Insets)DialogUtil.getStandardButtonInsets().clone();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, 21, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mFunctionInsertButton, gridBagConstraints, 2, 2, 1, 1, 21, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionGroupsComboBox, gridBagConstraints, 1, 2, 1, 1, 21, insets2);
        return jPanel;
    }

    private JPanel setupLogicalExpressionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_LOGICAL_EXPRESSION");
        jLabel.setLabelFor((Component)((Object)this.mExpressionArea));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.mExpressionArea));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight() / 4));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 21, null);
        DialogUtil.addUsingGBL(jPanel, this.mCalculatorButtonsPanel, gridBagConstraints, 0, 2, 1, 1, 21, new Insets(DialogUtil.getComponentGroupGap() / 2, 0, 0, 0));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, 21, null);
        return jPanel;
    }

    private JPanel setupRuleDefinitionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RULE_DEFINITION")));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_RULE_NAME");
        jLabel.setLabelFor((Component)((Object)this.mRuleNameField));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mRuleNameField), gridBagConstraints, 1, 0, 1, 1, 21, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, new JPanel(), gridBagConstraints, 1, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, 21, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        Insets insets2 = (Insets)insets.clone();
        insets2.top = DialogUtil.getStandardDialogInsets().top;
        DialogUtil.addUsingGBL(jPanel, this.setupLogicalExpressionPanel(), gridBagConstraints, 0, 1, 2, 1, 21, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.left = DialogUtil.getStandardDialogInsets().left;
        DialogUtil.addUsingGBL(jPanel, this.setupFunctionsPanel(), gridBagConstraints, 1, 2, 1, 1, 21, insets2);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        insets2.left = insets.left;
        DialogUtil.addUsingGBL(jPanel, this.setupVariablesPanel(), gridBagConstraints, 0, 2, 1, 1, 21, insets2);
        return jPanel;
    }

    private JPanel setupVariablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_SOURCE_VARIABLES");
        jLabel.setLabelFor(this.mSrcVariableList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVariableList);
        jScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        jScrollPane.setMinimumSize(this.mSrcVariableList.getMinimumSize());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 21, null);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mVarsInsertButton, gridBagConstraints, 0, 2, 1, 1, 22, DialogUtil.getStandardButtonInsets());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, 21, null);
        return jPanel;
    }

    private void deleteRules() {
        int n = this.mRulesTable.getSelectedRow();
        if (n != -1) {
            this.mDeletingRule = true;
            this.mRulesTableModel.deleteRule(n);
            if (this.mRulesTableModel.getRules().isEmpty()) {
                this.mDuplicateRuleButton.setEnabled(false);
                this.mDeleteRuleButton.setEnabled(false);
                this.mRuleNameField.setText("");
                this.mExpressionArea.setText("");
                this.setEnableState(this.mRuleDefinitionPanel, false);
            } else if (n > 0) {
                this.mDeletingRule = true;
                this.mRulesTable.requestFocus();
                this.mRulesTable.setRowSelectionInterval(n - 1, n - 1);
                this.setEnableState(this.mRuleDefinitionPanel, true);
            } else {
                this.mDeletingRule = true;
                this.mRulesTable.requestFocus();
                this.mRulesTable.setRowSelectionInterval(0, 0);
                this.setEnableState(this.mRuleDefinitionPanel, true);
            }
            if (this.mRulesTable.getRowCount() == 0) {
                this.mNewButton.requestFocus();
            }
        }
    }
}

