/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.validatedata;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFile;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.validatedata.res.ValidateDataResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;

public class LoadPredefRulesDlg
extends BaseProcedureDialog {
    static final String PREDEF_VALIDATION_RULES_HELP = "idh_idd_load_pred_val_rules";
    private JTextArea mPredefRuleExistMesg;
    private Vector<Object> mTabOrder;
    String mPath;
    String mRulesLocation;
    boolean mIsFileExist = false;
    static final int STANDARD_FONT_SIZE = 11;

    public LoadPredefRulesDlg(JFrame jFrame) {
        super(jFrame, true, ValidateDataResBundle.getDefaultResourceBundleName(), ValidateDataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_LOAD_PREDEF_VALID_RULES_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < LoadPredefRulesDlg.this.mCmdButtonPanel.getComponentCount(); ++i) {
                    if (!((JButton)LoadPredefRulesDlg.this.mCmdButtonPanel.getComponent(i)).getText().equals(ResUtil.getCommonDlgString("IDS_CANCEL"))) continue;
                    LoadPredefRulesDlg.this.mCmdButtonPanel.getComponent(i).requestFocus();
                }
            }
        });
    }

    @Override
    public String getIActionKey() {
        return "data_validation_load_predefined_rules";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("APPLY DICTIONARY"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("FROM "));
        if (DataServerProxy.getDataProxy().isRemoteConnection()) {
            this.mRulesLocation = this.mRulesLocation.replace("\\", "/");
        }
        stringBuffer.append(CharacterUtil.smartQuote((String)this.mRulesLocation));
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FILEINFO "));
        stringBuffer.append("ATTRIBUTES=MERGE");
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/VARINFO"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE ATTRIBUTE"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES=ALL"));
        stringBuffer.append(" DELETE=$VD.SRuleRef");
        stringBuffer.append(SyntaxUtil.terminateSyntax().toString());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return PREDEF_VALIDATION_RULES_HELP;
    }

    @Override
    protected void init() {
        File[] fileArray;
        Object object;
        super.init();
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Data, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        if (!DataServerProxy.getDataProxy().isRemoteConnection()) {
            this.mPath = System.getProperty("application.home");
            object = new File(this.mPath + File.separatorChar + "lang" + File.separatorChar + this.getOLangTag());
            fileArray = ((File)object).listFiles();
            this.checkFileExist(fileArray);
        } else {
            this.mPath = remoteFileChooser.getFileSystemView().getDefaultDirectory().getAbsolutePath();
            object = remoteFileChooser.getFileSystemView();
            fileArray = ((FileSystemView)object).getFiles((File)new RefFile(this.mPath + File.separatorChar + "lang" + File.separatorChar + this.getOLangTag()), false);
            this.checkFileExist(fileArray);
        }
        if (this.mIsFileExist) {
            Object object2;
            JComponent jComponent;
            this.initVars();
            this.setDefaults();
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
                jComponent = (JButton)this.mCmdButtonPanel.getComponent(i);
                object2 = jComponent.getText();
                if (((String)object2).equals(ResUtil.getCommonDlgString("IDS_RESET"))) {
                    n2 = i;
                }
                if (!((String)object2).equals(ResUtil.getCommonDlgString("IDS_CANCEL"))) continue;
                n = i;
            }
            this.mCmdButtonPanel.getRootPane().setDefaultButton((JButton)this.mCmdButtonPanel.getComponent(n));
            this.mCmdButtonPanel.remove(n2);
            JPanel jPanel = this.getViewPanel();
            jComponent = this.setupDefinationPanel();
            object2 = new GridBagConstraints();
            Insets insets = DialogUtil.getStandardControlInsets();
            ((GridBagConstraints)object2).weightx = 1.0;
            ((GridBagConstraints)object2).weighty = 1.0;
            int n3 = 23;
            ((GridBagConstraints)object2).fill = 1;
            DialogUtil.addUsingGBL(jPanel, jComponent, (GridBagConstraints)object2, 0, 0, 1, 1, n3, new Insets(0, insets.left * 15, 0, insets.right * 15));
            this.setTabPolicy();
            this.pack();
        } else {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), String.format(this.getResString("ERR_PREDEF_RULES_DO_NOT_EXIST_MESG"), this.getLangPredefFileName()), VersionInfo.getAppVersionString());
            this.dispose();
        }
    }

    private String getOLangTag() {
        return ComponentState.getOLangLocale().toString();
    }

    private void initVars() {
        double d;
        double d2;
        String string = String.format(this.getResString("IDS_PREDEF_RULES_EXIST_MESG_TEXT"), this.getLangPredefFileName());
        this.mPredefRuleExistMesg = new JTextArea(string);
        this.mPredefRuleExistMesg.setOpaque(false);
        this.mPredefRuleExistMesg.setEditable(false);
        this.mPredefRuleExistMesg.setFocusable(false);
        this.mPredefRuleExistMesg.setLineWrap(true);
        this.mPredefRuleExistMesg.setWrapStyleWord(true);
        int n = 300;
        int n2 = 180;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC || OSInfo.getOSType() == OSInfo.OSType.LINUX) {
            n2 += 30;
        }
        if ((d2 = (d = (double)this.mPredefRuleExistMesg.getFont().getSize()) / 11.0) < 1.0) {
            d2 = 1.0;
        }
        if (d2 > 1.0) {
            d2 = 1.25;
        }
        n = (int)((double)n * d2);
        n2 = (int)((double)n2 * d2);
        this.mPredefRuleExistMesg.setMinimumSize(new Dimension(n, n2));
        this.mPredefRuleExistMesg.setPreferredSize(new Dimension(n, n2));
        this.mTabOrder = new Vector();
    }

    private void setDefaults() {
        this.enableOkPaste(true);
    }

    private JPanel setupDefinationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mPredefRuleExistMesg, gridBagConstraints, 0, 0, 1, 1, n, null);
        return jPanel;
    }

    private void setTabPolicy() {
        this.mTabOrder.add(this.mPredefRuleExistMesg);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void checkFileExist(File[] fileArray) {
        for (File file : fileArray) {
            if (!file.isFile() || !file.getName().equals(this.getPredefFileName())) continue;
            this.mIsFileExist = true;
            this.mRulesLocation = file.getAbsolutePath();
            break;
        }
    }

    private String getLangPredefFileName() {
        return "lang" + File.separatorChar + this.getOLangTag() + File.separatorChar + this.getPredefFileName();
    }

    private String getPredefFileName() {
        return "Predefined Validation Rules.sav";
    }
}

