/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TreeValidation
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener,
ListSelectionListener {
    static final int NUMBER_OF_SAMPLE_COLUMNS = 6;
    static final int TRAINING_SAMPLE_COLUMNS = 5;
    static final int SAMPLE_MIN = 2;
    static final int SAMPLE_MAX = 25;
    static final String PERCENTAGE_LABEL = "   50%";
    static final String NONE_RADIO_KEY = "IDS_TREE_VALIDATION_NONE_RADIO";
    static final String CROSSVALIDATION_RADIO_KEY = "IDS_TREE_VALIDATION_CROSSVALIDATION_RADIO";
    static final String SPLIT_SAMPLE_RADIO_KEY = "IDS_TREE_VALIDATION_SPLIT_SAMPLE_RADIO";
    static final String USE_RANDOM_RADIO_KEY = "IDS_TREE_VALIDATION_USE_RANDOM_RADIO";
    static final String USE_VARIABLE_RADIO_KEY = "IDS_TREE_VALIDATION_USE_VARIABLE_RADIO";
    static final String TRAINING_TEST_RADIO_KEY = "IDS_TREE_VALIDATION_TRAINING_TEST_RADIO";
    static final String TEST_SAMPLE_RADIO_KEY = "IDS_TREE_VALIDATIONTEST_SAMPLE_RADIO";
    static final String SAMPLE_FOLDS = "10";
    static final double TRAINING_SAMPLE = 50.0;
    static final String NUMBER_OF_SAMPLES_EDIT = "IDS_TREE_VALIDATION_NUMBER_OF_SAMPLES_FOLDS_EDIT";
    static final String TRAINING_SAMPLES_EDIT = "IDS_TREE_VALIDATION_NUMBER_OF_SAMPLES_EDIT";
    static final String SPLIT_SAMPLE_BY_LIST = "IDS_TREE_VALIDATION_SPLIT_SAMPLE_BY_LIST";
    private char mDecimalSeparator;
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mTargetVarList;
    private JScrollPane mTargetScrollPane;
    private ArrowButton mArrowButton;
    private JRadioButton mNoneRadio;
    private JRadioButton mCrossValidationRadio;
    private JRadioButton mSplitSampleRadio;
    private JRadioButton mUseRandomRadio;
    private JRadioButton mUseVariableRadio;
    private JRadioButton mTrainingRadio;
    private JRadioButton mTestSampleRadio;
    private JLabel mNumberOfSampleLabel;
    private JLabel mTrainingSampleLabel;
    private JLabel mTestSampleLabel;
    private JLabel mVariableLabel;
    private JLabel mSplitSampleLabel;
    private IntTextField mNumberOfSampleText;
    private FloatTextField mTrainingSampleText;
    private SpssButtonGroup mGroup;
    private SpssButtonGroup mCaseGroup;
    private SpssButtonGroup mDisplayGroup;
    private TitledBorder mCaseAllocationTitleBorder;
    private TitledBorder mDisplayResultTitleBorder;
    private TreeDlg mTreeDlg;
    private FocusableTextArea mCaseArea;
    private FocusableTextArea mInfoText;

    public TreeValidation(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_TREE_VALIDATION_TITLE"), true);
        this.mTreeDlg = (TreeDlg)baseProcedureDialog;
        this.initialzePanel();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mSrcVarList.isEnabled()) {
            this.mArrowButton.setEnabled(true);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mTrainingSampleText)) {
            this.mTrainingSampleText.selectAll();
        }
        if (focusEvent.getSource().equals(this.mNumberOfSampleText)) {
            this.mNumberOfSampleText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mTrainingSampleText)) {
            this.mTrainingSampleText.setSelectionStart(0);
            this.mTrainingSampleText.setSelectionEnd(0);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setPercentageLabel();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setPercentageLabel();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setPercentageLabel();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        boolean bl2;
        DialogUtil.enableTitledBorder(this.mCaseAllocationTitleBorder, this.mSplitSampleRadio.isSelected());
        DialogUtil.enableTitledBorder(this.mDisplayResultTitleBorder, this.mSplitSampleRadio.isSelected());
        this.repaint();
        if (itemEvent.getSource() == this.mCrossValidationRadio) {
            bl2 = this.mCrossValidationRadio.isSelected();
            this.mNumberOfSampleLabel.setEnabled(bl2);
            this.mNumberOfSampleText.setEnabled(bl2);
            this.mNumberOfSampleText.setOpaque(bl2);
            this.mInfoText.setEnabled(bl2);
        }
        if (itemEvent.getSource() == this.mSplitSampleRadio) {
            bl2 = this.mSplitSampleRadio.isSelected();
            this.mUseRandomRadio.setEnabled(bl2);
            this.mUseVariableRadio.setEnabled(bl2);
            this.mTrainingRadio.setEnabled(bl2);
            this.mTestSampleRadio.setEnabled(bl2);
            bl = this.mUseRandomRadio.isSelected();
            this.mTrainingSampleLabel.setEnabled(bl2 && bl);
            this.mTrainingSampleText.setEnabled(bl2 && bl);
            this.mTrainingSampleText.setOpaque(bl2 && bl);
            this.mTestSampleLabel.setEnabled(bl2 && bl);
            boolean bl3 = this.mUseVariableRadio.isSelected();
            this.mVariableLabel.setEnabled(bl2 && bl3);
            this.mSplitSampleLabel.setEnabled(bl2 && bl3);
            this.mCaseArea.setEnabled(bl2 && bl3);
            this.mSrcVarList.setEnabled(bl2 && bl3);
            this.mSrcVarList.setOpaque(bl2 && bl3);
            this.mSrcScrollPane.setEnabled(bl2 && bl3);
            this.mSrcScrollPane.getVerticalScrollBar().setEnabled(bl2 && bl3);
            this.mTargetVarList.setEnabled(bl2 && bl3);
            this.mTargetVarList.setOpaque(bl2 && bl3);
            this.mArrowButton.setEnabled(false);
            this.mSrcScrollPane.setAutoscrolls(bl2 && bl3);
        }
        if (itemEvent.getSource() == this.mUseRandomRadio) {
            bl2 = this.mSplitSampleRadio.isSelected();
            bl = this.mUseRandomRadio.isSelected();
            this.mTrainingSampleLabel.setEnabled(bl2 && bl);
            this.mTrainingSampleText.setEnabled(bl2 && bl);
            this.mTrainingSampleText.setOpaque(bl2 && bl);
            this.mTestSampleLabel.setEnabled(bl2 && bl);
        }
        if (itemEvent.getSource() == this.mUseVariableRadio) {
            bl2 = this.mSplitSampleRadio.isSelected();
            bl = this.mUseVariableRadio.isSelected();
            this.mVariableLabel.setEnabled(bl2 && bl);
            this.mSplitSampleLabel.setEnabled(bl2 && bl);
            this.mCaseArea.setEnabled(bl2 && bl);
            this.mSrcVarList.setEnabled(bl2 && bl);
            this.mSrcVarList.setOpaque(bl2 && bl);
            this.mSrcScrollPane.setEnabled(bl2 && bl);
            this.mSrcScrollPane.getVerticalScrollBar().setEnabled(bl2 && bl);
            this.mTargetVarList.setEnabled(bl2 && bl);
            this.mTargetVarList.setOpaque(bl2 && bl);
            this.mArrowButton.setEnabled(false);
            this.mSrcScrollPane.setAutoscrolls(bl2 && bl);
        }
    }

    public boolean getSplitSampleState() {
        return this.mSplitSampleRadio.isSelected();
    }

    @Override
    public boolean continuePressed() {
        super.continuePressed();
        this.mTreeDlg.getSrcVariableList().setModel(this.mSrcVarList.getModel());
        boolean bl = true;
        if (this.mTrainingSampleText.isEnabled() && (this.mTrainingSampleText.getText().length() == 0 || Double.valueOf(this.mTrainingSampleText.getText()) <= 0.0 || Double.valueOf(this.mTrainingSampleText.getText()) >= 100.0)) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_TREE_VALIDATION_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
            this.mTrainingSampleText.grabFocus();
            this.mTrainingSampleText.setSelectionStart(0);
            this.mTrainingSampleText.setSelectionEnd(this.mTrainingSampleText.getText().length());
            bl = false;
        }
        if (this.mTargetVarList.isEnabled() && this.mTargetVarList.getModel().getSize() < 1) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_TREE_VALIDATION_SPLIT_WARNNING_MSG"), VersionInfo.getAppVersionString());
            bl = false;
        }
        if (this.mNumberOfSampleText.isEnabled() && this.mNumberOfSampleText.getText().length() == 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_TREE_VALIDATION_SAMPLE_FOLD_WARNNING_MSG"), VersionInfo.getAppVersionString());
            this.mNumberOfSampleText.grabFocus();
            bl = false;
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tree_validation";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        Boolean bl = dialogDataModel.getBoolean(SPLIT_SAMPLE_RADIO_KEY);
        Boolean bl2 = dialogDataModel.getBoolean(USE_VARIABLE_RADIO_KEY);
        if (bl != null && bl.booleanValue() && bl2 != null && bl2.booleanValue() && dialogDataModel.getVarArray(SPLIT_SAMPLE_BY_LIST).length == 0) {
            this.mNoneRadio.setSelected(true);
        }
        if (((TreeDlg)this.mParentDlg).isSelectedForceCheck()) {
            this.mCrossValidationRadio.setEnabled(false);
        }
        this.mSrcVarList.setModel(((TreeDlg)this.mParentDlg).getSrcVariableList().getModel());
    }

    protected void initialzePanel() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupCaseAllocationPanel();
        JPanel jPanel3 = this.setupDisplayResultsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNoneRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCrossValidationRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel4 = this.setupLabelPanel();
        Insets insets2 = new Insets(0, 2 * n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSplitSampleRadio, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 5, 2, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(n2, 2 * n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 6, 2, 1, n, insets2);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void initVars() {
        this.mInfoText = new FocusableTextArea(this.getResString("IDS_TREE_VALIDATION_INFORMATION"));
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.getSelectionModel().addListSelectionListener(this);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mTargetVarList.addVarFilter(spssVarFilter);
        this.mTargetVarList.setIdentifier(SPLIT_SAMPLE_BY_LIST);
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTargetScrollPane.setVerticalScrollBarPolicy(21);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, NONE_RADIO_KEY);
        this.mNoneRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, CROSSVALIDATION_RADIO_KEY);
        this.mCrossValidationRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SPLIT_SAMPLE_RADIO_KEY);
        this.mSplitSampleRadio = new JRadioButton(toggleButtonAction);
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mNoneRadio);
        this.mGroup.add(this.mCrossValidationRadio);
        this.mGroup.add(this.mSplitSampleRadio);
        this.mNoneRadio.addItemListener(this);
        this.mCrossValidationRadio.addItemListener(this);
        this.mSplitSampleRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, USE_RANDOM_RADIO_KEY);
        this.mUseRandomRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, USE_VARIABLE_RADIO_KEY);
        this.mUseVariableRadio = new JRadioButton(toggleButtonAction);
        this.mCaseGroup = new SpssButtonGroup();
        this.mCaseGroup.add(this.mUseRandomRadio);
        this.mCaseGroup.add(this.mUseVariableRadio);
        this.mUseRandomRadio.addItemListener(this);
        this.mUseVariableRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, TRAINING_TEST_RADIO_KEY);
        this.mTrainingRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, TEST_SAMPLE_RADIO_KEY);
        this.mTestSampleRadio = new JRadioButton(toggleButtonAction);
        this.mDisplayGroup = new SpssButtonGroup();
        this.mDisplayGroup.add(this.mTrainingRadio);
        this.mDisplayGroup.add(this.mTestSampleRadio);
        this.mTrainingRadio.addItemListener(this);
        this.mTestSampleRadio.addItemListener(this);
        this.mNumberOfSampleText = new IntTextField(2, 25, true);
        this.mNumberOfSampleText.setColumns(6);
        this.mNumberOfSampleText.setAction((Action)new TextFieldAction(this.mParentDlg, NUMBER_OF_SAMPLES_EDIT));
        this.mNumberOfSampleText.addFocusListener((FocusListener)this);
        this.mNumberOfSampleLabel = DialogUtil.createLabel(this, "IDS_TREE_VAILDATION_NUMBER_SAMPLE");
        this.mNumberOfSampleLabel.setLabelFor((Component)this.mNumberOfSampleText);
        this.mTrainingSampleText = new FloatTextField(0.0, 100.0, 2, true);
        this.mTrainingSampleText.setColumns(5);
        this.mTrainingSampleText.getDocument().addDocumentListener(this);
        this.mTrainingSampleText.addFocusListener((FocusListener)this);
        this.mTrainingSampleText.setAction((Action)new TextFieldAction(this.mParentDlg, TRAINING_SAMPLES_EDIT));
        this.mTrainingSampleLabel = DialogUtil.createLabel(this, "IDS_TREE_VAILDATION_TRAINING_SAMPLE");
        this.mTrainingSampleLabel.setLabelFor((Component)this.mTrainingSampleText);
        this.mVariableLabel = DialogUtil.createLabel(this, "IDS_TREE_VAILDATION_VARIABLE");
        this.mVariableLabel.setLabelFor(this.mSrcVarList);
        this.mTestSampleLabel = new JLabel();
        this.mSplitSampleLabel = DialogUtil.createLabel(this, "IDS_TREE_VAILDATION_SPLIT_SAMPLE");
        this.mSplitSampleLabel.setLabelFor(this.mTargetVarList);
        this.mCaseArea = new FocusableTextArea(this.getResString("IDS_TREE_VAILDATION_CASES_LABEL"));
        this.mCaseArea.setFont(this.mTestSampleRadio.getFont());
        this.mCaseArea.setLineWrap(true);
        this.mCaseAllocationTitleBorder = new TitledBorder(this.getResString("IDS_TREE_VALIDATION_CASE_ALLOCATION"));
        this.mDisplayResultTitleBorder = new TitledBorder(this.getResString("IDS_TREE_VALIDATION_DISPLAY_RESULT"));
        this.mDecimalSeparator = new DecimalFormatSymbols(ComponentState.getSPSSLocale()).getDecimalSeparator();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGroup);
        vector.add(this.mNumberOfSampleText);
        vector.add(this.mInfoText);
        vector.add(this.mCaseGroup);
        vector.add(this.mTrainingSampleText);
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mCaseArea);
        vector.add(this.mDisplayGroup);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mNoneRadio.setSelected(true);
        this.mNumberOfSampleText.setText(SAMPLE_FOLDS);
        this.mTrainingSampleText.setText(String.format(ComponentState.getSPSSLocale(), "%.2f", 50.0));
        this.mUseRandomRadio.setSelected(true);
        this.mTrainingRadio.setSelected(true);
        this.mNoneRadio.setEnabled(true);
        this.mCrossValidationRadio.setEnabled(true);
        this.mSplitSampleRadio.setEnabled(true);
        this.mNumberOfSampleLabel.setEnabled(false);
        this.mNumberOfSampleText.setEnabled(false);
        this.mNumberOfSampleText.setOpaque(false);
        this.mInfoText.setEnabled(false);
        this.mUseRandomRadio.setEnabled(false);
        this.mUseVariableRadio.setEnabled(false);
        this.mTrainingRadio.setEnabled(false);
        this.mTestSampleRadio.setEnabled(false);
        this.mTrainingSampleLabel.setEnabled(false);
        this.mTrainingSampleText.setEnabled(false);
        this.mTrainingSampleText.setOpaque(false);
        this.mTestSampleLabel.setEnabled(false);
        this.mVariableLabel.setEnabled(false);
        this.mSplitSampleLabel.setEnabled(false);
        this.mCaseArea.setEnabled(false);
        this.mSrcVarList.setEnabled(false);
        this.mSrcVarList.setOpaque(false);
        this.mSrcScrollPane.setEnabled(false);
        this.mSrcScrollPane.getVerticalScrollBar().setEnabled(false);
        this.mTargetVarList.setEnabled(false);
        this.mArrowButton.setEnabled(false);
        this.mTargetVarList.setOpaque(false);
        this.mTargetScrollPane.setAutoscrolls(false);
        DialogUtil.enableTitledBorder(this.mCaseAllocationTitleBorder, false);
        DialogUtil.enableTitledBorder(this.mDisplayResultTitleBorder, false);
        this.repaint();
    }

    private JPanel setupCaseAllocationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.mCaseAllocationTitleBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, 2 * n2, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mUseRandomRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.setupTextLabelPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mUseVariableRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel3 = this.setupLists();
        insets2.set(0, 2 * n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupLabelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mNumberOfSampleLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberOfSampleText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mInfoText, gridBagConstraints, 0, 1, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTextLabelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mTrainingSampleLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTrainingSampleText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mTestSampleLabel.setText(String.format(this.getResString("IDS_TREE_VAILDATION_TEST_SAMPLE"), PERCENTAGE_LABEL));
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        Insets insets2 = new Insets(0, 2 * n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTestSampleLabel, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mVariableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 6, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 0, 1, 2, n, insets3);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSplitSampleLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        insets3.set(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mCaseArea, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        return jPanel;
    }

    private JPanel setupDisplayResultsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.mDisplayResultTitleBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTrainingRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTestSampleRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setPercentageLabel() {
        try {
            if (this.mTrainingSampleText.getText().length() < 1) {
                this.mTestSampleLabel.setText(String.format(this.getResString("IDS_TREE_VAILDATION_TEST_SAMPLE"), "  "));
                return;
            }
            if (Double.valueOf(this.mTrainingSampleText.getText()) <= 0.0 || Double.valueOf(this.mTrainingSampleText.getText()) >= 100.0) {
                this.mTestSampleLabel.setText(String.format(this.getResString("IDS_TREE_VAILDATION_TEST_SAMPLE"), "  "));
            } else {
                int n;
                double d = 100.0 - Double.valueOf(this.mTrainingSampleText.getText());
                String string = String.format(ComponentState.getSPSSLocale(), "%f", d);
                String string2 = String.valueOf(d);
                int n2 = string2.indexOf(this.mDecimalSeparator);
                int n3 = string2.length();
                if (n2 >= 0) {
                    n3 = n3 - n2 - 1;
                }
                if ((n = string.indexOf(this.mDecimalSeparator)) > 0 && string.length() - n >= 5) {
                    DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(ComponentState.getSPSSLocale());
                    if (n3 <= 2) {
                        decimalFormat.applyPattern(".00");
                    } else if (n3 == 3) {
                        decimalFormat.applyPattern(".000");
                    } else {
                        decimalFormat.applyPattern(".0000");
                    }
                    string = decimalFormat.format(d);
                }
                this.mTestSampleLabel.setText(String.format(this.getResString("IDS_TREE_VAILDATION_TEST_SAMPLE"), "   " + string + "%"));
            }
        }
        catch (Exception exception) {
            this.mTrainingSampleText.grabFocus();
        }
    }
}

