/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class TreeSave
extends BaseSubDialog
implements ItemListener,
ActionListener {
    static final int COLUMN_COUNT = 25;
    static final String XML_FILE_EXT = ".xml";
    static final String IDS_BROWSE_3_DOT_KEY = "IDS_BROWSE_3_DOT";
    static final String IDS_BROWSE_3DOT_KEY = "IDS_BROWSE_3DOT";
    static final String TERMINAL_NODE_KEY = "IDS_TREE_SAVE_TERMINAL_NODE";
    static final String PREDICTED_VALUE_KEY = "IDS_TREE_SAVE_PREDICTED_VALUE";
    static final String PREDICTED_PROBABILITIES_KEY = "IDS_TREE_SAVE_PREDICTED_PROBABILITIES";
    static final String SAMPLE_ASSIGNMENT_KEY = "IDS_TREE_SAVE_SAMPLE_ASSIGNMENT";
    static final String TRAINING_SAMPLE_KEY = "IDS_TREE_SAVE_TRAINING_SAMPLE";
    static final String IDS_TEST_SAMPLE_KEY = "IDS_TREE_SAVE_IDS_TEST_SAMPLE";
    public static final String TRAINING_SUFFIX = "_TRAINING_SUFFIX";
    public static final String TEST_SUFFIX = "_TEST_SUFFIX";
    private JCheckBox mTerminalNodeCheck;
    private JCheckBox mPredictedValueCheck;
    private JCheckBox mPredictedProbabilitiesCheck;
    private JCheckBox mSampleAssignCheck;
    private JCheckBox mTrainingSampleCheck;
    private JLabel mTrainingSampleLabel;
    private FileTextField mTrainingFileText;
    private JCheckBox mTestSampleCheck;
    private JLabel mTestSampleFileLabel;
    private FileTextField mTestSampleFileText;
    private JButton mBrowseButton1;
    private JButton mBrowseButton2;
    private RemoteFileChooser mFileChooser;

    public TreeSave(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_TREE_SAVE_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!RemoteFileChooser.enableSaveInModeler()) {
            if (this.mParentDlg.getDialogDataModel().getSafeBoolean("IDS_TREE_VALIDATION_SPLIT_SAMPLE_RADIO")) {
                this.mTrainingSampleCheck.setEnabled(false);
                this.mTrainingSampleCheck.setSelected(true);
                this.mTestSampleCheck.setEnabled(false);
                this.mTestSampleCheck.setSelected(true);
            } else {
                this.mTrainingSampleCheck.setEnabled(false);
                this.mTrainingSampleCheck.setSelected(true);
                this.mTestSampleCheck.setEnabled(false);
                this.mTestSampleCheck.setSelected(false);
            }
            return;
        }
        if (itemEvent.getSource().equals(this.mTrainingSampleCheck)) {
            this.mTrainingSampleLabel.setEnabled(this.mTrainingSampleCheck.isSelected());
            this.mTrainingFileText.setEditable(this.mTrainingSampleCheck.isSelected());
            this.mTrainingFileText.setEnabled(this.mTrainingSampleCheck.isSelected());
            this.mTrainingFileText.setOpaque(this.mTrainingSampleCheck.isSelected());
            this.mBrowseButton1.setEnabled(this.mTrainingSampleCheck.isSelected());
        }
        if (itemEvent.getSource().equals(this.mTestSampleCheck)) {
            this.mTestSampleFileLabel.setEnabled(this.mTestSampleCheck.isSelected());
            this.mTestSampleFileText.setEditable(this.mTestSampleCheck.isSelected());
            this.mTestSampleFileText.setEnabled(this.mTestSampleCheck.isSelected());
            this.mTestSampleFileText.setOpaque(this.mTestSampleCheck.isSelected());
            this.mBrowseButton2.setEnabled(this.mTestSampleCheck.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.mFileChooser.showSaveDialog(this.getParent());
        if (actionEvent.getSource() == this.mBrowseButton1) {
            if (n == 0) {
                FileLocationsUtil.setDataFilesDirectoryPath((String)this.mFileChooser.getCurrentDirectory().getAbsolutePath());
                String string = this.mFileChooser.getSelectedFilePath();
                this.mTrainingFileText.setText(string);
                if (string.length() >= this.mTrainingFileText.getColumns()) {
                    String string2 = "";
                    int n2 = string.indexOf(XML_FILE_EXT);
                    if (n2 == -1) {
                        n2 = string.indexOf(".XML");
                    }
                    if (n2 > -1) {
                        string2 = string.substring(0, n2);
                    }
                    if (!XML_FILE_EXT.regionMatches(true, 0, string2, string.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length())) {
                        this.mTrainingFileText.setText(string);
                        this.mTrainingFileText.setCaretPosition(0);
                    } else {
                        this.mTrainingFileText.setText(string + XML_FILE_EXT);
                    }
                }
            } else {
                this.mTrainingFileText.requestFocus();
            }
        } else if (actionEvent.getSource() == this.mBrowseButton2) {
            if (n == 0) {
                String string = this.mFileChooser.getSelectedFilePath();
                this.mTestSampleFileText.setText(string);
                if (string.length() >= this.mTrainingFileText.getColumns()) {
                    if (!XML_FILE_EXT.regionMatches(true, 0, string, string.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length())) {
                        this.mTestSampleFileText.setText(string);
                        this.mTestSampleFileText.setCaretPosition(0);
                    } else {
                        this.mTestSampleFileText.setText(string + XML_FILE_EXT);
                    }
                }
            } else {
                this.mTestSampleFileText.requestFocus();
            }
        }
    }

    @Override
    public boolean continuePressed() {
        super.continuePressed();
        boolean bl = true;
        boolean bl2 = this.mTrainingFileText.isEnabled();
        boolean bl3 = this.mTestSampleFileText.isEnabled();
        int n = this.mTrainingFileText.getText().length();
        int n2 = this.mTestSampleFileText.getText().length();
        if (bl2 && n < 1) {
            int n3 = this.mFileChooser.showSaveDialog((Component)((Object)this.mParentDlg));
            if (n3 == 0) {
                FileLocationsUtil.setDataFilesDirectoryPath((String)this.mFileChooser.getCurrentDirectory().getAbsolutePath());
                this.mTrainingFileText.setText(this.mFileChooser.getSelectedFilePath());
                return false;
            }
            this.mTrainingFileText.requestFocus();
            return false;
        }
        if (bl3 && n2 < 1) {
            int n4 = this.mFileChooser.showSaveDialog((Component)((Object)this.mParentDlg));
            if (n4 == 0) {
                FileLocationsUtil.setDataFilesDirectoryPath((String)this.mFileChooser.getCurrentDirectory().getAbsolutePath());
                this.mTestSampleFileText.setText(this.mFileChooser.getSelectedFilePath());
                return false;
            }
            this.mTestSampleFileText.requestFocus();
            return false;
        }
        if (this.mTrainingFileText.isEnabled() && this.mTestSampleFileText.isEnabled() && this.mTrainingFileText.getText().equals(this.mTestSampleFileText.getText())) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_TREE_SAVE_WRNING_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        if (bl2 && n > 0) {
            bl = FileValidator.validatePath((Component)((Object)this), this.mTrainingFileText.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection());
        }
        if (bl && bl3 && n2 > 0) {
            bl = FileValidator.validatePath((Component)((Object)this), this.mTestSampleFileText.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection());
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tree_save";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        this.setEnable();
        JPanel jPanel = this.getViewPanel();
        JComponent[] jComponentArray = new JComponent[]{this.mTerminalNodeCheck, this.mPredictedValueCheck, this.mPredictedProbabilitiesCheck, this.mSampleAssignCheck};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_TREE_SAVE_SAVED_VARIABLE"));
        DialogUtil.createButtonGroup(jPanel2);
        JPanel jPanel3 = this.setupExportTreePanel();
        DialogUtil.createButtonGroup(jPanel3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, null);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTerminalNodeCheck);
        vector.add(this.mPredictedValueCheck);
        vector.add(this.mPredictedProbabilitiesCheck);
        vector.add(this.mSampleAssignCheck);
        vector.add(this.mTrainingSampleCheck);
        vector.add(this.mTrainingFileText);
        vector.add(this.mBrowseButton1);
        vector.add(this.mTestSampleCheck);
        vector.add(this.mTestSampleFileText);
        vector.add(this.mBrowseButton2);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mTerminalNodeCheck.setEnabled(true);
        this.mPredictedValueCheck.setEnabled(true);
        this.mPredictedProbabilitiesCheck.setEnabled(false);
        this.mSampleAssignCheck.setEnabled(false);
        this.mTrainingSampleCheck.setEnabled(true);
        this.mTrainingFileText.setEditable(false);
        this.mBrowseButton1.setEnabled(false);
        this.mTestSampleCheck.setEnabled(false);
        this.mTestSampleFileLabel.setEnabled(false);
        this.mTestSampleFileText.setEditable(false);
        this.mTestSampleFileText.setOpaque(false);
        this.mBrowseButton2.setEnabled(false);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mTerminalNodeCheck.setEnabled(false);
            this.mPredictedValueCheck.setEnabled(false);
            this.mPredictedProbabilitiesCheck.setEnabled(false);
            this.mSampleAssignCheck.setEnabled(false);
            this.mTrainingSampleLabel.setEnabled(false);
            this.mTrainingFileText.setEnabled(false);
            this.mTestSampleFileLabel.setEnabled(false);
            this.mTestSampleFileText.setEnabled(false);
            this.mBrowseButton1.setEnabled(false);
            this.mBrowseButton2.setEnabled(false);
            this.mTrainingSampleCheck.setEnabled(false);
            this.mTrainingSampleCheck.setSelected(true);
            this.mTestSampleCheck.setEnabled(false);
            this.mTestSampleCheck.setSelected(false);
        }
    }

    private void setEnable() {
        try {
            if (this.mParentDlg.getDialogDataModel().getBoolean("IDS_TREE_VALIDATION_SPLIT_SAMPLE_RADIO").booleanValue()) {
                this.mSampleAssignCheck.setEnabled(true);
                this.mTrainingSampleCheck.setEnabled(true);
                this.mTestSampleCheck.setEnabled(true);
                if (!RemoteFileChooser.enableSaveInModeler()) {
                    this.mTrainingSampleCheck.setEnabled(false);
                    this.mTestSampleCheck.setEnabled(false);
                    this.mTestSampleCheck.setSelected(true);
                }
            } else if (!RemoteFileChooser.enableSaveInModeler()) {
                this.mTrainingSampleCheck.setEnabled(false);
                this.mTestSampleCheck.setEnabled(false);
                this.mTestSampleCheck.setSelected(false);
            }
        }
        catch (NullPointerException nullPointerException) {
            this.setDefaults();
        }
        try {
            int n = -1;
            ISpssVariable iSpssVariable = ((TreeDlg)this.mParentDlg).getDependentVariable();
            if (iSpssVariable != null) {
                n = iSpssVariable.getMeasurementLevel().value();
            }
            if (n == 1 || n == 2) {
                this.mPredictedProbabilitiesCheck.setEnabled(true);
            } else {
                this.mPredictedProbabilitiesCheck.setEnabled(false);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.mPredictedProbabilitiesCheck.setEnabled(false);
        }
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mTerminalNodeCheck.setEnabled(false);
            this.mPredictedValueCheck.setEnabled(false);
            this.mPredictedProbabilitiesCheck.setEnabled(false);
            this.mSampleAssignCheck.setEnabled(false);
        }
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, TERMINAL_NODE_KEY);
        this.mTerminalNodeCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PREDICTED_VALUE_KEY);
        this.mPredictedValueCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PREDICTED_PROBABILITIES_KEY);
        this.mPredictedProbabilitiesCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SAMPLE_ASSIGNMENT_KEY);
        this.mSampleAssignCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, TRAINING_SAMPLE_KEY);
        this.mTrainingSampleCheck = new JCheckBox(toggleButtonAction);
        this.mTrainingSampleCheck.addItemListener(this);
        this.mTrainingSampleLabel = DialogUtil.createLabel(this, "IDS_TREE_SAVE_FILE_TRAINING");
        this.mTrainingSampleLabel.setEnabled(false);
        this.mTrainingFileText = new FileTextField();
        this.mTrainingFileText.setColumns(25);
        this.mTrainingFileText.setPreferredSize(this.mTrainingFileText.getPreferredSize());
        this.mTrainingFileText.setAction(new TextFieldAction(this.mParentDlg, "EXPORT_XML_FILE_PATH_TRAINING_SUFFIX"));
        this.mTrainingFileText.setEnabled(false);
        this.mTrainingFileText.setOpaque(false);
        this.mTrainingSampleLabel.setLabelFor((Component)((Object)this.mTrainingFileText));
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_TEST_SAMPLE_KEY);
        this.mTestSampleCheck = new JCheckBox(toggleButtonAction);
        this.mTestSampleCheck.addItemListener(this);
        this.mTestSampleFileLabel = DialogUtil.createLabel(this, "IDS_TREE_SAVE_FILE_TEST");
        this.mTestSampleFileLabel.setEnabled(false);
        this.mTestSampleFileText = new FileTextField();
        this.mTestSampleFileText.setColumns(25);
        this.mTestSampleFileText.setAction(new TextFieldAction(this.mParentDlg, "EXPORT_XML_FILE_PATH_TEST_SUFFIX"));
        this.mTestSampleFileText.setPreferredSize(this.mTestSampleFileText.getPreferredSize());
        this.mTestSampleFileText.setEnabled(false);
        this.mTestSampleFileText.setOpaque(false);
        this.mTestSampleFileLabel.setLabelFor((Component)((Object)this.mTestSampleFileText));
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_BROWSE_3_DOT_KEY);
        this.mBrowseButton1 = new JButton(toggleButtonAction);
        this.mBrowseButton1.setEnabled(false);
        this.mBrowseButton1.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_BROWSE_3DOT_KEY);
        this.mBrowseButton2 = new JButton(toggleButtonAction);
        this.mBrowseButton2.setEnabled(false);
        this.mBrowseButton2.addActionListener(this);
        this.mFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        this.mFileChooser.setDialogTitle(this.getResString("IDS_TREE_SAVE_FILE_TITLE"));
        this.mFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_TREE_SAVE_XML_FILE_FILTER"), XML_FILE_EXT));
        this.mFileChooser.setAcceptAllFileFilterUsed(false);
    }

    private JPanel setupExportTreePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TREE_SAVE_EXPORT_TREE_MODEL_XML"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap() * 3, 0, 0);
        Insets insets3 = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mTrainingSampleCheck, gridBagConstraints, 0, 0, 4, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTrainingSampleLabel, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTrainingFileText), gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton1, gridBagConstraints, 3, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTestSampleCheck, gridBagConstraints, 0, 2, 4, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTestSampleFileLabel, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTestSampleFileText), gridBagConstraints, 2, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton2, gridBagConstraints, 3, 3, 1, 1, n, insets3);
        return jPanel;
    }
}

