/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeOutput;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class TreeOutputTree
extends BaseProcedureTab
implements ItemListener {
    static final String TREE_CHECKBOX = "IDS_TREE_OUTPUT_TREE";
    static final String TOP_DOWN_RADIO = "IDS_TREE_OUTPUT_TOP_DOWN";
    static final String LEFT_TO_RIGHT_RADIO = "IDS_TREE_OUTPUT_LEFT_TO_RIGHT";
    static final String RIGHT_TO_LEFT_RADIO = "IDS_TREE_OUTPUT_RIGHT_TO_LEFT";
    static final String TABLE_N_CHART_RADIO = "IDS_TREE_OUTPUT_TABLE_AND_CHART";
    static final String CHART_RADIO = "IDS_TREE_OUTPUT_CHART";
    static final String TABLE_RADIO = "IDS_TREE_OUTPUT_TABLE";
    static final String AUTOMATIC_RADIO = "IDS_TREE_OUTPUT_AUTOMATIC_REDUCES_SCALE_FOR_LARGE_TREES";
    static final String CUSTOM_RADIO = "IDS_TREE_OUTPUT_CUSTOM";
    static final String INDEPENDENT_VAR_STATS_CHECK = "IDS_TREE_OUTPUT_INDEPENDENT_VARIABLE_STATISTICS";
    static final String NODE_DEF_CHECK = "IDS_TREE_OUTPUT_NODE_DEFINITIONS";
    static final String TREE_IN_TABLE_FORMAT_CHECK = "IDS_TREE_OUTPUT_TREE_IN_TABLE_FORMAT";
    static final String PERCENT_EDIT = "IDS_TREEOUTPUTTREE_SCALE_PERCENT";
    private JCheckBox mTreeCheck;
    private JLabel mOrientationLbl;
    private JRadioButton mTopDownRadio;
    private JRadioButton mL2RRadio;
    private JRadioButton mR2LRadio;
    private JLabel mNodeContentsLbl;
    private JRadioButton mTableRadio;
    private JRadioButton mChartRadio;
    private JRadioButton mTableAndChartRadio;
    private JLabel mScaleLbl;
    private JRadioButton mAutomaticRadio;
    private JRadioButton mCustomRadio;
    private JLabel mPercentLbl;
    private IntTextField mPercentEdit;
    private JCheckBox mIndVarStatsCheck;
    private JCheckBox mNodeDefCheck;
    private TitledBorder mDisplayPanelBorder;
    private JCheckBox mTreeInTableFormatCheck;
    private SpssButtonGroup mOrientationRadioGrp;
    private SpssButtonGroup mNodeContentsRadioGrp;
    private SpssButtonGroup mScaleRadioGrp;

    public TreeOutputTree(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public boolean validateTab() {
        return this.isValidate();
    }

    public boolean isValidate() {
        boolean bl = true;
        try {
            if (this.mPercentEdit.isEnabled() && (Integer.valueOf(this.mPercentEdit.getText()) < 10 || Integer.valueOf(this.mPercentEdit.getText()) > 200)) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_OPUT_TREE_WRNING_MSG"), VersionInfo.getAppVersionString());
                this.mPercentEdit.grabFocus();
                this.mPercentEdit.setSelectionStart(0);
                this.mPercentEdit.setSelectionEnd(this.mPercentEdit.getText().length());
                return false;
            }
        }
        catch (Exception exception) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_OPUT_TREE_WRNING_MSG"), VersionInfo.getAppVersionString());
            this.mPercentEdit.grabFocus();
            this.mPercentEdit.setSelectionStart(0);
            this.mPercentEdit.setSelectionEnd(this.mPercentEdit.getText().length());
            return false;
        }
        return bl;
    }

    public void enableDisplayPanel(boolean bl) {
        if (bl) {
            DialogUtil.enableTitledBorder(this.mDisplayPanelBorder, true);
            this.repaint();
        } else {
            DialogUtil.enableTitledBorder(this.mDisplayPanelBorder, false);
            this.repaint();
        }
        this.mOrientationLbl.setEnabled(bl);
        this.mTopDownRadio.setEnabled(bl);
        this.mL2RRadio.setEnabled(bl);
        this.mR2LRadio.setEnabled(bl);
        this.mNodeContentsLbl.setEnabled(bl);
        this.mTableRadio.setEnabled(bl);
        this.mChartRadio.setEnabled(bl);
        this.mTableAndChartRadio.setEnabled(bl);
        this.mScaleLbl.setEnabled(bl);
        this.mAutomaticRadio.setEnabled(bl);
        this.mCustomRadio.setEnabled(bl);
        this.mPercentLbl.setEnabled(this.mCustomRadio.isSelected() && bl);
        this.mPercentEdit.setEnabled(this.mCustomRadio.isSelected() && bl);
        this.mPercentEdit.setOpaque(this.mCustomRadio.isSelected() && bl);
        this.mIndVarStatsCheck.setEnabled(bl);
        this.mNodeDefCheck.setEnabled(bl);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mTreeCheck) {
            this.enableDisplayPanel(this.mTreeCheck.isSelected());
        }
        if (itemEvent.getSource() == this.mCustomRadio) {
            this.mPercentLbl.setEnabled(this.mTreeCheck.isSelected() && this.mCustomRadio.isSelected());
            this.mPercentEdit.setEnabled(this.mTreeCheck.isSelected() && this.mCustomRadio.isSelected());
            this.mPercentEdit.setOpaque(this.mCustomRadio.isSelected());
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_output_tree";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mTreeCheck;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeOutputTree.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, 0, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(this, this.mTreeCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, insets.left + n2 * 2, n2, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(this, this.setupDisplayPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(this, this.mTreeInTableFormatCheck, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        this.mTreeCheck.setSelected(true);
        this.enableDisplayPanel(true);
    }

    protected void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, TREE_CHECKBOX);
        this.mTreeCheck = new JCheckBox(toggleButtonAction);
        this.mTreeCheck.addItemListener(this);
        this.mOrientationLbl = new JLabel(this.getResString("IDS_TREE_OUTPUT_ORIENTATION"));
        toggleButtonAction = new ToggleButtonAction(this.mParent, TOP_DOWN_RADIO);
        this.mTopDownRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, LEFT_TO_RIGHT_RADIO);
        this.mL2RRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, RIGHT_TO_LEFT_RADIO);
        this.mR2LRadio = new JRadioButton(toggleButtonAction);
        this.mOrientationRadioGrp = new SpssButtonGroup();
        this.mOrientationRadioGrp.add(this.mTopDownRadio);
        this.mOrientationRadioGrp.add(this.mL2RRadio);
        this.mOrientationRadioGrp.add(this.mR2LRadio);
        this.mTopDownRadio.setSelected(true);
        this.mNodeContentsLbl = new JLabel(this.getResString("IDS_TREE_OUTPUT_NODE_CONTENTS"));
        toggleButtonAction = new ToggleButtonAction(this.mParent, TABLE_RADIO);
        this.mTableRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, CHART_RADIO);
        this.mChartRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, TABLE_N_CHART_RADIO);
        this.mTableAndChartRadio = new JRadioButton(toggleButtonAction);
        this.mNodeContentsRadioGrp = new SpssButtonGroup();
        this.mNodeContentsRadioGrp.add(this.mTableRadio);
        this.mNodeContentsRadioGrp.add(this.mChartRadio);
        this.mNodeContentsRadioGrp.add(this.mTableAndChartRadio);
        this.mTableRadio.setSelected(true);
        this.mScaleLbl = new JLabel(this.getResString("IDS_TREE_OUTPUT_SCALE"));
        toggleButtonAction = new ToggleButtonAction(this.mParent, AUTOMATIC_RADIO);
        this.mAutomaticRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, CUSTOM_RADIO);
        this.mCustomRadio = new JRadioButton(toggleButtonAction);
        this.mCustomRadio.addItemListener(this);
        this.mScaleRadioGrp = new SpssButtonGroup();
        this.mScaleRadioGrp.add(this.mAutomaticRadio);
        this.mScaleRadioGrp.add(this.mCustomRadio);
        this.mAutomaticRadio.setSelected(true);
        this.mPercentLbl = DialogUtil.createLabel(this.mParent, "IDS_TREE_OUTPUT_PERCENT");
        this.mPercentEdit = new IntTextField(true);
        this.mPercentEdit.setAction((Action)new TextFieldAction(this.mParent, PERCENT_EDIT));
        this.mPercentLbl.setLabelFor((Component)this.mPercentEdit);
        this.mPercentEdit.setText("100");
        this.mPercentEdit.setOpaque(false);
        toggleButtonAction = new ToggleButtonAction(this.mParent, INDEPENDENT_VAR_STATS_CHECK);
        this.mIndVarStatsCheck = new JCheckBox(toggleButtonAction);
        this.mIndVarStatsCheck.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this.mParent, NODE_DEF_CHECK);
        this.mNodeDefCheck = new JCheckBox(toggleButtonAction);
        this.mNodeDefCheck.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this.mParent, TREE_IN_TABLE_FORMAT_CHECK);
        this.mTreeInTableFormatCheck = new JCheckBox(toggleButtonAction);
        this.mDisplayPanelBorder = new TitledBorder(this.getResString("IDS_TREE_OUTPUT_DISPLAY"));
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mIndVarStatsCheck);
        spssButtonGroup.add(this.mNodeDefCheck);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTreeCheck);
        vector.add(this.mOrientationRadioGrp);
        vector.add(this.mNodeContentsRadioGrp);
        vector.add(this.mScaleRadioGrp);
        vector.add(this.mPercentEdit);
        vector.add(this.mIndVarStatsCheck);
        vector.add(this.mNodeDefCheck);
        vector.add(this.mTreeInTableFormatCheck);
        JPanel jPanel = ((TreeOutput)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private JPanel setupDisplayPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(this.mDisplayPanelBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mOrientationLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mTopDownRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mL2RRadio, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mR2LRadio, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mNodeContentsLbl, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mTableRadio, gridBagConstraints, 1, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mChartRadio, gridBagConstraints, 1, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mTableAndChartRadio, gridBagConstraints, 1, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mScaleLbl, gridBagConstraints, 0, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mAutomaticRadio, gridBagConstraints, 1, 6, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mCustomRadio, gridBagConstraints, 1, 7, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap() + 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.setupPercentPanel(), gridBagConstraints, 1, 8, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mIndVarStatsCheck, gridBagConstraints, 0, 9, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mNodeDefCheck, gridBagConstraints, 0, 10, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPercentPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mPercentLbl, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, (JComponent)this.mPercentEdit, gridBagConstraints, 1, 0, 1, 1, n, null);
        return jPanel;
    }
}

