/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.java_client.ui.dialogs.trees.TreeOutput;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TreeOutputStats
extends BaseProcedureTab
implements ItemListener {
    static final String SUMMARY_CHECKBOX = "IDS_TREE_OUTPUT_SUMMARY";
    static final String RISK_CHECKBOX = "IDS_TREE_OUTPUT_RISK";
    static final String CLASSIFICATION_TREE_CHECKBOX = "IDS_TREE_OUTPUT_CLASSIFICATION_TABLE";
    static final String CPSP_CHECKBOX = "IDS_TREE_OUTPUT_COST_PRIOR_PROBABILITY_SCORE_AND_PROFIT_VALUES";
    static final String IMP_TO_MODEL_CHECKBOX = "IDS_TREE_OUTPUT_IMPORTANCE_TO_MODEL";
    static final String SURROGATES_BY_SPLIT_CHECKBOX = "IDS_TREE_OUTPUT_SURROGATES_BY_SPLIT";
    static final String SUMMARY_NP_CHECKBOX = "IDS_TREE_OUTPUT_SUMMARY_NP";
    static final String TARGET_CATEGORY_CHECKBOX = "IDS_TREE_OUTPUT_BY_TARGET_CATEGORY";
    static final String DISPLAY_CHECKBOX = "IDS_TREE_OUTPUT_DISPLAY_CUMULATIVE_STATISTICS";
    static final String ROWS_COMBO = "IDS_TREEOUTPUTSTAT_ROWS_COMBO";
    static final String SORT_ORDER_COMBO = "IDS_TREEOUTPUTSTAT_SORT_ORDER_COMBO";
    static final String PERCENTILE_INC_COMBO = "IDS_TREEOUTPUTSTAT_PERCENT_INC_COMBO";
    private JCheckBox mSummaryCheck;
    private JCheckBox mRiskCheck;
    private JCheckBox mClassTableCheck;
    private JCheckBox mCPSPCheck;
    private JCheckBox mImpToModelCheck;
    private JCheckBox mSurrogatesCheck;
    private JCheckBox mSummaryNPCheck;
    private JCheckBox mTargetCatogaryCheck;
    private JLabel mRowsLabel;
    private JLabel mSortOrderLabel;
    private JLabel mPercentIncLabel;
    private JComboBox mRowsCombo;
    private JComboBox mSortOrderCombo;
    private JComboBox mPercentIncCombo;
    private JCheckBox mDisplayCheck;

    public TreeOutputStats(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        if (itemEvent.getSource() == this.mSummaryNPCheck && this.mSummaryNPCheck.isEnabled()) {
            bl = this.mSummaryNPCheck.isSelected();
            this.mRowsLabel.setEnabled(bl);
            this.mRowsCombo.setEnabled(bl);
            DialogUtil.enableHTMLComponent(this.mSortOrderLabel, bl);
            this.mSortOrderCombo.setEnabled(bl);
            DialogUtil.enableHTMLComponent(this.mPercentIncLabel, bl && this.mRowsCombo.getSelectedIndex() != 0);
            this.mPercentIncCombo.setEnabled(bl && this.mRowsCombo.getSelectedIndex() != 0);
            this.mDisplayCheck.setEnabled(bl && this.mRowsCombo.getSelectedIndex() != 1);
        }
        if (itemEvent.getSource() == this.mTargetCatogaryCheck && this.mTargetCatogaryCheck.isEnabled()) {
            bl = this.mTargetCatogaryCheck.isSelected();
            this.mRowsLabel.setEnabled(bl);
            this.mRowsCombo.setEnabled(bl);
            DialogUtil.enableHTMLComponent(this.mSortOrderLabel, bl);
            this.mSortOrderCombo.setEnabled(bl);
            DialogUtil.enableHTMLComponent(this.mPercentIncLabel, bl && this.mRowsCombo.getSelectedIndex() != 0);
            this.mPercentIncCombo.setEnabled(bl && this.mRowsCombo.getSelectedIndex() != 0);
            this.mDisplayCheck.setEnabled(bl && this.mRowsCombo.getSelectedIndex() != 1);
        }
        if (itemEvent.getSource() == this.mRowsCombo) {
            DialogUtil.enableHTMLComponent(this.mPercentIncLabel, this.mRowsCombo.getSelectedIndex() != 0);
            this.mPercentIncCombo.setEnabled(this.mRowsCombo.getSelectedIndex() != 0);
            this.mDisplayCheck.setEnabled(this.mRowsCombo.getSelectedIndex() != 1);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_output_statistics";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSummaryCheck;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeOutputStats.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, n2, n2);
        JPanel jPanel = this.setupModelPanel();
        DialogUtil.createButtonGroup(jPanel);
        DialogUtil.addUsingGBLOnSpssTab(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(0, insets.left, insets.bottom, n2);
        JPanel jPanel2 = this.setupIndependentVarPanel();
        DialogUtil.createButtonGroup(jPanel2);
        DialogUtil.addUsingGBLOnSpssTab(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(insets.top, 0, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(this, this.setupNodePerformancePanel(), gridBagConstraints, 1, 0, 1, 2, n, insets2);
        this.setDefaults();
    }

    protected void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, SUMMARY_CHECKBOX);
        this.mSummaryCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, RISK_CHECKBOX);
        this.mRiskCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, CLASSIFICATION_TREE_CHECKBOX);
        this.mClassTableCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, CPSP_CHECKBOX);
        this.mCPSPCheck = new SpssMultiLineCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IMP_TO_MODEL_CHECKBOX);
        this.mImpToModelCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, SURROGATES_BY_SPLIT_CHECKBOX);
        this.mSurrogatesCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, SUMMARY_NP_CHECKBOX);
        this.mSummaryNPCheck = new JCheckBox(toggleButtonAction);
        this.mSummaryNPCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, TARGET_CATEGORY_CHECKBOX);
        this.mTargetCatogaryCheck = new JCheckBox(toggleButtonAction);
        this.mTargetCatogaryCheck.addItemListener(this);
        this.mRowsLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_OUTPUT_ROWS");
        this.mSortOrderLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_OUTPUT_SORT_ORDER");
        this.mPercentIncLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_OUTPUT_PERCENTILE_INCREMENT");
        this.mRowsCombo = new JComboBox<String>(this.getResStringArray("IDS_TREE_OUTPUT_ROWS_COMBO_ITEMS"));
        this.mRowsCombo.setAction(new ComboboxAction(this.mParent, ROWS_COMBO));
        this.mSortOrderCombo = new JComboBox<String>(this.getResStringArray("IDS_TREE_OUTPUT_SORT_ORDER_COMBO_ITEMS"));
        this.mSortOrderCombo.setAction(new ComboboxAction(this.mParent, SORT_ORDER_COMBO));
        this.mRowsCombo.addItemListener(this);
        this.mPercentIncCombo = new JComboBox<String>(new String[]{"1%", "2%", "5%", "10%", "20%", "25%"});
        this.mPercentIncCombo.setAction(new ComboboxAction(this.mParent, PERCENTILE_INC_COMBO));
        this.mPercentIncCombo.setSelectedIndex(3);
        this.mRowsLabel.setLabelFor(this.mRowsCombo);
        this.mSortOrderLabel.setLabelFor(this.mSortOrderCombo);
        this.mPercentIncLabel.setLabelFor(this.mPercentIncCombo);
        toggleButtonAction = new ToggleButtonAction(this.mParent, DISPLAY_CHECKBOX);
        this.mDisplayCheck = new JCheckBox(toggleButtonAction);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSummaryCheck);
        vector.add(this.mRiskCheck);
        vector.add(this.mClassTableCheck);
        vector.add(this.mCPSPCheck);
        vector.add(this.mImpToModelCheck);
        vector.add(this.mSurrogatesCheck);
        vector.add(this.mSummaryNPCheck);
        vector.add(this.mTargetCatogaryCheck);
        vector.add(this.mRowsCombo);
        vector.add(this.mSortOrderCombo);
        vector.add(this.mPercentIncCombo);
        vector.add(this.mDisplayCheck);
        JPanel jPanel = ((TreeOutput)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private JPanel setupModelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TREE_OUTPUT_MODEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mSummaryCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mRiskCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mClassTableCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mCPSPCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupIndependentVarPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TREE_OUTPUT_INDEPENDENT_VARIABLES")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mImpToModelCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mSurrogatesCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupNodePerformancePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TREE_OUTPUT_NODE_PERFORMANCE")));
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mSummaryNPCheck);
        spssButtonGroup.add(this.mTargetCatogaryCheck);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mSummaryNPCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mTargetCatogaryCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, new Insets(n2, 0, n2, 0));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.setupComboBoxPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupComboBoxPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mRowsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mRowsCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top + n2 / 2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mSortOrderLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(insets.top + n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mSortOrderCombo, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        insets2.set(insets.top + n2 / 2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mPercentIncLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        insets2.set(insets.top + n2 / 2 + n2 / 3, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mPercentIncCombo, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.set(insets.top + n2 / 2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mDisplayCheck, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        return jPanel;
    }

    private void setDefaults() {
        this.mSummaryCheck.setSelected(true);
        this.mRiskCheck.setSelected(true);
        this.mClassTableCheck.setSelected(true);
        this.mSummaryNPCheck.setSelected(true);
        this.mTargetCatogaryCheck.setSelected(true);
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)this.mParent.getParent())).getDialogDataModel();
        ISpssVariable iSpssVariable = ((TreeDlg)((Object)this.mParent.getParent())).getDependentVariable();
        boolean bl = iSpssVariable != null ? iSpssVariable.getMeasurementLevel().value() != 3 : false;
        boolean bl2 = ((TreeDlg)((Object)this.mParent.getParent())).isTargetCategoryDefined();
        boolean bl3 = iSpssVariable != null ? iSpssVariable.getMeasurementLevel().value() == 3 : false;
        this.mClassTableCheck.setEnabled(bl);
        DialogUtil.enableHTMLComponent(this.mCPSPCheck, bl);
        boolean bl4 = false;
        Boolean bl5 = dialogDataModel.getBoolean("IDS_TREE_OPT_PROFIT_CUSTOM");
        if (bl5 != null) {
            bl4 = bl5;
        }
        String string = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger("IDS_TREE_GROWING_METHOD_COMBOBOX")];
        this.mImpToModelCheck.setEnabled(string.equals("CRT"));
        this.mSurrogatesCheck.setEnabled(string.equals("CRT") || string.equals("QUEST"));
        this.mSummaryNPCheck.setEnabled(bl3 || bl && bl4);
        this.mTargetCatogaryCheck.setEnabled(bl && bl2);
        boolean bl6 = this.mSummaryNPCheck.isEnabled() && this.mSummaryNPCheck.isSelected() || this.mTargetCatogaryCheck.isEnabled() && this.mTargetCatogaryCheck.isSelected();
        this.mRowsLabel.setEnabled(bl6);
        this.mRowsCombo.setEnabled(bl6);
        DialogUtil.enableHTMLComponent(this.mSortOrderLabel, bl6);
        this.mSortOrderCombo.setEnabled(bl6);
        boolean bl7 = bl6 && this.mRowsCombo.getSelectedIndex() != 0;
        DialogUtil.enableHTMLComponent(this.mPercentIncLabel, bl7);
        this.mPercentIncCombo.setEnabled(bl7);
        this.mDisplayCheck.setEnabled(bl6 && this.mRowsCombo.getSelectedIndex() != 1);
    }
}

