/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.java_client.ui.dialogs.trees.TreeOutput;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class TreeOutputRules
extends BaseProcedureTab
implements ItemListener {
    static final String GENRERATE_RULES_CHECKBOX = "IDS_TREE_OUTPUT_GENERATE_CLASSIFICATION_RULES";
    static final String SPSS_RADIO = "IDS_TREE_OUTPUT_SPSS";
    static final String SQL_RADIO = "IDS_TREE_OUTPUT_SQL";
    static final String SIMPLE_TEXT_RADIO = "IDS_TREE_OUTPUT_SIMPLE_TEXT";
    static final String USE_VAL_LABELS_CHECKBOX = "IDS_TREE_OUTPUT_USE_VARIABLE_AND_VALUE_LABELS";
    static final String ASSIGN_VAL_TO_CASES_RADIO = "IDS_TREE_OUTPUT_ASSIGN_VALUES_TO_CASES";
    static final String SELECT_CASES_RADIO = "IDS_TREE_OUTPUT_SELECT_CASES";
    static final String INCLUDE_SURROGATES_CHECKBOX = "IDS_TREE_OUTPUT_INCLUDE_SURROGATES_IN_SPSS_AND_SQL_RULES";
    static final String ALL_TERMINAL_NODES_RADIO = "IDS_TREE_OUTPUT_ALL_TERMINAL_NODES";
    static final String BEST_TERMINAL_NODES_RADIO = "IDS_TREE_OUTPUT_BEST_TERMINAL_NODES";
    static final String BEST_TERMINAL_NODES_PERCENT_RADIO = "IDS_TREE_OUTPUT_BEST_TERMINAL_NODES_UP_TO_A_SPECIFIED_PERCENTAGE_OF_CASES";
    static final String BEST_TERMINAL_NODES_MIN_INDEX_RADIO = "IDS_TREE_OUTPUT_TERMINAL_NODES_WHOSE_INDEX_VALUE_MEETS_OR_EXCEEDS_A_CUTOFF_VALUE";
    static final String ALL_NODES_RADIO = "IDS_TREE_OUTPUT_ALL_NODES";
    static final String EXPORT_RULES_CHECKBOX = "IDS_TREE_OUTPUT_EXPORT_RULES_TO_A_FILE";
    static final String BROWSE_BUTTON = "IDS_TREE_OUTPUT_BROWSE";
    static final String MINIMUM_INDEX_EDIT = "IDS_TREEOUTPUTRULES_MIN_INDEX_EDIT";
    static final String PERCENT_EDIT = "IDS_TREEOUTPUTRULES_PERCENT_EDIT";
    static final String NUMBER_OF_NODES_EDIT = "IDS_TREEOUTPUTRULES_NUMBER_OF_NODES_EDIT";
    static final String FILE_EDIT = "IDS_TREEOUTPUTRULES_FILE_EDIT";
    private JCheckBox mGenRulesCheck;
    private JRadioButton mSpssRadio;
    private JRadioButton mSqlRadio;
    private JRadioButton mSimpleTextRadio;
    private JCheckBox mValLblCheck;
    private JRadioButton mValToCasesRadio;
    private JRadioButton mSelectCasesRadio;
    private JCheckBox mIncSurrogatesCheck;
    private JRadioButton mTerminalNodesRadio;
    private JRadioButton mBestTerminalRadio;
    private JLabel mNumberOfNodesLbl;
    private IntTextField mNumberOfNodesEdit;
    private JRadioButton mBestTerminalPercentRadio;
    private JLabel mPercentLbl;
    private FloatTextField mPercentEdit;
    private JRadioButton mBestTerminalMinIndexRadio;
    private JLabel mMinIndexLbl;
    private FloatTextField mMinIndexEdit;
    private JRadioButton mAllNodesRadio;
    private JCheckBox mExportRulesCheck;
    private JLabel mFileLbl;
    private FileTextField mFileEdit;
    private JButton mBrowseButton;
    private SpssButtonGroup mSyntaxRadioGrp;
    private SpssButtonGroup mTypeRadioGrp;
    private SpssButtonGroup mNodesGrp;
    private TitledBorder mSytaxPanelBorder;
    private TitledBorder mTypePanelBorder;
    private TitledBorder mNodePanelBorder;
    RemoteFileChooser mFileChooser;
    RefFileFilter mSyntaxFilter;
    RefFileFilter mSqlFilter;
    RefFileFilter mTextfileFilter;

    public TreeOutputRules(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public boolean validateTab() {
        return this.isValidate(false);
    }

    public boolean isValidate(boolean bl) {
        boolean bl2 = true;
        if (this.mSpssRadio.isSelected()) {
            this.mFileChooser.setFileFilter((FileFilter)this.mSyntaxFilter);
        } else if (this.mSqlRadio.isSelected()) {
            this.mFileChooser.setFileFilter((FileFilter)this.mSqlFilter);
        } else {
            this.mFileChooser.setFileFilter((FileFilter)this.mTextfileFilter);
        }
        if (this.mNumberOfNodesEdit.isEnabled()) {
            if (this.mNumberOfNodesEdit.getText().length() < 1 || Integer.valueOf(this.mNumberOfNodesEdit.getText()) <= 0) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_OPUT_RULES_NODES_MSG"), VersionInfo.getAppVersionString());
                this.mNumberOfNodesEdit.grabFocus();
                this.mNumberOfNodesEdit.setSelectionStart(0);
                this.mNumberOfNodesEdit.setSelectionEnd(this.mNumberOfNodesEdit.getText().length());
                bl2 = false;
            }
        } else if (this.mPercentEdit.isEnabled()) {
            if (this.mPercentEdit.getText().length() < 1 || Double.valueOf(this.mPercentEdit.getText()) >= 100.0 || Double.valueOf(this.mPercentEdit.getText()) <= 0.0) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_OPUT_RULES_PTAGE_MSG"), VersionInfo.getAppVersionString());
                this.mPercentEdit.grabFocus();
                this.mPercentEdit.setSelectionStart(0);
                this.mPercentEdit.setSelectionEnd(this.mPercentEdit.getText().length());
                bl2 = false;
            }
        } else if (this.mMinIndexEdit.isEnabled() && (this.mMinIndexEdit.getText().length() < 1 || Double.valueOf(this.mMinIndexEdit.getText()) <= 0.0)) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_OPUT_RULES_INDEX_MSG"), VersionInfo.getAppVersionString());
            this.mMinIndexEdit.grabFocus();
            this.mMinIndexEdit.setSelectionStart(0);
            this.mMinIndexEdit.setSelectionEnd(this.mMinIndexEdit.getText().length());
            bl2 = false;
        }
        if (this.mFileEdit.isEnabled() && this.mFileEdit.getText().length() < 1) {
            int n = this.mFileChooser.showSaveDialog((Component)this.mParent);
            if (n == 0) {
                FileLocationsUtil.setDataFilesDirectoryPath((String)this.mFileChooser.getCurrentDirectory().getAbsolutePath());
                this.mFileEdit.setText(this.mFileChooser.getSelectedFilePath());
                return false;
            }
            return false;
        }
        if (bl2) {
            bl2 = FileValidator.validatePath(this, this.mFileEdit.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection());
        }
        return bl2;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        DialogUtil.enableHTMLComponent(this.mIncSurrogatesCheck, this.canEnableSurrogatesCheckbox());
        if (itemEvent.getSource() == this.mGenRulesCheck) {
            this.enableControls(this.mGenRulesCheck.isSelected());
        }
        if (itemEvent.getSource() == this.mSimpleTextRadio) {
            boolean bl = this.mSimpleTextRadio.isSelected();
            this.mValLblCheck.setEnabled(bl);
            this.mValToCasesRadio.setEnabled(!bl);
            this.mSelectCasesRadio.setEnabled(!bl);
        }
        if (itemEvent.getSource() == this.mBestTerminalRadio) {
            if (!this.mBestTerminalRadio.isEnabled() && this.mBestTerminalRadio.isSelected()) {
                this.mTerminalNodesRadio.setSelected(true);
            }
            this.mNumberOfNodesLbl.setEnabled(this.mBestTerminalRadio.isSelected());
            this.mNumberOfNodesEdit.setEnabled(this.mBestTerminalRadio.isSelected());
            this.mNumberOfNodesEdit.setOpaque(this.mBestTerminalRadio.isSelected());
        }
        if (itemEvent.getSource() == this.mBestTerminalPercentRadio) {
            if (!this.mBestTerminalPercentRadio.isEnabled() && this.mBestTerminalPercentRadio.isSelected()) {
                this.mTerminalNodesRadio.setSelected(true);
            }
            this.mPercentLbl.setEnabled(this.mBestTerminalPercentRadio.isSelected());
            this.mPercentEdit.setEnabled(this.mBestTerminalPercentRadio.isSelected());
            this.mPercentEdit.setOpaque(this.mBestTerminalPercentRadio.isSelected());
        }
        if (itemEvent.getSource() == this.mBestTerminalMinIndexRadio) {
            if (!this.mBestTerminalMinIndexRadio.isEnabled() && this.mBestTerminalMinIndexRadio.isSelected()) {
                this.mTerminalNodesRadio.setSelected(true);
            }
            this.mMinIndexLbl.setEnabled(this.mBestTerminalMinIndexRadio.isSelected());
            this.mMinIndexEdit.setEnabled(this.mBestTerminalMinIndexRadio.isSelected());
            this.mMinIndexEdit.setOpaque(this.mBestTerminalMinIndexRadio.isSelected());
        }
        if (itemEvent.getSource() == this.mExportRulesCheck) {
            this.mFileLbl.setEnabled(this.mExportRulesCheck.isSelected());
            this.mFileEdit.setEnabled(this.mExportRulesCheck.isSelected());
            this.mFileEdit.setOpaque(this.mExportRulesCheck.isSelected());
            this.mBrowseButton.setEnabled(this.mExportRulesCheck.isSelected());
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_output_rules";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mGenRulesCheck;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeOutputRules.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, n2, insets.right);
        DialogUtil.addUsingGBL(this, this.mGenRulesCheck, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, insets.left, n2, n2);
        DialogUtil.addUsingGBL(this, this.setupSyntaxPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.setupTypePanel(), gridBagConstraints, 0, 2, 1, 1, n, insets2);
        insets2.set(0, 0, n2, insets.right);
        DialogUtil.addUsingGBL(this, this.setupNodesPanel(), gridBagConstraints, 1, 1, 1, 2, n, insets2);
        insets2.set(0, insets.left, insets.bottom, insets.right);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.setupExportRulesPanel(), gridBagConstraints, 0, 3, 2, 1, n, insets2);
        this.setDefaults();
    }

    protected void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, GENRERATE_RULES_CHECKBOX);
        this.mGenRulesCheck = new JCheckBox(toggleButtonAction);
        this.mGenRulesCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, SPSS_RADIO);
        this.mSpssRadio = new JRadioButton(toggleButtonAction);
        this.mSpssRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, SQL_RADIO);
        this.mSqlRadio = new JRadioButton(toggleButtonAction);
        this.mSqlRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, SIMPLE_TEXT_RADIO);
        this.mSimpleTextRadio = new JRadioButton(toggleButtonAction);
        this.mSimpleTextRadio.addItemListener(this);
        this.mSyntaxRadioGrp = new SpssButtonGroup();
        this.mSyntaxRadioGrp.add(this.mSpssRadio);
        this.mSyntaxRadioGrp.add(this.mSqlRadio);
        this.mSyntaxRadioGrp.add(this.mSimpleTextRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, USE_VAL_LABELS_CHECKBOX);
        this.mValLblCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, ASSIGN_VAL_TO_CASES_RADIO);
        this.mValToCasesRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, SELECT_CASES_RADIO);
        this.mSelectCasesRadio = new JRadioButton(toggleButtonAction);
        this.mTypeRadioGrp = new SpssButtonGroup();
        this.mTypeRadioGrp.add(this.mValToCasesRadio);
        this.mTypeRadioGrp.add(this.mSelectCasesRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, INCLUDE_SURROGATES_CHECKBOX);
        this.mIncSurrogatesCheck = new SpssMultiLineCheckBox(toggleButtonAction, 150);
        toggleButtonAction = new ToggleButtonAction(this.mParent, ALL_TERMINAL_NODES_RADIO);
        this.mTerminalNodesRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, BEST_TERMINAL_NODES_RADIO);
        this.mBestTerminalRadio = new JRadioButton(toggleButtonAction);
        this.mBestTerminalRadio.addItemListener(this);
        this.mNumberOfNodesLbl = DialogUtil.createLabel(this.mParent, "IDS_TREE_OUTPUT_NUMBER_OF_NODES");
        this.mNumberOfNodesEdit = new IntTextField(true);
        this.mNumberOfNodesEdit.setAction((Action)new TextFieldAction(this.mParent, NUMBER_OF_NODES_EDIT));
        this.mNumberOfNodesLbl.setLabelFor((Component)this.mNumberOfNodesEdit);
        toggleButtonAction = new ToggleButtonAction(this.mParent, BEST_TERMINAL_NODES_PERCENT_RADIO);
        this.mBestTerminalPercentRadio = new SpssMultiLineRadioButton(toggleButtonAction);
        this.mBestTerminalPercentRadio.addItemListener(this);
        this.mPercentLbl = DialogUtil.createLabel(this.mParent, "IDS_TREE_OUTPUT_PERCENTAGE");
        this.mPercentEdit = new FloatTextField(true);
        this.mPercentEdit.setAction((Action)new TextFieldAction(this.mParent, PERCENT_EDIT));
        this.mPercentLbl.setLabelFor((Component)this.mPercentEdit);
        toggleButtonAction = new ToggleButtonAction(this.mParent, BEST_TERMINAL_NODES_MIN_INDEX_RADIO);
        this.mBestTerminalMinIndexRadio = new SpssMultiLineRadioButton(toggleButtonAction);
        this.mBestTerminalMinIndexRadio.addItemListener(this);
        this.mBestTerminalMinIndexRadio.setMinimumSize(this.mBestTerminalMinIndexRadio.getSize());
        this.mMinIndexLbl = DialogUtil.createLabel(this.mParent, "IDS_TREE_OUTPUT_MINIMUM_INDEX_VALUE");
        this.mMinIndexEdit = new FloatTextField(true);
        this.mMinIndexLbl.setLabelFor((Component)this.mMinIndexEdit);
        this.mMinIndexEdit.setAction((Action)new TextFieldAction(this.mParent, MINIMUM_INDEX_EDIT));
        toggleButtonAction = new ToggleButtonAction(this.mParent, ALL_NODES_RADIO);
        this.mAllNodesRadio = new JRadioButton(toggleButtonAction);
        this.mNodesGrp = new SpssButtonGroup();
        this.mNodesGrp.add(this.mTerminalNodesRadio);
        this.mNodesGrp.add(this.mBestTerminalRadio);
        this.mNodesGrp.add(this.mBestTerminalPercentRadio);
        this.mNodesGrp.add(this.mBestTerminalMinIndexRadio);
        this.mNodesGrp.add(this.mAllNodesRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, EXPORT_RULES_CHECKBOX);
        this.mExportRulesCheck = new JCheckBox(toggleButtonAction);
        this.mExportRulesCheck.addItemListener(this);
        this.mFileLbl = DialogUtil.createLabel(this.mParent, "IDS_TREE_OUTPUT_FILE");
        this.mFileEdit = new FileTextField();
        this.mFileEdit.setAction(new TextFieldAction(this.mParent, FILE_EDIT));
        this.mFileLbl.setLabelFor((Component)((Object)this.mFileEdit));
        toggleButtonAction = new ToggleButtonAction(this.mParent, BROWSE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeOutputRules.this.showSaveDialog();
            }
        };
        this.mBrowseButton = new JButton(toggleButtonAction);
        this.mSytaxPanelBorder = new TitledBorder(this.getResString("IDS_TREE_OUTPUT_SYNTAX"));
        this.mTypePanelBorder = new TitledBorder(this.getResString("IDS_TREE_OUTPUT_TYPE"));
        this.mNodePanelBorder = new TitledBorder(this.getResString("IDS_TREE_OUTPUT_NODES"));
        this.mFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        this.mSyntaxFilter = new RefFileFilter(this.getResString("IDS_TREE_OUTPUT_SYNTAX_FILTER"), this.getResString("IDS_TREE_OUTPUT_SYNTAX_FILTER_EXTN"));
        this.mSqlFilter = new RefFileFilter(this.getResString("IDS_TREE_OUTPUT_SQL_FILTER"), this.getResString("IDS_TREE_OUTPUT_SQL_FILTER_EXTN"));
        this.mTextfileFilter = new RefFileFilter(this.getResString("IDS_TREE_OUTPUT_TEXT_FILE_FILTER"), this.getResString("IDS_TREE_OUTPUT_TEXT_FILE_FILTER_EXTN"));
        this.mFileChooser.addChoosableFileFilter((FileFilter)this.mSyntaxFilter);
        this.mFileChooser.addChoosableFileFilter((FileFilter)this.mSqlFilter);
        this.mFileChooser.addChoosableFileFilter((FileFilter)this.mTextfileFilter);
        this.mFileChooser.setAcceptAllFileFilterUsed(false);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGenRulesCheck);
        vector.add(this.mSyntaxRadioGrp);
        vector.add(this.mValLblCheck);
        vector.add(this.mTypeRadioGrp);
        vector.add(this.mIncSurrogatesCheck);
        vector.add(this.mNodesGrp);
        vector.add(this.mExportRulesCheck);
        vector.add(this.mFileEdit);
        vector.add(this.mBrowseButton);
        JPanel jPanel = ((TreeOutput)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void showSaveDialog() {
        if (this.mSpssRadio.isSelected()) {
            this.mFileChooser.setFileFilter((FileFilter)this.mSyntaxFilter);
        } else if (this.mSqlRadio.isSelected()) {
            this.mFileChooser.setFileFilter((FileFilter)this.mSqlFilter);
        } else {
            this.mFileChooser.setFileFilter((FileFilter)this.mTextfileFilter);
        }
        this.mFileChooser.setDialogTitle(this.getResString("IDS_TREE_OUTPUT_RULES_FILE_DLG_TITLE"));
        int n = this.mFileChooser.showSaveDialog((Component)this.mParent);
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)this.mFileChooser.getCurrentDirectory().getAbsolutePath());
            this.mFileEdit.setText(this.mFileChooser.getSelectedFilePath());
            this.mParent.justPack();
        }
    }

    private void setDefaults() {
        DialogUtil.enableTitledBorder(this.mSytaxPanelBorder, false);
        DialogUtil.enableTitledBorder(this.mTypePanelBorder, false);
        DialogUtil.enableTitledBorder(this.mNodePanelBorder, false);
        this.repaint();
        this.mValLblCheck.setSelected(true);
        this.mIncSurrogatesCheck.setSelected(true);
        this.mSpssRadio.setSelected(true);
        this.mValToCasesRadio.setSelected(true);
        this.mTerminalNodesRadio.setSelected(true);
        this.mSpssRadio.setEnabled(false);
        this.mSqlRadio.setEnabled(false);
        this.mSimpleTextRadio.setEnabled(false);
        this.mValLblCheck.setEnabled(false);
        this.mValToCasesRadio.setEnabled(false);
        this.mSelectCasesRadio.setEnabled(false);
        this.mTerminalNodesRadio.setEnabled(false);
        this.mBestTerminalRadio.setEnabled(false);
        this.mNumberOfNodesLbl.setEnabled(false);
        this.mNumberOfNodesEdit.setEnabled(false);
        this.mNumberOfNodesEdit.setOpaque(false);
        this.mPercentLbl.setEnabled(false);
        this.mPercentEdit.setEnabled(false);
        this.mPercentEdit.setOpaque(false);
        this.mMinIndexLbl.setEnabled(false);
        this.mMinIndexEdit.setEnabled(false);
        this.mMinIndexEdit.setOpaque(false);
        this.mAllNodesRadio.setEnabled(false);
        this.mExportRulesCheck.setEnabled(false);
        this.mFileLbl.setEnabled(false);
        this.mFileEdit.setEnabled(false);
        this.mFileEdit.setOpaque(false);
        this.mBrowseButton.setEnabled(false);
        DialogUtil.enableHTMLComponent(this.mBestTerminalPercentRadio, false);
        DialogUtil.enableHTMLComponent(this.mBestTerminalMinIndexRadio, false);
        DialogUtil.enableHTMLComponent(this.mIncSurrogatesCheck, false);
    }

    private void enableControls(boolean bl) {
        DialogUtil.enableTitledBorder(this.mSytaxPanelBorder, bl);
        DialogUtil.enableTitledBorder(this.mTypePanelBorder, bl);
        DialogUtil.enableTitledBorder(this.mNodePanelBorder, bl);
        this.repaint();
        this.mSpssRadio.setEnabled(bl);
        this.mSqlRadio.setEnabled(bl);
        this.mSimpleTextRadio.setEnabled(bl);
        this.mValLblCheck.setEnabled(bl && this.mSimpleTextRadio.isSelected());
        this.mValToCasesRadio.setEnabled(bl && (this.mSpssRadio.isSelected() || this.mSqlRadio.isSelected()));
        this.mSelectCasesRadio.setEnabled(bl && (this.mSpssRadio.isSelected() || this.mSqlRadio.isSelected()));
        DialogUtil.enableHTMLComponent(this.mIncSurrogatesCheck, bl && this.canEnableSurrogatesCheckbox());
        this.mTerminalNodesRadio.setEnabled(bl);
        boolean bl2 = ((TreeDlg)((Object)this.mParent.getParent())).isTargetCategoryDefined();
        this.mBestTerminalRadio.setEnabled(bl && bl2);
        this.mNumberOfNodesLbl.setEnabled(bl && this.mBestTerminalRadio.isSelected());
        this.mNumberOfNodesEdit.setEnabled(bl && this.mBestTerminalRadio.isSelected());
        this.mNumberOfNodesEdit.setOpaque(bl && this.mBestTerminalRadio.isSelected());
        DialogUtil.enableHTMLComponent(this.mBestTerminalPercentRadio, bl && bl2);
        this.mPercentLbl.setEnabled(bl && this.mBestTerminalPercentRadio.isSelected());
        this.mPercentEdit.setEnabled(bl && this.mBestTerminalPercentRadio.isSelected());
        this.mPercentEdit.setOpaque(bl && this.mBestTerminalPercentRadio.isSelected());
        DialogUtil.enableHTMLComponent(this.mBestTerminalMinIndexRadio, bl && bl2);
        this.mMinIndexLbl.setEnabled(bl && this.mBestTerminalMinIndexRadio.isSelected());
        this.mMinIndexEdit.setEnabled(bl && this.mBestTerminalMinIndexRadio.isSelected());
        this.mMinIndexEdit.setOpaque(bl && this.mBestTerminalMinIndexRadio.isSelected());
        this.mAllNodesRadio.setEnabled(bl);
        this.mExportRulesCheck.setEnabled(bl);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mExportRulesCheck.setEnabled(false);
        }
        this.mFileLbl.setEnabled(bl && this.mExportRulesCheck.isSelected());
        this.mFileEdit.setEnabled(bl && this.mExportRulesCheck.isSelected());
        this.mFileEdit.setOpaque(bl && this.mExportRulesCheck.isSelected());
        this.mBrowseButton.setEnabled(bl && this.mExportRulesCheck.isSelected());
    }

    private boolean canEnableSurrogatesCheckbox() {
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)this.mParent.getParent())).getDialogDataModel();
        String string = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger("IDS_TREE_GROWING_METHOD_COMBOBOX")].toUpperCase();
        boolean bl = !(!this.mSpssRadio.isSelected() && !this.mSqlRadio.isSelected() || !string.equals(this.getResString("IDS_TREE_GROWING_METHOD_CRT_ITEM")) && !string.equals(this.getResString("IDS_TREE_GROWING_METHOD_QUEST_ITEM")));
        return bl;
    }

    private JPanel setupSyntaxPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(this.mSytaxPanelBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mSpssRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mSqlRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mSimpleTextRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap() + 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mValLblCheck, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(this.mTypePanelBorder);
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mValToCasesRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mSelectCasesRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mIncSurrogatesCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupNodesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(this.mNodePanelBorder);
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap() * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mTerminalNodesRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mBestTerminalRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.setupNumberOfNodesPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mBestTerminalPercentRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.setupPercentPanel(), gridBagConstraints, 0, 4, 1, 1, n, insets2);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mBestTerminalMinIndexRadio, gridBagConstraints, 0, 5, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.setupMinIndexValPanel(), gridBagConstraints, 0, 6, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mAllNodesRadio, gridBagConstraints, 0, 7, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPercentPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.mPercentLbl);
        jPanel.add((Component)this.mPercentEdit);
        return jPanel;
    }

    private JPanel setupNumberOfNodesPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.mNumberOfNodesLbl);
        jPanel.add((Component)this.mNumberOfNodesEdit);
        return jPanel;
    }

    private JPanel setupMinIndexValPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.mMinIndexLbl);
        jPanel.add((Component)this.mMinIndexEdit);
        return jPanel;
    }

    private JPanel setupExportRulesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap() * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mExportRulesCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(insets.top, insets.left + DialogUtil.getComponentGroupGap() * 3, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.setupFileNamePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupFileNamePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(2, 0, 0, 0);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mFileLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(2, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, (JComponent)((Object)this.mFileEdit), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }
}

